/*
 * Decompiled with CFR 0.152.
 */
package com.othershe.calendarview.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.othershe.calendarview.bean.DateBean;
import com.othershe.calendarview.utils.LunarUtil;
import com.othershe.calendarview.utils.SolarUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class CalendarUtil {
    public static List<DateBean> getMonthDate(int year, int month, Map<String, String> map) {
        int i;
        int nextYear;
        int nextMonth;
        int lastYear;
        int lastMonth;
        ArrayList<DateBean> datas = new ArrayList<DateBean>();
        int week = SolarUtil.getFirstWeekOfMonth(year, month - 1);
        if (month == 1) {
            lastMonth = 12;
            lastYear = year - 1;
        } else {
            lastMonth = month - 1;
            lastYear = year;
        }
        int lastMonthDays = SolarUtil.getMonthDays(lastYear, lastMonth);
        int currentMonthDays = SolarUtil.getMonthDays(year, month);
        if (month == 12) {
            nextMonth = 1;
            nextYear = year + 1;
        } else {
            nextMonth = month + 1;
            nextYear = year;
        }
        for (i = 0; i < week; ++i) {
            datas.add(CalendarUtil.initDateBean(lastYear, lastMonth, lastMonthDays - week + 1 + i, 0, map));
        }
        for (i = 0; i < currentMonthDays; ++i) {
            datas.add(CalendarUtil.initDateBean(year, month, i + 1, 1, map));
        }
        for (i = 0; i < 7 * CalendarUtil.getMonthRows(year, month) - currentMonthDays - week; ++i) {
            datas.add(CalendarUtil.initDateBean(nextYear, nextMonth, i + 1, 2, map));
        }
        return datas;
    }

    private static DateBean initDateBean(int year, int month, int day, int type, Map<String, String> map) {
        DateBean dateBean = new DateBean();
        dateBean.setSolar(year, month, day);
        if (map == null) {
            String[] temp = LunarUtil.solarToLunar(year, month, day);
            dateBean.setLunar(new String[]{temp[0], temp[1]});
            dateBean.setLunarHoliday(temp[2]);
        } else if (map.containsKey(year + "." + month + "." + day)) {
            dateBean.setLunar(new String[]{"", map.get(year + "." + month + "." + day), ""});
        } else {
            dateBean.setLunar(new String[]{"", "", ""});
        }
        dateBean.setType(type);
        dateBean.setTerm(LunarUtil.getTermString(year, month - 1, day));
        if (type == 0) {
            dateBean.setSolarHoliday(SolarUtil.getSolarHoliday(year, month, day - 1));
        } else {
            dateBean.setSolarHoliday(SolarUtil.getSolarHoliday(year, month, day));
        }
        return dateBean;
    }

    public static DateBean getDateBean(int year, int month, int day) {
        return CalendarUtil.initDateBean(year, month, day, 1, null);
    }

    public static int getMonthRows(int year, int month) {
        int rows;
        int items = SolarUtil.getFirstWeekOfMonth(year, month - 1) + SolarUtil.getMonthDays(year, month);
        int n = rows = items % 7 == 0 ? items / 7 : items / 7 + 1;
        if (rows == 4) {
            rows = 5;
        }
        return rows;
    }

    public static int[] positionToDate(int position, int startY, int startM) {
        int year = position / 12 + startY;
        int month = position % 12 + startM;
        if (month > 12) {
            month %= 12;
        }
        return new int[]{++year, month};
    }

    public static int dateToPosition(int year, int month, int startY, int startM) {
        return (year - startY) * 12 + month - startM;
    }

    public static int[] getCurrentDate() {
        Calendar calendar = Calendar.getInstance();
        return new int[]{calendar.get(1), calendar.get(2) + 1, calendar.get(5)};
    }

    public static int[] strToArray(String str) {
        if (!TextUtils.isEmpty((CharSequence)str)) {
            String[] strArray = str.split("\\.");
            int[] result = new int[strArray.length];
            for (int i = 0; i < strArray.length; ++i) {
                result[i] = Integer.valueOf(strArray[i]);
            }
            return result;
        }
        return null;
    }

    public static long dateToMillis(int[] date) {
        int day = date.length == 2 ? 1 : date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(date[0], date[1], day);
        return calendar.getTimeInMillis();
    }

    public static int getPxSize(Context context, int size) {
        return size * context.getResources().getDisplayMetrics().densityDpi;
    }

    public static int getTextSize1(Context context, int size) {
        return (int)((float)size * context.getResources().getDisplayMetrics().scaledDensity);
    }

    public static int getTextSize(Context context, int size) {
        return (int)TypedValue.applyDimension((int)0, (float)size, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }
}

