/*
 * Decompiled with CFR 0.152.
 */
package com.downloader.internal;

import com.downloader.Error;
import com.downloader.Progress;
import com.downloader.Response;
import com.downloader.Status;
import com.downloader.database.DownloadModel;
import com.downloader.handler.ProgressHandler;
import com.downloader.httpclient.HttpClient;
import com.downloader.internal.ComponentHolder;
import com.downloader.internal.stream.FileDownloadOutputStream;
import com.downloader.internal.stream.FileDownloadRandomAccessFile;
import com.downloader.request.DownloadRequest;
import com.downloader.utils.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class DownloadTask {
    private static final int BUFFER_SIZE = 4096;
    private static final long TIME_GAP_FOR_SYNC = 2000L;
    private static final long MIN_BYTES_FOR_SYNC = 65536L;
    private final DownloadRequest request;
    private ProgressHandler progressHandler;
    private long lastSyncTime;
    private long lastSyncBytes;
    private InputStream inputStream;
    private FileDownloadOutputStream outputStream;
    private HttpClient httpClient;
    private long totalBytes;
    private int responseCode;
    private String eTag;
    private boolean isResumeSupported;
    private String tempPath;

    private DownloadTask(DownloadRequest request) {
        this.request = request;
    }

    static DownloadTask create(DownloadRequest request) {
        return new DownloadTask(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Response run() {
        Response response = new Response();
        if (this.request.getStatus() == Status.CANCELLED) {
            response.setCancelled(true);
            return response;
        }
        if (this.request.getStatus() == Status.PAUSED) {
            response.setPaused(true);
            return response;
        }
        try {
            int byteCount;
            if (this.request.getOnProgressListener() != null) {
                this.progressHandler = new ProgressHandler(this.request.getOnProgressListener());
            }
            this.tempPath = Utils.getTempPath(this.request.getDirPath(), this.request.getFileName());
            File file = new File(this.tempPath);
            DownloadModel model = this.getDownloadModelIfAlreadyPresentInDatabase();
            if (model != null) {
                if (file.exists()) {
                    this.request.setTotalBytes(model.getTotalBytes());
                    this.request.setDownloadedBytes(model.getDownloadedBytes());
                } else {
                    this.removeNoMoreNeededModelFromDatabase();
                    this.request.setDownloadedBytes(0L);
                    this.request.setTotalBytes(0L);
                    model = null;
                }
            }
            this.httpClient = ComponentHolder.getInstance().getHttpClient();
            this.httpClient.connect(this.request);
            if (this.request.getStatus() == Status.CANCELLED) {
                response.setCancelled(true);
                Response response2 = response;
                return response2;
            }
            if (this.request.getStatus() == Status.PAUSED) {
                response.setPaused(true);
                Response response3 = response;
                return response3;
            }
            this.httpClient = Utils.getRedirectedConnectionIfAny(this.httpClient, this.request);
            this.responseCode = this.httpClient.getResponseCode();
            this.eTag = this.httpClient.getResponseHeader("ETag");
            if (this.checkIfFreshStartRequiredAndStart(model)) {
                model = null;
            }
            if (!this.isSuccessful()) {
                Error error = new Error();
                error.setServerError(true);
                error.setServerErrorMessage(this.convertStreamToString(this.httpClient.getErrorStream()));
                error.setHeaderFields(this.httpClient.getHeaderFields());
                error.setResponseCode(this.responseCode);
                response.setError(error);
                Response response4 = response;
                return response4;
            }
            this.setResumeSupportedOrNot();
            this.totalBytes = this.request.getTotalBytes();
            if (!this.isResumeSupported) {
                this.deleteTempFile();
            }
            if (this.totalBytes == 0L) {
                this.totalBytes = this.httpClient.getContentLength();
                this.request.setTotalBytes(this.totalBytes);
            }
            if (this.isResumeSupported && model == null) {
                this.createAndInsertNewModel();
            }
            if (this.request.getStatus() == Status.CANCELLED) {
                response.setCancelled(true);
                Response error = response;
                return error;
            }
            if (this.request.getStatus() == Status.PAUSED) {
                response.setPaused(true);
                Response error = response;
                return error;
            }
            this.request.deliverStartEvent();
            this.inputStream = this.httpClient.getInputStream();
            byte[] buff = new byte[4096];
            if (!file.exists()) {
                if (file.getParentFile() != null && !file.getParentFile().exists()) {
                    if (file.getParentFile().mkdirs()) {
                        file.createNewFile();
                    }
                } else {
                    file.createNewFile();
                }
            }
            this.outputStream = FileDownloadRandomAccessFile.create(file);
            if (this.isResumeSupported && this.request.getDownloadedBytes() != 0L) {
                this.outputStream.seek(this.request.getDownloadedBytes());
            }
            if (this.request.getStatus() == Status.CANCELLED) {
                response.setCancelled(true);
                Response response5 = response;
                return response5;
            }
            if (this.request.getStatus() == Status.PAUSED) {
                response.setPaused(true);
                Response response6 = response;
                return response6;
            }
            while ((byteCount = this.inputStream.read(buff, 0, 4096)) != -1) {
                this.outputStream.write(buff, 0, byteCount);
                this.request.setDownloadedBytes(this.request.getDownloadedBytes() + (long)byteCount);
                this.sendProgress();
                this.syncIfRequired(this.outputStream);
                if (this.request.getStatus() == Status.CANCELLED) {
                    response.setCancelled(true);
                    Response response7 = response;
                    return response7;
                }
                if (this.request.getStatus() != Status.PAUSED) continue;
                this.sync(this.outputStream);
                response.setPaused(true);
                Response response8 = response;
                return response8;
            }
            String path = Utils.getPath(this.request.getDirPath(), this.request.getFileName());
            Utils.renameFileName(this.tempPath, path);
            response.setSuccessful(true);
            if (this.isResumeSupported) {
                this.removeNoMoreNeededModelFromDatabase();
            }
        }
        catch (IOException | IllegalAccessException e) {
            if (!this.isResumeSupported) {
                this.deleteTempFile();
            }
            Error error = new Error();
            error.setConnectionError(true);
            error.setConnectionException(e);
            response.setError(error);
        }
        finally {
            this.closeAllSafely(this.outputStream);
        }
        return response;
    }

    private void deleteTempFile() {
        File file = new File(this.tempPath);
        if (file.exists()) {
            file.delete();
        }
    }

    private boolean isSuccessful() {
        return this.responseCode >= 200 && this.responseCode < 300;
    }

    private void setResumeSupportedOrNot() {
        this.isResumeSupported = this.responseCode == 206;
    }

    private boolean checkIfFreshStartRequiredAndStart(DownloadModel model) throws IOException, IllegalAccessException {
        if (this.responseCode == 416 || this.isETagChanged(model)) {
            if (model != null) {
                this.removeNoMoreNeededModelFromDatabase();
            }
            this.deleteTempFile();
            this.request.setDownloadedBytes(0L);
            this.request.setTotalBytes(0L);
            this.httpClient = ComponentHolder.getInstance().getHttpClient();
            this.httpClient.connect(this.request);
            this.httpClient = Utils.getRedirectedConnectionIfAny(this.httpClient, this.request);
            this.responseCode = this.httpClient.getResponseCode();
            return true;
        }
        return false;
    }

    private boolean isETagChanged(DownloadModel model) {
        return this.eTag != null && model != null && model.getETag() != null && !model.getETag().equals(this.eTag);
    }

    private DownloadModel getDownloadModelIfAlreadyPresentInDatabase() {
        return ComponentHolder.getInstance().getDbHelper().find(this.request.getDownloadId());
    }

    private void createAndInsertNewModel() {
        DownloadModel model = new DownloadModel();
        model.setId(this.request.getDownloadId());
        model.setUrl(this.request.getUrl());
        model.setETag(this.eTag);
        model.setDirPath(this.request.getDirPath());
        model.setFileName(this.request.getFileName());
        model.setDownloadedBytes(this.request.getDownloadedBytes());
        model.setTotalBytes(this.totalBytes);
        model.setLastModifiedAt(System.currentTimeMillis());
        ComponentHolder.getInstance().getDbHelper().insert(model);
    }

    private void removeNoMoreNeededModelFromDatabase() {
        ComponentHolder.getInstance().getDbHelper().remove(this.request.getDownloadId());
    }

    private void sendProgress() {
        if (this.request.getStatus() != Status.CANCELLED && this.progressHandler != null) {
            this.progressHandler.obtainMessage(1, new Progress(this.request.getDownloadedBytes(), this.totalBytes)).sendToTarget();
        }
    }

    private void syncIfRequired(FileDownloadOutputStream outputStream) {
        long currentBytes = this.request.getDownloadedBytes();
        long currentTime = System.currentTimeMillis();
        long bytesDelta = currentBytes - this.lastSyncBytes;
        long timeDelta = currentTime - this.lastSyncTime;
        if (bytesDelta > 65536L && timeDelta > 2000L) {
            this.sync(outputStream);
            this.lastSyncBytes = currentBytes;
            this.lastSyncTime = currentTime;
        }
    }

    private void sync(FileDownloadOutputStream outputStream) {
        boolean success;
        try {
            outputStream.flushAndSync();
            success = true;
        }
        catch (IOException e) {
            success = false;
            e.printStackTrace();
        }
        if (success && this.isResumeSupported) {
            ComponentHolder.getInstance().getDbHelper().updateProgress(this.request.getDownloadId(), this.request.getDownloadedBytes(), System.currentTimeMillis());
        }
    }

    private void closeAllSafely(FileDownloadOutputStream outputStream) {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (outputStream != null) {
                try {
                    this.sync(outputStream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertStreamToString(InputStream stream) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stream != null) {
            BufferedReader bufferedReader = null;
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(stream));
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuilder.append(line);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException | NullPointerException exception) {}
            }
        }
        return stringBuilder.toString();
    }
}

