/*
 * Decompiled with CFR 0.152.
 */
package com.ortiz.touchview;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import androidx.appcompat.widget.AppCompatImageView;
import com.ortiz.touchview.FixedPixel;
import com.ortiz.touchview.ImageActionState;
import com.ortiz.touchview.OnTouchCoordinatesListener;
import com.ortiz.touchview.OnTouchImageViewListener;
import com.ortiz.touchview.OnZoomFinishedListener;
import com.ortiz.touchview.R;
import com.ortiz.touchview.ZoomVariables;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u0000 \u00cf\u00012\u00020\u0001:\u0010\u00c8\u0001\u00c9\u0001\u00ca\u0001\u00cb\u0001\u00cc\u0001\u00cd\u0001\u00ce\u0001\u00cf\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020\u0013J\u0012\u0010S\u001a\u00020Q2\b\u0010T\u001a\u0004\u0018\u00010MH\u0016J\u000e\u0010U\u001a\u00020Q2\u0006\u0010V\u001a\u00020OJ\u000e\u0010W\u001a\u00020Q2\u0006\u0010X\u001a\u00020KJ\u000e\u0010Y\u001a\u00020Q2\u0006\u0010Z\u001a\u00020IJ\u0010\u0010[\u001a\u00020Q2\u0006\u0010\\\u001a\u00020\u0007H\u0016J\u0012\u0010]\u001a\u00020Q2\b\u0010^\u001a\u0004\u0018\u00010_H\u0016J\u0012\u0010`\u001a\u00020Q2\b\u0010a\u001a\u0004\u0018\u00010bH\u0016J\u0012\u0010c\u001a\u00020Q2\b\u0010d\u001a\u0004\u0018\u00010eH\u0016J\u0010\u0010f\u001a\u00020Q2\u0006\u0010g\u001a\u000207H\u0016J\b\u0010h\u001a\u000207H\u0016J\u0006\u0010n\u001a\u00020QJ\n\u0010o\u001a\u0004\u0018\u00010pH\u0016J\u0010\u0010q\u001a\u00020Q2\u0006\u0010r\u001a\u00020pH\u0016J\u0010\u0010s\u001a\u00020Q2\u0006\u0010t\u001a\u00020uH\u0014J\u0010\u0010v\u001a\u00020Q2\u0006\u0010w\u001a\u00020xH\u0016J\u000e\u0010}\u001a\u00020Q2\u0006\u0010y\u001a\u00020\u000bJ\u0007\u0010\u0082\u0001\u001a\u00020QJ\u0007\u0010\u0083\u0001\u001a\u00020QJ\u0010\u0010\u0084\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000bJ\"\u0010\u0084\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000bJ-\u0010\u0084\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000b2\t\u0010\u0088\u0001\u001a\u0004\u0018\u000107J\u0010\u0010\u0084\u0001\u001a\u00020Q2\u0007\u0010\u0089\u0001\u001a\u00020\u0000J\u0013\u0010\u008e\u0001\u001a\u00020\u00132\b\u0010a\u001a\u0004\u0018\u00010bH\u0002J\u0013\u0010\u008f\u0001\u001a\u00020\u00072\b\u0010a\u001a\u0004\u0018\u00010bH\u0002J\u0013\u0010\u0090\u0001\u001a\u00020\u00072\b\u0010a\u001a\u0004\u0018\u00010bH\u0002J\u0019\u0010\u0091\u0001\u001a\u00020Q2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000bJ\t\u0010\u0092\u0001\u001a\u00020QH\u0002J\t\u0010\u0093\u0001\u001a\u00020QH\u0002J-\u0010\u0094\u0001\u001a\u00020\u000b2\u0007\u0010\u0095\u0001\u001a\u00020\u000b2\u0007\u0010\u0096\u0001\u001a\u00020\u000b2\u0007\u0010\u0097\u0001\u001a\u00020\u000b2\u0007\u0010\u0098\u0001\u001a\u00020\u000bH\u0002J$\u0010\u0099\u0001\u001a\u00020\u000b2\u0007\u0010\u009a\u0001\u001a\u00020\u000b2\u0007\u0010\u0096\u0001\u001a\u00020\u000b2\u0007\u0010\u0097\u0001\u001a\u00020\u000bH\u0002J\u001b\u0010\u009f\u0001\u001a\u00020Q2\u0007\u0010\u00a0\u0001\u001a\u00020\u00072\u0007\u0010\u00a1\u0001\u001a\u00020\u0007H\u0014J-\u0010\u00a2\u0001\u001a\u00020Q2\u0007\u0010\u00a3\u0001\u001a\u00020\u00072\u0007\u0010\u00a4\u0001\u001a\u00020\u00072\u0007\u0010\u00a5\u0001\u001a\u00020\u00072\u0007\u0010\u00a6\u0001\u001a\u00020\u0007H\u0014J\t\u0010\u00a7\u0001\u001a\u00020QH\u0002J$\u0010\u00a8\u0001\u001a\u00020\u00072\u0007\u0010\u00a9\u0001\u001a\u00020\u00072\u0007\u0010\u00aa\u0001\u001a\u00020\u00072\u0007\u0010\u00ab\u0001\u001a\u00020\u0007H\u0002JJ\u0010\u00ac\u0001\u001a\u00020\u000b2\u0007\u0010\u0095\u0001\u001a\u00020\u000b2\u0007\u0010\u00ad\u0001\u001a\u00020\u000b2\u0007\u0010\u00ae\u0001\u001a\u00020\u000b2\u0007\u0010\u00af\u0001\u001a\u00020\u00072\u0007\u0010\u0096\u0001\u001a\u00020\u00072\u0007\u0010\u00b0\u0001\u001a\u00020\u00072\t\u0010\u00b1\u0001\u001a\u0004\u0018\u00010\u001bH\u0002J\u0011\u0010\u00b2\u0001\u001a\u00020Q2\u0006\u0010$\u001a\u00020%H\u0002J\u0012\u0010\u00b3\u0001\u001a\u00020\u00132\u0007\u0010\u00b4\u0001\u001a\u00020\u0007H\u0016J\u0012\u0010\u00b5\u0001\u001a\u00020\u00132\u0007\u0010\u00b4\u0001\u001a\u00020\u0007H\u0016J.\u0010\u00b6\u0001\u001a\u00020Q2\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u00012\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000b2\u0007\u0010\u00b9\u0001\u001a\u00020\u0013H\u0002J%\u0010\u00ba\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00bb\u0001\u001a\u00020\u000b2\u0007\u0010\u00bc\u0001\u001a\u00020\u000b2\u0007\u0010\u00bd\u0001\u001a\u00020\u0013H\u0004J\u001c\u0010\u00be\u0001\u001a\u00030\u008b\u00012\u0007\u0010\u00bf\u0001\u001a\u00020\u000b2\u0007\u0010\u00c0\u0001\u001a\u00020\u000bH\u0004J\u0013\u0010\u00c1\u0001\u001a\u00020Q2\b\u0010\u00c2\u0001\u001a\u00030\u00c3\u0001H\u0002J\"\u0010\u00c4\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000bJ+\u0010\u00c4\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000b2\u0007\u0010\u00c5\u0001\u001a\u00020\u0007J7\u0010\u00c4\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000b2\u0007\u0010\u00c5\u0001\u001a\u00020\u00072\n\u0010\u00c6\u0001\u001a\u0005\u0018\u00010\u00c7\u0001J.\u0010\u00c4\u0001\u001a\u00020Q2\u0007\u0010\u0085\u0001\u001a\u00020\u000b2\u0007\u0010\u0086\u0001\u001a\u00020\u000b2\u0007\u0010\u0087\u0001\u001a\u00020\u000b2\n\u0010\u00c6\u0001\u001a\u0005\u0018\u00010\u00c7\u0001R\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001fR\u000e\u0010#\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010/\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000e\"\u0004\b1\u00102R\u0014\u00103\u001a\b\u0018\u000104R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010H\u001a\u0004\u0018\u00010IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010L\u001a\u0004\u0018\u00010MX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010N\u001a\u0004\u0018\u00010OX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010i\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\bi\u0010\u0014R\u0011\u0010j\u001a\u00020k8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010mR$\u0010z\u001a\u00020\u000b2\u0006\u0010y\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b{\u0010\u000e\"\u0004\b|\u00102R&\u0010\u007f\u001a\u00020\u000b2\u0006\u0010~\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\u001a\u0005\b\u0080\u0001\u0010\u000e\"\u0005\b\u0081\u0001\u00102R\u0015\u0010\u008a\u0001\u001a\u00030\u008b\u00018F\u00a2\u0006\b\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001R\u0016\u0010\u009b\u0001\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u009c\u0001\u0010\u000eR\u0016\u0010\u009d\u0001\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0007\u001a\u0005\b\u009e\u0001\u0010\u000e\u00a8\u0006\u00d0\u0001"}, d2={"Lcom/ortiz/touchview/TouchImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "currentZoom", "getCurrentZoom", "()F", "touchMatrix", "Landroid/graphics/Matrix;", "prevMatrix", "isZoomEnabled", "", "()Z", "setZoomEnabled", "(Z)V", "isSuperZoomEnabled", "setSuperZoomEnabled", "isRotateImageToFitScreen", "orientationChangeFixedPixel", "Lcom/ortiz/touchview/FixedPixel;", "getOrientationChangeFixedPixel", "()Lcom/ortiz/touchview/FixedPixel;", "setOrientationChangeFixedPixel", "(Lcom/ortiz/touchview/FixedPixel;)V", "viewSizeChangeFixedPixel", "getViewSizeChangeFixedPixel", "setViewSizeChangeFixedPixel", "orientationJustChanged", "imageActionState", "Lcom/ortiz/touchview/ImageActionState;", "userSpecifiedMinScale", "minScale", "maxScaleIsSetByMultiplier", "maxScaleMultiplier", "maxScale", "superMinScale", "superMaxScale", "floatMatrix", "", "doubleTapScale", "getDoubleTapScale", "setDoubleTapScale", "(F)V", "fling", "Lcom/ortiz/touchview/TouchImageView$Fling;", "orientation", "touchScaleType", "Landroid/widget/ImageView$ScaleType;", "imageRenderedAtLeastOnce", "onDrawReady", "delayedZoomVariables", "Lcom/ortiz/touchview/ZoomVariables;", "viewWidth", "viewHeight", "prevViewWidth", "prevViewHeight", "matchViewWidth", "matchViewHeight", "prevMatchViewWidth", "prevMatchViewHeight", "scaleDetector", "Landroid/view/ScaleGestureDetector;", "gestureDetector", "Landroid/view/GestureDetector;", "touchCoordinatesListener", "Lcom/ortiz/touchview/OnTouchCoordinatesListener;", "doubleTapListener", "Landroid/view/GestureDetector$OnDoubleTapListener;", "userTouchListener", "Landroid/view/View$OnTouchListener;", "touchImageViewListener", "Lcom/ortiz/touchview/OnTouchImageViewListener;", "setRotateImageToFitScreen", "", "rotateImageToFitScreen", "setOnTouchListener", "onTouchListener", "setOnTouchImageViewListener", "onTouchImageViewListener", "setOnDoubleTapListener", "onDoubleTapListener", "setOnTouchCoordinatesListener", "onTouchCoordinatesListener", "setImageResource", "resId", "setImageBitmap", "bm", "Landroid/graphics/Bitmap;", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImageURI", "uri", "Landroid/net/Uri;", "setScaleType", "type", "getScaleType", "isZoomed", "zoomedRect", "Landroid/graphics/RectF;", "getZoomedRect", "()Landroid/graphics/RectF;", "savePreviousImageValues", "onSaveInstanceState", "Landroid/os/Parcelable;", "onRestoreInstanceState", "state", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "max", "maxZoom", "getMaxZoom", "setMaxZoom", "setMaxZoomRatio", "min", "minZoom", "getMinZoom", "setMinZoom", "resetZoom", "resetZoomAnimated", "setZoom", "scale", "focusX", "focusY", "scaleType", "imageSource", "scrollPosition", "Landroid/graphics/PointF;", "getScrollPosition", "()Landroid/graphics/PointF;", "orientationMismatch", "getDrawableWidth", "getDrawableHeight", "setScrollPosition", "fixTrans", "fixScaleTrans", "getFixTrans", "trans", "viewSize", "contentSize", "offset", "getFixDragTrans", "delta", "imageWidth", "getImageWidth", "imageHeight", "getImageHeight", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "fitImageToView", "setViewSize", "mode", "size", "drawableWidth", "newTranslationAfterChange", "prevImageSize", "imageSize", "prevViewSize", "drawableSize", "sizeChangeFixedPixel", "setState", "canScrollHorizontally", "direction", "canScrollVertically", "scaleImage", "deltaScale", "", "stretchImageToSuper", "transformCoordTouchToBitmap", "x", "y", "clipToBitmap", "transformCoordBitmapToTouch", "bx", "by", "compatPostOnAnimation", "runnable", "Ljava/lang/Runnable;", "setZoomAnimated", "zoomTimeMs", "listener", "Lcom/ortiz/touchview/OnZoomFinishedListener;", "GestureListener", "PrivateOnTouchListener", "ScaleListener", "DoubleTapZoom", "Fling", "CompatScroller", "AnimatedZoom", "Companion", "touchview_release"})
public class TouchImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float currentZoom;
    @NotNull
    private Matrix touchMatrix;
    @NotNull
    private Matrix prevMatrix;
    private boolean isZoomEnabled;
    private boolean isSuperZoomEnabled;
    private boolean isRotateImageToFitScreen;
    @Nullable
    private FixedPixel orientationChangeFixedPixel;
    @Nullable
    private FixedPixel viewSizeChangeFixedPixel;
    private boolean orientationJustChanged;
    @Nullable
    private ImageActionState imageActionState;
    private float userSpecifiedMinScale;
    private float minScale;
    private boolean maxScaleIsSetByMultiplier;
    private float maxScaleMultiplier;
    private float maxScale;
    private float superMinScale;
    private float superMaxScale;
    @NotNull
    private float[] floatMatrix;
    private float doubleTapScale;
    @Nullable
    private Fling fling;
    private int orientation;
    @Nullable
    private ImageView.ScaleType touchScaleType;
    private boolean imageRenderedAtLeastOnce;
    private boolean onDrawReady;
    @Nullable
    private ZoomVariables delayedZoomVariables;
    private int viewWidth;
    private int viewHeight;
    private int prevViewWidth;
    private int prevViewHeight;
    private float matchViewWidth;
    private float matchViewHeight;
    private float prevMatchViewWidth;
    private float prevMatchViewHeight;
    @NotNull
    private ScaleGestureDetector scaleDetector;
    @NotNull
    private GestureDetector gestureDetector;
    @Nullable
    private OnTouchCoordinatesListener touchCoordinatesListener;
    @Nullable
    private GestureDetector.OnDoubleTapListener doubleTapListener;
    @Nullable
    private View.OnTouchListener userTouchListener;
    @Nullable
    private OnTouchImageViewListener touchImageViewListener;
    private static final float SUPER_MIN_MULTIPLIER = 0.75f;
    private static final float SUPER_MAX_MULTIPLIER = 1.25f;
    private static final int DEFAULT_ZOOM_TIME = 500;
    public static final float AUTOMATIC_MIN_ZOOM = -1.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmOverloads
    public TouchImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.isSuperZoomEnabled = true;
        this.orientationChangeFixedPixel = FixedPixel.CENTER;
        this.viewSizeChangeFixedPixel = FixedPixel.CENTER;
        super.setClickable(true);
        this.orientation = this.getResources().getConfiguration().orientation;
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.touchMatrix = new Matrix();
        this.prevMatrix = new Matrix();
        this.floatMatrix = new float[9];
        this.currentZoom = 1.0f;
        if (this.touchScaleType == null) {
            this.touchScaleType = ImageView.ScaleType.FIT_CENTER;
        }
        this.minScale = 1.0f;
        this.maxScale = 3.0f;
        this.superMinScale = 0.75f * this.minScale;
        this.superMaxScale = 1.25f * this.maxScale;
        this.setImageMatrix(this.touchMatrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setState(ImageActionState.NONE);
        this.onDrawReady = false;
        super.setOnTouchListener((View.OnTouchListener)new PrivateOnTouchListener());
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.TouchImageView, defStyle, 0);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"obtainStyledAttributes(...)");
        TypedArray attributes = typedArray;
        try {
            if (!this.isInEditMode()) {
                this.isZoomEnabled = attributes.getBoolean(R.styleable.TouchImageView_zoom_enabled, true);
            }
        }
        finally {
            attributes.recycle();
        }
    }

    public /* synthetic */ TouchImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    public final float getCurrentZoom() {
        return this.currentZoom;
    }

    public final boolean isZoomEnabled() {
        return this.isZoomEnabled;
    }

    public final void setZoomEnabled(boolean bl) {
        this.isZoomEnabled = bl;
    }

    public final boolean isSuperZoomEnabled() {
        return this.isSuperZoomEnabled;
    }

    public final void setSuperZoomEnabled(boolean bl) {
        this.isSuperZoomEnabled = bl;
    }

    @Nullable
    public final FixedPixel getOrientationChangeFixedPixel() {
        return this.orientationChangeFixedPixel;
    }

    public final void setOrientationChangeFixedPixel(@Nullable FixedPixel fixedPixel) {
        this.orientationChangeFixedPixel = fixedPixel;
    }

    @Nullable
    public final FixedPixel getViewSizeChangeFixedPixel() {
        return this.viewSizeChangeFixedPixel;
    }

    public final void setViewSizeChangeFixedPixel(@Nullable FixedPixel fixedPixel) {
        this.viewSizeChangeFixedPixel = fixedPixel;
    }

    public final float getDoubleTapScale() {
        return this.doubleTapScale;
    }

    public final void setDoubleTapScale(float f) {
        this.doubleTapScale = f;
    }

    public final void setRotateImageToFitScreen(boolean rotateImageToFitScreen) {
        this.isRotateImageToFitScreen = rotateImageToFitScreen;
    }

    public void setOnTouchListener(@Nullable View.OnTouchListener onTouchListener) {
        this.userTouchListener = onTouchListener;
    }

    public final void setOnTouchImageViewListener(@NotNull OnTouchImageViewListener onTouchImageViewListener) {
        Intrinsics.checkNotNullParameter((Object)onTouchImageViewListener, (String)"onTouchImageViewListener");
        this.touchImageViewListener = onTouchImageViewListener;
    }

    public final void setOnDoubleTapListener(@NotNull GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        Intrinsics.checkNotNullParameter((Object)onDoubleTapListener, (String)"onDoubleTapListener");
        this.doubleTapListener = onDoubleTapListener;
    }

    public final void setOnTouchCoordinatesListener(@NotNull OnTouchCoordinatesListener onTouchCoordinatesListener) {
        Intrinsics.checkNotNullParameter((Object)onTouchCoordinatesListener, (String)"onTouchCoordinatesListener");
        this.touchCoordinatesListener = onTouchCoordinatesListener;
    }

    public void setImageResource(int resId) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageResource(resId);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageBitmap(@Nullable Bitmap bm) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageBitmap(bm);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageDrawable(drawable);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageURI(@Nullable Uri uri) {
        this.imageRenderedAtLeastOnce = false;
        super.setImageURI(uri);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setScaleType(@NotNull ImageView.ScaleType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type == ImageView.ScaleType.MATRIX) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        } else {
            this.touchScaleType = type;
            if (this.onDrawReady) {
                this.setZoom(this);
            }
        }
    }

    @NotNull
    public ImageView.ScaleType getScaleType() {
        ImageView.ScaleType scaleType = this.touchScaleType;
        Intrinsics.checkNotNull((Object)scaleType);
        return scaleType;
    }

    public final boolean isZoomed() {
        return !(this.currentZoom == 1.0f);
    }

    @NotNull
    public final RectF getZoomedRect() {
        if (this.touchScaleType == ImageView.ScaleType.FIT_XY) {
            throw new UnsupportedOperationException("getZoomedRect() not supported with FIT_XY");
        }
        PointF topLeft = this.transformCoordTouchToBitmap(0.0f, 0.0f, true);
        PointF bottomRight = this.transformCoordTouchToBitmap(this.viewWidth, this.viewHeight, true);
        float w = this.getDrawableWidth(this.getDrawable());
        float h = this.getDrawableHeight(this.getDrawable());
        return new RectF(topLeft.x / w, topLeft.y / h, bottomRight.x / w, bottomRight.y / h);
    }

    public final void savePreviousImageValues() {
        if (this.viewHeight != 0 && this.viewWidth != 0) {
            this.touchMatrix.getValues(this.floatMatrix);
            this.prevMatrix.setValues(this.floatMatrix);
            this.prevMatchViewHeight = this.matchViewHeight;
            this.prevMatchViewWidth = this.matchViewWidth;
            this.prevViewHeight = this.viewHeight;
            this.prevViewWidth = this.viewWidth;
        }
    }

    @Nullable
    public Parcelable onSaveInstanceState() {
        super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putInt("orientation", this.orientation);
        bundle.putFloat("saveScale", this.currentZoom);
        bundle.putFloat("matchViewHeight", this.matchViewHeight);
        bundle.putFloat("matchViewWidth", this.matchViewWidth);
        bundle.putInt("viewWidth", this.viewWidth);
        bundle.putInt("viewHeight", this.viewHeight);
        this.touchMatrix.getValues(this.floatMatrix);
        bundle.putFloatArray("matrix", this.floatMatrix);
        bundle.putBoolean("imageRendered", this.imageRenderedAtLeastOnce);
        bundle.putSerializable("viewSizeChangeFixedPixel", (Serializable)((Object)this.viewSizeChangeFixedPixel));
        bundle.putSerializable("orientationChangeFixedPixel", (Serializable)((Object)this.orientationChangeFixedPixel));
        return (Parcelable)bundle;
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            this.currentZoom = ((Bundle)state).getFloat("saveScale");
            float[] fArray = ((Bundle)state).getFloatArray("matrix");
            Intrinsics.checkNotNull((Object)fArray);
            this.floatMatrix = fArray;
            this.prevMatrix.setValues(this.floatMatrix);
            this.prevMatchViewHeight = ((Bundle)state).getFloat("matchViewHeight");
            this.prevMatchViewWidth = ((Bundle)state).getFloat("matchViewWidth");
            this.prevViewHeight = ((Bundle)state).getInt("viewHeight");
            this.prevViewWidth = ((Bundle)state).getInt("viewWidth");
            this.imageRenderedAtLeastOnce = ((Bundle)state).getBoolean("imageRendered");
            if (Build.VERSION.SDK_INT >= 33) {
                this.viewSizeChangeFixedPixel = (FixedPixel)((Object)((Bundle)state).getSerializable("viewSizeChangeFixedPixel", FixedPixel.class));
                this.orientationChangeFixedPixel = (FixedPixel)((Object)((Bundle)state).getSerializable("orientationChangeFixedPixel", FixedPixel.class));
            } else {
                this.viewSizeChangeFixedPixel = (FixedPixel)((Object)((Bundle)state).getSerializable("viewSizeChangeFixedPixel"));
                this.orientationChangeFixedPixel = (FixedPixel)((Object)((Bundle)state).getSerializable("orientationChangeFixedPixel"));
            }
            int oldOrientation = ((Bundle)state).getInt("orientation");
            if (this.orientation != oldOrientation) {
                this.orientationJustChanged = true;
            }
            return;
        }
        super.onRestoreInstanceState(state);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.onDrawReady = true;
        this.imageRenderedAtLeastOnce = true;
        if (this.delayedZoomVariables != null) {
            ZoomVariables zoomVariables = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables);
            float f = zoomVariables.getScale();
            ZoomVariables zoomVariables2 = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables2);
            float f2 = zoomVariables2.getFocusX();
            ZoomVariables zoomVariables3 = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables3);
            float f3 = zoomVariables3.getFocusY();
            ZoomVariables zoomVariables4 = this.delayedZoomVariables;
            Intrinsics.checkNotNull((Object)zoomVariables4);
            this.setZoom(f, f2, f3, zoomVariables4.getScaleType());
            this.delayedZoomVariables = null;
        }
        super.onDraw(canvas);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        int newOrientation = this.getResources().getConfiguration().orientation;
        if (newOrientation != this.orientation) {
            this.orientationJustChanged = true;
            this.orientation = newOrientation;
        }
        this.savePreviousImageValues();
    }

    public final float getMaxZoom() {
        return this.maxScale;
    }

    public final void setMaxZoom(float max) {
        this.maxScale = max;
        this.superMaxScale = 1.25f * this.maxScale;
        this.maxScaleIsSetByMultiplier = false;
    }

    public final void setMaxZoomRatio(float max) {
        this.maxScaleMultiplier = max;
        this.maxScale = this.minScale * this.maxScaleMultiplier;
        this.superMaxScale = 1.25f * this.maxScale;
        this.maxScaleIsSetByMultiplier = true;
    }

    public final float getMinZoom() {
        return this.minScale;
    }

    public final void setMinZoom(float min) {
        this.userSpecifiedMinScale = min;
        if (min == -1.0f) {
            if (this.touchScaleType == ImageView.ScaleType.CENTER || this.touchScaleType == ImageView.ScaleType.CENTER_CROP) {
                Drawable drawable = this.getDrawable();
                int drawableWidth = this.getDrawableWidth(drawable);
                int drawableHeight = this.getDrawableHeight(drawable);
                if (drawable != null && drawableWidth > 0 && drawableHeight > 0) {
                    float widthRatio = (float)this.viewWidth / (float)drawableWidth;
                    float heightRatio = (float)this.viewHeight / (float)drawableHeight;
                    this.minScale = this.touchScaleType == ImageView.ScaleType.CENTER ? Math.min(widthRatio, heightRatio) : Math.min(widthRatio, heightRatio) / Math.max(widthRatio, heightRatio);
                }
            } else {
                this.minScale = 1.0f;
            }
        } else {
            this.minScale = this.userSpecifiedMinScale;
        }
        if (this.maxScaleIsSetByMultiplier) {
            this.setMaxZoomRatio(this.maxScaleMultiplier);
        }
        this.superMinScale = 0.75f * this.minScale;
    }

    public final void resetZoom() {
        this.currentZoom = 1.0f;
        this.fitImageToView();
    }

    public final void resetZoomAnimated() {
        this.setZoomAnimated(1.0f, 0.5f, 0.5f);
    }

    public final void setZoom(float scale) {
        this.setZoom(scale, 0.5f, 0.5f);
    }

    public final void setZoom(float scale, float focusX, float focusY) {
        this.setZoom(scale, focusX, focusY, this.touchScaleType);
    }

    public final void setZoom(float scale, float focusX, float focusY, @Nullable ImageView.ScaleType scaleType) {
        if (!this.onDrawReady) {
            this.delayedZoomVariables = new ZoomVariables(scale, focusX, focusY, scaleType);
            return;
        }
        if (this.userSpecifiedMinScale == -1.0f) {
            this.setMinZoom(-1.0f);
            if (this.currentZoom < this.minScale) {
                this.currentZoom = this.minScale;
            }
        }
        if (scaleType != this.touchScaleType) {
            ImageView.ScaleType scaleType2 = scaleType;
            Intrinsics.checkNotNull((Object)scaleType2);
            this.setScaleType(scaleType2);
        }
        this.resetZoom();
        this.scaleImage(scale, (float)this.viewWidth / 2.0f, (float)this.viewHeight / 2.0f, this.isSuperZoomEnabled);
        this.touchMatrix.getValues(this.floatMatrix);
        this.floatMatrix[2] = -(focusX * this.getImageWidth() - (float)this.viewWidth * 0.5f);
        this.floatMatrix[5] = -(focusY * this.getImageHeight() - (float)this.viewHeight * 0.5f);
        this.touchMatrix.setValues(this.floatMatrix);
        this.fixTrans();
        this.savePreviousImageValues();
        this.setImageMatrix(this.touchMatrix);
    }

    public final void setZoom(@NotNull TouchImageView imageSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)imageSource), (String)"imageSource");
        PointF center = imageSource.getScrollPosition();
        this.setZoom(imageSource.currentZoom, center.x, center.y, imageSource.getScaleType());
    }

    @NotNull
    public final PointF getScrollPosition() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return new PointF(0.5f, 0.5f);
        }
        Drawable drawable2 = drawable;
        int drawableWidth = this.getDrawableWidth(drawable2);
        int drawableHeight = this.getDrawableHeight(drawable2);
        PointF point = this.transformCoordTouchToBitmap((float)this.viewWidth / 2.0f, (float)this.viewHeight / 2.0f, true);
        point.x /= (float)drawableWidth;
        point.y /= (float)drawableHeight;
        return point;
    }

    private final boolean orientationMismatch(Drawable drawable) {
        boolean bl = this.viewWidth > this.viewHeight;
        Drawable drawable2 = drawable;
        Intrinsics.checkNotNull((Object)drawable2);
        return bl != drawable2.getIntrinsicWidth() > drawable.getIntrinsicHeight();
    }

    private final int getDrawableWidth(Drawable drawable) {
        int n;
        if (this.orientationMismatch(drawable) && this.isRotateImageToFitScreen) {
            Drawable drawable2 = drawable;
            Intrinsics.checkNotNull((Object)drawable2);
            n = drawable2.getIntrinsicHeight();
        } else {
            Drawable drawable3 = drawable;
            Intrinsics.checkNotNull((Object)drawable3);
            n = drawable3.getIntrinsicWidth();
        }
        return n;
    }

    private final int getDrawableHeight(Drawable drawable) {
        int n;
        if (this.orientationMismatch(drawable) && this.isRotateImageToFitScreen) {
            Drawable drawable2 = drawable;
            Intrinsics.checkNotNull((Object)drawable2);
            n = drawable2.getIntrinsicWidth();
        } else {
            Drawable drawable3 = drawable;
            Intrinsics.checkNotNull((Object)drawable3);
            n = drawable3.getIntrinsicHeight();
        }
        return n;
    }

    public final void setScrollPosition(float focusX, float focusY) {
        this.setZoom(this.currentZoom, focusX, focusY);
    }

    private final void fixTrans() {
        this.touchMatrix.getValues(this.floatMatrix);
        float transX = this.floatMatrix[2];
        float transY = this.floatMatrix[5];
        float offset = 0.0f;
        if (this.isRotateImageToFitScreen && this.orientationMismatch(this.getDrawable())) {
            offset = this.getImageWidth();
        }
        float fixTransX = this.getFixTrans(transX, this.viewWidth, this.getImageWidth(), offset);
        float fixTransY = this.getFixTrans(transY, this.viewHeight, this.getImageHeight(), 0.0f);
        this.touchMatrix.postTranslate(fixTransX, fixTransY);
    }

    private final void fixScaleTrans() {
        this.fixTrans();
        this.touchMatrix.getValues(this.floatMatrix);
        if (this.getImageWidth() < (float)this.viewWidth) {
            float xOffset = ((float)this.viewWidth - this.getImageWidth()) / (float)2;
            if (this.isRotateImageToFitScreen && this.orientationMismatch(this.getDrawable())) {
                xOffset += this.getImageWidth();
            }
            this.floatMatrix[2] = xOffset;
        }
        if (this.getImageHeight() < (float)this.viewHeight) {
            this.floatMatrix[5] = ((float)this.viewHeight - this.getImageHeight()) / (float)2;
        }
        this.touchMatrix.setValues(this.floatMatrix);
    }

    private final float getFixTrans(float trans, float viewSize, float contentSize, float offset) {
        float minTrans = 0.0f;
        float maxTrans = 0.0f;
        if (contentSize <= viewSize) {
            minTrans = offset;
            maxTrans = offset + viewSize - contentSize;
        } else {
            minTrans = offset + viewSize - contentSize;
            maxTrans = offset;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        return trans > maxTrans ? -trans + maxTrans : 0.0f;
    }

    private final float getFixDragTrans(float delta, float viewSize, float contentSize) {
        return contentSize <= viewSize ? 0.0f : delta;
    }

    private final float getImageWidth() {
        return this.matchViewWidth * this.currentZoom;
    }

    private final float getImageHeight() {
        return this.matchViewHeight * this.currentZoom;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        int drawableWidth = this.getDrawableWidth(drawable);
        int drawableHeight = this.getDrawableHeight(drawable);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int totalViewWidth = this.setViewSize(widthMode, widthSize, drawableWidth);
        int totalViewHeight = this.setViewSize(heightMode, heightSize, drawableHeight);
        if (!this.orientationJustChanged) {
            this.savePreviousImageValues();
        }
        this.setMeasuredDimension(totalViewWidth, totalViewHeight);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w - this.getPaddingRight() - this.getPaddingLeft();
        this.viewHeight = h - this.getPaddingTop() - this.getPaddingBottom();
        this.fitImageToView();
    }

    private final void fitImageToView() {
        FixedPixel fixedPixel = this.orientationJustChanged ? this.orientationChangeFixedPixel : this.viewSizeChangeFixedPixel;
        this.orientationJustChanged = false;
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            return;
        }
        if (this.touchMatrix == null || this.prevMatrix == null) {
            return;
        }
        if (this.userSpecifiedMinScale == -1.0f) {
            this.setMinZoom(-1.0f);
            if (this.currentZoom < this.minScale) {
                this.currentZoom = this.minScale;
            }
        }
        int drawableWidth = this.getDrawableWidth(drawable);
        int drawableHeight = this.getDrawableHeight(drawable);
        float scaleX = 0.0f;
        scaleX = (float)this.viewWidth / (float)drawableWidth;
        float scaleY = 0.0f;
        scaleY = (float)this.viewHeight / (float)drawableHeight;
        ImageView.ScaleType scaleType = this.touchScaleType;
        switch (scaleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: {
                scaleX = scaleY = 1.0f;
                break;
            }
            case 2: {
                scaleX = scaleY = Math.max(scaleX, scaleY);
                break;
            }
            case 3: {
                TouchImageView $this$fitImageToView_u24lambda_u240 = this;
                boolean bl = false;
                scaleX = scaleY = Math.min(1.0f, Math.min(scaleX, scaleY));
                TouchImageView $this$fitImageToView_u24lambda_u241 = this;
                boolean bl2 = false;
                scaleX = scaleY = Math.min(scaleX, scaleY);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                scaleX = scaleY = Math.min(scaleX, scaleY);
                break;
            }
            case 7: {
                break;
            }
        }
        float redundantXSpace = (float)this.viewWidth - scaleX * (float)drawableWidth;
        float redundantYSpace = (float)this.viewHeight - scaleY * (float)drawableHeight;
        this.matchViewWidth = (float)this.viewWidth - redundantXSpace;
        this.matchViewHeight = (float)this.viewHeight - redundantYSpace;
        if (!this.isZoomed() && !this.imageRenderedAtLeastOnce) {
            if (this.isRotateImageToFitScreen && this.orientationMismatch(drawable)) {
                this.touchMatrix.setRotate(90.0f);
                this.touchMatrix.postTranslate((float)drawableWidth, 0.0f);
                this.touchMatrix.postScale(scaleX, scaleY);
            } else {
                this.touchMatrix.setScale(scaleX, scaleY);
            }
            ImageView.ScaleType scaleType2 = this.touchScaleType;
            switch (scaleType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[scaleType2.ordinal()]) {
                case 5: {
                    boolean bl = this.touchMatrix.postTranslate(0.0f, 0.0f);
                    break;
                }
                case 6: {
                    boolean bl = this.touchMatrix.postTranslate(redundantXSpace, redundantYSpace);
                    break;
                }
                default: {
                    boolean bl = this.touchMatrix.postTranslate(redundantXSpace / (float)2, redundantYSpace / (float)2);
                }
            }
            this.currentZoom = 1.0f;
        } else {
            if (this.prevMatchViewWidth == 0.0f || this.prevMatchViewHeight == 0.0f) {
                this.savePreviousImageValues();
            }
            this.prevMatrix.getValues(this.floatMatrix);
            this.floatMatrix[0] = this.matchViewWidth / (float)drawableWidth * this.currentZoom;
            this.floatMatrix[4] = this.matchViewHeight / (float)drawableHeight * this.currentZoom;
            float transX = this.floatMatrix[2];
            float transY = this.floatMatrix[5];
            float prevActualWidth = this.prevMatchViewWidth * this.currentZoom;
            float actualWidth = this.getImageWidth();
            this.floatMatrix[2] = this.newTranslationAfterChange(transX, prevActualWidth, actualWidth, this.prevViewWidth, this.viewWidth, drawableWidth, fixedPixel);
            float prevActualHeight = this.prevMatchViewHeight * this.currentZoom;
            float actualHeight = this.getImageHeight();
            this.floatMatrix[5] = this.newTranslationAfterChange(transY, prevActualHeight, actualHeight, this.prevViewHeight, this.viewHeight, drawableHeight, fixedPixel);
            this.touchMatrix.setValues(this.floatMatrix);
        }
        this.fixTrans();
        this.setImageMatrix(this.touchMatrix);
    }

    private final int setViewSize(int mode, int size, int drawableWidth) {
        return switch (mode) {
            case 0x40000000 -> size;
            case Integer.MIN_VALUE -> Math.min(drawableWidth, size);
            case 0 -> drawableWidth;
            default -> size;
        };
    }

    private final float newTranslationAfterChange(float trans, float prevImageSize, float imageSize, int prevViewSize, int viewSize, int drawableSize, FixedPixel sizeChangeFixedPixel) {
        float f;
        if (imageSize < (float)viewSize) {
            f = ((float)viewSize - (float)drawableSize * this.floatMatrix[0]) * 0.5f;
        } else if (trans > 0.0f) {
            f = -((imageSize - (float)viewSize) * 0.5f);
        } else {
            float fixedPixelPositionInView = 0.5f;
            if (sizeChangeFixedPixel == FixedPixel.BOTTOM_RIGHT) {
                fixedPixelPositionInView = 1.0f;
            } else if (sizeChangeFixedPixel == FixedPixel.TOP_LEFT) {
                fixedPixelPositionInView = 0.0f;
            }
            float fixedPixelPositionInImage = (-trans + fixedPixelPositionInView * (float)prevViewSize) / prevImageSize;
            f = -(fixedPixelPositionInImage * imageSize - (float)viewSize * fixedPixelPositionInView);
        }
        return f;
    }

    private final void setState(ImageActionState imageActionState) {
        this.imageActionState = imageActionState;
    }

    public boolean canScrollHorizontally(int direction) {
        this.touchMatrix.getValues(this.floatMatrix);
        float x = this.floatMatrix[2];
        return this.getImageWidth() < (float)this.viewWidth ? false : (x >= -1.0f && direction < 0 ? false : Math.abs(x) + (float)this.viewWidth + 1.0f < this.getImageWidth() || direction <= 0);
    }

    public boolean canScrollVertically(int direction) {
        this.touchMatrix.getValues(this.floatMatrix);
        float y = this.floatMatrix[5];
        return this.getImageHeight() < (float)this.viewHeight ? false : (y >= -1.0f && direction < 0 ? false : Math.abs(y) + (float)this.viewHeight + 1.0f < this.getImageHeight() || direction <= 0);
    }

    private final void scaleImage(double deltaScale, float focusX, float focusY, boolean stretchImageToSuper) {
        double deltaScaleLocal = deltaScale;
        float lowerScale = 0.0f;
        float upperScale = 0.0f;
        if (stretchImageToSuper) {
            lowerScale = this.superMinScale;
            upperScale = this.superMaxScale;
        } else {
            lowerScale = this.minScale;
            upperScale = this.maxScale;
        }
        float origScale = this.currentZoom;
        this.currentZoom *= (float)deltaScaleLocal;
        if (this.currentZoom > upperScale) {
            this.currentZoom = upperScale;
            deltaScaleLocal = (double)upperScale / (double)origScale;
        } else if (this.currentZoom < lowerScale) {
            this.currentZoom = lowerScale;
            deltaScaleLocal = (double)lowerScale / (double)origScale;
        }
        this.touchMatrix.postScale((float)deltaScaleLocal, (float)deltaScaleLocal, focusX, focusY);
        this.fixScaleTrans();
    }

    @NotNull
    protected final PointF transformCoordTouchToBitmap(float x, float y, boolean clipToBitmap) {
        this.touchMatrix.getValues(this.floatMatrix);
        float origW = this.getDrawable().getIntrinsicWidth();
        float origH = this.getDrawable().getIntrinsicHeight();
        float transX = this.floatMatrix[2];
        float transY = this.floatMatrix[5];
        float finalX = (x - transX) * origW / this.getImageWidth();
        float finalY = (y - transY) * origH / this.getImageHeight();
        if (clipToBitmap) {
            finalX = Math.min(Math.max(finalX, 0.0f), origW);
            finalY = Math.min(Math.max(finalY, 0.0f), origH);
        }
        return new PointF(finalX, finalY);
    }

    @NotNull
    protected final PointF transformCoordBitmapToTouch(float bx, float by) {
        this.touchMatrix.getValues(this.floatMatrix);
        float origW = this.getDrawable().getIntrinsicWidth();
        float origH = this.getDrawable().getIntrinsicHeight();
        float px = bx / origW;
        float py = by / origH;
        float finalX = this.floatMatrix[2] + this.getImageWidth() * px;
        float finalY = this.floatMatrix[5] + this.getImageHeight() * py;
        return new PointF(finalX, finalY);
    }

    private final void compatPostOnAnimation(Runnable runnable) {
        this.postOnAnimation(runnable);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY) {
        this.setZoomAnimated(scale, focusX, focusY, 500);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, int zoomTimeMs) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), zoomTimeMs);
        this.compatPostOnAnimation(animation);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, int zoomTimeMs, @Nullable OnZoomFinishedListener listener) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), zoomTimeMs);
        animation.setListener(listener);
        this.compatPostOnAnimation(animation);
    }

    public final void setZoomAnimated(float scale, float focusX, float focusY, @Nullable OnZoomFinishedListener listener) {
        AnimatedZoom animation = new AnimatedZoom(scale, new PointF(focusX, focusY), 500);
        animation.setListener(listener);
        this.compatPostOnAnimation(animation);
    }

    @JvmOverloads
    public TouchImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public TouchImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0002J\u0010\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ortiz/touchview/TouchImageView$AnimatedZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focus", "Landroid/graphics/PointF;", "zoomTimeMillis", "", "<init>", "(Lcom/ortiz/touchview/TouchImageView;FLandroid/graphics/PointF;I)V", "startTime", "", "startZoom", "startFocus", "targetFocus", "interpolator", "Landroid/view/animation/LinearInterpolator;", "zoomFinishedListener", "Lcom/ortiz/touchview/OnZoomFinishedListener;", "run", "", "interpolate", "setListener", "listener", "touchview_release"})
    private final class AnimatedZoom
    implements Runnable {
        private final int zoomTimeMillis;
        private final long startTime;
        private final float startZoom;
        private final float targetZoom;
        @NotNull
        private final PointF startFocus;
        @NotNull
        private final PointF targetFocus;
        @NotNull
        private final LinearInterpolator interpolator;
        @Nullable
        private OnZoomFinishedListener zoomFinishedListener;

        public AnimatedZoom(@NotNull float targetZoom, PointF focus, int zoomTimeMillis) {
            Intrinsics.checkNotNullParameter((Object)focus, (String)"focus");
            this.interpolator = new LinearInterpolator();
            TouchImageView.this.setState(ImageActionState.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.getCurrentZoom();
            this.targetZoom = targetZoom;
            this.zoomTimeMillis = zoomTimeMillis;
            this.startFocus = TouchImageView.this.getScrollPosition();
            this.targetFocus = focus;
        }

        @Override
        public void run() {
            block1: {
                block0: {
                    float t = this.interpolate();
                    float nextZoom = this.startZoom + (this.targetZoom - this.startZoom) * t;
                    float nextX = this.startFocus.x + (this.targetFocus.x - this.startFocus.x) * t;
                    float nextY = this.startFocus.y + (this.targetFocus.y - this.startFocus.y) * t;
                    TouchImageView.this.setZoom(nextZoom, nextX, nextY);
                    if (!(t < 1.0f)) break block0;
                    TouchImageView.this.compatPostOnAnimation(this);
                    break block1;
                }
                TouchImageView.this.setState(ImageActionState.NONE);
                OnZoomFinishedListener onZoomFinishedListener = this.zoomFinishedListener;
                if (onZoomFinishedListener == null) break block1;
                onZoomFinishedListener.onZoomFinished();
            }
        }

        private final float interpolate() {
            float elapsed = (float)(System.currentTimeMillis() - this.startTime) / (float)this.zoomTimeMillis;
            elapsed = Math.min(1.0f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        public final void setListener(@Nullable OnZoomFinishedListener listener) {
            this.zoomFinishedListener = listener;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ortiz/touchview/TouchImageView$Companion;", "", "<init>", "()V", "SUPER_MIN_MULTIPLIER", "", "SUPER_MAX_MULTIPLIER", "DEFAULT_ZOOM_TIME", "", "AUTOMATIC_MIN_ZOOM", "touchview_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\t\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JF\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001c\u001a\u00020\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u001a\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001d\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\u00a8\u0006\""}, d2={"Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "", "context", "Landroid/content/Context;", "<init>", "(Lcom/ortiz/touchview/TouchImageView;Landroid/content/Context;)V", "overScroller", "Landroid/widget/OverScroller;", "getOverScroller", "()Landroid/widget/OverScroller;", "setOverScroller", "(Landroid/widget/OverScroller;)V", "fling", "", "startX", "", "startY", "velocityX", "velocityY", "minX", "maxX", "minY", "maxY", "forceFinished", "finished", "", "isFinished", "()Z", "computeScrollOffset", "currX", "getCurrX", "()I", "currY", "getCurrY", "touchview_release"})
    private final class CompatScroller {
        @NotNull
        private OverScroller overScroller;

        public CompatScroller(Context context) {
            this.overScroller = new OverScroller(context);
        }

        @NotNull
        public final OverScroller getOverScroller() {
            return this.overScroller;
        }

        public final void setOverScroller(@NotNull OverScroller overScroller) {
            Intrinsics.checkNotNullParameter((Object)overScroller, (String)"<set-?>");
            this.overScroller = overScroller;
        }

        public final void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
            this.overScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
        }

        public final void forceFinished(boolean finished) {
            this.overScroller.forceFinished(finished);
        }

        public final boolean isFinished() {
            return this.overScroller.isFinished();
        }

        public final boolean computeScrollOffset() {
            this.overScroller.computeScrollOffset();
            return this.overScroller.computeScrollOffset();
        }

        public final int getCurrX() {
            return this.overScroller.getCurrX();
        }

        public final int getCurrY() {
            return this.overScroller.getCurrY();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/ortiz/touchview/TouchImageView$DoubleTapZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focusX", "focusY", "stretchImageToSuper", "", "<init>", "(Lcom/ortiz/touchview/TouchImageView;FFFZ)V", "startTime", "", "startZoom", "bitmapX", "bitmapY", "interpolator", "Landroid/view/animation/AccelerateDecelerateInterpolator;", "startTouch", "Landroid/graphics/PointF;", "endTouch", "run", "", "translateImageToCenterTouchPosition", "t", "interpolate", "calculateDeltaScale", "", "touchview_release"})
    private final class DoubleTapZoom
    implements Runnable {
        private final long startTime;
        private final float startZoom;
        private final float targetZoom;
        private final float bitmapX;
        private final float bitmapY;
        private final boolean stretchImageToSuper;
        @NotNull
        private final AccelerateDecelerateInterpolator interpolator = new AccelerateDecelerateInterpolator();
        @NotNull
        private final PointF startTouch;
        @NotNull
        private final PointF endTouch;

        public DoubleTapZoom(float targetZoom, float focusX, float focusY, boolean stretchImageToSuper) {
            TouchImageView.this.setState(ImageActionState.ANIMATE_ZOOM);
            this.startTime = System.currentTimeMillis();
            this.startZoom = TouchImageView.this.getCurrentZoom();
            this.targetZoom = targetZoom;
            this.stretchImageToSuper = stretchImageToSuper;
            PointF bitmapPoint = TouchImageView.this.transformCoordTouchToBitmap(focusX, focusY, false);
            this.bitmapX = bitmapPoint.x;
            this.bitmapY = bitmapPoint.y;
            this.startTouch = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            this.endTouch = new PointF((float)(TouchImageView.this.viewWidth / 2), (float)(TouchImageView.this.viewHeight / 2));
        }

        @Override
        public void run() {
            if (TouchImageView.this.getDrawable() == null) {
                TouchImageView.this.setState(ImageActionState.NONE);
                return;
            }
            float t = this.interpolate();
            double deltaScale = this.calculateDeltaScale(t);
            TouchImageView.this.scaleImage(deltaScale, this.bitmapX, this.bitmapY, this.stretchImageToSuper);
            this.translateImageToCenterTouchPosition(t);
            TouchImageView.this.fixScaleTrans();
            TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
            OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
            if (onTouchImageViewListener != null) {
                onTouchImageViewListener.onMove();
            }
            if (t < 1.0f) {
                TouchImageView.this.compatPostOnAnimation(this);
            } else {
                TouchImageView.this.setState(ImageActionState.NONE);
            }
        }

        private final void translateImageToCenterTouchPosition(float t) {
            float targetX = this.startTouch.x + t * (this.endTouch.x - this.startTouch.x);
            float targetY = this.startTouch.y + t * (this.endTouch.y - this.startTouch.y);
            PointF curr = TouchImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            TouchImageView.this.touchMatrix.postTranslate(targetX - curr.x, targetY - curr.y);
        }

        private final float interpolate() {
            long currTime = System.currentTimeMillis();
            float elapsed = (float)(currTime - this.startTime) / 500.0f;
            elapsed = Math.min(1.0f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        private final double calculateDeltaScale(float t) {
            double zoom = (double)this.startZoom + (double)t * (double)(this.targetZoom - this.startZoom);
            return zoom / (double)TouchImageView.this.getCurrentZoom();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u00020\u0017H\u0016R\u001e\u0010\u0007\u001a\u00060\bR\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/ortiz/touchview/TouchImageView$Fling;", "Ljava/lang/Runnable;", "velocityX", "", "velocityY", "<init>", "(Lcom/ortiz/touchview/TouchImageView;II)V", "scroller", "Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "Lcom/ortiz/touchview/TouchImageView;", "getScroller", "()Lcom/ortiz/touchview/TouchImageView$CompatScroller;", "setScroller", "(Lcom/ortiz/touchview/TouchImageView$CompatScroller;)V", "currX", "getCurrX", "()I", "setCurrX", "(I)V", "currY", "getCurrY", "setCurrY", "cancelFling", "", "run", "touchview_release"})
    private final class Fling
    implements Runnable {
        @NotNull
        private CompatScroller scroller;
        private int currX;
        private int currY;

        public Fling(int velocityX, int velocityY) {
            TouchImageView.this.setState(ImageActionState.FLING);
            this.scroller = new CompatScroller(TouchImageView.this.getContext());
            TouchImageView.this.touchMatrix.getValues(TouchImageView.this.floatMatrix);
            int startX = (int)TouchImageView.this.floatMatrix[2];
            int startY = (int)TouchImageView.this.floatMatrix[5];
            int minX = 0;
            int maxX = 0;
            int minY = 0;
            int maxY = 0;
            if (TouchImageView.this.isRotateImageToFitScreen && TouchImageView.this.orientationMismatch(TouchImageView.this.getDrawable())) {
                startX -= (int)TouchImageView.this.getImageWidth();
            }
            if (TouchImageView.this.getImageWidth() > (float)TouchImageView.this.viewWidth) {
                minX = TouchImageView.this.viewWidth - (int)TouchImageView.this.getImageWidth();
                maxX = 0;
            } else {
                minX = maxX = startX;
            }
            if (TouchImageView.this.getImageHeight() > (float)TouchImageView.this.viewHeight) {
                minY = TouchImageView.this.viewHeight - (int)TouchImageView.this.getImageHeight();
                maxY = 0;
            } else {
                minY = maxY = startY;
            }
            this.scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            this.currX = startX;
            this.currY = startY;
        }

        @NotNull
        public final CompatScroller getScroller() {
            return this.scroller;
        }

        public final void setScroller(@NotNull CompatScroller compatScroller) {
            Intrinsics.checkNotNullParameter((Object)compatScroller, (String)"<set-?>");
            this.scroller = compatScroller;
        }

        public final int getCurrX() {
            return this.currX;
        }

        public final void setCurrX(int n) {
            this.currX = n;
        }

        public final int getCurrY() {
            return this.currY;
        }

        public final void setCurrY(int n) {
            this.currY = n;
        }

        public final void cancelFling() {
            TouchImageView.this.setState(ImageActionState.NONE);
            this.scroller.forceFinished(true);
        }

        @Override
        public void run() {
            OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
            if (onTouchImageViewListener != null) {
                onTouchImageViewListener.onMove();
            }
            if (this.scroller.isFinished()) {
                return;
            }
            if (this.scroller.computeScrollOffset()) {
                int newX = this.scroller.getCurrX();
                int newY = this.scroller.getCurrY();
                int transX = newX - this.currX;
                int transY = newY - this.currY;
                this.currX = newX;
                this.currY = newY;
                TouchImageView.this.touchMatrix.postTranslate((float)transX, (float)transY);
                TouchImageView.this.fixTrans();
                TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
                TouchImageView.this.compatPostOnAnimation(this);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J*\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/ortiz/touchview/TouchImageView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "<init>", "(Lcom/ortiz/touchview/TouchImageView;)V", "onSingleTapConfirmed", "", "e", "Landroid/view/MotionEvent;", "onLongPress", "", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onDoubleTap", "onDoubleTapEvent", "touchview_release"})
    @SourceDebugExtension(value={"SMAP\nTouchImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TouchImageView.kt\ncom/ortiz/touchview/TouchImageView$GestureListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1286:1\n1#2:1287\n*E\n"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
            return onDoubleTapListener != null ? onDoubleTapListener.onSingleTapConfirmed(e) : TouchImageView.this.performClick();
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TouchImageView.this.performLongClick();
        }

        /*
         * WARNING - void declaration
         */
        public boolean onFling(@Nullable MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
            void it;
            Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
            Fling fling = TouchImageView.this.fling;
            if (fling != null) {
                fling.cancelFling();
            }
            Fling fling2 = new Fling((int)velocityX, (int)velocityY);
            TouchImageView touchImageView = TouchImageView.this;
            Fling fling3 = fling2;
            TouchImageView touchImageView2 = TouchImageView.this;
            boolean bl = false;
            touchImageView.compatPostOnAnimation((Runnable)it);
            touchImageView2.fling = fling2;
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onDoubleTap(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            boolean consumed = false;
            if (TouchImageView.this.isZoomEnabled()) {
                GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
                if (onDoubleTapListener != null) {
                    GestureDetector.OnDoubleTapListener it = onDoubleTapListener;
                    boolean bl = false;
                    consumed = it.onDoubleTap(e);
                }
                if (TouchImageView.this.imageActionState == ImageActionState.NONE) {
                    float maxZoomScale = TouchImageView.this.getDoubleTapScale() == 0.0f ? TouchImageView.this.maxScale : TouchImageView.this.getDoubleTapScale();
                    float targetZoom = TouchImageView.this.getCurrentZoom() == TouchImageView.this.minScale ? maxZoomScale : TouchImageView.this.minScale;
                    DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, e.getX(), e.getY(), false);
                    TouchImageView.this.compatPostOnAnimation(doubleTap);
                    consumed = true;
                }
            }
            return consumed;
        }

        public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            GestureDetector.OnDoubleTapListener onDoubleTapListener = TouchImageView.this.doubleTapListener;
            return onDoubleTapListener != null ? onDoubleTapListener.onDoubleTapEvent(e) : false;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ortiz/touchview/TouchImageView$PrivateOnTouchListener;", "Landroid/view/View$OnTouchListener;", "<init>", "(Lcom/ortiz/touchview/TouchImageView;)V", "last", "Landroid/graphics/PointF;", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "touchview_release"})
    private final class PrivateOnTouchListener
    implements View.OnTouchListener {
        @NotNull
        private final PointF last = new PointF();

        public boolean onTouch(@NotNull View v, @NotNull MotionEvent event) {
            block11: {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (TouchImageView.this.getDrawable() == null) {
                    TouchImageView.this.setState(ImageActionState.NONE);
                    return false;
                }
                if (TouchImageView.this.isZoomEnabled()) {
                    TouchImageView.this.scaleDetector.onTouchEvent(event);
                }
                TouchImageView.this.gestureDetector.onTouchEvent(event);
                PointF curr = new PointF(event.getX(), event.getY());
                if (TouchImageView.this.imageActionState == ImageActionState.NONE || TouchImageView.this.imageActionState == ImageActionState.DRAG || TouchImageView.this.imageActionState == ImageActionState.FLING) {
                    switch (event.getAction()) {
                        case 0: {
                            this.last.set(curr);
                            Fling fling = TouchImageView.this.fling;
                            if (fling != null) {
                                fling.cancelFling();
                            }
                            TouchImageView.this.setState(ImageActionState.DRAG);
                            break;
                        }
                        case 2: {
                            if (TouchImageView.this.imageActionState != ImageActionState.DRAG) break;
                            float deltaX = curr.x - this.last.x;
                            float deltaY = curr.y - this.last.y;
                            float fixTransX = TouchImageView.this.getFixDragTrans(deltaX, TouchImageView.this.viewWidth, TouchImageView.this.getImageWidth());
                            float fixTransY = TouchImageView.this.getFixDragTrans(deltaY, TouchImageView.this.viewHeight, TouchImageView.this.getImageHeight());
                            TouchImageView.this.touchMatrix.postTranslate(fixTransX, fixTransY);
                            TouchImageView.this.fixTrans();
                            this.last.set(curr.x, curr.y);
                            break;
                        }
                        case 1: 
                        case 6: {
                            TouchImageView.this.setState(ImageActionState.NONE);
                        }
                    }
                }
                OnTouchCoordinatesListener onTouchCoordinatesListener = TouchImageView.this.touchCoordinatesListener;
                if (onTouchCoordinatesListener != null) {
                    OnTouchCoordinatesListener onTouchCoordinatesListener2 = onTouchCoordinatesListener;
                    TouchImageView touchImageView = TouchImageView.this;
                    OnTouchCoordinatesListener it = onTouchCoordinatesListener2;
                    boolean bl = false;
                    PointF bitmapPoint = touchImageView.transformCoordTouchToBitmap(event.getX(), event.getY(), true);
                    it.onTouchCoordinate(v, event, bitmapPoint);
                }
                TouchImageView.this.setImageMatrix(TouchImageView.this.touchMatrix);
                View.OnTouchListener onTouchListener = TouchImageView.this.userTouchListener;
                if (onTouchListener != null) {
                    onTouchListener.onTouch(v, event);
                }
                OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
                if (onTouchImageViewListener == null) break block11;
                onTouchImageViewListener.onMove();
            }
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/ortiz/touchview/TouchImageView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "<init>", "(Lcom/ortiz/touchview/TouchImageView;)V", "onScaleBegin", "", "detector", "Landroid/view/ScaleGestureDetector;", "onScale", "onScaleEnd", "", "touchview_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            TouchImageView.this.setState(ImageActionState.ZOOM);
            return true;
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
                TouchImageView.this.scaleImage(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY(), TouchImageView.this.isSuperZoomEnabled());
                OnTouchImageViewListener onTouchImageViewListener = TouchImageView.this.touchImageViewListener;
                if (onTouchImageViewListener == null) break block0;
                onTouchImageViewListener.onMove();
            }
            return true;
        }

        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkNotNullParameter((Object)detector, (String)"detector");
            super.onScaleEnd(detector);
            TouchImageView.this.setState(ImageActionState.NONE);
            boolean animateToZoomBoundary = false;
            float targetZoom = TouchImageView.this.getCurrentZoom();
            if (TouchImageView.this.getCurrentZoom() > TouchImageView.this.maxScale) {
                targetZoom = TouchImageView.this.maxScale;
                animateToZoomBoundary = true;
            } else if (TouchImageView.this.getCurrentZoom() < TouchImageView.this.minScale) {
                targetZoom = TouchImageView.this.minScale;
                animateToZoomBoundary = true;
            }
            if (animateToZoomBoundary) {
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, TouchImageView.this.viewWidth / 2, TouchImageView.this.viewHeight / 2, TouchImageView.this.isSuperZoomEnabled());
                TouchImageView.this.compatPostOnAnimation(doubleTap);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageView.ScaleType.values().length];
            try {
                nArray[ImageView.ScaleType.CENTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_CROP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.CENTER_INSIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_CENTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_START.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_END.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageView.ScaleType.FIT_XY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

