/*
 * Decompiled with CFR 0.152.
 */
package com.mackhartley.roundedprogressbar;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.core.content.ContextCompat;
import com.mackhartley.roundedprogressbar.DefaultProgressTextFormatter;
import com.mackhartley.roundedprogressbar.ProgressTextFormatter;
import com.mackhartley.roundedprogressbar.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0014J\b\u0010#\u001a\u00020 H\u0002J\b\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020 2\b\b\u0001\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000eJ\u000e\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0015J\u0010\u0010+\u001a\u00020 2\b\b\u0001\u0010&\u001a\u00020\u0007J\u000e\u0010,\u001a\u00020 2\u0006\u0010-\u001a\u00020\u0017J\u000e\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020\u0015J\u000e\u00100\u001a\u00020 2\u0006\u00101\u001a\u00020\u0015J\u000e\u0010\u001a\u001a\u00020 2\u0006\u00102\u001a\u00020\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/mackhartley/roundedprogressbar/ProgressTextOverlay;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "backgroundTextOverlayPaint", "Landroid/graphics/Paint;", "boundingRect", "Landroid/graphics/Rect;", "customFontPath", "", "defaultBgTextColor", "defaultFontPath", "defaultShowProgressText", "", "defaultTextColor", "defaultTextSize", "", "progressTextFormatter", "Lcom/mackhartley/roundedprogressbar/ProgressTextFormatter;", "progressTextOverlayPaint", "progressValue", "showProgressText", "textContainerHeight", "textContainerWidth", "textSidePadding", "textSize", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "reCalculateTextHeight", "reCalculateTextWidth", "setBackgroundTextColor", "newColor", "setCustomFontPath", "newFontPath", "setProgress", "newProgress", "setProgressTextColor", "setProgressTextFormatter", "newProgressTextFormatter", "setTextPadding", "newTextPadding", "setTextSize", "newTextSize", "newShowProgressText", "Companion", "roundedprogressbar_release"})
public final class ProgressTextOverlay
extends View {
    private final float defaultTextSize;
    private final int defaultTextColor;
    private final int defaultBgTextColor;
    private final boolean defaultShowProgressText = true;
    private final String defaultFontPath = "";
    private float progressValue;
    private float textSize;
    private boolean showProgressText;
    private float textContainerHeight;
    private float textContainerWidth;
    private float textSidePadding;
    private String customFontPath;
    private ProgressTextFormatter progressTextFormatter;
    private final Paint progressTextOverlayPaint;
    private final Paint backgroundTextOverlayPaint;
    private final Rect boundingRect;
    public static final float START_PROGRESS_VALUE = 0.0f;
    public static final boolean DEFAULT_SHOW_TEXT = true;
    @NotNull
    public static final String DEFAULT_FONT_PATH = "";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    protected void onDraw(@Nullable Canvas canvas) {
        block0: {
            float xPosition;
            float yPosition;
            block1: {
                if (!this.showProgressText) break block0;
                super.onDraw(canvas);
                yPosition = (float)(this.getHeight() / 2) + this.textContainerHeight / (float)2;
                float progressDrawableWidth = (float)this.getWidth() * this.progressValue;
                float requiredTextContainerWidth = this.textContainerWidth + (float)2 * this.textSidePadding;
                xPosition = 0.0f;
                if (!(requiredTextContainerWidth < progressDrawableWidth)) break block1;
                xPosition = (float)this.getWidth() * this.progressValue - this.textContainerWidth - this.textSidePadding;
                Canvas canvas2 = canvas;
                if (canvas2 == null) break block0;
                canvas2.drawText(this.progressTextFormatter.getProgressText(this.progressValue), xPosition, yPosition, this.progressTextOverlayPaint);
                break block0;
            }
            xPosition = (float)this.getWidth() * this.progressValue + this.textSidePadding;
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block0;
            canvas3.drawText(this.progressTextFormatter.getProgressText(this.progressValue), xPosition, yPosition, this.backgroundTextOverlayPaint);
        }
    }

    private final void reCalculateTextHeight() {
        float measuredSize;
        this.progressTextOverlayPaint.setTextSize(this.textSize);
        this.backgroundTextOverlayPaint.setTextSize(this.textSize);
        String newProgressString = this.progressTextFormatter.getProgressText(this.progressValue);
        this.progressTextOverlayPaint.getTextBounds(newProgressString, 0, newProgressString.length(), this.boundingRect);
        this.textContainerHeight = measuredSize = (float)this.boundingRect.height();
    }

    private final void reCalculateTextWidth() {
        float f;
        this.progressTextOverlayPaint.setTextSize(this.textSize);
        this.backgroundTextOverlayPaint.setTextSize(this.textSize);
        String newProgressString = this.progressTextFormatter.getProgressText(this.progressValue);
        this.progressTextOverlayPaint.getTextBounds(newProgressString, 0, newProgressString.length(), this.boundingRect);
        float measuredSize = this.boundingRect.width();
        this.progressTextOverlayPaint.getTextBounds(this.progressTextFormatter.getMinWidthString(), 0, this.progressTextFormatter.getMinWidthString().length(), this.boundingRect);
        float minSizeAllowed = this.boundingRect.width();
        ProgressTextOverlay progressTextOverlay = this;
        boolean bl = false;
        progressTextOverlay.textContainerWidth = f = Math.max(measuredSize, minSizeAllowed);
    }

    public final void setProgress(float newProgress) {
        this.progressValue = newProgress;
        this.reCalculateTextWidth();
        this.invalidate();
    }

    public final void setTextSize(float newTextSize) {
        this.textSize = newTextSize;
        this.reCalculateTextHeight();
        this.reCalculateTextWidth();
        this.invalidate();
    }

    public final void setCustomFontPath(@NotNull String newFontPath) {
        Intrinsics.checkParameterIsNotNull((Object)newFontPath, (String)"newFontPath");
        CharSequence charSequence = newFontPath;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            this.customFontPath = newFontPath;
            Context context = this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            Typeface newTypeface = Typeface.createFromAsset((AssetManager)context.getAssets(), (String)this.customFontPath);
            this.progressTextOverlayPaint.setTypeface(newTypeface);
            this.backgroundTextOverlayPaint.setTypeface(newTypeface);
            this.reCalculateTextHeight();
            this.reCalculateTextWidth();
            this.invalidate();
        }
    }

    public final void setProgressTextColor(@ColorInt int newColor) {
        this.progressTextOverlayPaint.setColor(newColor);
        this.invalidate();
    }

    public final void setBackgroundTextColor(@ColorInt int newColor) {
        this.backgroundTextOverlayPaint.setColor(newColor);
        this.invalidate();
    }

    public final void showProgressText(boolean newShowProgressText) {
        this.showProgressText = newShowProgressText;
        this.invalidate();
    }

    public final void setTextPadding(float newTextPadding) {
        this.textSidePadding = newTextPadding;
        this.reCalculateTextWidth();
        this.invalidate();
    }

    public final void setProgressTextFormatter(@NotNull ProgressTextFormatter newProgressTextFormatter) {
        Intrinsics.checkParameterIsNotNull((Object)newProgressTextFormatter, (String)"newProgressTextFormatter");
        this.progressTextFormatter = newProgressTextFormatter;
        this.reCalculateTextWidth();
        this.invalidate();
    }

    @JvmOverloads
    public ProgressTextOverlay(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.defaultTextSize = context.getResources().getDimension(R.dimen.rpb_default_text_size);
        this.defaultTextColor = R.color.rpb_default_text_color;
        this.defaultBgTextColor = R.color.rpb_default_text_color;
        this.defaultShowProgressText = true;
        this.defaultFontPath = DEFAULT_FONT_PATH;
        this.textSize = this.defaultTextSize;
        this.showProgressText = this.defaultShowProgressText;
        this.textSidePadding = context.getResources().getDimension(R.dimen.rpb_default_text_padding);
        this.customFontPath = this.defaultFontPath;
        this.progressTextFormatter = new DefaultProgressTextFormatter(false, false, 3, null);
        this.boundingRect = new Rect();
        Paint newPaint = new Paint(1);
        newPaint.setColor(ContextCompat.getColor((Context)context, (int)this.defaultTextColor));
        this.progressTextOverlayPaint = newPaint;
        Paint newAltPaint = new Paint(1);
        newAltPaint.setColor(ContextCompat.getColor((Context)context, (int)this.defaultBgTextColor));
        this.backgroundTextOverlayPaint = newAltPaint;
        CharSequence charSequence = this.customFontPath;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence)) {
            this.setCustomFontPath(this.customFontPath);
        }
        this.reCalculateTextHeight();
    }

    public /* synthetic */ ProgressTextOverlay(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public ProgressTextOverlay(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public ProgressTextOverlay(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/mackhartley/roundedprogressbar/ProgressTextOverlay$Companion;", "", "()V", "DEFAULT_FONT_PATH", "", "DEFAULT_SHOW_TEXT", "", "START_PROGRESS_VALUE", "", "roundedprogressbar_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

