/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.routing;

import android.util.Log;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.routing.Road;
import org.osmdroid.bonuspack.routing.RoadManager;
import org.osmdroid.bonuspack.routing.RoadNode;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class MapQuestRoadManager
extends RoadManager {
    static final String MAPQUEST_GUIDANCE_SERVICE = "https://open.mapquestapi.com/guidance/v2/route?";
    protected String mApiKey;

    public MapQuestRoadManager(String apiKey) {
        this.mApiKey = apiKey;
    }

    protected String getUrl(ArrayList<GeoPoint> waypoints) {
        StringBuilder urlString = new StringBuilder(MAPQUEST_GUIDANCE_SERVICE);
        urlString.append("key=" + this.mApiKey);
        urlString.append("&from=");
        GeoPoint p = waypoints.get(0);
        urlString.append(this.geoPointAsString(p));
        for (int i = 1; i < waypoints.size(); ++i) {
            p = waypoints.get(i);
            urlString.append("&to=" + this.geoPointAsString(p));
        }
        urlString.append("&shapeFormat=cmp6");
        urlString.append("&narrativeType=text");
        urlString.append("&unit=k&fishbone=false");
        urlString.append(this.mOptions);
        return urlString.toString();
    }

    @Override
    public Road getRoad(ArrayList<GeoPoint> waypoints) {
        String url = this.getUrl(waypoints);
        Log.d((String)"BONUSPACK", (String)("MapQuestRoadManager.getRoute:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url);
        if (jString == null) {
            return new Road(waypoints);
        }
        Road road = new Road();
        ArrayList<RoadLink> links = new ArrayList<RoadLink>();
        try {
            JSONObject jRoot = new JSONObject(jString);
            JSONObject jGuidance = jRoot.getJSONObject("guidance");
            JSONArray jGuidanceLinkCollection = jGuidance.getJSONArray("GuidanceLinkCollection");
            int n = jGuidanceLinkCollection.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jLink = jGuidanceLinkCollection.getJSONObject(i);
                RoadLink link = new RoadLink();
                link.mLength = jLink.getDouble("length");
                link.mSpeed = jLink.getDouble("speed");
                link.mShapeIndex = jLink.getInt("shapeIndex");
                link.mDuration = link.mLength / link.mSpeed * 3600.0;
                links.add(link);
                road.mLength += link.mLength;
                road.mDuration += link.mDuration;
            }
            JSONArray jGuidanceNodeCollection = jGuidance.getJSONArray("GuidanceNodeCollection");
            n = jGuidanceNodeCollection.length();
            for (int i = 0; i < n; ++i) {
                int maneuverType;
                JSONObject jNode = jGuidanceNodeCollection.getJSONObject(i);
                RoadNode node = new RoadNode();
                int turnCost = jNode.optInt("turnCost", 0);
                node.mDuration += (double)turnCost;
                road.mDuration += (double)turnCost;
                node.mManeuverType = maneuverType = jNode.optInt("maneuverType", 0);
                JSONArray jLinkIds = jNode.optJSONArray("linkIds");
                if (jLinkIds != null) {
                    node.mNextRoadLink = jLinkIds.getInt(0);
                }
                node.mInstructions = jNode.optString("preTts", "");
                road.mNodes.add(node);
            }
            JSONArray jShape = jGuidance.getJSONArray("shapePoints");
            n = jShape.length();
            road.mRouteHigh = new ArrayList(n);
            for (int i = 0; i < n / 2; ++i) {
                double lat = jShape.getDouble(i * 2);
                double lng = jShape.getDouble(i * 2 + 1);
                GeoPoint p = new GeoPoint(lat, lng);
                road.mRouteHigh.add(p);
            }
            JSONObject jSummary = jGuidance.getJSONObject("summary");
            JSONObject jBoundingBox = jSummary.getJSONObject("boundingBox");
            road.mBoundingBox = new BoundingBox(jBoundingBox.getDouble("maxLat"), jBoundingBox.getDouble("maxLng"), jBoundingBox.getDouble("minLat"), jBoundingBox.getDouble("minLng"));
            road.mNodes = this.finalizeNodes(road.mNodes, links, road.mRouteHigh);
            road.mRouteHigh = this.finalizeRoadShape(road, links);
            road.buildLegs(waypoints);
            road.mStatus = 0;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new Road(waypoints);
        }
        Log.d((String)"BONUSPACK", (String)"MapQuestRoadManager.getRoute - finished");
        return road;
    }

    @Override
    public Road[] getRoads(ArrayList<GeoPoint> waypoints) {
        Road road = this.getRoad(waypoints);
        Road[] roads = new Road[]{road};
        return roads;
    }

    protected ArrayList<RoadNode> finalizeNodes(ArrayList<RoadNode> mNodes, ArrayList<RoadLink> mLinks, ArrayList<GeoPoint> polyline) {
        int n = mNodes.size();
        if (n == 0) {
            return mNodes;
        }
        ArrayList<RoadNode> newNodes = new ArrayList<RoadNode>(n);
        RoadNode lastNode = null;
        for (int i = 1; i < n - 1; ++i) {
            RoadNode node = mNodes.get(i);
            RoadLink link = mLinks.get(node.mNextRoadLink);
            if (lastNode != null && (node.mInstructions == null || node.mManeuverType == 0)) {
                lastNode.mLength += link.mLength;
                lastNode.mDuration += node.mDuration + link.mDuration;
                continue;
            }
            node.mLength = link.mLength;
            node.mDuration += link.mDuration;
            int locationIndex = link.mShapeIndex;
            node.mLocation = polyline.get(locationIndex);
            newNodes.add(node);
            lastNode = node;
        }
        return newNodes;
    }

    public ArrayList<GeoPoint> finalizeRoadShape(Road road, ArrayList<RoadLink> links) {
        ArrayList<GeoPoint> newShape = new ArrayList<GeoPoint>(road.mRouteHigh.size());
        RoadNode nodeStart = road.mNodes.get(0);
        RoadNode nodeEnd = road.mNodes.get(road.mNodes.size() - 1);
        int shapeIndexStart = links.get((int)nodeStart.mNextRoadLink).mShapeIndex;
        int shapeIndexEnd = links.get((int)nodeEnd.mNextRoadLink).mShapeIndex;
        for (int i = shapeIndexStart; i <= shapeIndexEnd; ++i) {
            newShape.add(road.mRouteHigh.get(i));
        }
        return newShape;
    }

    class RoadLink {
        public double mSpeed;
        public double mLength;
        public double mDuration;
        public int mShapeIndex;

        RoadLink() {
        }
    }
}

