/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import java.util.ArrayList;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.Projection;
import org.osmdroid.views.overlay.Overlay;

public class GroundOverlay
extends Overlay {
    private final Paint mPaint = new Paint();
    private final Matrix mMatrix = new Matrix();
    private float mBearing = 0.0f;
    private float mTransparency;
    private Bitmap mImage;
    private float[] mMatrixSrc;
    private float[] mMatrixDst;
    private GeoPoint mTopLeft;
    private GeoPoint mTopRight;
    private GeoPoint mBottomRight;
    private GeoPoint mBottomLeft;

    public GroundOverlay() {
        this.setTransparency(0.0f);
    }

    public void setImage(Bitmap pImage) {
        this.mImage = pImage;
        this.mMatrixSrc = null;
    }

    public Bitmap getImage() {
        return this.mImage;
    }

    public void setBearing(float pBearing) {
        this.mBearing = pBearing;
    }

    public float getBearing() {
        return this.mBearing;
    }

    public void setTransparency(float pTransparency) {
        this.mTransparency = pTransparency;
        this.mPaint.setAlpha(255 - (int)(this.mTransparency * 255.0f));
    }

    public float getTransparency() {
        return this.mTransparency;
    }

    public void draw(Canvas pCanvas, Projection pProjection) {
        if (this.mImage == null) {
            return;
        }
        this.computeMatrix(pProjection);
        pCanvas.drawBitmap(this.mImage, this.mMatrix, this.mPaint);
    }

    public void setPositionFromBounds(BoundingBox bb) {
        this.setPositionFromBounds(new GeoPoint(bb.getLatNorth(), bb.getLonWest()), new GeoPoint(bb.getLatSouth(), bb.getLonEast()));
    }

    public void setPositionFromBounds(GeoPoint pTopLeft, GeoPoint pBottomRight) {
        this.mMatrix.reset();
        this.mMatrixSrc = null;
        this.mMatrixDst = null;
        this.mTopLeft = new GeoPoint(pTopLeft);
        this.mTopRight = null;
        this.mBottomRight = new GeoPoint(pBottomRight);
        this.mBottomLeft = null;
    }

    public void setPositionFromBounds(GeoPoint pTopLeft, GeoPoint pTopRight, GeoPoint pBottomRight, GeoPoint pBottomLeft) {
        this.mMatrix.reset();
        this.mTopLeft = new GeoPoint(pTopLeft);
        this.mTopRight = new GeoPoint(pTopRight);
        this.mBottomRight = new GeoPoint(pBottomRight);
        this.mBottomLeft = new GeoPoint(pBottomLeft);
    }

    public ArrayList<GeoPoint> getAllBounds() {
        ArrayList<GeoPoint> bounds = new ArrayList<GeoPoint>(4);
        if (this.mTopRight == null) {
            bounds.add(this.mTopLeft);
            bounds.add(this.mBottomRight);
        } else {
            bounds.add(this.mTopLeft);
            bounds.add(this.mTopRight);
            bounds.add(this.mBottomRight);
            bounds.add(this.mBottomLeft);
        }
        return bounds;
    }

    private void computeMatrix(Projection pProjection) {
        if (this.mTopRight == null) {
            long x0 = pProjection.getLongPixelXFromLongitude(this.mTopLeft.getLongitude());
            long y0 = pProjection.getLongPixelYFromLatitude(this.mTopLeft.getLatitude());
            long x1 = pProjection.getLongPixelXFromLongitude(this.mBottomRight.getLongitude());
            long y1 = pProjection.getLongPixelYFromLatitude(this.mBottomRight.getLatitude());
            float widthOnTheMap = x1 - x0;
            float heightOnTheMap = y1 - y0;
            float scaleX = widthOnTheMap / (float)this.mImage.getWidth();
            float scaleY = heightOnTheMap / (float)this.mImage.getHeight();
            this.mMatrix.setScale(scaleX, scaleY);
            this.mMatrix.postTranslate((float)x0, (float)y0);
            return;
        }
        if (this.mMatrixSrc == null) {
            this.mMatrixSrc = new float[8];
            int width = this.mImage.getWidth();
            int height = this.mImage.getHeight();
            this.mMatrixSrc[0] = 0.0f;
            this.mMatrixSrc[1] = 0.0f;
            this.mMatrixSrc[2] = width;
            this.mMatrixSrc[3] = 0.0f;
            this.mMatrixSrc[4] = width;
            this.mMatrixSrc[5] = height;
            this.mMatrixSrc[6] = 0.0f;
            this.mMatrixSrc[7] = height;
        }
        if (this.mMatrixDst == null) {
            this.mMatrixDst = new float[8];
        }
        long topLeftCornerX = pProjection.getLongPixelXFromLongitude(this.mTopLeft.getLongitude());
        long topLeftCornerY = pProjection.getLongPixelYFromLatitude(this.mTopLeft.getLatitude());
        long topRightCornerX = pProjection.getLongPixelXFromLongitude(this.mTopRight.getLongitude());
        long topRightCornerY = pProjection.getLongPixelYFromLatitude(this.mTopRight.getLatitude());
        long bottomRightCornerX = pProjection.getLongPixelXFromLongitude(this.mBottomRight.getLongitude());
        long bottomRightCornerY = pProjection.getLongPixelYFromLatitude(this.mBottomRight.getLatitude());
        long bottomLeftCornerX = pProjection.getLongPixelXFromLongitude(this.mBottomLeft.getLongitude());
        long bottomLeftCornerY = pProjection.getLongPixelYFromLatitude(this.mBottomLeft.getLatitude());
        this.mMatrixDst[0] = topLeftCornerX;
        this.mMatrixDst[1] = topLeftCornerY;
        this.mMatrixDst[2] = topRightCornerX;
        this.mMatrixDst[3] = topRightCornerY;
        this.mMatrixDst[4] = bottomRightCornerX;
        this.mMatrixDst[5] = bottomRightCornerY;
        this.mMatrixDst[6] = bottomLeftCornerX;
        this.mMatrixDst[7] = bottomLeftCornerY;
        this.mMatrix.setPolyToPoly(this.mMatrixSrc, 0, this.mMatrixDst, 0, 4);
    }
}

