/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.overlays;

import android.graphics.Canvas;
import java.util.Comparator;
import java.util.TreeSet;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class FolderZOverlay
extends Overlay {
    protected TreeSet<ZOverlay> mList = new TreeSet();
    protected String mName = "";
    protected String mDescription = "";

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean add(Overlay item, float zIndex) {
        return this.mList.add(new ZOverlay(item, zIndex));
    }

    public boolean add(Overlay item) {
        return this.add(item, 0.0f);
    }

    protected ZOverlay get(Overlay overlay) {
        for (ZOverlay item : this.mList) {
            if (item.mOverlay != overlay) continue;
            this.mList.remove(item);
            return item;
        }
        return null;
    }

    public boolean remove(Overlay overlay) {
        ZOverlay item = this.get(overlay);
        if (item != null) {
            this.mList.remove(item);
            return true;
        }
        return false;
    }

    public void setZIndex(Overlay overlay, float zIndex) {
        ZOverlay item = this.get(overlay);
        if (item == null) {
            return;
        }
        this.mList.remove(item);
        item.mZIndex = zIndex;
        this.mList.add(item);
    }

    public void setBoundingBox(Overlay overlay, BoundingBox bb) {
        ZOverlay item = this.get(overlay);
        if (item == null) {
            return;
        }
        item.setBoundingBox(bb);
    }

    public void unsetBoundingBox(Overlay overlay) {
        ZOverlay item = this.get(overlay);
        if (item == null) {
            return;
        }
        item.unsetBoundingBox();
    }

    public void draw(Canvas canvas, MapView mapView, boolean shadow) {
        if (shadow) {
            return;
        }
        for (ZOverlay item : this.mList) {
            Overlay overlay = item.mOverlay;
            if (overlay == null || !overlay.isEnabled() || !item.shouldBeDrawn(mapView.getBoundingBox(), mapView.getMapOrientation())) continue;
            overlay.draw(canvas, mapView, false);
        }
    }

    protected class ZOverlay
    implements Comparator<ZOverlay> {
        float mZIndex;
        BoundingBox mBoundingBox;
        boolean mBoundingBoxSet;
        Overlay mOverlay;

        public ZOverlay(Overlay o, float zIndex) {
            this.mOverlay = o;
            this.mZIndex = zIndex;
            this.mBoundingBoxSet = false;
        }

        @Override
        public int compare(ZOverlay o1, ZOverlay o2) {
            return (int)Math.signum(o1.mZIndex - o2.mZIndex);
        }

        public void setBoundingBox(BoundingBox bb) {
            this.mBoundingBox = bb.clone();
            this.mBoundingBoxSet = true;
        }

        public void unsetBoundingBox() {
            this.mBoundingBox = null;
            this.mBoundingBoxSet = false;
        }

        public boolean shouldBeDrawn(BoundingBox mapBB, float mapOrientation) {
            if (!this.mBoundingBoxSet) {
                return true;
            }
            if (this.mBoundingBox == null) {
                return false;
            }
            if (mapOrientation != 0.0f) {
                return true;
            }
            return !(this.mBoundingBox.getLatSouth() > mapBB.getLatNorth() || this.mBoundingBox.getLatNorth() < mapBB.getLatSouth() || this.mBoundingBox.getLonWest() > mapBB.getLonEast()) && !(this.mBoundingBox.getLonEast() < mapBB.getLonWest());
        }
    }
}

