/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.util.Log;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.osmdroid.bonuspack.kml.KmlFolder;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlMultiGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.location.POI;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class OverpassAPIProvider {
    public static final String OVERPASS_API_DE_SERVICE = "https://overpass-api.de/api/interpreter";
    public static final String OVERPASS_API_SERVICE = "https://api.openstreetmap.fr/oapi/interpreter";
    protected String mService;

    public OverpassAPIProvider() {
        this.setService(OVERPASS_API_DE_SERVICE);
    }

    public void setService(String serviceUrl) {
        this.mService = serviceUrl;
    }

    public String urlForPOISearch(String tag, BoundingBox bb, int limit, int timeout) {
        StringBuilder s = new StringBuilder();
        s.append(this.mService + "?data=");
        String sBB = "(" + bb.getLatSouth() + "," + bb.getLonWest() + "," + bb.getLatNorth() + "," + bb.getLonEast() + ")";
        String data = "[out:json][timeout:" + timeout + "];(node[" + tag + "]" + sBB + ";way[" + tag + "]" + sBB + ";relation[" + tag + "]" + sBB + ";);out qt center " + limit + " tags;";
        Log.d((String)"BONUSPACK", (String)("data=" + data));
        s.append(URLEncoder.encode(data));
        return s.toString();
    }

    protected GeoPoint geoPointFromJson(JsonObject jLatLon) {
        double lat = jLatLon.get("lat").getAsDouble();
        double lon = jLatLon.get("lon").getAsDouble();
        return new GeoPoint(lat, lon);
    }

    protected String tagValueFromJson(String key, JsonObject jTags) {
        JsonElement jTag = jTags.get(key);
        if (jTag == null) {
            return null;
        }
        return jTag.getAsString();
    }

    protected String tagValueFromJsonNotNull(String key, JsonObject jTags) {
        String v = this.tagValueFromJson(key, jTags);
        return v != null ? "," + v : "";
    }

    public ArrayList<POI> getPOIsFromUrl(String url) {
        Log.d((String)"BONUSPACK", (String)("OverpassAPIProvider:getPOIsFromUrl:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"OverpassAPIProvider: request failed.");
            return null;
        }
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(jString);
            JsonObject jResult = json.getAsJsonObject();
            JsonArray jElements = jResult.get("elements").getAsJsonArray();
            ArrayList<POI> pois = new ArrayList<POI>(jElements.size());
            for (JsonElement j : jElements) {
                JsonObject jo = j.getAsJsonObject();
                POI poi = new POI(POI.POI_SERVICE_OVERPASS_API);
                poi.mId = jo.get("id").getAsLong();
                poi.mCategory = jo.get("type").getAsString();
                if (jo.has("tags")) {
                    JsonObject jTags = jo.get("tags").getAsJsonObject();
                    poi.mType = this.tagValueFromJson("name", jTags);
                    poi.mDescription = this.tagValueFromJsonNotNull("amenity", jTags) + this.tagValueFromJsonNotNull("boundary", jTags) + this.tagValueFromJsonNotNull("building", jTags) + this.tagValueFromJsonNotNull("craft", jTags) + this.tagValueFromJsonNotNull("emergency", jTags) + this.tagValueFromJsonNotNull("highway", jTags) + this.tagValueFromJsonNotNull("historic", jTags) + this.tagValueFromJsonNotNull("landuse", jTags) + this.tagValueFromJsonNotNull("leisure", jTags) + this.tagValueFromJsonNotNull("natural", jTags) + this.tagValueFromJsonNotNull("shop", jTags) + this.tagValueFromJsonNotNull("sport", jTags) + this.tagValueFromJsonNotNull("tourism", jTags);
                    if (poi.mDescription.length() > 0) {
                        poi.mDescription = poi.mDescription.substring(1);
                    }
                    poi.mUrl = this.tagValueFromJson("website", jTags);
                    if (poi.mUrl != null && !poi.mUrl.startsWith("http://") && !poi.mUrl.startsWith("https://")) {
                        poi.mUrl = "http://" + poi.mUrl;
                    }
                }
                if ("node".equals(poi.mCategory)) {
                    poi.mLocation = this.geoPointFromJson(jo);
                } else if (jo.has("center")) {
                    JsonObject jCenter = jo.get("center").getAsJsonObject();
                    poi.mLocation = this.geoPointFromJson(jCenter);
                }
                if (poi.mLocation == null) continue;
                pois.add(poi);
            }
            return pois;
        }
        catch (JsonSyntaxException e) {
            Log.e((String)"BONUSPACK", (String)"OverpassAPIProvider: parsing error.");
            return null;
        }
    }

    public String urlForTagSearchKml(String tag, BoundingBox bb, int limit, int timeout) {
        StringBuilder s = new StringBuilder();
        s.append(this.mService + "?data=");
        String sBB = "(" + bb.getLatSouth() + "," + bb.getLonWest() + "," + bb.getLatNorth() + "," + bb.getLonEast() + ")";
        String data = "[out:json][timeout:" + timeout + "];(node[" + tag + "]" + sBB + ";way[" + tag + "]" + sBB + ";);out qt geom tags " + limit + ";relation[" + tag + "]" + sBB + ";out qt geom body " + limit + ";";
        Log.d((String)"BONUSPACK", (String)("data=" + data));
        s.append(URLEncoder.encode(data));
        return s.toString();
    }

    protected boolean isAnArea(ArrayList<GeoPoint> coords) {
        return coords != null && coords.size() >= 3 && coords.get(0).equals((Object)coords.get(coords.size() - 1));
    }

    protected ArrayList<GeoPoint> parseGeometry(JsonObject jo) {
        JsonArray jGeometry = jo.get("geometry").getAsJsonArray();
        ArrayList<GeoPoint> coords = new ArrayList<GeoPoint>(jGeometry.size());
        for (JsonElement j : jGeometry) {
            JsonObject jLatLon = j.getAsJsonObject();
            GeoPoint p = this.geoPointFromJson(jLatLon);
            coords.add(p);
        }
        return coords;
    }

    protected KmlMultiGeometry buildMultiGeometry(JsonArray jMembers) {
        KmlMultiGeometry geometry = new KmlMultiGeometry();
        for (JsonElement j : jMembers) {
            JsonObject jMember = j.getAsJsonObject();
            KmlGeometry item = this.buildGeometry(jMember);
            geometry.addItem(item);
        }
        return geometry;
    }

    protected KmlGeometry buildGeometry(JsonObject jo) {
        KmlGeometry geometry;
        String type = jo.get("type").getAsString();
        if ("node".equals(type)) {
            geometry = new KmlPoint(this.geoPointFromJson(jo));
        } else if ("way".equals(type)) {
            ArrayList<GeoPoint> coords = this.parseGeometry(jo);
            if (this.isAnArea(coords)) {
                geometry = new KmlPolygon();
                geometry.mCoordinates = coords;
            } else {
                geometry = new KmlLineString();
                geometry.mCoordinates = coords;
            }
        } else {
            JsonArray jMembers = jo.get("members").getAsJsonArray();
            geometry = this.buildMultiGeometry(jMembers);
        }
        return geometry;
    }

    public boolean addInKmlFolder(KmlFolder kmlFolder, String url) {
        Log.d((String)"BONUSPACK", (String)("OverpassAPIProvider:addInKmlFolder:" + url));
        String jString = BonusPackHelper.requestStringFromUrl(url);
        if (jString == null) {
            Log.e((String)"BONUSPACK", (String)"OverpassAPIProvider: request failed.");
            return false;
        }
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(jString);
            JsonObject jResult = json.getAsJsonObject();
            JsonArray jElements = jResult.get("elements").getAsJsonArray();
            for (JsonElement j : jElements) {
                JsonObject jo = j.getAsJsonObject();
                KmlPlacemark placemark = new KmlPlacemark();
                placemark.mGeometry = this.buildGeometry(jo);
                placemark.mId = jo.get("id").getAsString();
                if (jo.has("tags")) {
                    JsonObject jTags = jo.get("tags").getAsJsonObject();
                    if (jTags.has("name")) {
                        placemark.mName = jTags.get("name").getAsString();
                    }
                    Set entrySet = jTags.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String key = (String)entry.getKey();
                        String value = ((JsonElement)entry.getValue()).getAsString();
                        placemark.setExtendedData(key, value);
                    }
                }
                kmlFolder.add(placemark);
            }
            return true;
        }
        catch (JsonSyntaxException e) {
            Log.e((String)"BONUSPACK", (String)"OverpassAPIProvider: parsing error.");
            return false;
        }
    }
}

