/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.location;

import android.location.Address;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;

public class GeocoderNominatim {
    public static final String NOMINATIM_SERVICE_URL = "https://nominatim.openstreetmap.org/";
    public static final String MAPQUEST_SERVICE_URL = "https://open.mapquestapi.com/nominatim/v1/";
    protected Locale mLocale;
    protected String mServiceUrl;
    protected String mKey;
    protected String mUserAgent;
    protected boolean mPolygon;

    public GeocoderNominatim(Locale locale, String userAgent) {
        this.mLocale = locale;
        this.setOptions(false);
        this.setService(NOMINATIM_SERVICE_URL);
        this.mUserAgent = userAgent;
    }

    public GeocoderNominatim(String userAgent) {
        this(Locale.getDefault(), userAgent);
    }

    public static boolean isPresent() {
        return true;
    }

    public void setService(String serviceUrl) {
        this.mServiceUrl = serviceUrl;
    }

    public void setKey(String appKey) {
        this.mKey = appKey;
    }

    public void setOptions(boolean polygon) {
        this.mPolygon = polygon;
    }

    protected Address buildAndroidAddress(JsonObject jResult) throws JsonSyntaxException {
        Address gAddress = new Address(this.mLocale);
        if (!(jResult.has("lat") && jResult.has("lon") && jResult.has("address"))) {
            return null;
        }
        gAddress.setLatitude(jResult.get("lat").getAsDouble());
        gAddress.setLongitude(jResult.get("lon").getAsDouble());
        JsonObject jAddress = jResult.get("address").getAsJsonObject();
        int addressIndex = 0;
        if (jAddress.has("road")) {
            gAddress.setAddressLine(addressIndex++, jAddress.get("road").getAsString());
            gAddress.setThoroughfare(jAddress.get("road").getAsString());
        }
        if (jAddress.has("house_number")) {
            gAddress.setSubThoroughfare(jAddress.get("house_number").getAsString());
        }
        if (jAddress.has("suburb")) {
            gAddress.setSubLocality(jAddress.get("suburb").getAsString());
        }
        if (jAddress.has("postcode")) {
            gAddress.setAddressLine(addressIndex++, jAddress.get("postcode").getAsString());
            gAddress.setPostalCode(jAddress.get("postcode").getAsString());
        }
        if (jAddress.has("city")) {
            gAddress.setAddressLine(addressIndex++, jAddress.get("city").getAsString());
            gAddress.setLocality(jAddress.get("city").getAsString());
        } else if (jAddress.has("town")) {
            gAddress.setAddressLine(addressIndex++, jAddress.get("town").getAsString());
            gAddress.setLocality(jAddress.get("town").getAsString());
        } else if (jAddress.has("village")) {
            gAddress.setAddressLine(addressIndex++, jAddress.get("village").getAsString());
            gAddress.setLocality(jAddress.get("village").getAsString());
        }
        if (jAddress.has("county")) {
            gAddress.setSubAdminArea(jAddress.get("county").getAsString());
        }
        if (jAddress.has("state")) {
            gAddress.setAdminArea(jAddress.get("state").getAsString());
        }
        if (jAddress.has("country")) {
            gAddress.setAddressLine(addressIndex++, jAddress.get("country").getAsString());
            gAddress.setCountryName(jAddress.get("country").getAsString());
        }
        if (jAddress.has("country_code")) {
            gAddress.setCountryCode(jAddress.get("country_code").getAsString());
        }
        Bundle extras = new Bundle();
        if (jResult.has("polygonpoints")) {
            JsonArray jPolygonPoints = jResult.get("polygonpoints").getAsJsonArray();
            ArrayList<GeoPoint> polygonPoints = new ArrayList<GeoPoint>(jPolygonPoints.size());
            for (int i = 0; i < jPolygonPoints.size(); ++i) {
                JsonArray jCoords = jPolygonPoints.get(i).getAsJsonArray();
                double lon = jCoords.get(0).getAsDouble();
                double lat = jCoords.get(1).getAsDouble();
                GeoPoint p = new GeoPoint(lat, lon);
                polygonPoints.add(p);
            }
            extras.putParcelableArrayList("polygonpoints", polygonPoints);
        }
        if (jResult.has("boundingbox")) {
            JsonArray jBoundingBox = jResult.get("boundingbox").getAsJsonArray();
            BoundingBox bb = new BoundingBox(jBoundingBox.get(1).getAsDouble(), jBoundingBox.get(2).getAsDouble(), jBoundingBox.get(0).getAsDouble(), jBoundingBox.get(3).getAsDouble());
            extras.putParcelable("boundingbox", (Parcelable)bb);
        }
        if (jResult.has("osm_id")) {
            long osm_id = jResult.get("osm_id").getAsLong();
            extras.putLong("osm_id", osm_id);
        }
        if (jResult.has("osm_type")) {
            String osm_type = jResult.get("osm_type").getAsString();
            extras.putString("osm_type", osm_type);
        }
        if (jResult.has("display_name")) {
            String display_name = jResult.get("display_name").getAsString();
            extras.putString("display_name", display_name);
        }
        gAddress.setExtras(extras);
        return gAddress;
    }

    public List<Address> getFromLocation(double latitude, double longitude, int maxResults) throws IOException {
        String url = this.mServiceUrl + "reverse.php?";
        if (this.mKey != null) {
            url = url + "key=" + this.mKey + "&";
        }
        url = url + "format=json&accept-language=" + this.mLocale.getLanguage() + "&lat=" + latitude + "&lon=" + longitude;
        Log.d((String)"BONUSPACK", (String)("GeocoderNominatim::getFromLocation:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (result == null) {
            throw new IOException();
        }
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(result);
            JsonObject jResult = json.getAsJsonObject();
            Address gAddress = this.buildAndroidAddress(jResult);
            ArrayList<Address> list = new ArrayList<Address>(1);
            if (gAddress != null) {
                list.add(gAddress);
            }
            return list;
        }
        catch (JsonSyntaxException e) {
            throw new IOException();
        }
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude, boolean bounded) throws IOException {
        String url = this.mServiceUrl + "search.php?";
        if (this.mKey != null) {
            url = url + "key=" + this.mKey + "&";
        }
        url = url + "format=json&accept-language=" + this.mLocale.getLanguage() + "&addressdetails=1&limit=" + maxResults + "&q=" + URLEncoder.encode(locationName);
        if (lowerLeftLatitude != 0.0 && upperRightLatitude != 0.0) {
            url = url + "&viewbox=" + lowerLeftLongitude + "," + upperRightLatitude + "," + upperRightLongitude + "," + lowerLeftLatitude + "&bounded=" + (bounded ? 1 : 0);
        }
        if (this.mPolygon) {
            url = url + "&polygon=1";
        }
        Log.d((String)"BONUSPACK", (String)("GeocoderNominatim::getFromLocationName:" + url));
        String result = BonusPackHelper.requestStringFromUrl(url, this.mUserAgent);
        if (result == null) {
            throw new IOException();
        }
        try {
            JsonParser parser = new JsonParser();
            JsonElement json = parser.parse(result);
            JsonArray jResults = json.getAsJsonArray();
            ArrayList<Address> list = new ArrayList<Address>(jResults.size());
            for (int i = 0; i < jResults.size(); ++i) {
                JsonObject jResult = jResults.get(i).getAsJsonObject();
                Address gAddress = this.buildAndroidAddress(jResult);
                if (gAddress == null) continue;
                list.add(gAddress);
            }
            return list;
        }
        catch (JsonSyntaxException e) {
            throw new IOException();
        }
    }

    public List<Address> getFromLocationName(String locationName, int maxResults, double lowerLeftLatitude, double lowerLeftLongitude, double upperRightLatitude, double upperRightLongitude) throws IOException {
        return this.getFromLocationName(locationName, maxResults, lowerLeftLatitude, lowerLeftLongitude, upperRightLatitude, upperRightLongitude, true);
    }

    public List<Address> getFromLocationName(String locationName, int maxResults) throws IOException {
        return this.getFromLocationName(locationName, maxResults, 0.0, 0.0, 0.0, 0.0, false);
    }
}

