/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.Paint;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polygon;
import org.osmdroid.views.overlay.infowindow.BasicInfoWindow;
import org.osmdroid.views.overlay.infowindow.InfoWindow;

public class KmlPolygon
extends KmlGeometry {
    public ArrayList<ArrayList<GeoPoint>> mHoles;
    static int mDefaultLayoutResId = 0;
    public static final Parcelable.Creator<KmlPolygon> CREATOR = new Parcelable.Creator<KmlPolygon>(){

        public KmlPolygon createFromParcel(Parcel source) {
            return new KmlPolygon(source);
        }

        public KmlPolygon[] newArray(int size) {
            return new KmlPolygon[size];
        }
    };

    public KmlPolygon() {
    }

    public void applyDefaultStyling(Polygon polygonOverlay, Style defaultStyle, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument, MapView map) {
        Paint outlinePaint;
        Context context = map.getContext();
        Style style = kmlDocument.getStyle(kmlPlacemark.mStyle);
        if (style != null) {
            outlinePaint = style.getOutlinePaint();
            polygonOverlay.setStrokeColor(outlinePaint.getColor());
            polygonOverlay.setStrokeWidth(outlinePaint.getStrokeWidth());
            if (style.mPolyStyle != null) {
                int fillColor = style.mPolyStyle.getFinalColor();
                polygonOverlay.setFillColor(fillColor);
            }
        } else if (defaultStyle != null) {
            outlinePaint = defaultStyle.getOutlinePaint();
            polygonOverlay.setStrokeColor(outlinePaint.getColor());
            polygonOverlay.setStrokeWidth(outlinePaint.getStrokeWidth());
            int fillColor = defaultStyle.mPolyStyle.getFinalColor();
            polygonOverlay.setFillColor(fillColor);
        }
        if (kmlPlacemark.mName != null && !"".equals(kmlPlacemark.mName) || kmlPlacemark.mDescription != null && !"".equals(kmlPlacemark.mDescription) || polygonOverlay.getSubDescription() != null && !"".equals(polygonOverlay.getSubDescription())) {
            if (mDefaultLayoutResId == 0) {
                String packageName = context.getPackageName();
                mDefaultLayoutResId = context.getResources().getIdentifier("layout/bonuspack_bubble", null, packageName);
            }
            polygonOverlay.setInfoWindow((InfoWindow)new BasicInfoWindow(mDefaultLayoutResId, map));
        }
        polygonOverlay.setEnabled(kmlPlacemark.mVisibility);
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlPlacemark kmlPlacemark, KmlDocument kmlDocument) {
        Polygon polygonOverlay = new Polygon();
        polygonOverlay.setPoints((List)this.mCoordinates);
        if (this.mHoles != null) {
            polygonOverlay.setHoles(this.mHoles);
        }
        polygonOverlay.setTitle(kmlPlacemark.mName);
        polygonOverlay.setSnippet(kmlPlacemark.mDescription);
        polygonOverlay.setSubDescription(kmlPlacemark.getExtendedDataAsText());
        polygonOverlay.setRelatedObject((Object)this);
        polygonOverlay.setId(this.mId);
        if (styler == null) {
            this.applyDefaultStyling(polygonOverlay, defaultStyle, kmlPlacemark, kmlDocument, map);
        } else {
            styler.onPolygon(polygonOverlay, kmlPlacemark, this);
        }
        return polygonOverlay;
    }

    protected KmlPolygon(JsonArray rings) {
        this();
        this.mCoordinates = KmlGeometry.parseGeoJSONPositions(rings.get(0).getAsJsonArray());
        if (rings.size() > 1) {
            this.mHoles = new ArrayList(rings.size() - 1);
            for (int i = 1; i < rings.size(); ++i) {
                ArrayList<GeoPoint> hole = KmlGeometry.parseGeoJSONPositions(rings.get(i).getAsJsonArray());
                this.mHoles.add(hole);
            }
        }
    }

    public KmlPolygon(JsonObject json) {
        this(json.get("coordinates").getAsJsonArray());
    }

    @Override
    public void saveAsKML(Writer writer) {
        try {
            writer.write("<Polygon>\n");
            writer.write("<outerBoundaryIs>\n<LinearRing>\n");
            KmlPolygon.writeKMLCoordinates(writer, this.mCoordinates);
            writer.write("</LinearRing>\n</outerBoundaryIs>\n");
            if (this.mHoles != null) {
                for (ArrayList<GeoPoint> hole : this.mHoles) {
                    writer.write("<innerBoundaryIs>\n<LinearRing>\n");
                    KmlPolygon.writeKMLCoordinates(writer, hole);
                    writer.write("</LinearRing>\n</innerBoundaryIs>\n");
                }
            }
            writer.write("</Polygon>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JsonObject asGeoJSON() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "Polygon");
        JsonArray coords = new JsonArray();
        coords.add((JsonElement)KmlGeometry.geoJSONCoordinates(this.mCoordinates));
        if (this.mHoles != null) {
            for (ArrayList<GeoPoint> hole : this.mHoles) {
                coords.add((JsonElement)KmlGeometry.geoJSONCoordinates(hole));
            }
        }
        json.add("coordinates", (JsonElement)coords);
        return json;
    }

    @Override
    public BoundingBox getBoundingBox() {
        if (this.mCoordinates != null) {
            return BoundingBox.fromGeoPoints((List)this.mCoordinates);
        }
        return null;
    }

    @Override
    public KmlPolygon clone() {
        KmlPolygon kmlPolygon = (KmlPolygon)super.clone();
        if (this.mHoles != null) {
            kmlPolygon.mHoles = new ArrayList(this.mHoles.size());
            for (ArrayList<GeoPoint> hole : this.mHoles) {
                kmlPolygon.mHoles.add(KmlPolygon.cloneArrayOfGeoPoint(hole));
            }
        }
        return kmlPolygon;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        if (this.mHoles != null) {
            out.writeInt(this.mHoles.size());
            for (ArrayList<GeoPoint> l : this.mHoles) {
                out.writeList(l);
            }
        } else {
            out.writeInt(0);
        }
    }

    public KmlPolygon(Parcel in) {
        super(in);
        int holes = in.readInt();
        if (holes != 0) {
            this.mHoles = new ArrayList(holes);
            for (int i = 0; i < holes; ++i) {
                ArrayList l = in.readArrayList(GeoPoint.class.getClassLoader());
                this.mHoles.add(l);
            }
        }
    }
}

