/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.LineStyle;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.util.BoundingBox;
import org.osmdroid.util.GeoPoint;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Marker;
import org.osmdroid.views.overlay.Overlay;
import org.osmdroid.views.overlay.Polygon;
import org.osmdroid.views.overlay.Polyline;

public class KmlPlacemark
extends KmlFeature
implements Cloneable,
Parcelable {
    public KmlGeometry mGeometry;
    public static final Parcelable.Creator<KmlPlacemark> CREATOR = new Parcelable.Creator<KmlPlacemark>(){

        public KmlPlacemark createFromParcel(Parcel source) {
            return new KmlPlacemark(source);
        }

        public KmlPlacemark[] newArray(int size) {
            return new KmlPlacemark[size];
        }
    };

    public KmlPlacemark() {
    }

    public KmlPlacemark(GeoPoint position) {
        this();
        this.mGeometry = new KmlPoint(position);
    }

    public KmlPlacemark(Marker marker) {
        this(marker.getPosition());
        this.mName = marker.getTitle();
        this.mDescription = marker.getSnippet();
        this.mVisibility = marker.isEnabled();
        this.mId = marker.getId();
    }

    public KmlPlacemark(Polygon polygon, KmlDocument kmlDoc) {
        this();
        this.mName = polygon.getTitle();
        this.mDescription = polygon.getSnippet();
        this.mGeometry = new KmlPolygon();
        this.mGeometry.mCoordinates = (ArrayList)polygon.getPoints();
        this.mVisibility = polygon.isEnabled();
        this.mId = polygon.getId();
        Style style = new Style();
        style.mPolyStyle = new ColorStyle(polygon.getFillColor());
        style.mLineStyle = new LineStyle(polygon.getStrokeColor(), polygon.getStrokeWidth());
        this.mStyle = kmlDoc.addStyle(style);
    }

    public KmlPlacemark(Polyline polyline, KmlDocument kmlDoc) {
        this();
        this.mName = polyline.getTitle();
        this.mDescription = polyline.getSnippet();
        this.mGeometry = new KmlLineString();
        this.mGeometry.mCoordinates = polyline.getPoints();
        this.mVisibility = polyline.isEnabled();
        this.mId = polyline.getId();
        Style style = new Style();
        style.mLineStyle = new LineStyle(polyline.getColor(), polyline.getWidth());
        this.mStyle = kmlDoc.addStyle(style);
    }

    public KmlPlacemark(JsonObject json) {
        this();
        JsonElement element;
        if (json.has("id")) {
            this.mId = json.get("id").getAsString();
        }
        if ((element = json.get("geometry")) != null && !element.isJsonNull()) {
            JsonObject geometry = element.getAsJsonObject();
            this.mGeometry = KmlGeometry.parseGeoJSON(geometry);
        }
        if (json.has("properties") && !(element = json.get("properties")).isJsonNull()) {
            JsonObject properties = json.getAsJsonObject("properties");
            Set entrySet = properties.entrySet();
            for (Map.Entry entry : entrySet) {
                String value;
                String key = (String)entry.getKey();
                JsonElement je = (JsonElement)entry.getValue();
                try {
                    value = je.getAsString();
                }
                catch (Exception e) {
                    value = je.toString();
                }
                if (key == null || value == null) continue;
                this.setExtendedData(key, value);
            }
            if (this.mExtendedData != null && this.mExtendedData.containsKey("name")) {
                this.mName = (String)this.mExtendedData.get("name");
                this.mExtendedData.remove("name");
            }
        }
    }

    @Override
    public BoundingBox getBoundingBox() {
        if (this.mGeometry != null) {
            return this.mGeometry.getBoundingBox();
        }
        return null;
    }

    @Override
    public Overlay buildOverlay(MapView map, Style defaultStyle, KmlFeature.Styler styler, KmlDocument kmlDocument) {
        if (this.mGeometry != null) {
            return this.mGeometry.buildOverlay(map, defaultStyle, styler, this, kmlDocument);
        }
        return null;
    }

    @Override
    public void writeKMLSpecifics(Writer writer) {
        if (this.mGeometry != null) {
            this.mGeometry.saveAsKML(writer);
        }
    }

    protected JsonObject geoJSONProperties() {
        try {
            JsonObject json = new JsonObject();
            if (this.mName != null) {
                json.addProperty("name", this.mName);
            }
            if (this.mExtendedData != null) {
                for (Map.Entry entry : this.mExtendedData.entrySet()) {
                    String name = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    json.addProperty(name, value);
                }
            }
            return json;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public JsonObject asGeoJSON(boolean isRoot) {
        JsonObject json = new JsonObject();
        json.addProperty("type", "Feature");
        if (this.mId != null) {
            json.addProperty("id", this.mId);
        }
        if (this.mGeometry != null) {
            json.add("geometry", (JsonElement)this.mGeometry.asGeoJSON());
        } else {
            json.add("geometry", (JsonElement)JsonNull.INSTANCE);
        }
        json.add("properties", (JsonElement)this.geoJSONProperties());
        return json;
    }

    @Override
    public KmlPlacemark clone() {
        KmlPlacemark kmlPlacemark = (KmlPlacemark)super.clone();
        if (this.mGeometry != null) {
            kmlPlacemark.mGeometry = this.mGeometry.clone();
        }
        return kmlPlacemark;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeParcelable((Parcelable)this.mGeometry, flags);
    }

    public KmlPlacemark(Parcel in) {
        super(in);
        this.mGeometry = (KmlGeometry)in.readParcelable(KmlGeometry.class.getClassLoader());
    }
}

