/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringEscapeUtils;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.HotSpot;
import org.osmdroid.bonuspack.utils.WebImageCache;
import org.osmdroid.views.overlay.Marker;

public class IconStyle
extends ColorStyle
implements Parcelable {
    public float mScale;
    public float mHeading;
    public String mHref;
    public Bitmap mIcon;
    public HotSpot mHotSpot;
    private static WebImageCache mIconCache = new WebImageCache(100);
    public static final Parcelable.Creator<IconStyle> CREATOR = new Parcelable.Creator<IconStyle>(){

        public IconStyle createFromParcel(Parcel source) {
            return new IconStyle(source);
        }

        public IconStyle[] newArray(int size) {
            return new IconStyle[size];
        }
    };

    public IconStyle() {
        this.mScale = 1.0f;
        this.mHeading = 0.0f;
        this.mHotSpot = new HotSpot();
    }

    public void setIcon(String href, File containerFile, ZipFile kmzContainer) {
        this.mHref = href;
        if (this.mHref == null) {
            this.mIcon = null;
        } else if (this.mHref.startsWith("http://") || this.mHref.startsWith("https://")) {
            this.mIcon = mIconCache.get(this.mHref);
        } else if (kmzContainer == null) {
            if (containerFile != null) {
                String actualFullPath = containerFile.getParent() + '/' + this.mHref;
                this.mIcon = BitmapFactory.decodeFile((String)actualFullPath);
            } else {
                this.mIcon = null;
            }
        } else {
            try {
                ZipEntry fileEntry = kmzContainer.getEntry(href);
                InputStream stream = kmzContainer.getInputStream(fileEntry);
                this.mIcon = BitmapFactory.decodeStream((InputStream)stream);
            }
            catch (Exception e) {
                this.mIcon = null;
            }
        }
    }

    public BitmapDrawable getFinalIcon(Context context) {
        if (this.mIcon == null) {
            return null;
        }
        int sizeX = Math.round((float)this.mIcon.getWidth() * this.mScale);
        int sizeY = Math.round((float)this.mIcon.getHeight() * this.mScale);
        if (sizeX == 0 || sizeY == 0) {
            Log.w((String)"BONUSPACK", (String)"KML icon has size=0");
            return null;
        }
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)this.mIcon, (int)sizeX, (int)sizeY, (boolean)true);
        BitmapDrawable finalIcon = new BitmapDrawable(context.getResources(), scaledBitmap);
        int color = this.getFinalColor();
        if (color != 0) {
            finalIcon.setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
        return finalIcon;
    }

    public void styleMarker(Marker marker, Context context) {
        BitmapDrawable icon = this.getFinalIcon(context);
        if (icon != null) {
            marker.setIcon((Drawable)icon);
            marker.setAnchor(this.mHotSpot.getX((float)icon.getIntrinsicWidth() / this.mScale), 1.0f - this.mHotSpot.getY((float)icon.getIntrinsicHeight() / this.mScale));
        }
        marker.setRotation(this.mHeading);
    }

    @Override
    public void writeAsKML(Writer writer) {
        try {
            writer.write("<IconStyle>\n");
            super.writeAsKML(writer);
            if (this.mScale != 1.0f) {
                writer.write("<scale>" + this.mScale + "</scale>\n");
            }
            if (this.mHeading != 0.0f) {
                writer.write("<heading>" + this.mHeading + "</heading>\n");
            }
            if (this.mHref != null) {
                writer.write("<Icon><href>" + StringEscapeUtils.escapeXml10((String)this.mHref) + "</href></Icon>\n");
            }
            this.mHotSpot.writeAsKML(writer);
            writer.write("</IconStyle>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeFloat(this.mScale);
        out.writeFloat(this.mHeading);
        out.writeString(this.mHref);
        out.writeParcelable((Parcelable)this.mIcon, flags);
        out.writeParcelable((Parcelable)this.mHotSpot, flags);
    }

    public IconStyle(Parcel in) {
        super(in);
        this.mScale = in.readFloat();
        this.mHeading = in.readFloat();
        this.mHref = in.readString();
        this.mIcon = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.mHotSpot = (HotSpot)in.readParcelable(HotSpot.class.getClassLoader());
    }
}

