/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.util;

import android.content.Context;
import android.content.ContextWrapper;
import androidx.lifecycle.LifecycleOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\n\u0010\t\u001a\u00020\u0005*\u00020\n\u001a\n\u0010\u000b\u001a\u00020\u0005*\u00020\n\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\n\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0001\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0007\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0011"}, d2={"ZIP_MAGIC", "", "getZIP_MAGIC", "()[B", "matchesMagicBytes", "", "inputSource", "Lokio/BufferedSource;", "magic", "isDotLottieAsset", "", "isJsonAsset", "isUrl", "isZipCompressed", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "Landroid/content/Context;", "dotlottie_release"})
public final class DotLottieUtilsKt {
    @NotNull
    private static final byte[] ZIP_MAGIC;

    public static final boolean isJsonAsset(@NotNull String $this$isJsonAsset) {
        Intrinsics.checkNotNullParameter((Object)$this$isJsonAsset, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isJsonAsset, (String)".json", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)$this$isJsonAsset, (String)".lot", (boolean)false, (int)2, null);
    }

    public static final boolean isDotLottieAsset(@NotNull String $this$isDotLottieAsset) {
        Intrinsics.checkNotNullParameter((Object)$this$isDotLottieAsset, (String)"<this>");
        return StringsKt.endsWith$default((String)$this$isDotLottieAsset, (String)".lottie", (boolean)false, (int)2, null);
    }

    public static final boolean isUrl(@NotNull String $this$isUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$isUrl, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isUrl, (String)"http", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isUrl, (String)"https", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final byte[] getZIP_MAGIC() {
        return ZIP_MAGIC;
    }

    public static final boolean isZipCompressed(@NotNull BufferedSource $this$isZipCompressed) {
        Intrinsics.checkNotNullParameter((Object)$this$isZipCompressed, (String)"<this>");
        return DotLottieUtilsKt.matchesMagicBytes($this$isZipCompressed, ZIP_MAGIC);
    }

    public static final boolean isZipCompressed(@NotNull byte[] $this$isZipCompressed) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isZipCompressed, (String)"<this>");
        try {
            if ($this$isZipCompressed.length < ZIP_MAGIC.length) {
                return false;
            }
            int n = ZIP_MAGIC.length;
            for (int i = 0; i < n; ++i) {
                if ($this$isZipCompressed[i] == ZIP_MAGIC[i]) continue;
                return false;
            }
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final LifecycleOwner lifecycleOwner(@NotNull Context $this$lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)$this$lifecycleOwner, (String)"<this>");
        Context curContext = $this$lifecycleOwner;
        int maxDepth = 20;
        while (maxDepth-- > 0 && !(curContext instanceof LifecycleOwner)) {
            Intrinsics.checkNotNullExpressionValue((Object)((ContextWrapper)curContext).getBaseContext(), (String)"getBaseContext(...)");
        }
        return curContext instanceof LifecycleOwner ? (LifecycleOwner)curContext : null;
    }

    public static final boolean matchesMagicBytes(@NotNull BufferedSource inputSource, @NotNull byte[] magic) {
        Intrinsics.checkNotNullParameter((Object)inputSource, (String)"inputSource");
        Intrinsics.checkNotNullParameter((Object)magic, (String)"magic");
        try {
            BufferedSource peek = inputSource.peek();
            for (byte b : magic) {
                if (peek.readByte() == b) continue;
                return false;
            }
            peek.close();
            return true;
        }
        catch (NoSuchMethodError e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        byte[] byArray = new byte[]{80, 75, 3, 4};
        ZIP_MAGIC = byArray;
    }
}

