// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package com.dotlottie.dlplayer

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_dotlottie_player_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_dotlottie_player_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: kotlin.Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: kotlin.Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "uniffi_dotlottie_player"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
internal interface UniffiCallbackInterfaceObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`frameNo`: Float,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod2 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod3 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod4 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`loopCount`: Int,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod5 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod6 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod7 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`frameNo`: Float,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceObserverMethod8 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineInternalObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`oldValue`: Byte,`newValue`: Byte,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod1 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod2 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod3 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod4 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`oldValue`: Float,`newValue`: Float,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod5 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod6 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`enteringState`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod7 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`leavingState`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod8 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod9 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`oldValue`: RustBuffer.ByValue,`newValue`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
internal interface UniffiCallbackInterfaceStateMachineObserverMethod10 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`previousState`: RustBuffer.ByValue,`newState`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,)
}
@Structure.FieldOrder("onComplete", "onFrame", "onLoad", "onLoadError", "onLoop", "onPause", "onPlay", "onRender", "onStop", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceObserver(
    @JvmField internal var `onComplete`: UniffiCallbackInterfaceObserverMethod0? = null,
    @JvmField internal var `onFrame`: UniffiCallbackInterfaceObserverMethod1? = null,
    @JvmField internal var `onLoad`: UniffiCallbackInterfaceObserverMethod2? = null,
    @JvmField internal var `onLoadError`: UniffiCallbackInterfaceObserverMethod3? = null,
    @JvmField internal var `onLoop`: UniffiCallbackInterfaceObserverMethod4? = null,
    @JvmField internal var `onPause`: UniffiCallbackInterfaceObserverMethod5? = null,
    @JvmField internal var `onPlay`: UniffiCallbackInterfaceObserverMethod6? = null,
    @JvmField internal var `onRender`: UniffiCallbackInterfaceObserverMethod7? = null,
    @JvmField internal var `onStop`: UniffiCallbackInterfaceObserverMethod8? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onComplete`: UniffiCallbackInterfaceObserverMethod0? = null,
        `onFrame`: UniffiCallbackInterfaceObserverMethod1? = null,
        `onLoad`: UniffiCallbackInterfaceObserverMethod2? = null,
        `onLoadError`: UniffiCallbackInterfaceObserverMethod3? = null,
        `onLoop`: UniffiCallbackInterfaceObserverMethod4? = null,
        `onPause`: UniffiCallbackInterfaceObserverMethod5? = null,
        `onPlay`: UniffiCallbackInterfaceObserverMethod6? = null,
        `onRender`: UniffiCallbackInterfaceObserverMethod7? = null,
        `onStop`: UniffiCallbackInterfaceObserverMethod8? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceObserver(`onComplete`,`onFrame`,`onLoad`,`onLoadError`,`onLoop`,`onPause`,`onPlay`,`onRender`,`onStop`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceObserver) {
        `onComplete` = other.`onComplete`
        `onFrame` = other.`onFrame`
        `onLoad` = other.`onLoad`
        `onLoadError` = other.`onLoadError`
        `onLoop` = other.`onLoop`
        `onPause` = other.`onPause`
        `onPlay` = other.`onPlay`
        `onRender` = other.`onRender`
        `onStop` = other.`onStop`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onMessage", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceStateMachineInternalObserver(
    @JvmField internal var `onMessage`: UniffiCallbackInterfaceStateMachineInternalObserverMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onMessage`: UniffiCallbackInterfaceStateMachineInternalObserverMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceStateMachineInternalObserver(`onMessage`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceStateMachineInternalObserver) {
        `onMessage` = other.`onMessage`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("onBooleanInputValueChange", "onCustomEvent", "onError", "onInputFired", "onNumericInputValueChange", "onStart", "onStateEntered", "onStateExit", "onStop", "onStringInputValueChange", "onTransition", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceStateMachineObserver(
    @JvmField internal var `onBooleanInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod0? = null,
    @JvmField internal var `onCustomEvent`: UniffiCallbackInterfaceStateMachineObserverMethod1? = null,
    @JvmField internal var `onError`: UniffiCallbackInterfaceStateMachineObserverMethod2? = null,
    @JvmField internal var `onInputFired`: UniffiCallbackInterfaceStateMachineObserverMethod3? = null,
    @JvmField internal var `onNumericInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod4? = null,
    @JvmField internal var `onStart`: UniffiCallbackInterfaceStateMachineObserverMethod5? = null,
    @JvmField internal var `onStateEntered`: UniffiCallbackInterfaceStateMachineObserverMethod6? = null,
    @JvmField internal var `onStateExit`: UniffiCallbackInterfaceStateMachineObserverMethod7? = null,
    @JvmField internal var `onStop`: UniffiCallbackInterfaceStateMachineObserverMethod8? = null,
    @JvmField internal var `onStringInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod9? = null,
    @JvmField internal var `onTransition`: UniffiCallbackInterfaceStateMachineObserverMethod10? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `onBooleanInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod0? = null,
        `onCustomEvent`: UniffiCallbackInterfaceStateMachineObserverMethod1? = null,
        `onError`: UniffiCallbackInterfaceStateMachineObserverMethod2? = null,
        `onInputFired`: UniffiCallbackInterfaceStateMachineObserverMethod3? = null,
        `onNumericInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod4? = null,
        `onStart`: UniffiCallbackInterfaceStateMachineObserverMethod5? = null,
        `onStateEntered`: UniffiCallbackInterfaceStateMachineObserverMethod6? = null,
        `onStateExit`: UniffiCallbackInterfaceStateMachineObserverMethod7? = null,
        `onStop`: UniffiCallbackInterfaceStateMachineObserverMethod8? = null,
        `onStringInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod9? = null,
        `onTransition`: UniffiCallbackInterfaceStateMachineObserverMethod10? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceStateMachineObserver(`onBooleanInputValueChange`,`onCustomEvent`,`onError`,`onInputFired`,`onNumericInputValueChange`,`onStart`,`onStateEntered`,`onStateExit`,`onStop`,`onStringInputValueChange`,`onTransition`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceStateMachineObserver) {
        `onBooleanInputValueChange` = other.`onBooleanInputValueChange`
        `onCustomEvent` = other.`onCustomEvent`
        `onError` = other.`onError`
        `onInputFired` = other.`onInputFired`
        `onNumericInputValueChange` = other.`onNumericInputValueChange`
        `onStart` = other.`onStart`
        `onStateEntered` = other.`onStateEntered`
        `onStateExit` = other.`onStateExit`
        `onStop` = other.`onStop`
        `onStringInputValueChange` = other.`onStringInputValueChange`
        `onTransition` = other.`onTransition`
        `uniffiFree` = other.`uniffiFree`
    }

}



























































































































































































































































































// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.

internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            loadIndirect<UniffiLib>(componentName = "dotlottie_player")
            .also { lib: UniffiLib ->
                uniffiCheckContractApiVersion(lib)
                uniffiCheckApiChecksums(lib)
                uniffiCallbackInterfaceObserver.register(lib)
                uniffiCallbackInterfaceStateMachineInternalObserver.register(lib)
                uniffiCallbackInterfaceStateMachineObserver.register(lib)
                }
        }

        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    fun uniffi_dotlottie_player_fn_clone_dotlottieplayer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun uniffi_dotlottie_player_fn_free_dotlottieplayer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_constructor_dotlottieplayer_new(`config`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun uniffi_dotlottie_player_fn_constructor_dotlottieplayer_with_threads(`config`: RustBuffer.ByValue,`threads`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_active_animation_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_active_state_machine_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_active_theme_id(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_animation_size(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_len(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Long
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_ptr(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Long
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_clear(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_config(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_current_frame(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_duration(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_get_layer_bounds(`ptr`: Pointer,`layerName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_get_state_machine(`ptr`: Pointer,`stateMachineId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_get_transform(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_intersect(`ptr`: Pointer,`x`: Float,`y`: Float,`layerName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_complete(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_loaded(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_paused(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_playing(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_stopped(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_is_tweening(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation(`ptr`: Pointer,`animationId`: RustBuffer.ByValue,`width`: Int,`height`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_data(`ptr`: Pointer,`animationData`: RustBuffer.ByValue,`width`: Int,`height`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_path(`ptr`: Pointer,`animationPath`: RustBuffer.ByValue,`width`: Int,`height`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_load_dotlottie_data(`ptr`: Pointer,`fileData`: RustBuffer.ByValue,`width`: Int,`height`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_loop_count(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Int
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest_string(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_markers(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_pause(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_play(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_render(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_request_frame(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_reset_theme(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_resize(`ptr`: Pointer,`width`: Int,`height`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_seek(`ptr`: Pointer,`no`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_segment_duration(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_config(`ptr`: Pointer,`config`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_frame(`ptr`: Pointer,`no`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_quality(`ptr`: Pointer,`quality`: Byte,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_slots(`ptr`: Pointer,`slots`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_theme(`ptr`: Pointer,`themeId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_theme_data(`ptr`: Pointer,`themeData`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_transform(`ptr`: Pointer,`transform`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_set_viewport(`ptr`: Pointer,`x`: Int,`y`: Int,`w`: Int,`h`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_current_state(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_fire_event(`ptr`: Pointer,`event`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_framework_setup(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_boolean_input(`ptr`: Pointer,`key`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_inputs(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_numeric_input(`ptr`: Pointer,`key`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_string_input(`ptr`: Pointer,`key`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_internal_subscribe(`ptr`: Pointer,`observer`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_internal_unsubscribe(`ptr`: Pointer,`observer`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_load(`ptr`: Pointer,`stateMachineId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_load_data(`ptr`: Pointer,`stateMachine`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_override_current_state(`ptr`: Pointer,`stateName`: RustBuffer.ByValue,`doTick`: Byte,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_click_event(`ptr`: Pointer,`x`: Float,`y`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_event(`ptr`: Pointer,`event`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_down_event(`ptr`: Pointer,`x`: Float,`y`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_enter_event(`ptr`: Pointer,`x`: Float,`y`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_exit_event(`ptr`: Pointer,`x`: Float,`y`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_move_event(`ptr`: Pointer,`x`: Float,`y`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_up_event(`ptr`: Pointer,`x`: Float,`y`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_set_boolean_input(`ptr`: Pointer,`key`: RustBuffer.ByValue,`value`: Byte,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_set_numeric_input(`ptr`: Pointer,`key`: RustBuffer.ByValue,`value`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_set_string_input(`ptr`: Pointer,`key`: RustBuffer.ByValue,`value`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_start(`ptr`: Pointer,`openUrlPolicy`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_status(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_stop(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_subscribe(`ptr`: Pointer,`observer`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_unsubscribe(`ptr`: Pointer,`observer`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_stop(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_subscribe(`ptr`: Pointer,`observer`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_tick(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_total_frames(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_tween(`ptr`: Pointer,`to`: Float,`duration`: RustBuffer.ByValue,`easing`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_tween_stop(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_tween_to_marker(`ptr`: Pointer,`marker`: RustBuffer.ByValue,`duration`: RustBuffer.ByValue,`easing`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_tween_update(`ptr`: Pointer,`progress`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun uniffi_dotlottie_player_fn_method_dotlottieplayer_unsubscribe(`ptr`: Pointer,`observer`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_clone_observer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun uniffi_dotlottie_player_fn_free_observer(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_init_callback_vtable_observer(`vtable`: UniffiVTableCallbackInterfaceObserver,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_complete(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_frame(`ptr`: Pointer,`frameNo`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_load(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_load_error(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_loop(`ptr`: Pointer,`loopCount`: Int,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_pause(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_play(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_render(`ptr`: Pointer,`frameNo`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_observer_on_stop(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_clone_statemachineinternalobserver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun uniffi_dotlottie_player_fn_free_statemachineinternalobserver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_init_callback_vtable_statemachineinternalobserver(`vtable`: UniffiVTableCallbackInterfaceStateMachineInternalObserver,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineinternalobserver_on_message(`ptr`: Pointer,`message`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_clone_statemachineobserver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun uniffi_dotlottie_player_fn_free_statemachineobserver(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_init_callback_vtable_statemachineobserver(`vtable`: UniffiVTableCallbackInterfaceStateMachineObserver,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_boolean_input_value_change(`ptr`: Pointer,`inputName`: RustBuffer.ByValue,`oldValue`: Byte,`newValue`: Byte,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_custom_event(`ptr`: Pointer,`message`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_error(`ptr`: Pointer,`message`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_input_fired(`ptr`: Pointer,`inputName`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_numeric_input_value_change(`ptr`: Pointer,`inputName`: RustBuffer.ByValue,`oldValue`: Float,`newValue`: Float,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_start(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_state_entered(`ptr`: Pointer,`enteringState`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_state_exit(`ptr`: Pointer,`leavingState`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_stop(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_string_input_value_change(`ptr`: Pointer,`inputName`: RustBuffer.ByValue,`oldValue`: RustBuffer.ByValue,`newValue`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_method_statemachineobserver_on_transition(`ptr`: Pointer,`previousState`: RustBuffer.ByValue,`newState`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_fn_func_create_default_config(uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_func_create_default_layout(uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_func_create_default_open_url_policy(uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun uniffi_dotlottie_player_fn_func_transform_theme_to_lottie_slots(`themeData`: RustBuffer.ByValue,`animationId`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun ffi_dotlottie_player_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun ffi_dotlottie_player_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun ffi_dotlottie_player_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun ffi_dotlottie_player_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun ffi_dotlottie_player_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_u8(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_u8(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun ffi_dotlottie_player_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_i8(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_i8(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Byte
    fun ffi_dotlottie_player_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_u16(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_u16(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Short
    fun ffi_dotlottie_player_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_i16(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_i16(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Short
    fun ffi_dotlottie_player_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_u32(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_u32(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Int
    fun ffi_dotlottie_player_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_i32(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_i32(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Int
    fun ffi_dotlottie_player_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_u64(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_u64(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Long
    fun ffi_dotlottie_player_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_i64(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_i64(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Long
    fun ffi_dotlottie_player_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_f32(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_f32(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Float
    fun ffi_dotlottie_player_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_f64(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_f64(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Double
    fun ffi_dotlottie_player_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_pointer(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_pointer(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Pointer
    fun ffi_dotlottie_player_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_rust_buffer(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): RustBuffer.ByValue
    fun ffi_dotlottie_player_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_cancel_void(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_free_void(`handle`: Long,
    ): Unit
    fun ffi_dotlottie_player_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus,
    ): Unit
    fun uniffi_dotlottie_player_checksum_func_create_default_config(
    ): Short
    fun uniffi_dotlottie_player_checksum_func_create_default_layout(
    ): Short
    fun uniffi_dotlottie_player_checksum_func_create_default_open_url_policy(
    ): Short
    fun uniffi_dotlottie_player_checksum_func_transform_theme_to_lottie_slots(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_active_animation_id(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_active_state_machine_id(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_active_theme_id(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_animation_size(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_len(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_ptr(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_clear(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_config(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_current_frame(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_duration(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_get_layer_bounds(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_get_state_machine(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_get_transform(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_intersect(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_complete(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_loaded(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_paused(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_playing(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_stopped(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_tweening(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_data(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_path(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_dotlottie_data(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_loop_count(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest_string(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_markers(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_pause(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_play(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_render(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_request_frame(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_reset_theme(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_resize(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_seek(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_segment_duration(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_config(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_frame(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_quality(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_slots(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_theme(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_theme_data(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_transform(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_viewport(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_current_state(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_fire_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_framework_setup(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_boolean_input(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_inputs(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_numeric_input(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_string_input(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_internal_subscribe(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_internal_unsubscribe(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_load(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_load_data(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_override_current_state(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_click_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_down_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_enter_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_exit_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_move_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_up_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_set_boolean_input(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_set_numeric_input(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_set_string_input(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_start(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_status(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_stop(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_subscribe(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_unsubscribe(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_stop(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_subscribe(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_tick(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_total_frames(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween_stop(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween_to_marker(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween_update(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_dotlottieplayer_unsubscribe(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_complete(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_frame(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_load(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_load_error(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_loop(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_pause(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_play(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_render(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_observer_on_stop(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineinternalobserver_on_message(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_boolean_input_value_change(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_custom_event(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_error(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_input_fired(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_numeric_input_value_change(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_start(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_state_entered(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_state_exit(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_stop(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_string_input_value_change(
    ): Short
    fun uniffi_dotlottie_player_checksum_method_statemachineobserver_on_transition(
    ): Short
    fun uniffi_dotlottie_player_checksum_constructor_dotlottieplayer_new(
    ): Short
    fun uniffi_dotlottie_player_checksum_constructor_dotlottieplayer_with_threads(
    ): Short
    fun ffi_dotlottie_player_uniffi_contract_version(
    ): Int

}

private fun uniffiCheckContractApiVersion(lib: UniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 26
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_dotlottie_player_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}

@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: UniffiLib) {
    if (lib.uniffi_dotlottie_player_checksum_func_create_default_config() != 10767.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_func_create_default_layout() != 41529.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_func_create_default_open_url_policy() != 13935.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_func_transform_theme_to_lottie_slots() != 23836.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_active_animation_id() != 57608.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_active_state_machine_id() != 55591.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_active_theme_id() != 60173.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_animation_size() != 49812.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_len() != 33793.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_buffer_ptr() != 30907.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_clear() != 26373.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_config() != 36040.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_current_frame() != 42425.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_duration() != 3831.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_get_layer_bounds() != 55811.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_get_state_machine() != 4598.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_get_transform() != 49287.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_intersect() != 12346.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_complete() != 51890.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_loaded() != 20186.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_paused() != 56658.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_playing() != 45670.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_stopped() != 28412.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_is_tweening() != 55447.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation() != 52252.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_data() != 63827.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_animation_path() != 5718.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_load_dotlottie_data() != 3402.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_loop_count() != 14780.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest() != 39779.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_manifest_string() != 60193.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_markers() != 29800.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_pause() != 16452.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_play() != 54931.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_render() != 34602.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_request_frame() != 39939.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_reset_theme() != 44947.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_resize() != 16787.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_seek() != 60656.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_segment_duration() != 38024.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_config() != 39472.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_frame() != 44086.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_quality() != 55740.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_slots() != 64804.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_theme() != 33069.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_theme_data() != 31802.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_transform() != 1923.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_set_viewport() != 29505.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_current_state() != 16021.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_fire_event() != 43003.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_framework_setup() != 17926.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_boolean_input() != 55120.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_inputs() != 47898.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_numeric_input() != 10400.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_get_string_input() != 47598.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_internal_subscribe() != 16838.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_internal_unsubscribe() != 15116.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_load() != 64493.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_load_data() != 34359.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_override_current_state() != 49496.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_click_event() != 95.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_event() != 7805.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_down_event() != 34737.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_enter_event() != 40556.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_exit_event() != 45140.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_move_event() != 9392.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_post_pointer_up_event() != 29087.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_set_boolean_input() != 63405.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_set_numeric_input() != 54841.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_set_string_input() != 4923.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_start() != 55237.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_status() != 45792.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_stop() != 31070.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_subscribe() != 52020.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_state_machine_unsubscribe() != 30025.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_stop() != 25240.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_subscribe() != 45859.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_tick() != 60075.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_total_frames() != 12091.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween() != 57206.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween_stop() != 42833.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween_to_marker() != 26478.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_tween_update() != 11200.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_dotlottieplayer_unsubscribe() != 1373.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_complete() != 24930.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_frame() != 51247.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_load() != 56735.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_load_error() != 51239.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_loop() != 7035.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_pause() != 146.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_play() != 59485.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_render() != 55581.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_observer_on_stop() != 52331.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineinternalobserver_on_message() != 34646.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_boolean_input_value_change() != 21933.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_custom_event() != 50052.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_error() != 46774.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_input_fired() != 28837.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_numeric_input_value_change() != 49226.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_start() != 26147.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_state_entered() != 49087.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_state_exit() != 30161.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_stop() != 19940.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_string_input_value_change() != 58131.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_method_statemachineobserver_on_transition() != 25374.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_constructor_dotlottieplayer_new() != 34558.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_dotlottie_player_checksum_constructor_dotlottieplayer_with_threads() != 55397.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

// Async support

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            args.filterIsInstance<Disposable>()
                .forEach(Disposable::destroy)
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/**
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer

/**
 * @suppress
 */
public object FfiConverterUByte: FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte {
        return value.toUByte()
    }

    override fun read(buf: ByteBuffer): UByte {
        return lift(buf.get())
    }

    override fun lower(value: UByte): Byte {
        return value.toByte()
    }

    override fun allocationSize(value: UByte) = 1UL

    override fun write(value: UByte, buf: ByteBuffer) {
        buf.put(value.toByte())
    }
}

/**
 * @suppress
 */
public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterInt: FfiConverter<Int, Int> {
    override fun lift(value: Int): Int {
        return value
    }

    override fun read(buf: ByteBuffer): Int {
        return buf.getInt()
    }

    override fun lower(value: Int): Int {
        return value
    }

    override fun allocationSize(value: Int) = 4UL

    override fun write(value: Int, buf: ByteBuffer) {
        buf.putInt(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterULong: FfiConverter<ULong, Long> {
    override fun lift(value: Long): ULong {
        return value.toULong()
    }

    override fun read(buf: ByteBuffer): ULong {
        return lift(buf.getLong())
    }

    override fun lower(value: ULong): Long {
        return value.toLong()
    }

    override fun allocationSize(value: ULong) = 8UL

    override fun write(value: ULong, buf: ByteBuffer) {
        buf.putLong(value.toLong())
    }
}

/**
 * @suppress
 */
public object FfiConverterFloat: FfiConverter<Float, Float> {
    override fun lift(value: Float): Float {
        return value
    }

    override fun read(buf: ByteBuffer): Float {
        return buf.getFloat()
    }

    override fun lower(value: Float): Float {
        return value
    }

    override fun allocationSize(value: Float) = 4UL

    override fun write(value: Float, buf: ByteBuffer) {
        buf.putFloat(value)
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

/**
 * @suppress
 */
public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}
public interface DotLottiePlayerInterface {

    fun `activeAnimationId`(): kotlin.String

    fun `activeStateMachineId`(): kotlin.String

    fun `activeThemeId`(): kotlin.String

    fun `animationSize`(): List<kotlin.Float>

    fun `bufferLen`(): kotlin.ULong

    fun `bufferPtr`(): kotlin.ULong

    fun `clear`()

    fun `config`(): Config

    fun `currentFrame`(): kotlin.Float

    fun `duration`(): kotlin.Float

    fun `getLayerBounds`(`layerName`: kotlin.String): List<kotlin.Float>

    fun `getStateMachine`(`stateMachineId`: kotlin.String): kotlin.String

    fun `getTransform`(): List<kotlin.Float>

    fun `intersect`(`x`: kotlin.Float, `y`: kotlin.Float, `layerName`: kotlin.String): kotlin.Boolean

    fun `isComplete`(): kotlin.Boolean

    fun `isLoaded`(): kotlin.Boolean

    fun `isPaused`(): kotlin.Boolean

    fun `isPlaying`(): kotlin.Boolean

    fun `isStopped`(): kotlin.Boolean

    fun `isTweening`(): kotlin.Boolean

    fun `loadAnimation`(`animationId`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean

    fun `loadAnimationData`(`animationData`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean

    fun `loadAnimationPath`(`animationPath`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean

    fun `loadDotlottieData`(`fileData`: kotlin.ByteArray, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean

    fun `loopCount`(): kotlin.UInt

    fun `manifest`(): Manifest?

    fun `manifestString`(): kotlin.String

    fun `markers`(): List<Marker>

    fun `pause`(): kotlin.Boolean

    fun `play`(): kotlin.Boolean

    fun `render`(): kotlin.Boolean

    fun `requestFrame`(): kotlin.Float

    fun `resetTheme`(): kotlin.Boolean

    fun `resize`(`width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean

    fun `seek`(`no`: kotlin.Float): kotlin.Boolean

    fun `segmentDuration`(): kotlin.Float

    fun `setConfig`(`config`: Config)

    fun `setFrame`(`no`: kotlin.Float): kotlin.Boolean

    fun `setQuality`(`quality`: kotlin.UByte): kotlin.Boolean

    fun `setSlots`(`slots`: kotlin.String): kotlin.Boolean

    fun `setTheme`(`themeId`: kotlin.String): kotlin.Boolean

    fun `setThemeData`(`themeData`: kotlin.String): kotlin.Boolean

    fun `setTransform`(`transform`: List<kotlin.Float>): kotlin.Boolean

    fun `setViewport`(`x`: kotlin.Int, `y`: kotlin.Int, `w`: kotlin.Int, `h`: kotlin.Int): kotlin.Boolean

    fun `stateMachineCurrentState`(): kotlin.String

    fun `stateMachineFireEvent`(`event`: kotlin.String)

    fun `stateMachineFrameworkSetup`(): List<kotlin.String>

    fun `stateMachineGetBooleanInput`(`key`: kotlin.String): kotlin.Boolean

    fun `stateMachineGetInputs`(): List<kotlin.String>

    fun `stateMachineGetNumericInput`(`key`: kotlin.String): kotlin.Float

    fun `stateMachineGetStringInput`(`key`: kotlin.String): kotlin.String

    fun `stateMachineInternalSubscribe`(`observer`: StateMachineInternalObserver): kotlin.Boolean

    fun `stateMachineInternalUnsubscribe`(`observer`: StateMachineInternalObserver): kotlin.Boolean

    fun `stateMachineLoad`(`stateMachineId`: kotlin.String): kotlin.Boolean

    fun `stateMachineLoadData`(`stateMachine`: kotlin.String): kotlin.Boolean

    fun `stateMachineOverrideCurrentState`(`stateName`: kotlin.String, `doTick`: kotlin.Boolean): kotlin.Boolean

    fun `stateMachinePostClickEvent`(`x`: kotlin.Float, `y`: kotlin.Float)

    fun `stateMachinePostEvent`(`event`: Event)

    fun `stateMachinePostPointerDownEvent`(`x`: kotlin.Float, `y`: kotlin.Float)

    fun `stateMachinePostPointerEnterEvent`(`x`: kotlin.Float, `y`: kotlin.Float)

    fun `stateMachinePostPointerExitEvent`(`x`: kotlin.Float, `y`: kotlin.Float)

    fun `stateMachinePostPointerMoveEvent`(`x`: kotlin.Float, `y`: kotlin.Float)

    fun `stateMachinePostPointerUpEvent`(`x`: kotlin.Float, `y`: kotlin.Float)

    fun `stateMachineSetBooleanInput`(`key`: kotlin.String, `value`: kotlin.Boolean): kotlin.Boolean

    fun `stateMachineSetNumericInput`(`key`: kotlin.String, `value`: kotlin.Float): kotlin.Boolean

    fun `stateMachineSetStringInput`(`key`: kotlin.String, `value`: kotlin.String): kotlin.Boolean

    fun `stateMachineStart`(`openUrlPolicy`: OpenUrlPolicy): kotlin.Boolean

    fun `stateMachineStatus`(): kotlin.String

    fun `stateMachineStop`(): kotlin.Boolean

    fun `stateMachineSubscribe`(`observer`: StateMachineObserver): kotlin.Boolean

    fun `stateMachineUnsubscribe`(`observer`: StateMachineObserver): kotlin.Boolean

    fun `stop`(): kotlin.Boolean

    fun `subscribe`(`observer`: Observer)

    fun `tick`(): kotlin.Boolean

    fun `totalFrames`(): kotlin.Float

    fun `tween`(`to`: kotlin.Float, `duration`: kotlin.Float?, `easing`: List<kotlin.Float>?): kotlin.Boolean

    fun `tweenStop`(): kotlin.Boolean

    fun `tweenToMarker`(`marker`: kotlin.String, `duration`: kotlin.Float?, `easing`: List<kotlin.Float>?): kotlin.Boolean

    fun `tweenUpdate`(`progress`: kotlin.Float?): kotlin.Boolean

    fun `unsubscribe`(`observer`: Observer)

    companion object
}

open class DotLottiePlayer: Disposable, AutoCloseable, DotLottiePlayerInterface {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`config`: Config) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_constructor_dotlottieplayer_new(
        FfiConverterTypeConfig.lower(`config`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_free_dotlottieplayer(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_clone_dotlottieplayer(pointer!!, status)
        }
    }

    override fun `activeAnimationId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_active_animation_id(
        it, _status)
}
    }
    )
    }


    override fun `activeStateMachineId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_active_state_machine_id(
        it, _status)
}
    }
    )
    }


    override fun `activeThemeId`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_active_theme_id(
        it, _status)
}
    }
    )
    }


    override fun `animationSize`(): List<kotlin.Float> {
            return FfiConverterSequenceFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_animation_size(
        it, _status)
}
    }
    )
    }


    override fun `bufferLen`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_len(
        it, _status)
}
    }
    )
    }


    override fun `bufferPtr`(): kotlin.ULong {
            return FfiConverterULong.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_buffer_ptr(
        it, _status)
}
    }
    )
    }


    override fun `clear`()
        =
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_clear(
        it, _status)
}
    }



    override fun `config`(): Config {
            return FfiConverterTypeConfig.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_config(
        it, _status)
}
    }
    )
    }


    override fun `currentFrame`(): kotlin.Float {
            return FfiConverterFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_current_frame(
        it, _status)
}
    }
    )
    }


    override fun `duration`(): kotlin.Float {
            return FfiConverterFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_duration(
        it, _status)
}
    }
    )
    }


    override fun `getLayerBounds`(`layerName`: kotlin.String): List<kotlin.Float> {
            return FfiConverterSequenceFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_get_layer_bounds(
        it, FfiConverterString.lower(`layerName`),_status)
}
    }
    )
    }


    override fun `getStateMachine`(`stateMachineId`: kotlin.String): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_get_state_machine(
        it, FfiConverterString.lower(`stateMachineId`),_status)
}
    }
    )
    }


    override fun `getTransform`(): List<kotlin.Float> {
            return FfiConverterSequenceFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_get_transform(
        it, _status)
}
    }
    )
    }


    override fun `intersect`(`x`: kotlin.Float, `y`: kotlin.Float, `layerName`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_intersect(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),FfiConverterString.lower(`layerName`),_status)
}
    }
    )
    }


    override fun `isComplete`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_complete(
        it, _status)
}
    }
    )
    }


    override fun `isLoaded`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_loaded(
        it, _status)
}
    }
    )
    }


    override fun `isPaused`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_paused(
        it, _status)
}
    }
    )
    }


    override fun `isPlaying`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_playing(
        it, _status)
}
    }
    )
    }


    override fun `isStopped`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_stopped(
        it, _status)
}
    }
    )
    }


    override fun `isTweening`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_is_tweening(
        it, _status)
}
    }
    )
    }


    override fun `loadAnimation`(`animationId`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation(
        it, FfiConverterString.lower(`animationId`),FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),_status)
}
    }
    )
    }


    override fun `loadAnimationData`(`animationData`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_data(
        it, FfiConverterString.lower(`animationData`),FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),_status)
}
    }
    )
    }


    override fun `loadAnimationPath`(`animationPath`: kotlin.String, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_animation_path(
        it, FfiConverterString.lower(`animationPath`),FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),_status)
}
    }
    )
    }


    override fun `loadDotlottieData`(`fileData`: kotlin.ByteArray, `width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_load_dotlottie_data(
        it, FfiConverterByteArray.lower(`fileData`),FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),_status)
}
    }
    )
    }


    override fun `loopCount`(): kotlin.UInt {
            return FfiConverterUInt.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_loop_count(
        it, _status)
}
    }
    )
    }


    override fun `manifest`(): Manifest? {
            return FfiConverterOptionalTypeManifest.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest(
        it, _status)
}
    }
    )
    }


    override fun `manifestString`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_manifest_string(
        it, _status)
}
    }
    )
    }


    override fun `markers`(): List<Marker> {
            return FfiConverterSequenceTypeMarker.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_markers(
        it, _status)
}
    }
    )
    }


    override fun `pause`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_pause(
        it, _status)
}
    }
    )
    }


    override fun `play`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_play(
        it, _status)
}
    }
    )
    }


    override fun `render`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_render(
        it, _status)
}
    }
    )
    }


    override fun `requestFrame`(): kotlin.Float {
            return FfiConverterFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_request_frame(
        it, _status)
}
    }
    )
    }


    override fun `resetTheme`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_reset_theme(
        it, _status)
}
    }
    )
    }


    override fun `resize`(`width`: kotlin.UInt, `height`: kotlin.UInt): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_resize(
        it, FfiConverterUInt.lower(`width`),FfiConverterUInt.lower(`height`),_status)
}
    }
    )
    }


    override fun `seek`(`no`: kotlin.Float): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_seek(
        it, FfiConverterFloat.lower(`no`),_status)
}
    }
    )
    }


    override fun `segmentDuration`(): kotlin.Float {
            return FfiConverterFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_segment_duration(
        it, _status)
}
    }
    )
    }


    override fun `setConfig`(`config`: Config)
        =
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_config(
        it, FfiConverterTypeConfig.lower(`config`),_status)
}
    }



    override fun `setFrame`(`no`: kotlin.Float): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_frame(
        it, FfiConverterFloat.lower(`no`),_status)
}
    }
    )
    }


    override fun `setQuality`(`quality`: kotlin.UByte): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_quality(
        it, FfiConverterUByte.lower(`quality`),_status)
}
    }
    )
    }


    override fun `setSlots`(`slots`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_slots(
        it, FfiConverterString.lower(`slots`),_status)
}
    }
    )
    }


    override fun `setTheme`(`themeId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_theme(
        it, FfiConverterString.lower(`themeId`),_status)
}
    }
    )
    }


    override fun `setThemeData`(`themeData`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_theme_data(
        it, FfiConverterString.lower(`themeData`),_status)
}
    }
    )
    }


    override fun `setTransform`(`transform`: List<kotlin.Float>): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_transform(
        it, FfiConverterSequenceFloat.lower(`transform`),_status)
}
    }
    )
    }


    override fun `setViewport`(`x`: kotlin.Int, `y`: kotlin.Int, `w`: kotlin.Int, `h`: kotlin.Int): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_set_viewport(
        it, FfiConverterInt.lower(`x`),FfiConverterInt.lower(`y`),FfiConverterInt.lower(`w`),FfiConverterInt.lower(`h`),_status)
}
    }
    )
    }


    override fun `stateMachineCurrentState`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_current_state(
        it, _status)
}
    }
    )
    }


    override fun `stateMachineFireEvent`(`event`: kotlin.String)
        =
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_fire_event(
        it, FfiConverterString.lower(`event`),_status)
}
    }



    override fun `stateMachineFrameworkSetup`(): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_framework_setup(
        it, _status)
}
    }
    )
    }


    override fun `stateMachineGetBooleanInput`(`key`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_boolean_input(
        it, FfiConverterString.lower(`key`),_status)
}
    }
    )
    }


    override fun `stateMachineGetInputs`(): List<kotlin.String> {
            return FfiConverterSequenceString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_inputs(
        it, _status)
}
    }
    )
    }
    

    override fun `stateMachineGetNumericInput`(`key`: kotlin.String): kotlin.Float {
            return FfiConverterFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_numeric_input(
        it, FfiConverterString.lower(`key`),_status)
}
    }
    )
    }
    

    override fun `stateMachineGetStringInput`(`key`: kotlin.String): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_get_string_input(
        it, FfiConverterString.lower(`key`),_status)
}
    }
    )
    }
    

    override fun `stateMachineInternalSubscribe`(`observer`: StateMachineInternalObserver): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_internal_subscribe(
        it, FfiConverterTypeStateMachineInternalObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `stateMachineInternalUnsubscribe`(`observer`: StateMachineInternalObserver): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_internal_unsubscribe(
        it, FfiConverterTypeStateMachineInternalObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `stateMachineLoad`(`stateMachineId`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_load(
        it, FfiConverterString.lower(`stateMachineId`),_status)
}
    }
    )
    }
    

    override fun `stateMachineLoadData`(`stateMachine`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_load_data(
        it, FfiConverterString.lower(`stateMachine`),_status)
}
    }
    )
    }
    

    override fun `stateMachineOverrideCurrentState`(`stateName`: kotlin.String, `doTick`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_override_current_state(
        it, FfiConverterString.lower(`stateName`),FfiConverterBoolean.lower(`doTick`),_status)
}
    }
    )
    }
    

    override fun `stateMachinePostClickEvent`(`x`: kotlin.Float, `y`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_click_event(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),_status)
}
    }
    
    

    override fun `stateMachinePostEvent`(`event`: Event)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_event(
        it, FfiConverterTypeEvent.lower(`event`),_status)
}
    }
    
    

    override fun `stateMachinePostPointerDownEvent`(`x`: kotlin.Float, `y`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_down_event(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),_status)
}
    }
    
    

    override fun `stateMachinePostPointerEnterEvent`(`x`: kotlin.Float, `y`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_enter_event(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),_status)
}
    }
    
    

    override fun `stateMachinePostPointerExitEvent`(`x`: kotlin.Float, `y`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_exit_event(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),_status)
}
    }
    
    

    override fun `stateMachinePostPointerMoveEvent`(`x`: kotlin.Float, `y`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_move_event(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),_status)
}
    }
    
    

    override fun `stateMachinePostPointerUpEvent`(`x`: kotlin.Float, `y`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_post_pointer_up_event(
        it, FfiConverterFloat.lower(`x`),FfiConverterFloat.lower(`y`),_status)
}
    }
    
    

    override fun `stateMachineSetBooleanInput`(`key`: kotlin.String, `value`: kotlin.Boolean): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_set_boolean_input(
        it, FfiConverterString.lower(`key`),FfiConverterBoolean.lower(`value`),_status)
}
    }
    )
    }
    

    override fun `stateMachineSetNumericInput`(`key`: kotlin.String, `value`: kotlin.Float): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_set_numeric_input(
        it, FfiConverterString.lower(`key`),FfiConverterFloat.lower(`value`),_status)
}
    }
    )
    }
    

    override fun `stateMachineSetStringInput`(`key`: kotlin.String, `value`: kotlin.String): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_set_string_input(
        it, FfiConverterString.lower(`key`),FfiConverterString.lower(`value`),_status)
}
    }
    )
    }
    

    override fun `stateMachineStart`(`openUrlPolicy`: OpenUrlPolicy): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_start(
        it, FfiConverterTypeOpenUrlPolicy.lower(`openUrlPolicy`),_status)
}
    }
    )
    }
    

    override fun `stateMachineStatus`(): kotlin.String {
            return FfiConverterString.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_status(
        it, _status)
}
    }
    )
    }
    

    override fun `stateMachineStop`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_stop(
        it, _status)
}
    }
    )
    }
    

    override fun `stateMachineSubscribe`(`observer`: StateMachineObserver): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_subscribe(
        it, FfiConverterTypeStateMachineObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `stateMachineUnsubscribe`(`observer`: StateMachineObserver): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_state_machine_unsubscribe(
        it, FfiConverterTypeStateMachineObserver.lower(`observer`),_status)
}
    }
    )
    }
    

    override fun `stop`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_stop(
        it, _status)
}
    }
    )
    }
    

    override fun `subscribe`(`observer`: Observer)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_subscribe(
        it, FfiConverterTypeObserver.lower(`observer`),_status)
}
    }
    
    

    override fun `tick`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_tick(
        it, _status)
}
    }
    )
    }
    

    override fun `totalFrames`(): kotlin.Float {
            return FfiConverterFloat.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_total_frames(
        it, _status)
}
    }
    )
    }
    

    override fun `tween`(`to`: kotlin.Float, `duration`: kotlin.Float?, `easing`: List<kotlin.Float>?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_tween(
        it, FfiConverterFloat.lower(`to`),FfiConverterOptionalFloat.lower(`duration`),FfiConverterOptionalSequenceFloat.lower(`easing`),_status)
}
    }
    )
    }
    

    override fun `tweenStop`(): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_tween_stop(
        it, _status)
}
    }
    )
    }
    

    override fun `tweenToMarker`(`marker`: kotlin.String, `duration`: kotlin.Float?, `easing`: List<kotlin.Float>?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_tween_to_marker(
        it, FfiConverterString.lower(`marker`),FfiConverterOptionalFloat.lower(`duration`),FfiConverterOptionalSequenceFloat.lower(`easing`),_status)
}
    }
    )
    }
    

    override fun `tweenUpdate`(`progress`: kotlin.Float?): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_tween_update(
        it, FfiConverterOptionalFloat.lower(`progress`),_status)
}
    }
    )
    }
    

    override fun `unsubscribe`(`observer`: Observer)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_dotlottieplayer_unsubscribe(
        it, FfiConverterTypeObserver.lower(`observer`),_status)
}
    }
    
    

    

    
    companion object {
         fun `withThreads`(`config`: Config, `threads`: kotlin.UInt): DotLottiePlayer {
            return FfiConverterTypeDotLottiePlayer.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_constructor_dotlottieplayer_with_threads(
        FfiConverterTypeConfig.lower(`config`),FfiConverterUInt.lower(`threads`),_status)
}
    )
    }
    

        
    }
    
}

/**
 * @suppress
 */
public object FfiConverterTypeDotLottiePlayer: FfiConverter<DotLottiePlayer, Pointer> {

    override fun lower(value: DotLottiePlayer): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): DotLottiePlayer {
        return DotLottiePlayer(value)
    }

    override fun read(buf: ByteBuffer): DotLottiePlayer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: DotLottiePlayer) = 8UL

    override fun write(value: DotLottiePlayer, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface Observer {
    
    fun `onComplete`()
    
    fun `onFrame`(`frameNo`: kotlin.Float)
    
    fun `onLoad`()
    
    fun `onLoadError`()
    
    fun `onLoop`(`loopCount`: kotlin.UInt)
    
    fun `onPause`()
    
    fun `onPlay`()
    
    fun `onRender`(`frameNo`: kotlin.Float)
    
    fun `onStop`()
    
    companion object
}

open class ObserverImpl: Disposable, AutoCloseable, Observer {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_free_observer(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_clone_observer(pointer!!, status)
        }
    }

    override fun `onComplete`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_complete(
        it, _status)
}
    }
    
    

    override fun `onFrame`(`frameNo`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_frame(
        it, FfiConverterFloat.lower(`frameNo`),_status)
}
    }
    
    

    override fun `onLoad`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_load(
        it, _status)
}
    }
    
    

    override fun `onLoadError`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_load_error(
        it, _status)
}
    }
    
    

    override fun `onLoop`(`loopCount`: kotlin.UInt)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_loop(
        it, FfiConverterUInt.lower(`loopCount`),_status)
}
    }
    
    

    override fun `onPause`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_pause(
        it, _status)
}
    }
    
    

    override fun `onPlay`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_play(
        it, _status)
}
    }
    
    

    override fun `onRender`(`frameNo`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_render(
        it, FfiConverterFloat.lower(`frameNo`),_status)
}
    }
    
    

    override fun `onStop`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_observer_on_stop(
        it, _status)
}
    }
    
    

    

    
    
    companion object
    
}
// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

/**
 * @suppress
 */
public abstract class FfiConverterCallbackInterface<CallbackInterface: Any>: FfiConverter<CallbackInterface, Long> {
    internal val handleMap = UniffiHandleMap<CallbackInterface>()

    internal fun drop(handle: Long) {
        handleMap.remove(handle)
    }

    override fun lift(value: Long): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8UL

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}

// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceObserver {
    internal object `onComplete`: UniffiCallbackInterfaceObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onComplete`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onFrame`: UniffiCallbackInterfaceObserverMethod1 {
        override fun callback(`uniffiHandle`: Long,`frameNo`: Float,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onFrame`(
                    FfiConverterFloat.lift(`frameNo`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onLoad`: UniffiCallbackInterfaceObserverMethod2 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onLoad`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onLoadError`: UniffiCallbackInterfaceObserverMethod3 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onLoadError`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onLoop`: UniffiCallbackInterfaceObserverMethod4 {
        override fun callback(`uniffiHandle`: Long,`loopCount`: Int,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onLoop`(
                    FfiConverterUInt.lift(`loopCount`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onPause`: UniffiCallbackInterfaceObserverMethod5 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onPause`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onPlay`: UniffiCallbackInterfaceObserverMethod6 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onPlay`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onRender`: UniffiCallbackInterfaceObserverMethod7 {
        override fun callback(`uniffiHandle`: Long,`frameNo`: Float,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onRender`(
                    FfiConverterFloat.lift(`frameNo`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onStop`: UniffiCallbackInterfaceObserverMethod8 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onStop`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceObserver.UniffiByValue(
        `onComplete`,
        `onFrame`,
        `onLoad`,
        `onLoadError`,
        `onLoop`,
        `onPause`,
        `onPlay`,
        `onRender`,
        `onStop`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_dotlottie_player_fn_init_callback_vtable_observer(vtable)
    }
}

/**
 * @suppress
 */
public object FfiConverterTypeObserver: FfiConverter<Observer, Pointer> {
    internal val handleMap = UniffiHandleMap<Observer>()

    override fun lower(value: Observer): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): Observer {
        return ObserverImpl(value)
    }

    override fun read(buf: ByteBuffer): Observer {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: Observer) = 8UL

    override fun write(value: Observer, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface StateMachineInternalObserver {
    
    fun `onMessage`(`message`: kotlin.String)
    
    companion object
}

open class StateMachineInternalObserverImpl: Disposable, AutoCloseable, StateMachineInternalObserver {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_free_statemachineinternalobserver(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_clone_statemachineinternalobserver(pointer!!, status)
        }
    }

    override fun `onMessage`(`message`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineinternalobserver_on_message(
        it, FfiConverterString.lower(`message`),_status)
}
    }
    
    

    

    
    
    companion object
    
}


// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceStateMachineInternalObserver {
    internal object `onMessage`: UniffiCallbackInterfaceStateMachineInternalObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineInternalObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onMessage`(
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeStateMachineInternalObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceStateMachineInternalObserver.UniffiByValue(
        `onMessage`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_dotlottie_player_fn_init_callback_vtable_statemachineinternalobserver(vtable)
    }
}

/**
 * @suppress
 */
public object FfiConverterTypeStateMachineInternalObserver: FfiConverter<StateMachineInternalObserver, Pointer> {
    internal val handleMap = UniffiHandleMap<StateMachineInternalObserver>()

    override fun lower(value: StateMachineInternalObserver): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): StateMachineInternalObserver {
        return StateMachineInternalObserverImpl(value)
    }

    override fun read(buf: ByteBuffer): StateMachineInternalObserver {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: StateMachineInternalObserver) = 8UL

    override fun write(value: StateMachineInternalObserver, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface StateMachineObserver {
    
    fun `onBooleanInputValueChange`(`inputName`: kotlin.String, `oldValue`: kotlin.Boolean, `newValue`: kotlin.Boolean)
    
    fun `onCustomEvent`(`message`: kotlin.String)
    
    fun `onError`(`message`: kotlin.String)
    
    fun `onInputFired`(`inputName`: kotlin.String)
    
    fun `onNumericInputValueChange`(`inputName`: kotlin.String, `oldValue`: kotlin.Float, `newValue`: kotlin.Float)
    
    fun `onStart`()
    
    fun `onStateEntered`(`enteringState`: kotlin.String)
    
    fun `onStateExit`(`leavingState`: kotlin.String)
    
    fun `onStop`()
    
    fun `onStringInputValueChange`(`inputName`: kotlin.String, `oldValue`: kotlin.String, `newValue`: kotlin.String)
    
    fun `onTransition`(`previousState`: kotlin.String, `newState`: kotlin.String)
    
    companion object
}

open class StateMachineObserverImpl: Disposable, AutoCloseable, StateMachineObserver {

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_free_statemachineobserver(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_clone_statemachineobserver(pointer!!, status)
        }
    }

    override fun `onBooleanInputValueChange`(`inputName`: kotlin.String, `oldValue`: kotlin.Boolean, `newValue`: kotlin.Boolean)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_boolean_input_value_change(
        it, FfiConverterString.lower(`inputName`),FfiConverterBoolean.lower(`oldValue`),FfiConverterBoolean.lower(`newValue`),_status)
}
    }
    
    

    override fun `onCustomEvent`(`message`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_custom_event(
        it, FfiConverterString.lower(`message`),_status)
}
    }
    
    

    override fun `onError`(`message`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_error(
        it, FfiConverterString.lower(`message`),_status)
}
    }
    
    

    override fun `onInputFired`(`inputName`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_input_fired(
        it, FfiConverterString.lower(`inputName`),_status)
}
    }
    
    

    override fun `onNumericInputValueChange`(`inputName`: kotlin.String, `oldValue`: kotlin.Float, `newValue`: kotlin.Float)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_numeric_input_value_change(
        it, FfiConverterString.lower(`inputName`),FfiConverterFloat.lower(`oldValue`),FfiConverterFloat.lower(`newValue`),_status)
}
    }
    
    

    override fun `onStart`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_start(
        it, _status)
}
    }
    
    

    override fun `onStateEntered`(`enteringState`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_state_entered(
        it, FfiConverterString.lower(`enteringState`),_status)
}
    }
    
    

    override fun `onStateExit`(`leavingState`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_state_exit(
        it, FfiConverterString.lower(`leavingState`),_status)
}
    }
    
    

    override fun `onStop`()
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_stop(
        it, _status)
}
    }
    
    

    override fun `onStringInputValueChange`(`inputName`: kotlin.String, `oldValue`: kotlin.String, `newValue`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_string_input_value_change(
        it, FfiConverterString.lower(`inputName`),FfiConverterString.lower(`oldValue`),FfiConverterString.lower(`newValue`),_status)
}
    }
    
    

    override fun `onTransition`(`previousState`: kotlin.String, `newState`: kotlin.String)
        = 
    callWithPointer {
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_method_statemachineobserver_on_transition(
        it, FfiConverterString.lower(`previousState`),FfiConverterString.lower(`newState`),_status)
}
    }
    
    

    

    
    
    companion object
    
}


// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceStateMachineObserver {
    internal object `onBooleanInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod0 {
        override fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`oldValue`: Byte,`newValue`: Byte,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onBooleanInputValueChange`(
                    FfiConverterString.lift(`inputName`),
                    FfiConverterBoolean.lift(`oldValue`),
                    FfiConverterBoolean.lift(`newValue`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onCustomEvent`: UniffiCallbackInterfaceStateMachineObserverMethod1 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onCustomEvent`(
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onError`: UniffiCallbackInterfaceStateMachineObserverMethod2 {
        override fun callback(`uniffiHandle`: Long,`message`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onError`(
                    FfiConverterString.lift(`message`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onInputFired`: UniffiCallbackInterfaceStateMachineObserverMethod3 {
        override fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onInputFired`(
                    FfiConverterString.lift(`inputName`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onNumericInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod4 {
        override fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`oldValue`: Float,`newValue`: Float,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onNumericInputValueChange`(
                    FfiConverterString.lift(`inputName`),
                    FfiConverterFloat.lift(`oldValue`),
                    FfiConverterFloat.lift(`newValue`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onStart`: UniffiCallbackInterfaceStateMachineObserverMethod5 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onStart`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onStateEntered`: UniffiCallbackInterfaceStateMachineObserverMethod6 {
        override fun callback(`uniffiHandle`: Long,`enteringState`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onStateEntered`(
                    FfiConverterString.lift(`enteringState`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onStateExit`: UniffiCallbackInterfaceStateMachineObserverMethod7 {
        override fun callback(`uniffiHandle`: Long,`leavingState`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onStateExit`(
                    FfiConverterString.lift(`leavingState`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onStop`: UniffiCallbackInterfaceStateMachineObserverMethod8 {
        override fun callback(`uniffiHandle`: Long,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onStop`(
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onStringInputValueChange`: UniffiCallbackInterfaceStateMachineObserverMethod9 {
        override fun callback(`uniffiHandle`: Long,`inputName`: RustBuffer.ByValue,`oldValue`: RustBuffer.ByValue,`newValue`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onStringInputValueChange`(
                    FfiConverterString.lift(`inputName`),
                    FfiConverterString.lift(`oldValue`),
                    FfiConverterString.lift(`newValue`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }
    internal object `onTransition`: UniffiCallbackInterfaceStateMachineObserverMethod10 {
        override fun callback(`uniffiHandle`: Long,`previousState`: RustBuffer.ByValue,`newState`: RustBuffer.ByValue,`uniffiOutReturn`: Pointer,uniffiCallStatus: UniffiRustCallStatus,) {
            val uniffiObj = FfiConverterTypeStateMachineObserver.handleMap.get(uniffiHandle)
            val makeCall = { ->
                uniffiObj.`onTransition`(
                    FfiConverterString.lift(`previousState`),
                    FfiConverterString.lift(`newState`),
                )
            }
            val writeReturn = { _: Unit -> Unit }
            uniffiTraitInterfaceCall(uniffiCallStatus, makeCall, writeReturn)
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeStateMachineObserver.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceStateMachineObserver.UniffiByValue(
        `onBooleanInputValueChange`,
        `onCustomEvent`,
        `onError`,
        `onInputFired`,
        `onNumericInputValueChange`,
        `onStart`,
        `onStateEntered`,
        `onStateExit`,
        `onStop`,
        `onStringInputValueChange`,
        `onTransition`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_dotlottie_player_fn_init_callback_vtable_statemachineobserver(vtable)
    }
}

/**
 * @suppress
 */
public object FfiConverterTypeStateMachineObserver: FfiConverter<StateMachineObserver, Pointer> {
    internal val handleMap = UniffiHandleMap<StateMachineObserver>()

    override fun lower(value: StateMachineObserver): Pointer {
        return Pointer(handleMap.insert(value))
    }

    override fun lift(value: Pointer): StateMachineObserver {
        return StateMachineObserverImpl(value)
    }

    override fun read(buf: ByteBuffer): StateMachineObserver {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: StateMachineObserver) = 8UL

    override fun write(value: StateMachineObserver, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class Config (
    var `autoplay`: kotlin.Boolean, 
    var `loopAnimation`: kotlin.Boolean, 
    var `loopCount`: kotlin.UInt, 
    var `mode`: Mode, 
    var `speed`: kotlin.Float, 
    var `useFrameInterpolation`: kotlin.Boolean, 
    var `segment`: List<kotlin.Float>, 
    var `backgroundColor`: kotlin.UInt, 
    var `layout`: Layout, 
    var `marker`: kotlin.String, 
    var `themeId`: kotlin.String, 
    var `stateMachineId`: kotlin.String, 
    var `animationId`: kotlin.String
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeConfig: FfiConverterRustBuffer<Config> {
    override fun read(buf: ByteBuffer): Config {
        return Config(
            FfiConverterBoolean.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterTypeMode.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterBoolean.read(buf),
            FfiConverterSequenceFloat.read(buf),
            FfiConverterUInt.read(buf),
            FfiConverterTypeLayout.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
        )
    }

    override fun allocationSize(value: Config) = (
            FfiConverterBoolean.allocationSize(value.`autoplay`) +
            FfiConverterBoolean.allocationSize(value.`loopAnimation`) +
            FfiConverterUInt.allocationSize(value.`loopCount`) +
            FfiConverterTypeMode.allocationSize(value.`mode`) +
            FfiConverterFloat.allocationSize(value.`speed`) +
            FfiConverterBoolean.allocationSize(value.`useFrameInterpolation`) +
            FfiConverterSequenceFloat.allocationSize(value.`segment`) +
            FfiConverterUInt.allocationSize(value.`backgroundColor`) +
            FfiConverterTypeLayout.allocationSize(value.`layout`) +
            FfiConverterString.allocationSize(value.`marker`) +
            FfiConverterString.allocationSize(value.`themeId`) +
            FfiConverterString.allocationSize(value.`stateMachineId`) +
            FfiConverterString.allocationSize(value.`animationId`)
    )

    override fun write(value: Config, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`autoplay`, buf)
            FfiConverterBoolean.write(value.`loopAnimation`, buf)
            FfiConverterUInt.write(value.`loopCount`, buf)
            FfiConverterTypeMode.write(value.`mode`, buf)
            FfiConverterFloat.write(value.`speed`, buf)
            FfiConverterBoolean.write(value.`useFrameInterpolation`, buf)
            FfiConverterSequenceFloat.write(value.`segment`, buf)
            FfiConverterUInt.write(value.`backgroundColor`, buf)
            FfiConverterTypeLayout.write(value.`layout`, buf)
            FfiConverterString.write(value.`marker`, buf)
            FfiConverterString.write(value.`themeId`, buf)
            FfiConverterString.write(value.`stateMachineId`, buf)
            FfiConverterString.write(value.`animationId`, buf)
    }
}



data class Layout (
    var `fit`: Fit, 
    var `align`: List<kotlin.Float>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeLayout: FfiConverterRustBuffer<Layout> {
    override fun read(buf: ByteBuffer): Layout {
        return Layout(
            FfiConverterTypeFit.read(buf),
            FfiConverterSequenceFloat.read(buf),
        )
    }

    override fun allocationSize(value: Layout) = (
            FfiConverterTypeFit.allocationSize(value.`fit`) +
            FfiConverterSequenceFloat.allocationSize(value.`align`)
    )

    override fun write(value: Layout, buf: ByteBuffer) {
            FfiConverterTypeFit.write(value.`fit`, buf)
            FfiConverterSequenceFloat.write(value.`align`, buf)
    }
}



data class Manifest (
    var `version`: kotlin.String?, 
    var `generator`: kotlin.String?, 
    var `initial`: ManifestInitial?, 
    var `animations`: List<ManifestAnimation>, 
    var `themes`: List<ManifestTheme>?, 
    var `stateMachines`: List<ManifestStateMachine>?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeManifest: FfiConverterRustBuffer<Manifest> {
    override fun read(buf: ByteBuffer): Manifest {
        return Manifest(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeManifestInitial.read(buf),
            FfiConverterSequenceTypeManifestAnimation.read(buf),
            FfiConverterOptionalSequenceTypeManifestTheme.read(buf),
            FfiConverterOptionalSequenceTypeManifestStateMachine.read(buf),
        )
    }

    override fun allocationSize(value: Manifest) = (
            FfiConverterOptionalString.allocationSize(value.`version`) +
            FfiConverterOptionalString.allocationSize(value.`generator`) +
            FfiConverterOptionalTypeManifestInitial.allocationSize(value.`initial`) +
            FfiConverterSequenceTypeManifestAnimation.allocationSize(value.`animations`) +
            FfiConverterOptionalSequenceTypeManifestTheme.allocationSize(value.`themes`) +
            FfiConverterOptionalSequenceTypeManifestStateMachine.allocationSize(value.`stateMachines`)
    )

    override fun write(value: Manifest, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`version`, buf)
            FfiConverterOptionalString.write(value.`generator`, buf)
            FfiConverterOptionalTypeManifestInitial.write(value.`initial`, buf)
            FfiConverterSequenceTypeManifestAnimation.write(value.`animations`, buf)
            FfiConverterOptionalSequenceTypeManifestTheme.write(value.`themes`, buf)
            FfiConverterOptionalSequenceTypeManifestStateMachine.write(value.`stateMachines`, buf)
    }
}



data class ManifestAnimation (
    var `id`: kotlin.String, 
    var `name`: kotlin.String?, 
    var `initialTheme`: kotlin.String?, 
    var `themes`: List<kotlin.String>?, 
    var `background`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeManifestAnimation: FfiConverterRustBuffer<ManifestAnimation> {
    override fun read(buf: ByteBuffer): ManifestAnimation {
        return ManifestAnimation(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalSequenceString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ManifestAnimation) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalString.allocationSize(value.`name`) +
            FfiConverterOptionalString.allocationSize(value.`initialTheme`) +
            FfiConverterOptionalSequenceString.allocationSize(value.`themes`) +
            FfiConverterOptionalString.allocationSize(value.`background`)
    )

    override fun write(value: ManifestAnimation, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
            FfiConverterOptionalString.write(value.`initialTheme`, buf)
            FfiConverterOptionalSequenceString.write(value.`themes`, buf)
            FfiConverterOptionalString.write(value.`background`, buf)
    }
}



data class ManifestInitial (
    var `animation`: kotlin.String?, 
    var `stateMachine`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeManifestInitial: FfiConverterRustBuffer<ManifestInitial> {
    override fun read(buf: ByteBuffer): ManifestInitial {
        return ManifestInitial(
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ManifestInitial) = (
            FfiConverterOptionalString.allocationSize(value.`animation`) +
            FfiConverterOptionalString.allocationSize(value.`stateMachine`)
    )

    override fun write(value: ManifestInitial, buf: ByteBuffer) {
            FfiConverterOptionalString.write(value.`animation`, buf)
            FfiConverterOptionalString.write(value.`stateMachine`, buf)
    }
}



data class ManifestStateMachine (
    var `id`: kotlin.String, 
    var `name`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeManifestStateMachine: FfiConverterRustBuffer<ManifestStateMachine> {
    override fun read(buf: ByteBuffer): ManifestStateMachine {
        return ManifestStateMachine(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ManifestStateMachine) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalString.allocationSize(value.`name`)
    )

    override fun write(value: ManifestStateMachine, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
    }
}



data class ManifestTheme (
    var `id`: kotlin.String, 
    var `name`: kotlin.String?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeManifestTheme: FfiConverterRustBuffer<ManifestTheme> {
    override fun read(buf: ByteBuffer): ManifestTheme {
        return ManifestTheme(
            FfiConverterString.read(buf),
            FfiConverterOptionalString.read(buf),
        )
    }

    override fun allocationSize(value: ManifestTheme) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterOptionalString.allocationSize(value.`name`)
    )

    override fun write(value: ManifestTheme, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterOptionalString.write(value.`name`, buf)
    }
}



data class Marker (
    var `name`: kotlin.String, 
    var `time`: kotlin.Float, 
    var `duration`: kotlin.Float
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeMarker: FfiConverterRustBuffer<Marker> {
    override fun read(buf: ByteBuffer): Marker {
        return Marker(
            FfiConverterString.read(buf),
            FfiConverterFloat.read(buf),
            FfiConverterFloat.read(buf),
        )
    }

    override fun allocationSize(value: Marker) = (
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterFloat.allocationSize(value.`time`) +
            FfiConverterFloat.allocationSize(value.`duration`)
    )

    override fun write(value: Marker, buf: ByteBuffer) {
            FfiConverterString.write(value.`name`, buf)
            FfiConverterFloat.write(value.`time`, buf)
            FfiConverterFloat.write(value.`duration`, buf)
    }
}



data class OpenUrlPolicy (
    var `requireUserInteraction`: kotlin.Boolean, 
    var `whitelist`: List<kotlin.String>
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeOpenUrlPolicy: FfiConverterRustBuffer<OpenUrlPolicy> {
    override fun read(buf: ByteBuffer): OpenUrlPolicy {
        return OpenUrlPolicy(
            FfiConverterBoolean.read(buf),
            FfiConverterSequenceString.read(buf),
        )
    }

    override fun allocationSize(value: OpenUrlPolicy) = (
            FfiConverterBoolean.allocationSize(value.`requireUserInteraction`) +
            FfiConverterSequenceString.allocationSize(value.`whitelist`)
    )

    override fun write(value: OpenUrlPolicy, buf: ByteBuffer) {
            FfiConverterBoolean.write(value.`requireUserInteraction`, buf)
            FfiConverterSequenceString.write(value.`whitelist`, buf)
    }
}



sealed class Event {
    
    data class PointerDown(
        val `x`: kotlin.Float, 
        val `y`: kotlin.Float) : Event() {
        companion object
    }
    
    data class PointerUp(
        val `x`: kotlin.Float, 
        val `y`: kotlin.Float) : Event() {
        companion object
    }
    
    data class PointerMove(
        val `x`: kotlin.Float, 
        val `y`: kotlin.Float) : Event() {
        companion object
    }
    
    data class PointerEnter(
        val `x`: kotlin.Float, 
        val `y`: kotlin.Float) : Event() {
        companion object
    }
    
    data class PointerExit(
        val `x`: kotlin.Float, 
        val `y`: kotlin.Float) : Event() {
        companion object
    }
    
    data class Click(
        val `x`: kotlin.Float, 
        val `y`: kotlin.Float) : Event() {
        companion object
    }
    
    object OnComplete : Event()
    
    
    object OnLoopComplete : Event()
    
    

    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeEvent : FfiConverterRustBuffer<Event>{
    override fun read(buf: ByteBuffer): Event {
        return when(buf.getInt()) {
            1 -> Event.PointerDown(
                FfiConverterFloat.read(buf),
                FfiConverterFloat.read(buf),
                )
            2 -> Event.PointerUp(
                FfiConverterFloat.read(buf),
                FfiConverterFloat.read(buf),
                )
            3 -> Event.PointerMove(
                FfiConverterFloat.read(buf),
                FfiConverterFloat.read(buf),
                )
            4 -> Event.PointerEnter(
                FfiConverterFloat.read(buf),
                FfiConverterFloat.read(buf),
                )
            5 -> Event.PointerExit(
                FfiConverterFloat.read(buf),
                FfiConverterFloat.read(buf),
                )
            6 -> Event.Click(
                FfiConverterFloat.read(buf),
                FfiConverterFloat.read(buf),
                )
            7 -> Event.OnComplete
            8 -> Event.OnLoopComplete
            else -> throw RuntimeException("invalid enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: Event) = when(value) {
        is Event.PointerDown -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterFloat.allocationSize(value.`x`)
                + FfiConverterFloat.allocationSize(value.`y`)
            )
        }
        is Event.PointerUp -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterFloat.allocationSize(value.`x`)
                + FfiConverterFloat.allocationSize(value.`y`)
            )
        }
        is Event.PointerMove -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterFloat.allocationSize(value.`x`)
                + FfiConverterFloat.allocationSize(value.`y`)
            )
        }
        is Event.PointerEnter -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterFloat.allocationSize(value.`x`)
                + FfiConverterFloat.allocationSize(value.`y`)
            )
        }
        is Event.PointerExit -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterFloat.allocationSize(value.`x`)
                + FfiConverterFloat.allocationSize(value.`y`)
            )
        }
        is Event.Click -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
                + FfiConverterFloat.allocationSize(value.`x`)
                + FfiConverterFloat.allocationSize(value.`y`)
            )
        }
        is Event.OnComplete -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
        is Event.OnLoopComplete -> {
            // Add the size for the Int that specifies the variant plus the size needed for all fields
            (
                4UL
            )
        }
    }

    override fun write(value: Event, buf: ByteBuffer) {
        when(value) {
            is Event.PointerDown -> {
                buf.putInt(1)
                FfiConverterFloat.write(value.`x`, buf)
                FfiConverterFloat.write(value.`y`, buf)
                Unit
            }
            is Event.PointerUp -> {
                buf.putInt(2)
                FfiConverterFloat.write(value.`x`, buf)
                FfiConverterFloat.write(value.`y`, buf)
                Unit
            }
            is Event.PointerMove -> {
                buf.putInt(3)
                FfiConverterFloat.write(value.`x`, buf)
                FfiConverterFloat.write(value.`y`, buf)
                Unit
            }
            is Event.PointerEnter -> {
                buf.putInt(4)
                FfiConverterFloat.write(value.`x`, buf)
                FfiConverterFloat.write(value.`y`, buf)
                Unit
            }
            is Event.PointerExit -> {
                buf.putInt(5)
                FfiConverterFloat.write(value.`x`, buf)
                FfiConverterFloat.write(value.`y`, buf)
                Unit
            }
            is Event.Click -> {
                buf.putInt(6)
                FfiConverterFloat.write(value.`x`, buf)
                FfiConverterFloat.write(value.`y`, buf)
                Unit
            }
            is Event.OnComplete -> {
                buf.putInt(7)
                Unit
            }
            is Event.OnLoopComplete -> {
                buf.putInt(8)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }
}






enum class Fit {
    
    CONTAIN,
    FILL,
    COVER,
    FIT_WIDTH,
    FIT_HEIGHT,
    NONE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeFit: FfiConverterRustBuffer<Fit> {
    override fun read(buf: ByteBuffer) = try {
        Fit.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Fit) = 4UL

    override fun write(value: Fit, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






enum class Mode {
    
    FORWARD,
    REVERSE,
    BOUNCE,
    REVERSE_BOUNCE;
    companion object
}


/**
 * @suppress
 */
public object FfiConverterTypeMode: FfiConverterRustBuffer<Mode> {
    override fun read(buf: ByteBuffer) = try {
        Mode.values()[buf.getInt() - 1]
    } catch (e: IndexOutOfBoundsException) {
        throw RuntimeException("invalid enum value, something is very wrong!!", e)
    }

    override fun allocationSize(value: Mode) = 4UL

    override fun write(value: Mode, buf: ByteBuffer) {
        buf.putInt(value.ordinal + 1)
    }
}






/**
 * @suppress
 */
public object FfiConverterOptionalFloat: FfiConverterRustBuffer<kotlin.Float?> {
    override fun read(buf: ByteBuffer): kotlin.Float? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterFloat.read(buf)
    }

    override fun allocationSize(value: kotlin.Float?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterFloat.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Float?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterFloat.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeManifest: FfiConverterRustBuffer<Manifest?> {
    override fun read(buf: ByteBuffer): Manifest? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeManifest.read(buf)
    }

    override fun allocationSize(value: Manifest?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeManifest.allocationSize(value)
        }
    }

    override fun write(value: Manifest?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeManifest.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeManifestInitial: FfiConverterRustBuffer<ManifestInitial?> {
    override fun read(buf: ByteBuffer): ManifestInitial? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeManifestInitial.read(buf)
    }

    override fun allocationSize(value: ManifestInitial?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeManifestInitial.allocationSize(value)
        }
    }

    override fun write(value: ManifestInitial?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeManifestInitial.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceFloat: FfiConverterRustBuffer<List<kotlin.Float>?> {
    override fun read(buf: ByteBuffer): List<kotlin.Float>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceFloat.read(buf)
    }

    override fun allocationSize(value: List<kotlin.Float>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceFloat.allocationSize(value)
        }
    }

    override fun write(value: List<kotlin.Float>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceFloat.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceString: FfiConverterRustBuffer<List<kotlin.String>?> {
    override fun read(buf: ByteBuffer): List<kotlin.String>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceString.read(buf)
    }

    override fun allocationSize(value: List<kotlin.String>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceString.allocationSize(value)
        }
    }

    override fun write(value: List<kotlin.String>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceTypeManifestStateMachine: FfiConverterRustBuffer<List<ManifestStateMachine>?> {
    override fun read(buf: ByteBuffer): List<ManifestStateMachine>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeManifestStateMachine.read(buf)
    }

    override fun allocationSize(value: List<ManifestStateMachine>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeManifestStateMachine.allocationSize(value)
        }
    }

    override fun write(value: List<ManifestStateMachine>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeManifestStateMachine.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalSequenceTypeManifestTheme: FfiConverterRustBuffer<List<ManifestTheme>?> {
    override fun read(buf: ByteBuffer): List<ManifestTheme>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterSequenceTypeManifestTheme.read(buf)
    }

    override fun allocationSize(value: List<ManifestTheme>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterSequenceTypeManifestTheme.allocationSize(value)
        }
    }

    override fun write(value: List<ManifestTheme>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterSequenceTypeManifestTheme.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceFloat: FfiConverterRustBuffer<List<kotlin.Float>> {
    override fun read(buf: ByteBuffer): List<kotlin.Float> {
        val len = buf.getInt()
        return List<kotlin.Float>(len) {
            FfiConverterFloat.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.Float>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterFloat.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.Float>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterFloat.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceString: FfiConverterRustBuffer<List<kotlin.String>> {
    override fun read(buf: ByteBuffer): List<kotlin.String> {
        val len = buf.getInt()
        return List<kotlin.String>(len) {
            FfiConverterString.read(buf)
        }
    }

    override fun allocationSize(value: List<kotlin.String>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterString.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<kotlin.String>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterString.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeManifestAnimation: FfiConverterRustBuffer<List<ManifestAnimation>> {
    override fun read(buf: ByteBuffer): List<ManifestAnimation> {
        val len = buf.getInt()
        return List<ManifestAnimation>(len) {
            FfiConverterTypeManifestAnimation.read(buf)
        }
    }

    override fun allocationSize(value: List<ManifestAnimation>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeManifestAnimation.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ManifestAnimation>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeManifestAnimation.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeManifestStateMachine: FfiConverterRustBuffer<List<ManifestStateMachine>> {
    override fun read(buf: ByteBuffer): List<ManifestStateMachine> {
        val len = buf.getInt()
        return List<ManifestStateMachine>(len) {
            FfiConverterTypeManifestStateMachine.read(buf)
        }
    }

    override fun allocationSize(value: List<ManifestStateMachine>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeManifestStateMachine.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ManifestStateMachine>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeManifestStateMachine.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeManifestTheme: FfiConverterRustBuffer<List<ManifestTheme>> {
    override fun read(buf: ByteBuffer): List<ManifestTheme> {
        val len = buf.getInt()
        return List<ManifestTheme>(len) {
            FfiConverterTypeManifestTheme.read(buf)
        }
    }

    override fun allocationSize(value: List<ManifestTheme>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeManifestTheme.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<ManifestTheme>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeManifestTheme.write(it, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterSequenceTypeMarker: FfiConverterRustBuffer<List<Marker>> {
    override fun read(buf: ByteBuffer): List<Marker> {
        val len = buf.getInt()
        return List<Marker>(len) {
            FfiConverterTypeMarker.read(buf)
        }
    }

    override fun allocationSize(value: List<Marker>): ULong {
        val sizeForLength = 4UL
        val sizeForItems = value.map { FfiConverterTypeMarker.allocationSize(it) }.sum()
        return sizeForLength + sizeForItems
    }

    override fun write(value: List<Marker>, buf: ByteBuffer) {
        buf.putInt(value.size)
        value.iterator().forEach {
            FfiConverterTypeMarker.write(it, buf)
        }
    }
} fun `createDefaultConfig`(): Config {
            return FfiConverterTypeConfig.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_func_create_default_config(
        _status)
}
    )
    }
    
 fun `createDefaultLayout`(): Layout {
            return FfiConverterTypeLayout.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_func_create_default_layout(
        _status)
}
    )
    }
    
 fun `createDefaultOpenUrlPolicy`(): OpenUrlPolicy {
            return FfiConverterTypeOpenUrlPolicy.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_func_create_default_open_url_policy(
        _status)
}
    )
    }
    
 fun `transformThemeToLottieSlots`(`themeData`: kotlin.String, `animationId`: kotlin.String): kotlin.String {
            return FfiConverterString.lift(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_dotlottie_player_fn_func_transform_theme_to_lottie_slots(
        FfiConverterString.lower(`themeData`),FfiConverterString.lower(`animationId`),_status)
}
    )
    }
    


