/*
 * Decompiled with CFR 0.152.
 */
package com.lottiefiles.dotlottie.core.loader;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.lottiefiles.dotlottie.core.loader.AbstractLoader;
import com.lottiefiles.dotlottie.core.util.DotLottieContent;
import com.lottiefiles.dotlottie.core.util.DotLottieUtilsKt;
import java.io.Closeable;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\bH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/lottiefiles/dotlottie/core/loader/ResLoader;", "Lcom/lottiefiles/dotlottie/core/loader/AbstractLoader;", "context", "Landroid/content/Context;", "resourceId", "", "(Landroid/content/Context;I)V", "loadInternal", "Lcom/lottiefiles/dotlottie/core/util/DotLottieContent;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dotlottie_release"})
@StabilityInferred(parameters=0)
public final class ResLoader
extends AbstractLoader {
    private final int resourceId;
    public static final int $stable;

    public ResLoader(@NotNull Context context, int resourceId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.resourceId = resourceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object loadInternal(@NotNull Continuation<? super DotLottieContent> $completion) {
        Closeable closeable = this.getContext().getResources().openRawResource(this.resourceId);
        Throwable throwable = null;
        try {
            DotLottieContent content;
            DotLottieContent dotLottieContent;
            InputStream inputStream = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)inputStream);
            byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
            boolean isDotLottie = DotLottieUtilsKt.isZipCompressed(bytes);
            if (!isDotLottie) {
                String text = new String(bytes, Charsets.UTF_8);
                dotLottieContent = new DotLottieContent.Json(text);
            } else {
                dotLottieContent = new DotLottieContent.Binary(bytes);
            }
            DotLottieContent dotLottieContent2 = content = dotLottieContent;
            return dotLottieContent2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

