/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime;

import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.DatePicker;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.ViewSwitcher;
import com.kunzisoft.switchdatetime.R;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;

public class SwitchDateTimeDialogFragment
extends DialogFragment {
    private static final String STATE_DATETIME = "STATE_DATETIME";
    private Calendar dateTime = Calendar.getInstance();
    private static final String TAG_LABEL = "LABEL";
    private static final String TAG_POSITIVE_BUTTON = "POSITIVE_BUTTON";
    private static final String TAG_NEGATIVE_BUTTON = "NEGATIVE_BUTTON";
    private String mLabel;
    private String mPositiveButton;
    private String mNegativeButton;
    private OnButtonClickListener mListener;
    private ViewGroup viewGroup;
    private ViewSwitcher switcher;
    private int year = this.dateTime.get(1);
    private int month = this.dateTime.get(2);
    private int day = this.dateTime.get(5);
    private int hour = this.dateTime.get(11);
    private int minute = this.dateTime.get(12);

    public static SwitchDateTimeDialogFragment newInstance(String label, String positiveButton, String negativeButton) {
        SwitchDateTimeDialogFragment switchDateTimeDialogFragment = new SwitchDateTimeDialogFragment();
        Bundle args = new Bundle();
        args.putString(TAG_LABEL, label);
        args.putString(TAG_POSITIVE_BUTTON, positiveButton);
        args.putString(TAG_NEGATIVE_BUTTON, negativeButton);
        switchDateTimeDialogFragment.setArguments(args);
        return switchDateTimeDialogFragment;
    }

    public void setOnButtonClickListener(OnButtonClickListener onButtonClickListener) {
        this.mListener = onButtonClickListener;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putLong(STATE_DATETIME, this.dateTime.getTimeInMillis());
        super.onSaveInstanceState(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        super.onCreateDialog(savedInstanceState);
        if (this.getArguments() != null) {
            this.mLabel = this.getArguments().getString(TAG_LABEL);
            this.mPositiveButton = this.getArguments().getString(TAG_POSITIVE_BUTTON);
            this.mNegativeButton = this.getArguments().getString(TAG_NEGATIVE_BUTTON);
        }
        if (savedInstanceState != null) {
            this.dateTime.setTime(new Date(savedInstanceState.getLong(STATE_DATETIME)));
        } else {
            this.dateTime.set(this.year, this.month, this.day, this.hour, this.minute);
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        View dateTimeLayout = inflater.inflate(R.layout.dialog_switch_datetime_picker, (ViewGroup)this.getActivity().findViewById(R.id.datetime_picker));
        this.viewGroup = (ViewGroup)dateTimeLayout.findViewById(R.id.section_add);
        TextView labelView = (TextView)dateTimeLayout.findViewById(R.id.label);
        if (this.mLabel != null) {
            labelView.setText((CharSequence)this.mLabel);
        } else {
            labelView.setText((CharSequence)this.getString(R.string.label_datetime_dialog));
        }
        final TextView dateText = (TextView)dateTimeLayout.findViewById(R.id.value);
        AlertDialog.Builder db = new AlertDialog.Builder((Context)this.getActivity());
        db.setView(dateTimeLayout);
        if (this.mPositiveButton == null) {
            this.mPositiveButton = this.getString(R.string.positive_button_datetime_picker);
        }
        db.setPositiveButton((CharSequence)this.mPositiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (SwitchDateTimeDialogFragment.this.mListener != null) {
                    SwitchDateTimeDialogFragment.this.mListener.onPositiveButtonClick(SwitchDateTimeDialogFragment.this.dateTime.getTime());
                }
            }
        });
        if (this.mNegativeButton == null) {
            this.mNegativeButton = this.getString(R.string.negative_button_datetime_picker);
        }
        db.setNegativeButton((CharSequence)this.mNegativeButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (SwitchDateTimeDialogFragment.this.mListener != null) {
                    SwitchDateTimeDialogFragment.this.mListener.onNegativeButtonClick(SwitchDateTimeDialogFragment.this.dateTime.getTime());
                }
            }
        });
        dateText.setText((CharSequence)DateFormat.getDateTimeInstance().format(this.dateTime.getTime()));
        AlertDialog dialog = db.show();
        this.switcher = (ViewSwitcher)dialog.findViewById(R.id.dateSwitcher);
        ImageButton buttonSwitch = (ImageButton)dialog.findViewById(R.id.button_switch);
        buttonSwitch.setBackgroundColor(0);
        buttonSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (SwitchDateTimeDialogFragment.this.switcher.getDisplayedChild() == 0) {
                    SwitchDateTimeDialogFragment.this.switcher.showNext();
                    ((ImageButton)view).setImageResource(R.drawable.ic_clock_32dp);
                } else if (SwitchDateTimeDialogFragment.this.switcher.getDisplayedChild() == 1) {
                    SwitchDateTimeDialogFragment.this.switcher.showPrevious();
                    ((ImageButton)view).setImageResource(R.drawable.ic_calendar_32dp);
                }
            }
        });
        TimePicker timePicker = (TimePicker)dialog.findViewById(R.id.timePicker);
        if (Build.VERSION.SDK_INT >= 23) {
            timePicker.setHour(this.hour);
        } else {
            timePicker.setCurrentHour(Integer.valueOf(this.hour));
        }
        if (Build.VERSION.SDK_INT >= 23) {
            timePicker.setMinute(this.minute);
        } else {
            timePicker.setCurrentMinute(Integer.valueOf(this.minute));
        }
        timePicker.setOnTimeChangedListener(new TimePicker.OnTimeChangedListener(){

            public void onTimeChanged(TimePicker timePicker, int i, int i1) {
                SwitchDateTimeDialogFragment.this.dateTime.set(11, i);
                SwitchDateTimeDialogFragment.this.dateTime.set(12, i1);
                dateText.setText((CharSequence)DateFormat.getDateTimeInstance().format(SwitchDateTimeDialogFragment.this.dateTime.getTime()));
            }
        });
        DatePicker datePicker = (DatePicker)dialog.findViewById(R.id.datePicker);
        datePicker.init(this.year, this.month, this.day, new DatePicker.OnDateChangedListener(){

            public void onDateChanged(DatePicker datePicker, int i, int i1, int i2) {
                SwitchDateTimeDialogFragment.this.dateTime.set(1, i);
                SwitchDateTimeDialogFragment.this.dateTime.set(2, i1);
                SwitchDateTimeDialogFragment.this.dateTime.set(5, i2);
                dateText.setText((CharSequence)DateFormat.getDateTimeInstance().format(SwitchDateTimeDialogFragment.this.dateTime.getTime()));
            }
        });
        dialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialogInterface) {
                SwitchDateTimeDialogFragment.this.switcher.setMinimumWidth(SwitchDateTimeDialogFragment.this.viewGroup.getWidth() + SwitchDateTimeDialogFragment.this.switcher.getWidth());
            }
        });
        return dialog;
    }

    public void setYear(int year) {
        this.year = year;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public static interface OnButtonClickListener {
        public void onPositiveButtonClick(Date var1);

        public void onNegativeButtonClick(Date var1);
    }
}

