/*
 * Decompiled with CFR 0.152.
 */
package com.kunzisoft.switchdatetime;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageButton;
import android.widget.TextView;
import android.widget.ViewAnimator;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AlertDialog;
import androidx.fragment.app.DialogFragment;
import com.kunzisoft.switchdatetime.R;
import com.kunzisoft.switchdatetime.Utils;
import com.kunzisoft.switchdatetime.date.OnYearSelectedListener;
import com.kunzisoft.switchdatetime.date.widget.ListPickerYearView;
import com.kunzisoft.switchdatetime.time.SwitchTimePicker;
import com.prolificinteractive.materialcalendarview.CalendarDay;
import com.prolificinteractive.materialcalendarview.MaterialCalendarView;
import com.prolificinteractive.materialcalendarview.OnDateSelectedListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SwitchDateTimeDialogFragment
extends DialogFragment {
    private static final String TAG = "SwitchDateTimeDialogFrg";
    private static final String STATE_DATETIME = "STATE_DATETIME";
    private static final String STATE_CURRENT_POSITION = "STATE_CURRENT_POSITION";
    private static final int UNDEFINED_POSITION = -1;
    private Calendar dateTimeCalendar = Calendar.getInstance();
    private Calendar minimumDateTime = new GregorianCalendar(1970, 1, 1);
    private Calendar maximumDateTime = new GregorianCalendar(2200, 1, 1);
    private TimeZone timeZone = TimeZone.getDefault();
    private static final String TAG_LABEL = "LABEL";
    private static final String TAG_POSITIVE_BUTTON = "POSITIVE_BUTTON";
    private static final String TAG_NEGATIVE_BUTTON = "NEGATIVE_BUTTON";
    private static final String TAG_NEUTRAL_BUTTON = "NEUTRAL_BUTTON";
    private static final String TAG_DEFAULT_LOCALE = "DEFAULT_LOCALE";
    private static final String DEFAULT_LOCALE = "en";
    private String mLabel;
    private String mPositiveButton;
    private String mDefaultLocale;
    private String mNegativeButton;
    private String mNeutralButton;
    private OnButtonClickListener mListener;
    private boolean is24HoursMode = false;
    private boolean highlightAMPMSelection = false;
    private int startAtPosition = -1;
    private int currentPosition = 0;
    private int alertStyleId;
    private SimpleDateFormat dayAndMonthSimpleDate;
    private SimpleDateFormat yearSimpleDate;
    private ViewAnimator viewSwitcher;
    private SwitchTimePicker timePicker;
    private MaterialCalendarView materialCalendarView;
    private ListPickerYearView listPickerYearView;
    private TextView monthAndDayHeaderValues;
    private TextView yearHeaderValues;
    private boolean blockAnimationIn;
    private boolean blockAnimationOut;

    public static SwitchDateTimeDialogFragment newInstance(String label, String positiveButton, String negativeButton) {
        return SwitchDateTimeDialogFragment.newInstance(label, positiveButton, negativeButton, null, DEFAULT_LOCALE);
    }

    public static SwitchDateTimeDialogFragment newInstance(String label, String positiveButton, String negativeButton, String neutralButton, String defaultLocale) {
        SwitchDateTimeDialogFragment switchDateTimeDialogFragment = new SwitchDateTimeDialogFragment();
        Bundle args = new Bundle();
        args.putString(TAG_LABEL, label);
        args.putString(TAG_POSITIVE_BUTTON, positiveButton);
        args.putString(TAG_NEGATIVE_BUTTON, negativeButton);
        args.putString(TAG_DEFAULT_LOCALE, defaultLocale);
        if (neutralButton != null) {
            args.putString(TAG_NEUTRAL_BUTTON, neutralButton);
        }
        switchDateTimeDialogFragment.setArguments(args);
        return switchDateTimeDialogFragment;
    }

    public void setOnButtonClickListener(OnButtonClickListener onButtonClickListener) {
        this.mListener = onButtonClickListener;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putLong(STATE_DATETIME, this.dateTimeCalendar.getTimeInMillis());
        savedInstanceState.putInt(STATE_CURRENT_POSITION, this.currentPosition);
        this.timePicker.onSaveInstanceState(savedInstanceState);
        super.onSaveInstanceState(savedInstanceState);
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        super.onCreateDialog(savedInstanceState);
        assert (this.getActivity() != null);
        assert (this.getContext() != null);
        this.dateTimeCalendar.setTimeZone(this.timeZone);
        if (this.getArguments() != null) {
            this.mLabel = this.getArguments().getString(TAG_LABEL);
            this.mPositiveButton = this.getArguments().getString(TAG_POSITIVE_BUTTON);
            this.mNegativeButton = this.getArguments().getString(TAG_NEGATIVE_BUTTON);
            this.mNeutralButton = this.getArguments().getString(TAG_NEUTRAL_BUTTON);
            this.mDefaultLocale = this.getArguments().getString(TAG_DEFAULT_LOCALE);
        }
        this.setDefaultLocale(this.mDefaultLocale);
        if (savedInstanceState != null) {
            this.currentPosition = savedInstanceState.getInt(STATE_CURRENT_POSITION);
            this.dateTimeCalendar.setTime(new Date(savedInstanceState.getLong(STATE_DATETIME)));
        }
        if (this.dateTimeCalendar.before(this.minimumDateTime) || this.dateTimeCalendar.after(this.maximumDateTime)) {
            throw new RuntimeException("Default date " + this.dateTimeCalendar.getTime() + " must be between " + this.minimumDateTime.getTime() + " and " + this.maximumDateTime.getTime());
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        this.getActivity().getTheme().applyStyle(R.style.Theme_SwitchDateTime, false);
        View dateTimeLayout = inflater.inflate(R.layout.dialog_switch_datetime_picker, (ViewGroup)this.getActivity().findViewById(R.id.datetime_picker));
        TextView labelView = (TextView)dateTimeLayout.findViewById(R.id.label);
        if (this.mLabel != null) {
            labelView.setText((CharSequence)this.mLabel);
        } else {
            labelView.setText((CharSequence)this.getString(R.string.label_datetime_dialog));
        }
        this.blockAnimationIn = false;
        this.blockAnimationOut = false;
        this.viewSwitcher = (ViewAnimator)dateTimeLayout.findViewById(R.id.dateSwitcher);
        this.viewSwitcher.getInAnimation().setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationIn = true;
            }

            public void onAnimationEnd(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationIn = false;
                SwitchDateTimeDialogFragment.this.currentPosition = SwitchDateTimeDialogFragment.this.viewSwitcher.getDisplayedChild();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.viewSwitcher.getOutAnimation().setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationOut = true;
            }

            public void onAnimationEnd(Animation animation) {
                SwitchDateTimeDialogFragment.this.blockAnimationOut = false;
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        if (this.startAtPosition != -1) {
            this.currentPosition = this.startAtPosition;
        }
        this.viewSwitcher.setDisplayedChild(this.currentPosition);
        ImageButton buttonSwitch = (ImageButton)dateTimeLayout.findViewById(R.id.button_switch);
        buttonSwitch.setBackgroundColor(0);
        buttonSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Utils.animLabelElement(view);
                if (!SwitchDateTimeDialogFragment.this.blockAnimationIn || !SwitchDateTimeDialogFragment.this.blockAnimationOut) {
                    SwitchDateTimeDialogFragment.this.viewSwitcher.showNext();
                }
            }
        });
        View timeHeaderValues = dateTimeLayout.findViewById(R.id.time_header_values);
        OnClickHeaderElementListener onTimeClickListener = new OnClickHeaderElementListener(HeaderViewsPosition.VIEW_HOURS_AND_MINUTES.getPosition());
        timeHeaderValues.setOnClickListener((View.OnClickListener)onTimeClickListener);
        this.monthAndDayHeaderValues = (TextView)dateTimeLayout.findViewById(R.id.date_picker_month_and_day);
        OnClickHeaderElementListener onMonthAndDayClickListener = new OnClickHeaderElementListener(HeaderViewsPosition.VIEW_MONTH_AND_DAY.getPosition());
        this.monthAndDayHeaderValues.setOnClickListener((View.OnClickListener)onMonthAndDayClickListener);
        this.yearHeaderValues = (TextView)dateTimeLayout.findViewById(R.id.date_picker_year);
        OnClickHeaderElementListener onYearClickListener = new OnClickHeaderElementListener(HeaderViewsPosition.VIEW_YEAR.getPosition());
        this.yearHeaderValues.setOnClickListener((View.OnClickListener)onYearClickListener);
        if (this.dayAndMonthSimpleDate == null) {
            this.dayAndMonthSimpleDate = new SimpleDateFormat("MMMM dd", Locale.getDefault());
        }
        if (this.yearSimpleDate == null) {
            this.yearSimpleDate = new SimpleDateFormat("yyyy", Locale.getDefault());
        }
        this.dayAndMonthSimpleDate.setTimeZone(this.timeZone);
        this.yearSimpleDate.setTimeZone(this.timeZone);
        this.yearHeaderValues.setText((CharSequence)this.yearSimpleDate.format(this.dateTimeCalendar.getTime()));
        this.monthAndDayHeaderValues.setText((CharSequence)this.dayAndMonthSimpleDate.format(this.dateTimeCalendar.getTime()));
        SwitchTimePicker.OnTimeSelectedListener onTimeSelectedListener = new SwitchTimePicker.OnTimeSelectedListener(){

            @Override
            public void onTimeSelected(int hourOfDayTime, int minuteTime) {
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(11, hourOfDayTime);
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(12, minuteTime);
            }
        };
        this.timePicker = new SwitchTimePicker(this.getContext(), onTimeSelectedListener, savedInstanceState);
        this.timePicker.setIs24HourMode(this.is24HoursMode);
        this.timePicker.setHighlightAMPMSelection(this.highlightAMPMSelection);
        this.timePicker.setHourOfDay(this.dateTimeCalendar.get(11));
        this.timePicker.setMinute(this.dateTimeCalendar.get(12));
        this.timePicker.onCreateView(dateTimeLayout, savedInstanceState);
        this.timePicker.setOnClickTimeListener(onTimeClickListener);
        this.materialCalendarView = (MaterialCalendarView)dateTimeLayout.findViewById(R.id.datePicker);
        this.materialCalendarView.state().edit().setMinimumDate(CalendarDay.from((Calendar)this.minimumDateTime)).setMaximumDate(CalendarDay.from((Calendar)this.maximumDateTime)).commit();
        this.materialCalendarView.setCurrentDate(this.dateTimeCalendar);
        this.materialCalendarView.setDateSelected(this.dateTimeCalendar, true);
        this.materialCalendarView.setOnDateChangedListener(new OnDateSelectedListener(){

            public void onDateSelected(@NonNull MaterialCalendarView widget, @NonNull CalendarDay calendarDay, boolean selected) {
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(1, calendarDay.getYear());
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(2, calendarDay.getMonth());
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(5, calendarDay.getDay());
                SwitchDateTimeDialogFragment.this.listPickerYearView.assignCurrentYear(calendarDay.getYear());
                SwitchDateTimeDialogFragment.this.yearHeaderValues.setText((CharSequence)SwitchDateTimeDialogFragment.this.yearSimpleDate.format(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime()));
                SwitchDateTimeDialogFragment.this.monthAndDayHeaderValues.setText((CharSequence)SwitchDateTimeDialogFragment.this.dayAndMonthSimpleDate.format(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime()));
                SwitchDateTimeDialogFragment.this.timePicker.clickHour();
            }
        });
        this.materialCalendarView.invalidate();
        this.listPickerYearView = (ListPickerYearView)dateTimeLayout.findViewById(R.id.yearPicker);
        this.listPickerYearView.setMinYear(this.minimumDateTime.get(1));
        this.listPickerYearView.setMaxYear(this.maximumDateTime.get(1));
        this.listPickerYearView.assignCurrentYear(this.dateTimeCalendar.get(1));
        this.listPickerYearView.setDatePickerListener(new OnYearSelectedListener(){

            @Override
            public void onYearSelected(View view, int yearPicker) {
                SwitchDateTimeDialogFragment.this.dateTimeCalendar.set(1, yearPicker);
                SwitchDateTimeDialogFragment.this.yearHeaderValues.setText((CharSequence)SwitchDateTimeDialogFragment.this.yearSimpleDate.format(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime()));
                SwitchDateTimeDialogFragment.this.materialCalendarView.setCurrentDate(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime().getTime());
                SwitchDateTimeDialogFragment.this.materialCalendarView.setDateSelected(SwitchDateTimeDialogFragment.this.dateTimeCalendar, true);
                SwitchDateTimeDialogFragment.this.materialCalendarView.goToNext();
                SwitchDateTimeDialogFragment.this.materialCalendarView.goToPrevious();
            }
        });
        AlertDialog.Builder db = this.alertStyleId != 0 ? new AlertDialog.Builder(this.getContext(), this.alertStyleId) : new AlertDialog.Builder(this.getContext());
        db.setView(dateTimeLayout);
        if (this.mPositiveButton == null) {
            this.mPositiveButton = this.getString(17039370);
        }
        db.setPositiveButton((CharSequence)this.mPositiveButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (SwitchDateTimeDialogFragment.this.mListener != null) {
                    SwitchDateTimeDialogFragment.this.mListener.onPositiveButtonClick(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime());
                }
            }
        });
        if (this.mNegativeButton == null) {
            this.mNegativeButton = this.getString(0x1040000);
        }
        db.setNegativeButton((CharSequence)this.mNegativeButton, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (SwitchDateTimeDialogFragment.this.mListener != null) {
                    SwitchDateTimeDialogFragment.this.mListener.onNegativeButtonClick(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime());
                }
            }
        });
        if (this.mNeutralButton != null) {
            db.setNeutralButton((CharSequence)this.mNeutralButton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (SwitchDateTimeDialogFragment.this.mListener != null && SwitchDateTimeDialogFragment.this.mListener instanceof OnButtonWithNeutralClickListener) {
                        ((OnButtonWithNeutralClickListener)SwitchDateTimeDialogFragment.this.mListener).onNeutralButtonClick(SwitchDateTimeDialogFragment.this.dateTimeCalendar.getTime());
                    }
                }
            });
        }
        return db.create();
    }

    private void setDefaultLocale(String mDefaultLocale) {
        Locale locale = new Locale(mDefaultLocale);
        Locale.setDefault(locale);
        Configuration config = new Configuration();
        config.locale = locale;
        this.getResources().updateConfiguration(config, this.getResources().getDisplayMetrics());
    }

    public void onDismiss(DialogInterface dialog) {
        super.onDismiss(dialog);
        this.startAtPosition = -1;
    }

    public void startAtTimeView() {
        this.startAtPosition = HeaderViewsPosition.VIEW_HOURS_AND_MINUTES.getPosition();
    }

    public void startAtCalendarView() {
        this.startAtPosition = HeaderViewsPosition.VIEW_MONTH_AND_DAY.getPosition();
    }

    public void startAtYearView() {
        this.startAtPosition = HeaderViewsPosition.VIEW_YEAR.getPosition();
    }

    public void setDefaultYear(int year) {
        this.dateTimeCalendar.set(1, year);
    }

    @Deprecated
    public void setYear(int year) {
        this.setDefaultYear(year);
    }

    public void setDefaultMonth(int month) {
        this.dateTimeCalendar.set(2, month);
    }

    @Deprecated
    public void setMonth(int month) {
        this.setDefaultMonth(month);
    }

    public void setDefaultDay(int day) {
        this.dateTimeCalendar.set(5, day);
    }

    @Deprecated
    public void setDay(int day) {
        this.setDefaultDay(day);
    }

    public void setDefaultHourOfDay(int hourOfDay) {
        this.dateTimeCalendar.set(11, hourOfDay);
    }

    @Deprecated
    public void setHour(int hour) {
        this.setDefaultHourOfDay(hour);
    }

    public void setDefaultMinute(int minute) {
        this.dateTimeCalendar.set(12, minute);
    }

    @Deprecated
    public void setMinute(int minute) {
        this.setDefaultMinute(minute);
    }

    public int getYear() {
        return this.dateTimeCalendar.get(1);
    }

    public int getMonth() {
        return this.dateTimeCalendar.get(2);
    }

    public int getDay() {
        return this.dateTimeCalendar.get(5);
    }

    public int getHourOfDay() {
        return this.dateTimeCalendar.get(11);
    }

    public int getMinute() {
        return this.dateTimeCalendar.get(12);
    }

    public void setDefaultDateTime(Date date) {
        this.dateTimeCalendar.setTime(date);
    }

    public void setMinimumDateTime(Date date) {
        this.minimumDateTime.setTime(date);
    }

    public void setMaximumDateTime(Date date) {
        this.maximumDateTime.setTime(date);
    }

    public Date getMinimumDateTime() {
        return this.minimumDateTime.getTime();
    }

    public Date getMaximumDateTime() {
        return this.maximumDateTime.getTime();
    }

    public SimpleDateFormat getSimpleDateMonthAndDayFormat() {
        return this.dayAndMonthSimpleDate;
    }

    public void setSimpleDateMonthAndDayFormat(SimpleDateFormat simpleDateFormat) throws SimpleDateMonthAndDayFormatException {
        Pattern patternMonthAndDay = Pattern.compile("(M|w|W|D|d|F|E|u|\\.|\\s)*");
        Matcher matcherMonthAndDay = patternMonthAndDay.matcher(simpleDateFormat.toPattern());
        if (!matcherMonthAndDay.matches()) {
            throw new SimpleDateMonthAndDayFormatException(simpleDateFormat.toPattern() + "isn't allowed for " + patternMonthAndDay.pattern());
        }
        this.dayAndMonthSimpleDate = simpleDateFormat;
    }

    public void set24HoursMode(boolean is24HoursMode) {
        this.is24HoursMode = is24HoursMode;
    }

    public void setHighlightAMPMSelection(boolean highlightAMPMSelection) {
        this.highlightAMPMSelection = highlightAMPMSelection;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
    }

    public void setAlertStyle(@StyleRes int styleId) {
        this.alertStyleId = styleId;
    }

    public class OnClickHeaderElementListener
    implements View.OnClickListener {
        private final int positionView;

        OnClickHeaderElementListener(int positionView) {
            this.positionView = positionView;
        }

        public void onClick(View view) {
            Utils.animLabelElement(view);
            if (SwitchDateTimeDialogFragment.this.viewSwitcher.getDisplayedChild() != this.positionView) {
                SwitchDateTimeDialogFragment.this.viewSwitcher.setDisplayedChild(this.positionView);
            }
            SwitchDateTimeDialogFragment.this.startAtPosition = this.positionView;
        }
    }

    public static enum HeaderViewsPosition {
        VIEW_HOURS_AND_MINUTES(0),
        VIEW_MONTH_AND_DAY(1),
        VIEW_YEAR(2);

        private final int positionSwitch;

        private HeaderViewsPosition(int position) {
            this.positionSwitch = position;
        }

        public int getPosition() {
            return this.positionSwitch;
        }
    }

    public static interface OnButtonWithNeutralClickListener
    extends OnButtonClickListener {
        public void onNeutralButtonClick(Date var1);
    }

    public static interface OnButtonClickListener {
        public void onPositiveButtonClick(Date var1);

        public void onNegativeButtonClick(Date var1);
    }

    public static class SimpleDateMonthAndDayFormatException
    extends Exception {
        SimpleDateMonthAndDayFormatException(String message) {
            super(message);
        }
    }
}

