/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.signers;

import io.ethers.core.types.Address;
import io.ethers.core.types.Signature;
import io.ethers.core.types.transaction.ChainId;
import io.ethers.core.types.transaction.TransactionSigned;
import io.ethers.core.types.transaction.TransactionUnsigned;
import io.ethers.core.types.transaction.TxType;
import io.ethers.crypto.Hashing;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0010\u00c0\u0006\u0001"}, d2={"Lio/ethers/signers/Signer;", "", "address", "Lio/ethers/core/types/Address;", "getAddress", "()Lio/ethers/core/types/Address;", "signHash", "Lio/ethers/core/types/Signature;", "hash", "", "signMessage", "message", "signTransaction", "Lio/ethers/core/types/transaction/TransactionSigned;", "tx", "Lio/ethers/core/types/transaction/TransactionUnsigned;", "ethers-signers"})
public interface Signer {
    @NotNull
    public Address getAddress();

    @NotNull
    default public Signature signMessage(@NotNull byte[] message) {
        Signature sig = this.signHash(Hashing.hashMessage((byte[])message));
        sig.updateV(sig.recoveryId() + 27L);
        return sig;
    }

    @NotNull
    default public TransactionSigned signTransaction(@NotNull TransactionUnsigned tx) {
        Signature sig = this.signHash(tx.signatureHash());
        if (Intrinsics.areEqual((Object)tx.getType(), (Object)TxType.Legacy.INSTANCE)) {
            if (ChainId.isValid((long)tx.getChainId())) {
                sig.updateV(tx.getChainId() * (long)2 + 35L + sig.recoveryId());
            } else {
                sig.updateV(sig.recoveryId() + 27L);
            }
        }
        return new TransactionSigned(tx, sig, null, this.getAddress(), 4, null);
    }

    @NotNull
    public Signature signHash(@NotNull byte[] var1);
}

