/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import io.ethers.core.Jackson;
import io.ethers.core.JsonParserExtensionsKt;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.providers.BlockingSubscriptionStream;
import io.ethers.providers.HttpClient;
import io.ethers.providers.JsonPubSubClient;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.JsonRpcClientKt;
import io.ethers.providers.RpcError;
import io.ethers.providers.Stopwatch;
import io.ethers.providers.SubscriptionStream;
import io.ethers.providers.WsClient;
import io.ethers.providers.types.BatchRpcRequest;
import io.ethers.providers.types.RpcCall;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u00012\u00020\u0002:\u0006OPQRSTB#\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u0010+\u001a\u00020\u0004H\u0002J\u0010\u0010/\u001a\u00020)2\u0006\u00100\u001a\u00020-H\u0002J6\u00101\u001a\u00020)\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u00020\u00172\f\u00104\u001a\b\u0012\u0004\u0012\u0002H20\u001a2\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u000107H\u0002J\"\u00108\u001a\u00020)2\u0006\u00103\u001a\u00020\u00172\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u000107H\u0002J6\u00109\u001a\u00020)\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u00020\u00172\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H20#2\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u000107H\u0002J6\u0010;\u001a\u00020)\"\u0004\b\u0000\u001022\u0006\u00103\u001a\u00020\u00172\f\u00104\u001a\b\u0012\u0004\u0012\u0002H20\u001c2\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u000107H\u0002J.\u0010<\u001a\u00020)\"\b\b\u0000\u00102*\u00020=2\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H20?2\u0006\u0010@\u001a\u00020\u0017H\u0002JM\u00104\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H2\u0012\u0004\u0012\u0002070B0A\"\u0004\b\u0000\u001022\u0006\u0010C\u001a\u00020\u00042\n\u0010D\u001a\u0006\u0012\u0002\b\u00030E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u0002H20GH\u0016\u00a2\u0006\u0002\u0010HJ\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020 0A2\u0006\u0010J\u001a\u00020KH\u0016JK\u0010L\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H20M\u0012\u0004\u0012\u0002070B0A\"\u0004\b\u0000\u001022\n\u0010D\u001a\u0006\u0012\u0002\b\u00030E2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u0002H20GH\u0016\u00a2\u0006\u0002\u0010NR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e0\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u000e`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0019\u001a&\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\u0016j\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u001b\u001a&\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u0016j\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001a0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010%\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lio/ethers/providers/WsClient;", "Lio/ethers/providers/JsonPubSubClient;", "Lio/ethers/providers/JsonRpcClient;", "url", "", "client", "Lokhttp3/OkHttpClient;", "processorThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "(Ljava/lang/String;Lokhttp3/OkHttpClient;Ljava/util/concurrent/ThreadFactory;)V", "LOG", "Lorg/slf4j/Logger;", "batchRequestQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lio/ethers/providers/WsClient$CompletableBatchRequest;", "connectionClosedCondition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "connectionOpenedCondition", "eventLock", "Ljava/util/concurrent/locks/ReentrantLock;", "inFlightBatchRequests", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "inFlightRequests", "Lio/ethers/providers/WsClient$CompletableRequest;", "inFlightSubscriptionRequests", "Lio/ethers/providers/WsClient$CompletableSubscriptionRequest;", "messageQueue", "newEventCondition", "reconnect", "", "requestIdToSubscription", "Ljava/util/concurrent/ConcurrentHashMap;", "Lio/ethers/providers/WsClient$Subscription;", "requestQueue", "serverIdToSubscription", "stopping", "subscriptionQueue", "close", "", "handleBatchResponse", "text", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "handleMessage", "handleNotification", "paramsParser", "handleRequestResponse", "T", "id", "request", "resultParser", "error", "Lio/ethers/providers/RpcError;", "handleResponse", "handleResubscriptionResponse", "subscription", "handleSubscriptionResponse", "removeTimedOutRequests", "Lio/ethers/providers/WsClient$ExpiringRequest;", "requests", "", "timeoutMillis", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "method", "params", "", "resultDecoder", "Ljava/util/function/Function;", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", "requestBatch", "batch", "Lio/ethers/providers/types/BatchRpcRequest;", "subscribe", "Lio/ethers/providers/SubscriptionStream;", "([Ljava/lang/Object;Ljava/util/function/Function;)Ljava/util/concurrent/CompletableFuture;", "CompletableBatchRequest", "CompletableRequest", "CompletableSubscriptionRequest", "DefaultThreadFactory", "ExpiringRequest", "Subscription", "ethers-providers"})
@SourceDebugExtension(value={"SMAP\nWsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WsClient.kt\nio/ethers/providers/WsClient\n+ 2 LoggerExtensions.kt\nio/ethers/logger/LoggerExtensionsKt\n+ 3 JsonParserExtensions.kt\nio/ethers/core/JsonParserExtensionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,738:1\n20#2:739\n54#2,4:740\n27#2,4:762\n27#2,4:766\n27#2,4:770\n45#2,4:780\n45#2,4:785\n27#2,4:789\n36#2,4:793\n36#2,4:797\n36#2,4:801\n36#2,4:805\n36#2,4:809\n27#2,4:813\n27#2,4:817\n27#2,4:821\n72#2,4:825\n27#2,4:829\n33#3,6:744\n33#3,6:750\n33#3,6:756\n33#3,6:774\n1#4:784\n*S KotlinDebug\n*F\n+ 1 WsClient.kt\nio/ethers/providers/WsClient\n*L\n49#1:739\n330#1:740,4\n525#1:762,4\n561#1:766,4\n582#1:770,4\n620#1:780,4\n124#1:785,4\n150#1:789,4\n160#1:793,4\n190#1:797,4\n202#1:801,4\n214#1:805,4\n224#1:809,4\n246#1:813,4\n273#1:817,4\n288#1:821,4\n310#1:825,4\n547#1:829,4\n349#1:744,6\n420#1:750,6\n465#1:756,6\n588#1:774,6\n*E\n"})
public final class WsClient
implements JsonPubSubClient,
JsonRpcClient {
    @NotNull
    private final Logger LOG;
    @NotNull
    private final HashMap<Long, CompletableRequest<?>> inFlightRequests;
    @NotNull
    private final HashMap<Long, CompletableBatchRequest> inFlightBatchRequests;
    @NotNull
    private final HashMap<Long, CompletableSubscriptionRequest<?>> inFlightSubscriptionRequests;
    @NotNull
    private final ConcurrentHashMap<Long, Subscription<?>> requestIdToSubscription;
    @NotNull
    private final ConcurrentHashMap<String, Subscription<?>> serverIdToSubscription;
    @NotNull
    private final ReentrantLock eventLock;
    private final Condition newEventCondition;
    private final Condition connectionOpenedCondition;
    private final Condition connectionClosedCondition;
    @NotNull
    private final ConcurrentLinkedQueue<String> messageQueue;
    @NotNull
    private final ConcurrentLinkedQueue<CompletableRequest<?>> requestQueue;
    @NotNull
    private final ConcurrentLinkedQueue<CompletableBatchRequest> batchRequestQueue;
    @NotNull
    private final ConcurrentLinkedQueue<CompletableSubscriptionRequest<?>> subscriptionQueue;
    private volatile boolean reconnect;
    private volatile boolean stopping;

    @JvmOverloads
    public WsClient(@NotNull String url, @NotNull OkHttpClient client, @NotNull ThreadFactory processorThreadFactory) {
        WsClient $this$getLogger$iv = this;
        boolean $i$f$getLogger = false;
        this.LOG = LoggerFactory.getLogger($this$getLogger$iv.getClass());
        this.inFlightRequests = new HashMap();
        this.inFlightBatchRequests = new HashMap();
        this.inFlightSubscriptionRequests = new HashMap();
        this.requestIdToSubscription = new ConcurrentHashMap();
        this.serverIdToSubscription = new ConcurrentHashMap();
        this.eventLock = new ReentrantLock();
        this.newEventCondition = this.eventLock.newCondition();
        this.connectionOpenedCondition = this.eventLock.newCondition();
        this.connectionClosedCondition = this.eventLock.newCondition();
        this.messageQueue = new ConcurrentLinkedQueue();
        this.requestQueue = new ConcurrentLinkedQueue();
        this.batchRequestQueue = new ConcurrentLinkedQueue();
        this.subscriptionQueue = new ConcurrentLinkedQueue();
        Request wsRequest = new Request.Builder().url(url).build();
        WebSocketListener wsListener2 = new WebSocketListener(this){
            final /* synthetic */ WsClient this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOpen(@NotNull WebSocket webSocket, @NotNull Response response) {
                Logger $this$inf$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$inf = false;
                if ($this$inf$iv.isInfoEnabled()) {
                    Logger logger = $this$inf$iv;
                    boolean bl = false;
                    logger.info("WebSocket connection opened");
                }
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$getConnectionOpenedCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onMessage(@NotNull WebSocket webSocket, @NotNull String text) {
                WsClient.access$getMessageQueue$p(this.this$0).add(text);
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$getNewEventCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }

            public void onMessage(@NotNull WebSocket webSocket, @NotNull ByteString bytes) {
                throw new IOException("Binary messages are not supported");
            }

            public void onClosing(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Logger $this$dbg$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$dbg = false;
                if ($this$dbg$iv.isDebugEnabled()) {
                    Logger logger = $this$dbg$iv;
                    boolean bl = false;
                    logger.debug("WebSocket connection closing: " + code + " " + reason);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
                Logger $this$wrn$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$wrn = false;
                if ($this$wrn$iv.isWarnEnabled()) {
                    Logger logger = $this$wrn$iv;
                    boolean bl = false;
                    logger.warn("WebSocket connection closed: " + code + " " + reason);
                }
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$getConnectionClosedCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                this.requestReconnect();
            }

            public void onFailure(@NotNull WebSocket webSocket, @NotNull Throwable t, @Nullable Response response) {
                Logger $this$err$iv = WsClient.access$getLOG$p(this.this$0);
                boolean $i$f$err = false;
                if ($this$err$iv.isErrorEnabled()) {
                    Logger logger = $this$err$iv;
                    boolean bl = false;
                    logger.error("WebSocket failure", t);
                }
                this.requestReconnect();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void requestReconnect() {
                Lock lock = WsClient.access$getEventLock$p(this.this$0);
                WsClient wsClient = this.this$0;
                lock.lock();
                try {
                    boolean bl = false;
                    WsClient.access$setReconnect$p(wsClient, true);
                    WsClient.access$getNewEventCondition$p(wsClient).signalAll();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        };
        processorThreadFactory.newThread(() -> WsClient._init_$lambda$23(this, client, wsRequest, wsListener2)).start();
    }

    public /* synthetic */ WsClient(String string, OkHttpClient okHttpClient, ThreadFactory threadFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            okHttpClient = new OkHttpClient();
        }
        if ((n & 4) != 0) {
            threadFactory = new DefaultThreadFactory();
        }
        this(string, okHttpClient, threadFactory);
    }

    private final <T extends ExpiringRequest> void removeTimedOutRequests(Map<Long, T> requests, long timeoutMillis) {
        if (timeoutMillis <= 0L || requests.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Long, T>> iter = requests.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, T> entry = iter.next();
            if (!((ExpiringRequest)entry.getValue()).expireIfTimedOut(timeoutMillis, TimeUnit.MILLISECONDS)) continue;
            Logger $this$wrn$iv = this.LOG;
            boolean $i$f$wrn = false;
            if ($this$wrn$iv.isWarnEnabled()) {
                Logger logger = $this$wrn$iv;
                boolean bl = false;
                logger.warn("Request timed out: ID " + entry.getKey());
            }
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleMessage(String text) {
        Closeable closeable = (Closeable)Jackson.INSTANCE.createAndInitParser(Jackson.MAPPER, text);
        Throwable throwable = null;
        try {
            block56: {
                Object object;
                TokenBuffer buff2;
                Closeable closeable2;
                JsonParser parser = (JsonParser)closeable;
                boolean bl = false;
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    this.handleBatchResponse(text, parser);
                    return;
                }
                long id = 0L;
                id = -1L;
                String method = null;
                TokenBuffer resultBuffer = null;
                TokenBuffer paramsBuffer = null;
                Object error = null;
                JsonParser $this$forEachObjectField$iv = parser;
                boolean $i$f$forEachObjectField = false;
                while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    String field$iv = $this$forEachObjectField$iv.getCurrentName();
                    $this$forEachObjectField$iv.nextToken();
                    String field = field$iv;
                    boolean bl2 = false;
                    switch (field) {
                        case "id": {
                            id = parser.getLongValue();
                            break;
                        }
                        case "method": {
                            method = parser.getText();
                            break;
                        }
                        case "result": {
                            if (id != -1L) {
                                this.handleResponse(id, parser, (RpcError)error);
                                break block56;
                            }
                            resultBuffer = new TokenBuffer(parser);
                            resultBuffer.copyCurrentStructure(parser);
                            break;
                        }
                        case "params": {
                            if (method != null) {
                                this.handleNotification(parser);
                                break block56;
                            }
                            paramsBuffer = new TokenBuffer(parser);
                            paramsBuffer.copyCurrentStructure(parser);
                            break;
                        }
                        case "error": {
                            error = Jackson.MAPPER.readValue(parser, RpcError.class);
                            break;
                        }
                        default: {
                            throw new Exception("Invalid response: " + text);
                        }
                        case "jsonrpc": {
                            break;
                        }
                    }
                }
                if (method != null && paramsBuffer != null) {
                    closeable2 = (Closeable)paramsBuffer;
                    Throwable throwable2 = null;
                    try {
                        buff2 = (TokenBuffer)closeable2;
                        boolean bl3 = false;
                        Closeable closeable3 = (Closeable)buff2.asParser();
                        object = null;
                        try {
                            JsonParser it = (JsonParser)closeable3;
                            boolean bl4 = false;
                            it.nextToken();
                            this.handleNotification(it);
                            it = Unit.INSTANCE;
                        }
                        catch (Throwable it) {
                            object = it;
                            throw it;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable3, (Throwable)object);
                        }
                        buff2 = Unit.INSTANCE;
                    }
                    catch (Throwable buff2) {
                        throwable2 = buff2;
                        throw buff2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                }
                if (id != -1L && error != null) {
                    this.handleResponse(id, parser, (RpcError)error);
                } else {
                    if (id != -1L && resultBuffer != null) {
                        closeable2 = (Closeable)resultBuffer;
                        Throwable throwable3 = null;
                        try {
                            buff2 = (TokenBuffer)closeable2;
                            boolean bl5 = false;
                            Closeable closeable4 = (Closeable)buff2.asParser();
                            object = null;
                            try {
                                JsonParser it = (JsonParser)closeable4;
                                boolean bl6 = false;
                                it.nextToken();
                                this.handleResponse(id, it, null);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable4) {
                                object = throwable4;
                                throw throwable4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable4, (Throwable)object);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable5) {
                            throwable3 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable3);
                        }
                    }
                    throw new Exception("Invalid response: " + text);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleBatchResponse(String text, JsonParser p) {
        int responseIndex = 0;
        CompletableBatchRequest batch = null;
        while (!JsonParserExtensionsKt.isNextTokenArrayEnd((JsonParser)p)) {
            Object error;
            Object result;
            block50: {
                Object field$iv;
                if (batch != null) break block50;
                result = null;
                error = null;
                TokenBuffer buffer = null;
                JsonParser $this$forEachObjectField$iv = p;
                boolean $i$f$forEachObjectField2 = false;
                while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                    field$iv = $this$forEachObjectField$iv.getCurrentName();
                    $this$forEachObjectField$iv.nextToken();
                    String field = field$iv;
                    boolean bl = false;
                    switch (field) {
                        case "id": {
                            batch = this.inFlightBatchRequests.remove(p.getLongValue());
                            break;
                        }
                        case "result": {
                            if (batch == null) {
                                buffer = new TokenBuffer(p);
                                buffer.copyCurrentStructure(p);
                                break;
                            }
                            result = ((CompletableBatchRequest)batch).getRequest().getRequests$ethers_providers().get(responseIndex).getResultDecoder().apply(p);
                            break;
                        }
                        case "error": {
                            error = Jackson.MAPPER.readValue(p, RpcError.class);
                            break;
                        }
                        default: {
                            throw new Exception("Invalid response: " + text);
                        }
                        case "jsonrpc": 
                    }
                }
                if (batch == null) {
                    throw new Exception("Invalid response, no matching batch found: " + text);
                }
                TokenBuffer tokenBuffer = buffer;
                if (tokenBuffer != null) {
                    Closeable $i$f$forEachObjectField2 = (Closeable)tokenBuffer;
                    field$iv = null;
                    try {
                        TokenBuffer it = (TokenBuffer)$i$f$forEachObjectField2;
                        boolean bl = false;
                        result = ((CompletableBatchRequest)batch).getRequest().getRequests$ethers_providers().get(responseIndex).getResultDecoder().apply(it.asParserOnFirstToken());
                        it = Unit.INSTANCE;
                    }
                    catch (Throwable it) {
                        field$iv = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$i$f$forEachObjectField2, (Throwable)field$iv);
                    }
                }
                if (result == null && error == null) {
                    ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(HttpClient.Companion.getERROR_INVALID_RESPONSE$ethers_providers());
                } else {
                    Result result2;
                    Object v1 = result;
                    if (v1 != null) {
                        result2 = ResultKt.success(v1);
                    } else {
                        Object object = error;
                        Intrinsics.checkNotNull(object);
                        result2 = ResultKt.failure((Result.Error)((Result.Error)object));
                    }
                    Result response = result2;
                    ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(response);
                }
                int response = responseIndex;
                responseIndex = response + 1;
                continue;
            }
            result = null;
            error = null;
            JsonParser $this$forEachObjectField$iv = p;
            boolean $i$f$forEachObjectField = false;
            while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
                String field$iv = $this$forEachObjectField$iv.getCurrentName();
                $this$forEachObjectField$iv.nextToken();
                String field = field$iv;
                boolean bl = false;
                switch (field) {
                    case "result": {
                        result = ((CompletableBatchRequest)batch).getRequest().getRequests$ethers_providers().get(responseIndex).getResultDecoder().apply(p);
                        break;
                    }
                    case "error": {
                        error = Jackson.MAPPER.readValue(p, RpcError.class);
                        break;
                    }
                    default: {
                        throw new Exception("Invalid response: " + text);
                    }
                    case "id": 
                    case "jsonrpc": 
                }
            }
            if (result == null && error == null) {
                ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(HttpClient.Companion.getERROR_INVALID_RESPONSE$ethers_providers());
            } else {
                Result result3;
                Object v4 = result;
                if (v4 != null) {
                    result3 = ResultKt.success(v4);
                } else {
                    Object object = error;
                    Intrinsics.checkNotNull(object);
                    result3 = ResultKt.failure((Result.Error)((Result.Error)object));
                }
                Result response = result3;
                ((CompletableBatchRequest)batch).getRequest().getResponses$ethers_providers().get(responseIndex).complete(response);
            }
            int n = responseIndex;
            responseIndex = n + 1;
        }
        CompletableBatchRequest completableBatchRequest = batch;
        Intrinsics.checkNotNull(completableBatchRequest);
        ((CompletableBatchRequest)completableBatchRequest).getFuture().complete(true);
    }

    private final void handleResponse(long id, JsonParser resultParser, RpcError error) {
        CompletableRequest<?> request2 = this.inFlightRequests.remove(id);
        if (request2 != null) {
            this.handleRequestResponse(id, request2, resultParser, error);
            return;
        }
        CompletableSubscriptionRequest<?> subscriptionRequest = this.inFlightSubscriptionRequests.remove(id);
        if (subscriptionRequest != null) {
            this.handleSubscriptionResponse(id, subscriptionRequest, resultParser, error);
            return;
        }
        Subscription<?> resubscribed = this.requestIdToSubscription.get(id);
        if (resubscribed != null) {
            this.handleResubscriptionResponse(id, resubscribed, resultParser, error);
        }
    }

    private final <T> void handleRequestResponse(long id, CompletableRequest<T> request2, JsonParser resultParser, RpcError error) {
        Result result;
        Object result2;
        Object v0 = result2 = error == null ? request2.getResultDecoder().apply(resultParser) : null;
        if (result2 == null && error == null) {
            result = HttpClient.Companion.getERROR_INVALID_RESPONSE$ethers_providers();
        } else {
            Object v2 = result2;
            if (v2 != null) {
                result = ResultKt.success(v2);
            } else {
                RpcError rpcError = error;
                Intrinsics.checkNotNull((Object)rpcError);
                result = ResultKt.failure((Result.Error)rpcError);
            }
        }
        Result response = result;
        Logger $this$trc$iv = this.LOG;
        boolean $i$f$trc = false;
        if ($this$trc$iv.isTraceEnabled()) {
            Logger logger = $this$trc$iv;
            boolean bl = false;
            logger.trace("Handled response for request " + id + ": " + response);
        }
        request2.getFuture().complete(response);
    }

    private final <T> void handleSubscriptionResponse(long id, CompletableSubscriptionRequest<T> request2, JsonParser resultParser, RpcError error) {
        if (error != null) {
            request2.getFuture().complete(ResultKt.failure((Result.Error)error));
        } else {
            Subscription<T> subscription = new Subscription<T>(resultParser.getText(), request2.getParams(), request2.getResultDecoder(), new BlockingSubscriptionStream(() -> WsClient.handleSubscriptionResponse$lambda$36(this, id)));
            Long l = id;
            ((Map)this.requestIdToSubscription).put(l, subscription);
            ((Map)this.serverIdToSubscription).put(subscription.getServerId(), subscription);
            request2.getFuture().complete(ResultKt.success(subscription.getStream()));
        }
        Logger $this$trc$iv = this.LOG;
        boolean $i$f$trc = false;
        if ($this$trc$iv.isTraceEnabled()) {
            Logger logger = $this$trc$iv;
            boolean bl = false;
            logger.trace("Handled response for subscription request " + id);
        }
    }

    private final <T> void handleResubscriptionResponse(long id, Subscription<T> subscription, JsonParser resultParser, RpcError error) {
        if (error != null) {
            throw new Exception("Error re-subscribing to stream: " + subscription.getServerId() + ", error: " + error);
        }
        this.serverIdToSubscription.remove(subscription.getServerId());
        subscription.setServerId(resultParser.getText());
        ((Map)this.serverIdToSubscription).put(subscription.getServerId(), subscription);
        Logger $this$trc$iv = this.LOG;
        boolean $i$f$trc = false;
        if ($this$trc$iv.isTraceEnabled()) {
            Logger logger = $this$trc$iv;
            boolean bl = false;
            logger.trace("Handled response for re-subscription request " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleNotification(JsonParser paramsParser) {
        Object object;
        String subscriptionId = null;
        TokenBuffer resultBuff = null;
        JsonParser $this$forEachObjectField$iv = paramsParser;
        boolean $i$f$forEachObjectField = false;
        while (!JsonParserExtensionsKt.isNextTokenObjectEnd((JsonParser)$this$forEachObjectField$iv)) {
            String field$iv = $this$forEachObjectField$iv.getCurrentName();
            $this$forEachObjectField$iv.nextToken();
            String field = field$iv;
            boolean bl = false;
            object = field;
            if (Intrinsics.areEqual((Object)object, (Object)"subscription")) {
                subscriptionId = paramsParser.getText();
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)"result")) {
                if (subscriptionId != null) {
                    Subscription<?> subscription = this.serverIdToSubscription.get(subscriptionId);
                    if (subscription == null) {
                        return;
                    }
                    Subscription<?> subscription2 = subscription;
                    subscription2.handleNotification(paramsParser);
                    return;
                }
                resultBuff = new TokenBuffer(paramsParser);
                resultBuff.copyCurrentStructure(paramsParser);
                continue;
            }
            throw new Exception("Invalid notification: " + paramsParser);
        }
        Subscription<?> subscription = this.serverIdToSubscription.get(subscriptionId);
        if (subscription == null) {
            return;
        }
        Subscription<?> subscription3 = subscription;
        TokenBuffer tokenBuffer = resultBuff;
        Intrinsics.checkNotNull(tokenBuffer);
        Closeable closeable = (Closeable)tokenBuffer;
        Throwable throwable = null;
        try {
            TokenBuffer buff = (TokenBuffer)closeable;
            boolean bl = false;
            object = (Closeable)buff.asParser();
            Throwable throwable2 = null;
            try {
                JsonParser it = (JsonParser)object;
                boolean bl2 = false;
                it.nextToken();
                subscription3.handleNotification(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        Logger $this$inf$iv = this.LOG;
        boolean $i$f$inf = false;
        if ($this$inf$iv.isInfoEnabled()) {
            Logger logger = $this$inf$iv;
            boolean bl = false;
            logger.info("Requesting to close WebSocket");
        }
        this.stopping = true;
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public CompletableFuture<Boolean> requestBatch(@NotNull BatchRpcRequest batch) {
        CompletableBatchRequest request2 = new CompletableBatchRequest(batch, new CompletableFuture<Boolean>());
        this.batchRequestQueue.add(request2);
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return request2.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> CompletableFuture<Result<T, RpcError>> request(@NotNull String method, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder) {
        CompletableRequest<T> request2 = new CompletableRequest<T>(method, params, resultDecoder, new CompletableFuture());
        this.requestQueue.add(request2);
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return request2.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T> CompletableFuture<Result<SubscriptionStream<T>, RpcError>> subscribe(@NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder) {
        CompletableSubscriptionRequest<T> request2 = new CompletableSubscriptionRequest<T>(params, resultDecoder, new CompletableFuture());
        this.subscriptionQueue.add(request2);
        Lock lock = this.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            this.newEventCondition.signalAll();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return request2.getFuture();
    }

    @JvmOverloads
    public WsClient(@NotNull String url, @NotNull OkHttpClient client) {
        this(url, client, null, 4, null);
    }

    @JvmOverloads
    public WsClient(@NotNull String url) {
        this(url, null, null, 6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda$23(WsClient this$0, OkHttpClient $client, Request $wsRequest, wsListener.1 $wsListener) {
        Logger logger;
        Logger $this$inf$iv = this$0.LOG;
        boolean $i$f$inf = false;
        if ($this$inf$iv.isInfoEnabled()) {
            logger = $this$inf$iv;
            boolean bl = false;
            logger.info("Starting WebSocket processor thread and connecting to websocket");
        }
        WebSocket websocket = $client.newWebSocket($wsRequest, (WebSocketListener)$wsListener);
        Lock lock = this$0.eventLock;
        lock.lock();
        try {
            boolean bl = false;
            bl = this$0.connectionOpenedCondition.await($client.connectTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        finally {
            lock.unlock();
        }
        long requestId = 0L;
        String msg = null;
        Object request2 = null;
        Object batchRequest = null;
        Object subscriptionRequest = null;
        BufferRecycler bufferRecycler = new BufferRecycler();
        long lastTimeoutCheck = Stopwatch.Companion.start-ouJUFgk();
        while (!this$0.stopping) {
            try {
                Object id3;
                Object it;
                while (true) {
                    String string = this$0.messageQueue.poll();
                    it = string;
                    boolean bl = false;
                    msg = it;
                    if (string == null) break;
                    Logger $this$trc$iv = this$0.LOG;
                    boolean $i$f$trc = false;
                    if ($this$trc$iv.isTraceEnabled()) {
                        logger = $this$trc$iv;
                        boolean bl2 = false;
                        String string2 = msg;
                        logger.trace("Processing message: " + (string2 != null ? StringsKt.removeSuffix((String)string2, (CharSequence)System.lineSeparator()) : null));
                    }
                    String string3 = msg;
                    Intrinsics.checkNotNull((Object)string3);
                    this$0.handleMessage(string3);
                }
                if (this$0.reconnect) {
                    boolean $i$f$dbg;
                    Iterator iter;
                    boolean reconnectSuccessful = false;
                    while (!reconnectSuccessful && !this$0.stopping) {
                        boolean bl;
                        Object $this$dbg$iv = this$0.LOG;
                        boolean $i$f$dbg2 = false;
                        if ($this$dbg$iv.isDebugEnabled()) {
                            logger = $this$dbg$iv;
                            boolean bl3 = false;
                            logger.debug("Trying to reconnect WebSocket");
                        }
                        if (websocket.close(1000, "Close")) {
                            $this$dbg$iv = this$0.eventLock;
                            $this$dbg$iv.lock();
                            try {
                                boolean $i$a$-withLock-WsClient$1$82 = false;
                                this$0.connectionClosedCondition.await();
                                Unit $i$a$-withLock-WsClient$1$82 = Unit.INSTANCE;
                            }
                            finally {
                                $this$dbg$iv.unlock();
                            }
                        }
                        this$0.reconnect = false;
                        websocket = $client.newWebSocket($wsRequest, (WebSocketListener)$wsListener);
                        $this$dbg$iv = this$0.eventLock;
                        $this$dbg$iv.lock();
                        try {
                            bl = false;
                            bl = this$0.connectionOpenedCondition.await(5L, TimeUnit.SECONDS);
                        }
                        finally {
                            $this$dbg$iv.unlock();
                        }
                        reconnectSuccessful = bl;
                    }
                    if (this$0.stopping) break;
                    if (!((Map)this$0.inFlightRequests).isEmpty()) {
                        iter = ((Map)this$0.inFlightRequests).entrySet().iterator();
                        while (iter.hasNext()) {
                            CompletableRequest value = (CompletableRequest)iter.next().getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            $i$f$dbg = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Re-queued in-flight request: " + value);
                            }
                            this$0.requestQueue.add(value);
                            iter.remove();
                        }
                    }
                    if (!((Map)this$0.inFlightBatchRequests).isEmpty()) {
                        iter = ((Map)this$0.inFlightBatchRequests).entrySet().iterator();
                        while (iter.hasNext()) {
                            CompletableBatchRequest value = (CompletableBatchRequest)iter.next().getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            $i$f$dbg = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Re-queued in-flight batch request: " + value);
                            }
                            this$0.batchRequestQueue.add(value);
                            iter.remove();
                        }
                    }
                    if (!((Map)this$0.inFlightSubscriptionRequests).isEmpty()) {
                        iter = ((Map)this$0.inFlightSubscriptionRequests).entrySet().iterator();
                        while (iter.hasNext()) {
                            CompletableSubscriptionRequest value = (CompletableSubscriptionRequest)iter.next().getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            $i$f$dbg = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Re-queued in-flight subscription request: " + value);
                            }
                            this$0.subscriptionQueue.add(value);
                            iter.remove();
                        }
                    }
                    if (!((Map)this$0.requestIdToSubscription).isEmpty()) {
                        for (Map.Entry value : ((Map)this$0.requestIdToSubscription).entrySet()) {
                            long id2 = ((Number)value.getKey()).longValue();
                            Subscription sub = (Subscription)value.getValue();
                            Logger $this$dbg$iv = this$0.LOG;
                            boolean $i$f$dbg3 = false;
                            if ($this$dbg$iv.isDebugEnabled()) {
                                logger = $this$dbg$iv;
                                boolean bl = false;
                                logger.debug("Resent stream re-subscription: " + id2);
                            }
                            SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                            Closeable closeable = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                            Throwable bl = null;
                            try {
                                JsonGenerator gen = (JsonGenerator)closeable;
                                boolean bl4 = false;
                                JsonRpcClientKt.writeJsonRpcRequest(gen, "eth_subscribe", id2, sub.getParams());
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                bl = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)bl);
                            }
                            websocket.send(writer.getAndClear());
                        }
                    }
                }
                while (true) {
                    CompletableRequest<?> reconnectSuccessful = this$0.requestQueue.poll();
                    it = reconnectSuccessful;
                    boolean $i$a$-also-WsClient$1$142 = false;
                    request2 = it;
                    if (reconnectSuccessful == null) break;
                    long $i$a$-also-WsClient$1$142 = requestId;
                    requestId = $i$a$-also-WsClient$1$142 + 1L;
                    long id3 = $i$a$-also-WsClient$1$142;
                    SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                    Closeable id2 = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                    Throwable $i$f$dbg = null;
                    try {
                        JsonGenerator gen = (JsonGenerator)id2;
                        boolean bl = false;
                        Object object = request2;
                        Intrinsics.checkNotNull((Object)object);
                        JsonRpcClientKt.writeJsonRpcRequest(gen, ((CompletableRequest)object).getMethod(), id3, ((CompletableRequest)request2).getParams());
                        gen = Unit.INSTANCE;
                    }
                    catch (Throwable gen) {
                        $i$f$dbg = gen;
                        throw gen;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)id2, (Throwable)$i$f$dbg);
                    }
                    String req = writer.getAndClear();
                    Logger $this$trc$iv = this$0.LOG;
                    boolean $i$f$trc22 = false;
                    if ($this$trc$iv.isTraceEnabled()) {
                        logger = $this$trc$iv;
                        boolean bl = false;
                        logger.trace("Processing request: " + req);
                    }
                    Long $i$f$trc22 = id3;
                    ((Map)this$0.inFlightRequests).put($i$f$trc22, request2);
                    websocket.send(req);
                }
                while (true) {
                    it = id3 = this$0.batchRequestQueue.poll();
                    boolean $i$a$-also-WsClient$1$172 = false;
                    batchRequest = it;
                    if (id3 == null) break;
                    long batchId = 0L;
                    batchId = -1L;
                    SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                    Closeable $i$a$-also-WsClient$1$172 = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                    Throwable req = null;
                    try {
                        JsonGenerator gen = (JsonGenerator)$i$a$-also-WsClient$1$172;
                        boolean bl = false;
                        gen.writeStartArray();
                        Object object = batchRequest;
                        Intrinsics.checkNotNull((Object)object);
                        int n = ((CompletableBatchRequest)object).getRequest().getRequests$ethers_providers().size();
                        for (int i = 0; i < n; ++i) {
                            RpcCall<?> req2 = ((CompletableBatchRequest)batchRequest).getRequest().getRequests$ethers_providers().get(i);
                            long l = requestId;
                            requestId = l + 1L;
                            long id4 = l;
                            if (batchId == -1L) {
                                batchId = id4;
                            }
                            JsonRpcClientKt.writeJsonRpcRequest(gen, req2.getMethod(), id4, req2.getParams());
                        }
                        gen.writeEndArray();
                        gen = Unit.INSTANCE;
                    }
                    catch (Throwable gen) {
                        req = gen;
                        throw gen;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$i$a$-also-WsClient$1$172, (Throwable)req);
                    }
                    String req3 = writer.getAndClear();
                    Logger $this$trc$iv = this$0.LOG;
                    boolean $i$f$trc = false;
                    if ($this$trc$iv.isTraceEnabled()) {
                        logger = $this$trc$iv;
                        boolean bl = false;
                        logger.trace("Processing batch request: " + req3);
                    }
                    ((Map)this$0.inFlightBatchRequests).put(batchId, batchRequest);
                    websocket.send(req3);
                }
                while (true) {
                    id3 = this$0.subscriptionQueue.poll();
                    it = (CompletableSubscriptionRequest)id3;
                    boolean $i$a$-also-WsClient$1$202 = false;
                    subscriptionRequest = it;
                    if (id3 == null) break;
                    long $i$a$-also-WsClient$1$202 = requestId;
                    requestId = $i$a$-also-WsClient$1$202 + 1L;
                    long id2 = $i$a$-also-WsClient$1$202;
                    SegmentedStringWriter writer = new SegmentedStringWriter(bufferRecycler);
                    Closeable $this$trc$iv = (Closeable)Jackson.MAPPER.createGenerator((Writer)writer);
                    Throwable $i$f$trc = null;
                    try {
                        JsonGenerator gen = (JsonGenerator)$this$trc$iv;
                        boolean bl = false;
                        Object object = subscriptionRequest;
                        Intrinsics.checkNotNull((Object)object);
                        JsonRpcClientKt.writeJsonRpcRequest(gen, "eth_subscribe", id2, ((CompletableSubscriptionRequest)object).getParams());
                        gen = Unit.INSTANCE;
                    }
                    catch (Throwable gen) {
                        $i$f$trc = gen;
                        throw gen;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)$this$trc$iv, (Throwable)$i$f$trc);
                    }
                    String req = writer.getAndClear();
                    Logger $this$trc$iv2 = this$0.LOG;
                    boolean $i$f$trc2 = false;
                    if ($this$trc$iv2.isTraceEnabled()) {
                        logger = $this$trc$iv2;
                        boolean bl = false;
                        logger.trace("Processing subscription request: " + req);
                    }
                    Long l = id2;
                    ((Map)this$0.inFlightSubscriptionRequests).put(l, subscriptionRequest);
                    websocket.send(req);
                }
                if (Stopwatch.hasElapsed-impl(lastTimeoutCheck, 1000L, TimeUnit.MILLISECONDS)) {
                    this$0.removeTimedOutRequests((Map)this$0.inFlightRequests, $client.readTimeoutMillis());
                    this$0.removeTimedOutRequests((Map)this$0.inFlightBatchRequests, $client.readTimeoutMillis());
                    this$0.removeTimedOutRequests((Map)this$0.inFlightSubscriptionRequests, $client.readTimeoutMillis());
                    lastTimeoutCheck = Stopwatch.Companion.start-ouJUFgk();
                }
                id3 = this$0.eventLock;
                id3.lock();
                try {
                    boolean $i$a$-withLock-WsClient$1$232 = false;
                    if (this$0.messageQueue.isEmpty() && this$0.requestQueue.isEmpty() && this$0.batchRequestQueue.isEmpty() && this$0.subscriptionQueue.isEmpty()) {
                        this$0.newEventCondition.await(1L, TimeUnit.SECONDS);
                    }
                    Unit $i$a$-withLock-WsClient$1$232 = Unit.INSTANCE;
                }
                finally {
                    id3.unlock();
                }
            }
            catch (Exception e) {
                Logger $this$err$iv = this$0.LOG;
                boolean $i$f$err = false;
                if ($this$err$iv.isErrorEnabled()) {
                    logger = $this$err$iv;
                    boolean bl = false;
                    logger.error("Exception when processing events, reconnecting WebSocket", (Throwable)e);
                }
                this$0.reconnect = true;
            }
        }
        websocket.close(1000, "Close");
    }

    private static final void handleSubscriptionResponse$lambda$36(WsClient this$0, long $id) {
        Subscription<?> sub = this$0.requestIdToSubscription.remove($id);
        if (sub != null) {
            Logger $this$trc$iv = this$0.LOG;
            boolean $i$f$trc = false;
            if ($this$trc$iv.isTraceEnabled()) {
                Logger logger = $this$trc$iv;
                boolean bl = false;
                logger.trace("Unsubscribing from stream: " + sub.getServerId());
            }
            this$0.serverIdToSubscription.remove(sub.getServerId());
            Object[] objectArray = new String[]{sub.getServerId()};
            this$0.request("eth_unsubscribe", objectArray, Boolean.TYPE);
        }
    }

    public static final /* synthetic */ Logger access$getLOG$p(WsClient $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ ReentrantLock access$getEventLock$p(WsClient $this) {
        return $this.eventLock;
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getMessageQueue$p(WsClient $this) {
        return $this.messageQueue;
    }

    public static final /* synthetic */ Condition access$getConnectionOpenedCondition$p(WsClient $this) {
        return $this.connectionOpenedCondition;
    }

    public static final /* synthetic */ Condition access$getNewEventCondition$p(WsClient $this) {
        return $this.newEventCondition;
    }

    public static final /* synthetic */ Condition access$getConnectionClosedCondition$p(WsClient $this) {
        return $this.connectionClosedCondition;
    }

    public static final /* synthetic */ void access$setReconnect$p(WsClient $this, boolean bl) {
        $this.reconnect = bl;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lio/ethers/providers/WsClient$CompletableBatchRequest;", "Lio/ethers/providers/WsClient$ExpiringRequest;", "request", "Lio/ethers/providers/types/BatchRpcRequest;", "future", "Ljava/util/concurrent/CompletableFuture;", "", "(Lio/ethers/providers/types/BatchRpcRequest;Ljava/util/concurrent/CompletableFuture;)V", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "getRequest", "()Lio/ethers/providers/types/BatchRpcRequest;", "component1", "component2", "copy", "equals", "other", "", "expireRequest", "", "hashCode", "", "toString", "", "ethers-providers"})
    private static final class CompletableBatchRequest
    extends ExpiringRequest {
        @NotNull
        private final BatchRpcRequest request;
        @NotNull
        private final CompletableFuture<Boolean> future;

        public CompletableBatchRequest(@NotNull BatchRpcRequest request2, @NotNull CompletableFuture<Boolean> future) {
            this.request = request2;
            this.future = future;
        }

        @NotNull
        public final BatchRpcRequest getRequest() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<Boolean> getFuture() {
            return this.future;
        }

        @Override
        protected void expireRequest() {
            int n = this.request.getResponses$ethers_providers().size();
            for (int i = 0; i < n; ++i) {
                CompletableFuture<Result<?, RpcError>> response = this.request.getResponses$ethers_providers().get(i);
                response.complete(HttpClient.Companion.getERROR_CALL_TIMEOUT$ethers_providers());
            }
            this.future.complete(false);
        }

        @NotNull
        public final BatchRpcRequest component1() {
            return this.request;
        }

        @NotNull
        public final CompletableFuture<Boolean> component2() {
            return this.future;
        }

        @NotNull
        public final CompletableBatchRequest copy(@NotNull BatchRpcRequest request2, @NotNull CompletableFuture<Boolean> future) {
            return new CompletableBatchRequest(request2, future);
        }

        public static /* synthetic */ CompletableBatchRequest copy$default(CompletableBatchRequest completableBatchRequest, BatchRpcRequest batchRpcRequest, CompletableFuture completableFuture, int n, Object object) {
            if ((n & 1) != 0) {
                batchRpcRequest = completableBatchRequest.request;
            }
            if ((n & 2) != 0) {
                completableFuture = completableBatchRequest.future;
            }
            return completableBatchRequest.copy(batchRpcRequest, completableFuture);
        }

        @NotNull
        public String toString() {
            return "CompletableBatchRequest(request=" + this.request + ", future=" + this.future + ")";
        }

        public int hashCode() {
            int result = this.request.hashCode();
            result = result * 31 + this.future.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompletableBatchRequest)) {
                return false;
            }
            CompletableBatchRequest completableBatchRequest = (CompletableBatchRequest)other;
            if (!Intrinsics.areEqual((Object)this.request, (Object)completableBatchRequest.request)) {
                return false;
            }
            return Intrinsics.areEqual(this.future, completableBatchRequest.future);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0014R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lio/ethers/providers/WsClient$CompletableRequest;", "T", "Lio/ethers/providers/WsClient$ExpiringRequest;", "method", "", "params", "", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/RpcError;", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "getMethod", "()Ljava/lang/String;", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "expireRequest", "", "ethers-providers"})
    private static final class CompletableRequest<T>
    extends ExpiringRequest {
        @NotNull
        private final String method;
        @NotNull
        private final Object[] params;
        @NotNull
        private final Function<JsonParser, T> resultDecoder;
        @NotNull
        private final CompletableFuture<Result<T, RpcError>> future;

        public CompletableRequest(@NotNull String method, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder, @NotNull CompletableFuture<Result<T, RpcError>> future) {
            this.method = method;
            this.params = params;
            this.resultDecoder = resultDecoder;
            this.future = future;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        @NotNull
        public final Function<JsonParser, T> getResultDecoder() {
            return this.resultDecoder;
        }

        @NotNull
        public final CompletableFuture<Result<T, RpcError>> getFuture() {
            return this.future;
        }

        @Override
        protected void expireRequest() {
            this.future.complete(HttpClient.Companion.getERROR_CALL_TIMEOUT$ethers_providers());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BE\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0015\u001a\u00020\u0016H\u0014R)\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lio/ethers/providers/WsClient$CompletableSubscriptionRequest;", "T", "Lio/ethers/providers/WsClient$ExpiringRequest;", "params", "", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "future", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/SubscriptionStream;", "Lio/ethers/providers/RpcError;", "([Ljava/lang/Object;Ljava/util/function/Function;Ljava/util/concurrent/CompletableFuture;)V", "getFuture", "()Ljava/util/concurrent/CompletableFuture;", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "expireRequest", "", "ethers-providers"})
    private static final class CompletableSubscriptionRequest<T>
    extends ExpiringRequest {
        @NotNull
        private final Object[] params;
        @NotNull
        private final Function<JsonParser, T> resultDecoder;
        @NotNull
        private final CompletableFuture<Result<SubscriptionStream<T>, RpcError>> future;

        public CompletableSubscriptionRequest(@NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder, @NotNull CompletableFuture<Result<SubscriptionStream<T>, RpcError>> future) {
            this.params = params;
            this.resultDecoder = resultDecoder;
            this.future = future;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        @NotNull
        public final Function<JsonParser, T> getResultDecoder() {
            return this.resultDecoder;
        }

        @NotNull
        public final CompletableFuture<Result<SubscriptionStream<T>, RpcError>> getFuture() {
            return this.future;
        }

        @Override
        protected void expireRequest() {
            this.future.complete(HttpClient.Companion.getERROR_CALL_TIMEOUT$ethers_providers());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lio/ethers/providers/WsClient$DefaultThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "()V", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "ethers-providers"})
    private static final class DefaultThreadFactory
    implements ThreadFactory {
        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("WsClient-Processor-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\rH$R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u000e"}, d2={"Lio/ethers/providers/WsClient$ExpiringRequest;", "", "()V", "initiated", "Lio/ethers/providers/Stopwatch;", "J", "expireIfTimedOut", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "expireRequest", "", "ethers-providers"})
    private static abstract class ExpiringRequest {
        private final long initiated = Stopwatch.Companion.start-ouJUFgk();

        public final boolean expireIfTimedOut(long timeout, @NotNull TimeUnit unit) {
            if (Stopwatch.hasElapsed-impl(this.initiated, timeout, unit)) {
                this.expireRequest();
                return true;
            }
            return false;
        }

        protected abstract void expireRequest();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tR\u0017\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lio/ethers/providers/WsClient$Subscription;", "T", "", "serverId", "", "params", "", "resultDecoder", "Ljava/util/function/Function;", "Lcom/fasterxml/jackson/core/JsonParser;", "stream", "Lio/ethers/providers/BlockingSubscriptionStream;", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/util/function/Function;Lio/ethers/providers/BlockingSubscriptionStream;)V", "getParams", "()[Ljava/lang/Object;", "[Ljava/lang/Object;", "getResultDecoder", "()Ljava/util/function/Function;", "getServerId", "()Ljava/lang/String;", "setServerId", "(Ljava/lang/String;)V", "getStream", "()Lio/ethers/providers/BlockingSubscriptionStream;", "handleNotification", "", "event", "ethers-providers"})
    private static final class Subscription<T> {
        @NotNull
        private String serverId;
        @NotNull
        private final Object[] params;
        @NotNull
        private final Function<JsonParser, T> resultDecoder;
        @NotNull
        private final BlockingSubscriptionStream<T> stream;

        public Subscription(@NotNull String serverId, @NotNull Object[] params, @NotNull Function<JsonParser, T> resultDecoder, @NotNull BlockingSubscriptionStream<T> stream) {
            this.serverId = serverId;
            this.params = params;
            this.resultDecoder = resultDecoder;
            this.stream = stream;
        }

        @NotNull
        public final String getServerId() {
            return this.serverId;
        }

        public final void setServerId(@NotNull String string) {
            this.serverId = string;
        }

        @NotNull
        public final Object[] getParams() {
            return this.params;
        }

        @NotNull
        public final Function<JsonParser, T> getResultDecoder() {
            return this.resultDecoder;
        }

        @NotNull
        public final BlockingSubscriptionStream<T> getStream() {
            return this.stream;
        }

        public final void handleNotification(@NotNull JsonParser event) {
            this.stream.pushEvent(this.resultDecoder.apply(event));
        }
    }
}

