/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto.bip32;

import io.ethers.crypto.Hashing;
import io.ethers.crypto.Secp256k1;
import io.ethers.crypto.bip32.HDPath;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR#\u0010\u000e\u001a\n \u000f*\u0004\u0018\u00010\u00030\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\r\u001a\u0004\b\u0010\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lio/ethers/crypto/bip32/ExtendedSigningKey;", "", "privateKey", "", "chainCode", "([B[B)V", "getChainCode", "()[B", "fingerprint", "", "getFingerprint", "()I", "fingerprint$delegate", "Lkotlin/Lazy;", "pubCompressed", "kotlin.jvm.PlatformType", "getPubCompressed", "pubCompressed$delegate", "signingKey", "Lio/ethers/crypto/Secp256k1$SigningKey;", "getSigningKey", "()Lio/ethers/crypto/Secp256k1$SigningKey;", "deriveChild", "index", "derivePath", "path", "Lio/ethers/crypto/bip32/HDPath;", "Companion", "ethers-crypto"})
public final class ExtendedSigningKey {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] chainCode;
    @NotNull
    private final Secp256k1.SigningKey signingKey;
    @NotNull
    private final Lazy pubCompressed$delegate;
    @NotNull
    private final Lazy fingerprint$delegate;
    @NotNull
    private static final byte[] PREFIX_KEY_BYTES;

    public ExtendedSigningKey(@NotNull byte[] privateKey, @NotNull byte[] chainCode) {
        this.chainCode = chainCode;
        this.signingKey = new Secp256k1.SigningKey(privateKey);
        if (privateKey.length != 32) {
            throw new IllegalArgumentException("Invalid private key length. Should be exactly 32 bytes, got " + privateKey.length);
        }
        if (this.chainCode.length != 32) {
            throw new IllegalArgumentException("Invalid chain code length. Should be exactly 32 bytes, got " + this.chainCode.length);
        }
        this.pubCompressed$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<byte[]>(this){
            final /* synthetic */ ExtendedSigningKey this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final byte[] invoke() {
                return this.this$0.getSigningKey().getPublicPoint().getEncoded(true);
            }
        }));
        this.fingerprint$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ ExtendedSigningKey this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                byte[] id = Hashing.INSTANCE.sha256ripe160(ExtendedSigningKey.access$getPubCompressed(this.this$0));
                return id[3] & 0xFF | (id[2] & 0xFF) << 8 | (id[1] & 0xFF) << 16 | (id[0] & 0xFF) << 24;
            }
        }));
    }

    @NotNull
    public final byte[] getChainCode() {
        return this.chainCode;
    }

    @NotNull
    public final Secp256k1.SigningKey getSigningKey() {
        return this.signingKey;
    }

    private final byte[] getPubCompressed() {
        Lazy lazy = this.pubCompressed$delegate;
        return (byte[])lazy.getValue();
    }

    public final int getFingerprint() {
        Lazy lazy = this.fingerprint$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @NotNull
    public final ExtendedSigningKey derivePath(@NotNull HDPath path) {
        ExtendedSigningKey key = this;
        int n = path.getDepth();
        for (int depth = 0; depth < n; ++depth) {
            key = key.deriveChild(path.indexAtDepth(depth));
        }
        return key;
    }

    @NotNull
    public final ExtendedSigningKey deriveChild(int index) {
        byte[] hmac;
        ByteBuffer buff = ByteBuffer.allocate(37);
        if (HDPath.Companion.isHardened(index)) {
            buff.position(1);
            buff.put(this.signingKey.getPrivateKey());
        } else {
            buff.put(this.getPubCompressed());
        }
        buff.putInt(index);
        byte[] byArray = hmac = Hashing.hmacSha512(this.chainCode, buff.array());
        int n = 0;
        int n2 = 32;
        byte[] privateKeyNew = Secp256k1.INSTANCE.privateKeyAdd(this.signingKey.getPrivateKey(), ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        byte[] byArray2 = hmac;
        n2 = 32;
        int n3 = 64;
        byte[] chainCodeNew = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
        return new ExtendedSigningKey(privateKeyNew, chainCodeNew);
    }

    @JvmStatic
    @NotNull
    public static final ExtendedSigningKey fromSeed(@NotNull byte[] seed) {
        return Companion.fromSeed(seed);
    }

    public static final /* synthetic */ byte[] access$getPubCompressed(ExtendedSigningKey $this) {
        return $this.getPubCompressed();
    }

    static {
        byte[] byArray = "Bitcoin seed".getBytes(StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        PREFIX_KEY_BYTES = byArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/ethers/crypto/bip32/ExtendedSigningKey$Companion;", "", "()V", "PREFIX_KEY_BYTES", "", "fromSeed", "Lio/ethers/crypto/bip32/ExtendedSigningKey;", "seed", "ethers-crypto"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExtendedSigningKey fromSeed(@NotNull byte[] seed) {
            byte[] hmac;
            byte[] byArray = hmac = Hashing.hmacSha512(PREFIX_KEY_BYTES, seed);
            int n = 0;
            int n2 = 32;
            byte[] byArray2 = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byArray = hmac;
            n = 32;
            n2 = 64;
            return new ExtendedSigningKey(byArray2, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

