/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abigen.plugin;

import io.ethers.abigen.plugin.source.AbiSourceProvider;
import io.ethers.abigen.plugin.source.DirectorySourceProvider;
import io.ethers.abigen.reader.JsonAbiReader;
import io.ethers.abigen.reader.JsonAbiReaderRegistry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J$\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\n2\u0012\b\u0002\u0010\u001c\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u001e\u0018\u00010\u001dH\u0007R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001f"}, d2={"Lio/ethers/abigen/plugin/EthersAbigenExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "factory", "Lorg/gradle/api/model/ObjectFactory;", "kotlin.jvm.PlatformType", "functionRenames", "Lorg/gradle/api/provider/MapProperty;", "", "getFunctionRenames", "()Lorg/gradle/api/provider/MapProperty;", "outputDir", "Lorg/gradle/api/provider/Property;", "getOutputDir", "()Lorg/gradle/api/provider/Property;", "sourceProviders", "Lorg/gradle/api/provider/ListProperty;", "Lio/ethers/abigen/plugin/source/AbiSourceProvider;", "getSourceProviders", "()Lorg/gradle/api/provider/ListProperty;", "abiReader", "", "reader", "Lio/ethers/abigen/reader/JsonAbiReader;", "directorySource", "path", "action", "Lorg/gradle/api/Action;", "Lio/ethers/abigen/plugin/source/DirectorySourceProvider;", "ethers-abigen-plugin"})
public abstract class EthersAbigenExtension {
    @NotNull
    private final Project project;
    private final ObjectFactory factory;
    @NotNull
    private final Property<String> outputDir;
    @NotNull
    private final ListProperty<AbiSourceProvider> sourceProviders;
    @NotNull
    private final MapProperty<String, String> functionRenames;

    public EthersAbigenExtension(@NotNull Project project) {
        this.project = project;
        this.factory = this.project.getObjects();
        this.outputDir = this.factory.property(String.class).convention((Object)"generated/source/ethers/main/kotlin");
        this.sourceProviders = this.factory.listProperty(AbiSourceProvider.class).convention((Iterable)CollectionsKt.listOf((Object)new DirectorySourceProvider(this.project, "src/main/abi")));
        this.functionRenames = this.project.getObjects().mapProperty(String.class, String.class).convention(MapsKt.emptyMap());
    }

    @NotNull
    public final Property<String> getOutputDir() {
        return this.outputDir;
    }

    @NotNull
    public final ListProperty<AbiSourceProvider> getSourceProviders() {
        return this.sourceProviders;
    }

    @NotNull
    public final MapProperty<String, String> getFunctionRenames() {
        return this.functionRenames;
    }

    public final void abiReader(@NotNull JsonAbiReader reader) {
        JsonAbiReaderRegistry.INSTANCE.appendReader(reader);
    }

    @JvmOverloads
    public final void directorySource(@NotNull String path, @Nullable Action<? super DirectorySourceProvider> action) {
        DirectorySourceProvider source = new DirectorySourceProvider(this.project, path);
        Action<? super DirectorySourceProvider> action2 = action;
        if (action2 != null) {
            action2.execute((Object)source);
        }
        this.sourceProviders.add((Object)source);
    }

    public static /* synthetic */ void directorySource$default(EthersAbigenExtension ethersAbigenExtension, String string, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: directorySource");
        }
        if ((n & 2) != 0) {
            action = null;
        }
        ethersAbigenExtension.directorySource(string, (Action<? super DirectorySourceProvider>)action);
    }

    @JvmOverloads
    public final void directorySource(@NotNull String path) {
        EthersAbigenExtension.directorySource$default(this, path, null, 2, null);
    }
}

