/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.AbiContract;
import io.ethers.abi.call.CallDeploy;
import io.ethers.abi.call.PendingContractDeploy;
import io.ethers.abi.error.ContractError;
import io.ethers.abi.error.DeployError;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.CallRequest;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.PendingTransaction;
import java.util.function.BiFunction;
import kotlin.Metadata;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001aB\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\n0\u0010H\u0002\u00a8\u0006\u0012"}, d2={"handleCallResult", "Lio/ethers/core/Result;", "Lio/ethers/abi/call/CallDeploy;", "Lio/ethers/abi/error/ContractError;", "call", "Lio/ethers/core/types/CallRequest;", "result", "Lio/ethers/core/types/Bytes;", "handleSendResult", "Lio/ethers/abi/call/PendingContractDeploy;", "T", "Lio/ethers/abi/AbiContract;", "provider", "Lio/ethers/providers/middleware/Middleware;", "Lio/ethers/providers/types/PendingTransaction;", "constructor", "Ljava/util/function/BiFunction;", "Lio/ethers/core/types/Address;", "ethers-abi"})
public final class ConstructorCallKt {
    private static final Result<CallDeploy, ContractError> handleCallResult(CallRequest call2, Bytes result) {
        if (result.getSize() == 0) {
            return ResultKt.failure((Result.Error)DeployError.NoBytecode.INSTANCE);
        }
        long nonce = call2.getNonce() == -1L ? 0L : call2.getNonce();
        Address address = call2.getFrom();
        if (address == null) {
            address = Address.ZERO;
        }
        Address deployAddress = Address.Companion.computeCreate(address, nonce);
        return ResultKt.success((Object)new CallDeploy(deployAddress, result));
    }

    private static final <T extends AbiContract> PendingContractDeploy<T> handleSendResult(Middleware provider, PendingTransaction result, BiFunction<Middleware, Address, T> constructor) {
        return new PendingContractDeploy<T>(provider, result, constructor);
    }

    public static final /* synthetic */ Result access$handleCallResult(CallRequest call2, Bytes result) {
        return ConstructorCallKt.handleCallResult(call2, result);
    }

    public static final /* synthetic */ PendingContractDeploy access$handleSendResult(Middleware provider, PendingTransaction result, BiFunction constructor) {
        return ConstructorCallKt.handleSendResult(provider, result, constructor);
    }
}

