/*
 * Decompiled with CFR 0.152.
 */
package com.ypz.bangscreentools;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Rect;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.Window;
import android.view.WindowManager;
import com.ypz.bangscreentools.BangScreenSupport;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class HuaWeiBangScreen
implements BangScreenSupport {
    private Class hwBangSizeUtil;
    private boolean isHaveResult;
    private boolean isBangScreen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresApi(api=26)
    public boolean hasNotBangScreen(Window window) {
        if (this.isHaveResult) {
            return this.isBangScreen;
        }
        try {
            ClassLoader huaWeiClassLoader = window.getContext().getClassLoader();
            Class<?> HwNotchSizeUtil = huaWeiClassLoader.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method method = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
            this.isHaveResult = true;
            boolean bl = this.isBangScreen = ((Boolean)method.invoke(HwNotchSizeUtil, new Object[0])).booleanValue();
            return bl;
        }
        catch (ClassNotFoundException e) {
            Log.e((String)"BangScreenTools", (String)"hasNotchInScreen ClassNotFoundException");
        }
        catch (NoSuchMethodException e) {
            Log.e((String)"BangScreenTools", (String)"hasNotchInScreen NoSuchMethodException");
        }
        catch (Exception e) {
            Log.e((String)"BangScreenTools", (String)"hasNotchInScreen Exception");
        }
        finally {
            this.isHaveResult = true;
            return this.isBangScreen;
        }
    }

    @Override
    @RequiresApi(api=26)
    public List<Rect> getBangSize(Window window) {
        ArrayList<Rect> result = new ArrayList<Rect>();
        if (window != null) {
            Rect rect = new Rect();
            try {
                Context context = window.getContext();
                if (this.hwBangSizeUtil == null && context != null) {
                    ClassLoader cl = context.getClassLoader();
                    this.hwBangSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
                }
                if (this.hwBangSizeUtil == null) {
                    return result;
                }
                Method get = this.hwBangSizeUtil.getMethod("getNotchSize", new Class[0]);
                int[] ret = (int[])get.invoke((Object)this.hwBangSizeUtil, new Object[0]);
                if (ret == null) {
                    return result;
                }
                Resources resources = context.getResources();
                if (resources != null) {
                    rect.left = (resources.getDisplayMetrics().widthPixels - ret[0]) / 2;
                    rect.bottom = ret[1];
                    rect.right = rect.left + ret[0];
                    rect.top = 0;
                    result.add(rect);
                }
                return result;
            }
            catch (Exception e) {
                Log.e((String)"BangScreenTools", (String)e.getMessage());
                return result;
            }
        }
        return result;
    }

    @Override
    @RequiresApi(api=26)
    public void extendStatusCutout(Window window, Context context) {
        if (window != null) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            try {
                Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
                Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
                Object layoutParamsExObj = con.newInstance(layoutParams);
                Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
                method.invoke(layoutParamsExObj, 65536);
            }
            catch (Exception e) {
                Log.e((String)"BangScreenTools", (String)("exception:" + e.getMessage()));
            }
        }
    }

    @Override
    @RequiresApi(api=26)
    public void setWindowLayoutBlockNotch(Window window) {
        if (window != null) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            try {
                Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
                Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
                Object layoutParamsExObj = con.newInstance(layoutParams);
                Method method = layoutParamsExCls.getMethod("clearHwFlags", Integer.TYPE);
                method.invoke(layoutParamsExObj, 65536);
            }
            catch (Exception e) {
                Log.e((String)"BangScreenTools", (String)e.getMessage());
            }
        }
    }

    @Override
    public void transparentStatusCutout(Window window, Context context) {
        if (window != null) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            try {
                Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
                Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
                Object layoutParamsExObj = con.newInstance(layoutParams);
                Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
                method.invoke(layoutParamsExObj, 65536);
            }
            catch (Exception e) {
                Log.e((String)"BangScreenTools", (String)("exception:" + e.getMessage()));
            }
        }
    }

    @Override
    public void fullscreen(Window window, Context context) {
        if (window != null) {
            WindowManager.LayoutParams layoutParams = window.getAttributes();
            try {
                Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
                Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
                Object layoutParamsExObj = con.newInstance(layoutParams);
                Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
                method.invoke(layoutParamsExObj, 65536);
            }
            catch (Exception e) {
                Log.e((String)"BangScreenTools", (String)("exception:" + e.getMessage()));
            }
        }
    }
}

