/*
 * Decompiled with CFR 0.152.
 */
package com.kennyc.bottomsheet;

import android.app.Dialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.DrawableRes;
import android.support.annotation.IntegerRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.MenuRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.kennyc.bottomsheet.BottomSheetListener;
import com.kennyc.bottomsheet.CollapsingView;
import com.kennyc.bottomsheet.R;
import com.kennyc.bottomsheet.adapters.AppAdapter;
import com.kennyc.bottomsheet.adapters.GridAdapter;
import com.kennyc.bottomsheet.menu.BottomSheetMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class BottomSheet
extends Dialog
implements AdapterView.OnItemClickListener,
CollapsingView.CollapseListener {
    private static final int MIN_LIST_TABLET_ITEMS = 6;
    private static final int GRID_MIN_COLUMNS = 3;
    private static final int GRID_MAX_COLUMN = 4;
    private static final String TAG = BottomSheet.class.getSimpleName();
    private static final int[] ATTRS = new int[]{R.attr.bottom_sheet_bg_color, R.attr.bottom_sheet_title_text_appearance, R.attr.bottom_sheet_list_text_appearance, R.attr.bottom_sheet_grid_text_appearance, R.attr.bottom_sheet_message_text_appearance, R.attr.bottom_sheet_message_title_text_appearance, R.attr.bottom_sheet_button_text_appearance, R.attr.bottom_sheet_item_icon_color, R.attr.bottom_sheet_grid_spacing, R.attr.bottom_sheet_grid_top_padding, R.attr.bottom_sheet_grid_bottom_padding, R.attr.bottom_sheet_selector, R.attr.bottom_sheet_column_count};
    private Builder mBuilder;
    private BaseAdapter mAdapter;
    private GridView mGrid;
    private BottomSheetListener mListener;
    private int mWhich = Integer.MIN_VALUE;
    private final Runnable dismissRunnable = new Runnable(){

        @Override
        public void run() {
            BottomSheet.this.dismiss();
        }
    };

    private BottomSheet(Context context, Builder builder) {
        super(context, builder.style);
        this.mBuilder = builder;
        this.mListener = builder.listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        boolean isTablet;
        super.onCreate(savedInstanceState);
        if (!this.canCreateSheet()) {
            throw new IllegalStateException("Unable to create BottomSheet, missing params");
        }
        Window window = this.getWindow();
        int width = this.getContext().getResources().getDimensionPixelSize(R.dimen.bottom_sheet_width);
        boolean bl = isTablet = width > 0;
        if (window != null) {
            window.setLayout(width <= 0 ? -1 : width, -2);
            window.setGravity(80);
        } else {
            Log.e((String)TAG, (String)"Window came back as null, unable to set defaults");
        }
        TypedArray ta = this.getContext().obtainStyledAttributes(ATTRS);
        if (this.mBuilder.view != null) {
            this.initViewLayout(ta);
        } else if (!TextUtils.isEmpty((CharSequence)this.mBuilder.message)) {
            this.initMessageLayout(ta);
        } else {
            this.initLayout(ta, isTablet, this.mBuilder.columnCount);
            if (this.mBuilder.menuItems != null) {
                this.initMenu(ta);
            } else {
                this.mAdapter = new AppAdapter(this.getContext(), this.mBuilder.apps, this.mBuilder.isGrid);
                this.mGrid.setAdapter((ListAdapter)this.mAdapter);
            }
        }
        ta.recycle();
        if (this.mListener != null) {
            this.mListener.onSheetShown();
        }
    }

    public void dismiss() {
        if (this.mListener != null) {
            this.mListener.onSheetDismissed(this.mWhich);
        }
        super.dismiss();
    }

    private void initMessageLayout(TypedArray ta) {
        boolean hasTitle;
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bottom_sheet_message_layout, null);
        ((CollapsingView)view).setCollapseListener(this);
        view.findViewById(R.id.container).setBackgroundColor(ta.getColor(0, -1));
        TextView title = (TextView)view.findViewById(R.id.title);
        boolean bl = hasTitle = !TextUtils.isEmpty((CharSequence)this.mBuilder.title) || this.mBuilder.icon != null;
        if (hasTitle) {
            title.setText((CharSequence)this.mBuilder.title);
            title.setVisibility(0);
            title.setCompoundDrawablesWithIntrinsicBounds(this.mBuilder.icon, null, null, null);
            Compat.setTextAppearance(title, ta.getResourceId(5, R.style.BottomSheet_Message_Title_TextAppearance));
        } else {
            title.setVisibility(8);
        }
        TextView message = (TextView)view.findViewById(R.id.message);
        message.setText((CharSequence)this.mBuilder.message);
        Compat.setTextAppearance(message, ta.getResourceId(4, R.style.BottomSheet_Message_TextAppearance));
        if (!TextUtils.isEmpty((CharSequence)this.mBuilder.positiveBtn)) {
            Button positive = (Button)view.findViewById(R.id.positive);
            positive.setText((CharSequence)this.mBuilder.positiveBtn);
            positive.setVisibility(0);
            positive.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BottomSheet.this.mWhich = -1;
                    BottomSheet.this.dismiss();
                }
            });
            Compat.setTextAppearance((TextView)positive, ta.getResourceId(6, R.style.BottomSheet_Button_TextAppearance));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBuilder.negativeBtn)) {
            Button negative = (Button)view.findViewById(R.id.negative);
            negative.setText((CharSequence)this.mBuilder.negativeBtn);
            negative.setVisibility(0);
            negative.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BottomSheet.this.mWhich = -2;
                    BottomSheet.this.dismiss();
                }
            });
            Compat.setTextAppearance((TextView)negative, ta.getResourceId(6, R.style.BottomSheet_Button_TextAppearance));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mBuilder.neutralBtn)) {
            Button neutral = (Button)view.findViewById(R.id.neutral);
            neutral.setText((CharSequence)this.mBuilder.neutralBtn);
            neutral.setVisibility(0);
            neutral.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BottomSheet.this.mWhich = -3;
                    BottomSheet.this.dismiss();
                }
            });
            Compat.setTextAppearance((TextView)neutral, ta.getResourceId(6, R.style.BottomSheet_Button_TextAppearance));
        }
        this.setContentView(view);
    }

    private void initViewLayout(TypedArray ta) {
        CollapsingView collapsingView = new CollapsingView(this.getContext());
        collapsingView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        collapsingView.setCollapseListener(this);
        this.mBuilder.view.setBackgroundColor(ta.getColor(0, -1));
        collapsingView.addView(this.mBuilder.view);
        this.setContentView((View)collapsingView);
    }

    private void initLayout(TypedArray ta, boolean isTablet, int columnCount) {
        boolean hasTitle;
        this.setCancelable(this.mBuilder.cancelable);
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.bottom_sheet_layout, null);
        ((CollapsingView)view).setCollapseListener(this);
        view.findViewById(R.id.container).setBackgroundColor(ta.getColor(0, -1));
        this.mGrid = (GridView)view.findViewById(R.id.grid);
        this.mGrid.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        TextView title = (TextView)view.findViewById(R.id.title);
        boolean bl = hasTitle = !TextUtils.isEmpty((CharSequence)this.mBuilder.title);
        if (hasTitle) {
            title.setText((CharSequence)this.mBuilder.title);
            title.setVisibility(0);
            Compat.setTextAppearance(title, ta.getResourceId(1, R.style.BottomSheet_Title_TextAppearance));
        } else {
            title.setVisibility(8);
        }
        if (this.mBuilder.isGrid) {
            int spacing = ta.getDimensionPixelOffset(8, 0);
            int topPadding = ta.getDimensionPixelOffset(9, 0);
            int bottomPadding = ta.getDimensionPixelOffset(10, 0);
            this.mGrid.setVerticalSpacing(spacing);
            this.mGrid.setPadding(0, topPadding, 0, bottomPadding);
        } else {
            int padding = this.getContext().getResources().getDimensionPixelSize(R.dimen.bottom_sheet_list_padding);
            this.mGrid.setPadding(0, hasTitle ? 0 : padding, 0, padding);
        }
        if (columnCount <= 0 && (columnCount = ta.getInteger(12, -1)) <= 0) {
            columnCount = this.getNumColumns(isTablet);
        }
        this.mGrid.setNumColumns(columnCount);
        int selector = ta.getResourceId(11, R.drawable.bs_list_selector);
        this.mGrid.setSelector(selector);
        this.setContentView(view);
    }

    private int getNumColumns(boolean isTablet) {
        int numItems = this.mBuilder.menuItems != null ? this.mBuilder.menuItems.size() : this.mBuilder.apps.size();
        if (this.mBuilder.isGrid) {
            if ((numItems >= 7 || numItems == 4) && isTablet) {
                return 4;
            }
            return 3;
        }
        if (isTablet) {
            return numItems >= 6 ? 2 : 1;
        }
        return 1;
    }

    private void initMenu(TypedArray ta) {
        int listTextAppearance = ta.getResourceId(2, R.style.BottomSheet_ListItem_TextAppearance);
        int gridTextAppearance = ta.getResourceId(3, R.style.BottomSheet_GridItem_TextAppearance);
        int tintColor = ta.getColor(7, Integer.MIN_VALUE);
        this.mAdapter = new GridAdapter(this.getContext(), this.mBuilder.menuItems, this.mBuilder.isGrid, listTextAppearance, gridTextAppearance, tintColor);
        this.mGrid.setAdapter((ListAdapter)this.mAdapter);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        if (this.mAdapter instanceof GridAdapter) {
            if (this.mListener != null) {
                MenuItem item = ((GridAdapter)this.mAdapter).getItem(position);
                this.mListener.onSheetItemSelected(item);
            }
        } else if (this.mAdapter instanceof AppAdapter) {
            AppAdapter.AppInfo info = ((AppAdapter)this.mAdapter).getItem(position);
            Intent intent = new Intent(this.mBuilder.shareIntent);
            intent.setComponent(new ComponentName(info.packageName, info.name));
            intent.setFlags(0x10000000);
            this.getContext().startActivity(intent);
        }
        this.dismiss();
    }

    private boolean canCreateSheet() {
        return this.mBuilder != null && (this.mBuilder.menuItems != null && !this.mBuilder.menuItems.isEmpty() || this.mBuilder.apps != null && !this.mBuilder.apps.isEmpty() || this.mBuilder.view != null || !TextUtils.isEmpty((CharSequence)this.mBuilder.message));
    }

    @Override
    public void onCollapse() {
        if (this.getWindow() != null && this.getWindow().getDecorView() != null) {
            this.getWindow().getDecorView().post(this.dismissRunnable);
        } else {
            this.dismiss();
        }
    }

    @Nullable
    public static BottomSheet createShareBottomSheet(Context context, Intent intent, String shareTitle, boolean isGrid, @Nullable Set<String> appsFilter) {
        if (context == null || intent == null) {
            return null;
        }
        PackageManager manager = context.getPackageManager();
        List apps = manager.queryIntentActivities(intent, 0);
        if (apps != null && !apps.isEmpty()) {
            ArrayList<AppAdapter.AppInfo> appResources = new ArrayList<AppAdapter.AppInfo>(apps.size());
            boolean shouldCheckPackages = appsFilter != null && !appsFilter.isEmpty();
            for (ResolveInfo resolveInfo : apps) {
                String packageName = resolveInfo.activityInfo.packageName;
                if (shouldCheckPackages && !appsFilter.contains(resolveInfo.activityInfo.packageName)) continue;
                String title = resolveInfo.loadLabel(manager).toString();
                String name = resolveInfo.activityInfo.name;
                Drawable drawable2 = resolveInfo.loadIcon(manager);
                appResources.add(new AppAdapter.AppInfo(title, packageName, name, drawable2));
            }
            Builder b = new Builder(context).setApps(appResources, intent).setTitle(shareTitle);
            if (isGrid) {
                b.grid();
            }
            return b.create();
        }
        return null;
    }

    @Nullable
    public static BottomSheet createShareBottomSheet(Context context, Intent intent, @StringRes int shareTitle, boolean isGrid, @Nullable Set<String> appsFilter) {
        return BottomSheet.createShareBottomSheet(context, intent, context.getString(shareTitle), isGrid, appsFilter);
    }

    @Nullable
    public static BottomSheet createShareBottomSheet(Context context, Intent intent, @StringRes int shareTitle, boolean isGrid) {
        return BottomSheet.createShareBottomSheet(context, intent, context.getString(shareTitle), isGrid, null);
    }

    public static BottomSheet createShareBottomSheet(Context context, Intent intent, String shareTitle, boolean isGrid) {
        return BottomSheet.createShareBottomSheet(context, intent, shareTitle, isGrid, null);
    }

    @Nullable
    public static BottomSheet createShareBottomSheet(Context context, Intent intent, String shareTitle) {
        return BottomSheet.createShareBottomSheet(context, intent, shareTitle, false, null);
    }

    @Nullable
    public static BottomSheet createShareBottomSheet(Context context, Intent intent, @StringRes int shareTitle) {
        return BottomSheet.createShareBottomSheet(context, intent, context.getString(shareTitle), false, null);
    }

    private static class Compat {
        private Compat() {
        }

        public static void setTextAppearance(@NonNull TextView tv, @StyleRes int textAppearance) {
            if (Build.VERSION.SDK_INT >= 23) {
                tv.setTextAppearance(textAppearance);
            } else {
                tv.setTextAppearance(tv.getContext(), textAppearance);
            }
        }
    }

    public static class Builder {
        @StyleRes
        int style = R.style.BottomSheet;
        int columnCount = -1;
        String title = null;
        boolean cancelable = true;
        boolean isGrid = false;
        List<MenuItem> menuItems;
        Context context;
        Resources resources;
        BottomSheetListener listener;
        List<AppAdapter.AppInfo> apps;
        Intent shareIntent;
        @Nullable
        View view;
        @Nullable
        Drawable icon;
        String message;
        String neutralBtn;
        String negativeBtn;
        String positiveBtn;

        public Builder(Context context) {
            this(context, R.style.BottomSheet);
        }

        public Builder(Context context, @StyleRes int style2) {
            this.context = context;
            this.style = style2;
            this.resources = context.getResources();
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            return this.setTitle(this.resources.getString(title));
        }

        public Builder grid() {
            this.isGrid = true;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setListener(BottomSheetListener listener) {
            this.listener = listener;
            return this;
        }

        public Builder dark() {
            this.style = R.style.BottomSheet_Dark;
            return this;
        }

        public Builder setStyle(@StyleRes int style2) {
            this.style = style2;
            return this;
        }

        public Builder setSheet(@MenuRes int sheetItems) {
            BottomSheetMenu menu = new BottomSheetMenu(this.context);
            new MenuInflater(this.context).inflate(sheetItems, (Menu)menu);
            return this.setMenu(menu);
        }

        public Builder setMenu(@Nullable Menu menu) {
            if (menu != null) {
                ArrayList<MenuItem> items = new ArrayList<MenuItem>(menu.size());
                for (int i = 0; i < menu.size(); ++i) {
                    items.add(menu.getItem(i));
                }
                return this.setMenuItems(items);
            }
            return this;
        }

        public Builder setMenuItems(@Nullable List<MenuItem> menuItems) {
            this.menuItems = menuItems;
            return this;
        }

        public Builder addMenuItem(MenuItem item) {
            if (this.menuItems == null) {
                this.menuItems = new ArrayList<MenuItem>();
            }
            this.menuItems.add(item);
            return this;
        }

        public Builder setView(View view) {
            this.view = view;
            return this;
        }

        public Builder setView(@LayoutRes int view) {
            return this.setView(LayoutInflater.from((Context)this.context).inflate(view, null));
        }

        public Builder setIcon(Drawable icon) {
            this.icon = icon;
            return this;
        }

        public Builder setIcon(@DrawableRes int icon, @Nullable Resources.Theme theme) {
            Drawable dr = Build.VERSION.SDK_INT >= 21 ? this.resources.getDrawable(icon, theme) : this.resources.getDrawable(icon);
            return this.setIcon(dr);
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(@StringRes int message) {
            return this.setMessage(this.resources.getString(message));
        }

        public Builder setPositiveButton(String positiveButton) {
            this.positiveBtn = positiveButton;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButton) {
            return this.setPositiveButton(this.resources.getString(positiveButton));
        }

        public Builder setNegativeButton(String negativeButton) {
            this.negativeBtn = negativeButton;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButton) {
            return this.setNegativeButton(this.resources.getString(negativeButton));
        }

        public Builder setNeutralButton(String neutralButton) {
            this.neutralBtn = neutralButton;
            return this;
        }

        public Builder setNeutralButton(@StringRes int neutralButton) {
            return this.setNeutralButton(this.resources.getString(neutralButton));
        }

        public Builder setColumnCount(int columnCount) {
            this.columnCount = columnCount;
            return this;
        }

        public Builder setColumnCountResource(@IntegerRes int columnCount) {
            return this.setColumnCount(this.resources.getInteger(columnCount));
        }

        private Builder setApps(List<AppAdapter.AppInfo> apps, Intent intent) {
            this.apps = apps;
            this.shareIntent = intent;
            return this;
        }

        public BottomSheet create() {
            return new BottomSheet(this.context, this);
        }

        public void show() {
            this.create().show();
        }
    }
}

