/*
 * Decompiled with CFR 0.152.
 */
package com.kircherelectronics.fsensor.sensor.acceleration;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.kircherelectronics.fsensor.filter.gyroscope.fusion.complementary.OrientationFusedComplementary;
import com.kircherelectronics.fsensor.linearacceleration.LinearAcceleration;
import com.kircherelectronics.fsensor.linearacceleration.LinearAccelerationFusion;
import com.kircherelectronics.fsensor.observer.SensorSubject;
import com.kircherelectronics.fsensor.sensor.FSensor;
import com.kircherelectronics.fsensor.util.rotation.RotationUtil;

public class ComplementaryLinearAccelerationSensor
implements FSensor {
    private static final String TAG = ComplementaryLinearAccelerationSensor.class.getSimpleName();
    private final SensorManager sensorManager;
    private final SimpleSensorListener listener;
    private float startTime = 0.0f;
    private int count = 0;
    private float[] magnetic = new float[3];
    private float[] rawAcceleration = new float[3];
    private float[] rotation = new float[3];
    private float[] acceleration = new float[3];
    private float[] output = new float[4];
    private LinearAcceleration linearAccelerationFilterComplimentary;
    private OrientationFusedComplementary orientationFusionComplimentary;
    private int sensorDelay = 0;
    private int sensorType = 4;
    private final SensorSubject sensorSubject;

    public ComplementaryLinearAccelerationSensor(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        this.listener = new SimpleSensorListener();
        this.sensorSubject = new SensorSubject();
        this.initializeFSensorFusions();
    }

    @Override
    public void start() {
        this.startTime = 0.0f;
        this.count = 0;
        this.registerSensors(this.sensorDelay);
    }

    @Override
    public void stop() {
        this.unregisterSensors();
    }

    @Override
    public void register(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.register(sensorObserver);
    }

    @Override
    public void unregister(SensorSubject.SensorObserver sensorObserver) {
        this.sensorSubject.unregister(sensorObserver);
    }

    public void setSensorType(int sensorType) {
        if (sensorType != 4 && sensorType != 16) {
            throw new IllegalStateException("Sensor Type must be Sensor.TYPE_GYROSCOPE or Sensor.TYPE_GYROSCOPE_UNCALIBRATED");
        }
        this.sensorType = sensorType;
    }

    public void setSensorDelay(int sensorDelay) {
        if (sensorDelay != 0 && sensorDelay != 1 && sensorDelay != 3 && sensorDelay != 2) {
            throw new IllegalStateException("Sensor Frequency must be SensorManager.SENSOR_DELAY_FASTEST, SensorManager.SENSOR_DELAY_GAME, SensorManager.SENSOR_DELAY_NORMAL or SensorManager.SENSOR_DELAY_UI");
        }
        this.sensorDelay = sensorDelay;
    }

    public void setFSensorComplimentaryLinearAccelerationTimeConstant(float timeConstant) {
        this.orientationFusionComplimentary.setTimeConstant(timeConstant);
    }

    public void reset() {
        this.stop();
        this.magnetic = new float[3];
        this.acceleration = new float[3];
        this.rawAcceleration = new float[3];
        this.rotation = new float[3];
        this.output = new float[4];
        this.listener.reset();
        this.start();
    }

    private float calculateSensorFrequency() {
        if (this.startTime == 0.0f) {
            this.startTime = System.nanoTime();
        }
        long timestamp = System.nanoTime();
        return (float)this.count++ / (((float)timestamp - this.startTime) / 1.0E9f);
    }

    private void initializeFSensorFusions() {
        this.orientationFusionComplimentary = new OrientationFusedComplementary();
        this.linearAccelerationFilterComplimentary = new LinearAccelerationFusion(this.orientationFusionComplimentary);
    }

    private void processRawAcceleration(float[] rawAcceleration) {
        System.arraycopy(rawAcceleration, 0, this.rawAcceleration, 0, this.rawAcceleration.length);
    }

    private void processAcceleration(float[] acceleration) {
        System.arraycopy(acceleration, 0, this.acceleration, 0, this.acceleration.length);
    }

    private void processMagnetic(float[] magnetic) {
        System.arraycopy(magnetic, 0, this.magnetic, 0, this.magnetic.length);
    }

    private void processRotation(float[] rotation) {
        System.arraycopy(rotation, 0, this.rotation, 0, this.rotation.length);
    }

    private void registerSensors(int sensorDelay) {
        this.orientationFusionComplimentary.reset();
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(1), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(2), sensorDelay);
        this.sensorManager.registerListener((SensorEventListener)this.listener, this.sensorManager.getDefaultSensor(this.sensorType), sensorDelay);
    }

    private void unregisterSensors() {
        this.sensorManager.unregisterListener((SensorEventListener)this.listener);
    }

    private void setOutput(float[] value) {
        System.arraycopy(value, 0, this.output, 0, value.length);
        this.output[3] = this.calculateSensorFrequency();
        this.sensorSubject.onNext(this.output);
    }

    private class SimpleSensorListener
    implements SensorEventListener {
        private boolean hasRotation = false;
        private boolean hasMagnetic = false;

        private SimpleSensorListener() {
        }

        private void reset() {
            this.hasRotation = false;
            this.hasMagnetic = false;
        }

        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.getType() == 1) {
                ComplementaryLinearAccelerationSensor.this.processRawAcceleration(event.values);
                if (!ComplementaryLinearAccelerationSensor.this.orientationFusionComplimentary.isBaseOrientationSet()) {
                    if (this.hasRotation && this.hasMagnetic) {
                        ComplementaryLinearAccelerationSensor.this.orientationFusionComplimentary.setBaseOrientation(RotationUtil.getOrientationVectorFromAccelerationMagnetic(ComplementaryLinearAccelerationSensor.this.rawAcceleration, ComplementaryLinearAccelerationSensor.this.magnetic));
                    }
                } else {
                    ComplementaryLinearAccelerationSensor.this.orientationFusionComplimentary.calculateFusedOrientation(ComplementaryLinearAccelerationSensor.this.rotation, event.timestamp, ComplementaryLinearAccelerationSensor.this.rawAcceleration, ComplementaryLinearAccelerationSensor.this.magnetic);
                    ComplementaryLinearAccelerationSensor.this.processAcceleration(ComplementaryLinearAccelerationSensor.this.linearAccelerationFilterComplimentary.filter(ComplementaryLinearAccelerationSensor.this.rawAcceleration));
                    ComplementaryLinearAccelerationSensor.this.setOutput(ComplementaryLinearAccelerationSensor.this.acceleration);
                }
            } else if (event.sensor.getType() == 2) {
                ComplementaryLinearAccelerationSensor.this.processMagnetic(event.values);
                this.hasMagnetic = true;
            } else if (event.sensor.getType() == ComplementaryLinearAccelerationSensor.this.sensorType) {
                ComplementaryLinearAccelerationSensor.this.processRotation(event.values);
                this.hasRotation = true;
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

