/*
 * Decompiled with CFR 0.152.
 */
package com.download.library;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.StatFs;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.download.library.DownloadListener;
import com.download.library.DownloadNotifier;
import com.download.library.DownloadTask;
import com.download.library.ExecuteTask;
import com.download.library.ExecuteTasksMap;
import com.download.library.IDownloader;
import com.download.library.Rumtime;
import com.download.library.SerialExecutor;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class Downloader
extends AsyncTask<Void, Integer, Integer>
implements IDownloader<DownloadTask>,
ExecuteTask {
    protected volatile DownloadTask mDownloadTask;
    private volatile long mLoaded = 0L;
    protected volatile long mTotals = -1L;
    private long mLastLoaded = 0L;
    private long mUsedTime = 0L;
    private long mLastTime = 0L;
    private volatile long mBeginTime = 0L;
    private volatile long mAverageSpeed = 0L;
    protected volatile Throwable mThrowable;
    protected long mDownloadTimeOut = Long.MAX_VALUE;
    protected int mConnectTimeOut = 10000;
    private DownloadNotifier mDownloadNotifier;
    private static final String TAG = "Download-" + Downloader.class.getSimpleName();
    protected AtomicBoolean mIsCanceled = new AtomicBoolean(false);
    protected AtomicBoolean mIsPaused = new AtomicBoolean(false);
    protected AtomicBoolean mIsShutdown = new AtomicBoolean(false);
    private static final int BUFFER_SIZE = 8192;
    private static final int MAX_REDIRECTS = 7;
    private static final int HTTP_TEMP_REDIRECT = 307;
    public static final int ERROR_NETWORK_CONNECTION = 1024;
    public static final int ERROR_RESPONSE_STATUS = 1025;
    public static final int ERROR_STORAGE = 1026;
    public static final int ERROR_TIME_OUT = 1027;
    public static final int ERROR_USER_PAUSE = 1028;
    public static final int ERROR_USER_CANCEL = 1030;
    public static final int ERROR_SHUTDOWN = 1031;
    public static final int ERROR_TOO_MANY_REDIRECTS = 1032;
    public static final int ERROR_LOAD = 1033;
    public static final int ERROR_SERVICE = 1283;
    public static final int SUCCESSFUL = 512;
    public static final int HTTP_RANGE_NOT_SATISFIABLE = 416;
    private static final SparseArray<String> DOWNLOAD_MESSAGE = new SparseArray();
    private static final Executor SERIAL_EXECUTOR = new SerialExecutor();
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    protected Downloader() {
    }

    void checkIsNullTask(DownloadTask downloadTask) {
    }

    protected void onPreExecute() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (null == downloadTask) {
            throw new NullPointerException("DownloadTask can't be null ");
        }
        if (null == downloadTask.getFile()) {
            File file = Rumtime.getInstance().uniqueFile(downloadTask, null);
            downloadTask.setFile(file);
            Rumtime.getInstance().log(TAG, " file path:" + file.getAbsolutePath() + " isEnableIndicator:" + downloadTask.isEnableIndicator());
        } else if (downloadTask.getFile().isDirectory()) {
            File file = Rumtime.getInstance().uniqueFile(downloadTask, downloadTask.getFile());
            downloadTask.setFile(file);
            Rumtime.getInstance().log(TAG, "uniqueFile");
        }
        downloadTask.setStatus(1002);
        this.createNotifier();
        if (null != this.mDownloadNotifier) {
            this.mDownloadNotifier.onPreDownload();
        }
    }

    private boolean checkSpace() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (downloadTask.getTotalsLength() - downloadTask.getFile().length() > this.getAvailableStorage() - 0x6400000L) {
            Rumtime.getInstance().logError(TAG, " \u7a7a\u95f4\u4e0d\u8db3");
            return false;
        }
        return true;
    }

    private long getAvailableStorage() {
        try {
            StatFs stat = new StatFs(Environment.getExternalStorageDirectory().toString());
            if (Build.VERSION.SDK_INT >= 18) {
                return stat.getAvailableBlocksLong() * stat.getBlockSizeLong();
            }
            return (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        }
        catch (RuntimeException ex) {
            return 0L;
        }
    }

    private boolean checkNet() {
        DownloadTask downloadTask = this.mDownloadTask;
        if (!downloadTask.isForceDownload()) {
            return Rumtime.getInstance().checkWifi(downloadTask.getContext());
        }
        return Rumtime.getInstance().checkNetwork(downloadTask.getContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer doInBackground(Void ... params) {
        int result = 1033;
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName("pool-agentweb-thread-" + Rumtime.getInstance().generateGlobalThreadId());
        try {
            this.mBeginTime = SystemClock.elapsedRealtime();
            if (!this.checkNet()) {
                Integer n = 1024;
                return n;
            }
            result = this.doDownload();
        }
        catch (IOException e) {
            this.mThrowable = e;
            if (Rumtime.getInstance().isDebug()) {
                e.printStackTrace();
            }
        }
        finally {
            Thread.currentThread().setName(name);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doDownload() throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        downloadTask.updateTime(this.mBeginTime);
        int redirectionCount = 1;
        URL url = new URL(downloadTask.getUrl());
        HttpURLConnection mHttpURLConnection = null;
        try {
            block19: while (redirectionCount++ <= 7) {
                boolean finishKnown;
                if (null != mHttpURLConnection) {
                    mHttpURLConnection.disconnect();
                }
                mHttpURLConnection = this.createUrlConnectionAndSettingHeaders(url);
                mHttpURLConnection.connect();
                boolean isEncodingChunked = "chunked".equalsIgnoreCase(mHttpURLConnection.getHeaderField("Transfer-Encoding"));
                long contentLength = -1L;
                contentLength = this.getHeaderFieldLong(mHttpURLConnection, "Content-Length");
                boolean hasLength = contentLength > 0L;
                boolean bl = finishKnown = isEncodingChunked && hasLength || !isEncodingChunked && !hasLength;
                if (finishKnown) {
                    Rumtime.getInstance().logError(TAG, " error , giving up ,  EncodingChunked:" + isEncodingChunked + "  hasLength:" + hasLength + " response length:" + contentLength);
                    int n = 1033;
                    return n;
                }
                int responseCode = mHttpURLConnection.getResponseCode();
                switch (responseCode) {
                    case 200: {
                        this.mTotals = contentLength;
                        this.start(mHttpURLConnection);
                        if (!this.checkSpace()) {
                            int n = 1026;
                            return n;
                        }
                        downloadTask.setTotalsLength(this.mTotals);
                        if (downloadTask.getFile().length() >= contentLength) {
                            this.mTotals = contentLength;
                            int n = 512;
                            return n;
                        }
                        this.saveEtag(mHttpURLConnection);
                        downloadTask.setTotalsLength(this.mTotals);
                        int n = this.transferData(this.getInputStream(mHttpURLConnection), new LoadingRandomAccessFile(downloadTask.getFile()), false);
                        return n;
                    }
                    case 206: {
                        if (isEncodingChunked) {
                            this.mTotals = -1L;
                        } else {
                            if (this.mTotals > 0L && contentLength + downloadTask.getFile().length() != this.mTotals) {
                                int n = 1033;
                                return n;
                            }
                            if (this.mTotals <= 0L) {
                                this.mTotals = contentLength + downloadTask.getFile().length();
                            }
                        }
                        downloadTask.setTotalsLength(this.mTotals);
                        this.start(mHttpURLConnection);
                        if (!this.checkSpace()) {
                            int n = 1026;
                            return n;
                        }
                        int n = this.transferData(this.getInputStream(mHttpURLConnection), new LoadingRandomAccessFile(downloadTask.getFile()), !isEncodingChunked);
                        return n;
                    }
                    case 416: {
                        if (null == downloadTask.getFile()) break;
                        downloadTask.getFile().delete();
                        downloadTask.getFile().createNewFile();
                        break;
                    }
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: {
                        String location = mHttpURLConnection.getHeaderField("Location");
                        url = new URL(url, location);
                        continue block19;
                    }
                    case 500: 
                    case 501: 
                    case 502: 
                    case 503: {
                        int n = 1283;
                        return n;
                    }
                    default: {
                        int n = 1025;
                        return n;
                    }
                }
            }
            int n = 1032;
            return n;
        }
        finally {
            if (null != mHttpURLConnection) {
                mHttpURLConnection.disconnect();
            }
        }
    }

    private final void start(HttpURLConnection httpURLConnection) throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        if (TextUtils.isEmpty((CharSequence)downloadTask.getContentDisposition())) {
            downloadTask.setContentDisposition(httpURLConnection.getHeaderField("Content-Disposition"));
        }
        if (TextUtils.isEmpty((CharSequence)downloadTask.getMimetype())) {
            downloadTask.setMimetype(httpURLConnection.getHeaderField("Content-Type"));
        }
        downloadTask.setContentLength(this.getHeaderFieldLong(httpURLConnection, "Content-Length"));
        this.onStart();
    }

    protected void onStart() throws IOException {
        boolean cancel;
        DownloadTask downloadTask = this.mDownloadTask;
        if (null != downloadTask && null != downloadTask.getDownloadListener() && (cancel = downloadTask.getDownloadListener().onStart(downloadTask.mUrl, downloadTask.mUserAgent, downloadTask.mContentDisposition, downloadTask.mMimetype, downloadTask.mTotalsLength, downloadTask))) {
            throw new IOException("The user canceled the download . ");
        }
    }

    private InputStream getInputStream(HttpURLConnection httpURLConnection) throws IOException {
        if ("gzip".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            return new GZIPInputStream(httpURLConnection.getInputStream());
        }
        if ("deflate".equalsIgnoreCase(httpURLConnection.getContentEncoding())) {
            return new InflaterInputStream(httpURLConnection.getInputStream(), new Inflater(true));
        }
        return httpURLConnection.getInputStream();
    }

    private long getHeaderFieldLong(HttpURLConnection httpURLConnection, String name) {
        String field = httpURLConnection.getHeaderField(name);
        try {
            return null == field ? -1L : Long.parseLong(field);
        }
        catch (NumberFormatException e) {
            if (Rumtime.getInstance().isDebug()) {
                e.printStackTrace();
            }
            return -1L;
        }
    }

    private void saveEtag(HttpURLConnection httpURLConnection) {
        String etag = httpURLConnection.getHeaderField("ETag");
        if (TextUtils.isEmpty((CharSequence)etag)) {
            return;
        }
        String url = this.mDownloadTask.getUrl();
        String urlMD5 = Rumtime.getInstance().md5(url);
        Rumtime.getInstance().log(TAG, "save etag:" + etag);
        SharedPreferences mSharedPreferences = this.mDownloadTask.getContext().getSharedPreferences(Rumtime.getInstance().getIdentify(), 0);
        SharedPreferences.Editor editor = mSharedPreferences.edit();
        editor.putString(urlMD5, etag);
        editor.apply();
    }

    private String getEtag() {
        String url = this.mDownloadTask.getUrl();
        String urlMD5 = Rumtime.getInstance().md5(url);
        SharedPreferences mSharedPreferences = this.mDownloadTask.getContext().getSharedPreferences(Rumtime.getInstance().getIdentify(), 0);
        String mEtag = mSharedPreferences.getString(urlMD5, "-1");
        if (!TextUtils.isEmpty((CharSequence)mEtag) && !"-1".equals(mEtag)) {
            return mEtag;
        }
        return null;
    }

    private HttpURLConnection createUrlConnectionAndSettingHeaders(URL url) throws IOException {
        DownloadTask downloadTask = this.mDownloadTask;
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setConnectTimeout(this.mConnectTimeOut);
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setReadTimeout(downloadTask.getBlockMaxTime());
        httpURLConnection.setRequestProperty("Accept", "*/*");
        httpURLConnection.setRequestProperty("Accept-Encoding", "deflate,gzip");
        httpURLConnection.setRequestProperty("Connection", "close");
        Map<String, String> mHeaders = null;
        mHeaders = downloadTask.getHeaders();
        if (null != mHeaders && !mHeaders.isEmpty()) {
            for (Map.Entry<String, String> entry : mHeaders.entrySet()) {
                if (TextUtils.isEmpty((CharSequence)entry.getKey()) || TextUtils.isEmpty((CharSequence)entry.getValue())) continue;
                httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (null != downloadTask.getFile() && downloadTask.getFile().length() > 0L) {
            String mEtag = "";
            mEtag = this.getEtag();
            if (!TextUtils.isEmpty((CharSequence)mEtag)) {
                Rumtime.getInstance().log(TAG, "Etag:" + mEtag);
                httpURLConnection.setRequestProperty("If-Match", this.getEtag());
            }
            this.mLastLoaded = downloadTask.getFile().length();
            httpURLConnection.setRequestProperty("Range", "bytes=" + this.mLastLoaded + "-");
        }
        return httpURLConnection;
    }

    protected void onProgressUpdate(Integer ... values) {
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            long currentTime = SystemClock.elapsedRealtime();
            this.mUsedTime = currentTime - this.mBeginTime;
            this.mAverageSpeed = this.mUsedTime == 0L ? 0L : this.mLoaded * 1000L / this.mUsedTime;
            if (currentTime - this.mLastTime < 450L) {
                return;
            }
            this.mLastTime = currentTime;
            if (null != this.mDownloadNotifier) {
                if (this.mTotals > 0L) {
                    int mProgress = (int)((float)(this.mLastLoaded + this.mLoaded) / Float.valueOf(this.mTotals).floatValue() * 100.0f);
                    this.mDownloadNotifier.onDownloading(mProgress);
                } else {
                    this.mDownloadNotifier.onDownloaded(this.mLastLoaded + this.mLoaded);
                }
            }
            if (null != downloadTask.getDownloadListener()) {
                downloadTask.getDownloadListener().onProgress(downloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, downloadTask.getUsedTime());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onPostExecute(Integer integer) {
        DownloadTask downloadTask = this.mDownloadTask;
        try {
            if (null != downloadTask.getDownloadListener()) {
                downloadTask.getDownloadListener().onProgress(downloadTask.getUrl(), this.mLastLoaded + this.mLoaded, this.mTotals, this.mUsedTime);
            }
            if (integer == 1028) {
                downloadTask.setStatus(1003);
                downloadTask.pause();
                return;
            }
            downloadTask.completed();
            Rumtime.getInstance().log(TAG, "onPostExecute:" + (String)DOWNLOAD_MESSAGE.get(integer.intValue()));
            downloadTask.setStatus(1004);
            boolean isCancelDispose = this.doCallback(integer);
            if (integer > 512) {
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.cancel();
                }
                return;
            }
            if (downloadTask.isEnableIndicator()) {
                if (isCancelDispose) {
                    this.mDownloadNotifier.cancel();
                    return;
                }
                if (null != this.mDownloadNotifier) {
                    this.mDownloadNotifier.onDownloadFinished();
                }
            }
            if (!downloadTask.isAutoOpen()) {
                return;
            }
            Intent mIntent = Rumtime.getInstance().getCommonFileIntentCompat(downloadTask.getContext(), downloadTask);
            if (null == mIntent) {
                return;
            }
            if (!(downloadTask.getContext() instanceof Activity)) {
                mIntent.addFlags(0x10000000);
            }
            downloadTask.getContext().startActivity(mIntent);
        }
        catch (Throwable throwable) {
            if (Rumtime.getInstance().isDebug()) {
                throwable.printStackTrace();
            }
        }
        finally {
            Class<Downloader> clazz = Downloader.class;
            synchronized (Downloader.class) {
                ExecuteTasksMap.getInstance().removeTask(downloadTask.getUrl());
                // ** MonitorExit[var3_3] (shouldn't be in output)
                this.destroyTask();
            }
        }
    }

    protected void destroyTask() {
        if (this.mIsCanceled.get() || this.mIsPaused.get()) {
            return;
        }
        DownloadTask downloadTask = this.mDownloadTask;
        if (null != downloadTask) {
            downloadTask.destroy();
        }
    }

    private boolean doCallback(Integer code) {
        DownloadListener mDownloadListener = null;
        DownloadTask downloadTask = this.mDownloadTask;
        mDownloadListener = downloadTask.getDownloadListener();
        if (null == mDownloadListener) {
            return false;
        }
        return mDownloadListener.onResult(code <= 512 ? null : (null == this.mThrowable ? (this.mThrowable = new RuntimeException("Download failed \uff0c cause:" + (String)DOWNLOAD_MESSAGE.get(code.intValue()))) : this.mThrowable), downloadTask.getFileUri(), downloadTask.getUrl(), this.mDownloadTask);
    }

    private void createNotifier() {
        DownloadTask downloadTask = this.mDownloadTask;
        Context mContext = downloadTask.getContext().getApplicationContext();
        Rumtime.getInstance().log(TAG, " downloadTask.isEnableIndicator()):" + downloadTask.isEnableIndicator() + " file:" + downloadTask.getFile().getAbsolutePath());
        if (null != mContext && downloadTask.isEnableIndicator()) {
            this.mDownloadNotifier = new DownloadNotifier(mContext, downloadTask.getId());
            this.mDownloadNotifier.initBuilder(downloadTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int transferData(InputStream inputStream, RandomAccessFile randomAccessFile, boolean isSeek) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedInputStream bis = new BufferedInputStream(inputStream, 8192);
        RandomAccessFile out = randomAccessFile;
        try {
            int n;
            int n2;
            if (isSeek) {
                out.seek(out.length());
            } else {
                out.seek(0L);
                this.mLastLoaded = 0L;
            }
            int bytes = 0;
            while (!(this.mIsCanceled.get() || this.mIsShutdown.get() || this.mIsPaused.get() || (n2 = bis.read(buffer, 0, 8192)) == -1)) {
                out.write(buffer, 0, n2);
                bytes += n2;
                if (SystemClock.elapsedRealtime() - this.mBeginTime <= this.mDownloadTimeOut) continue;
                int n3 = 1027;
                return n3;
            }
            if (this.mIsPaused.get()) {
                n = 1028;
                return n;
            }
            if (this.mIsCanceled.get()) {
                n = 1030;
                return n;
            }
            if (this.mIsShutdown.get()) {
                n = 1031;
                return n;
            }
            n = 512;
            return n;
        }
        finally {
            this.closeIO(out);
            this.closeIO(bis);
            this.closeIO(inputStream);
        }
    }

    public void closeIO(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public final DownloadTask cancel() {
        try {
            DownloadTask downloadTask = this.mDownloadTask;
            return downloadTask;
        }
        finally {
            this.mIsCanceled.set(true);
        }
    }

    @Override
    public int status() {
        DownloadTask downloadTask = this.mDownloadTask;
        return downloadTask == null ? 1000 : downloadTask.getStatus();
    }

    @Override
    public boolean download(DownloadTask downloadTask) {
        return this.downloadInternal(downloadTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean downloadInternal(final DownloadTask downloadTask) {
        Class<Downloader> clazz = Downloader.class;
        synchronized (Downloader.class) {
            if (ExecuteTasksMap.getInstance().exist(downloadTask.mUrl)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            ExecuteTasksMap.getInstance().addTask(downloadTask.getUrl(), this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.checkIsNullTask(downloadTask);
            if (Looper.getMainLooper() != Looper.myLooper()) {
                HANDLER.post(new Runnable(){

                    @Override
                    public void run() {
                        Downloader.this.run(downloadTask);
                    }
                });
                return true;
            }
            this.run(downloadTask);
            return true;
        }
    }

    @SuppressLint(value={"NewApi"})
    private void run(DownloadTask downloadTask) {
        this.mDownloadTask = downloadTask;
        this.mTotals = this.mDownloadTask.getTotalsLength();
        this.mDownloadTimeOut = this.mDownloadTask.getDownloadTimeOut();
        this.mConnectTimeOut = this.mDownloadTask.getConnectTimeOut();
        if (downloadTask.getStatus() != 1003) {
            downloadTask.resetTime();
        }
        downloadTask.setStatus(1001);
        if (downloadTask.isParallelDownload()) {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
        } else {
            this.executeOnExecutor(SERIAL_EXECUTOR, new Void[0]);
        }
    }

    private final DownloadTask pause() {
        try {
            DownloadTask downloadTask = this.mDownloadTask;
            return downloadTask;
        }
        finally {
            this.mIsPaused.set(true);
        }
    }

    @Override
    public DownloadTask cancelDownload() {
        return this.cancel();
    }

    @Override
    public DownloadTask pauseDownload() {
        return this.pause();
    }

    @Override
    public DownloadTask getDownloadTask() {
        return this.mDownloadTask;
    }

    static {
        DOWNLOAD_MESSAGE.append(1024, (Object)"Network connection error . ");
        DOWNLOAD_MESSAGE.append(1025, (Object)"Response code non-200 or non-206 . ");
        DOWNLOAD_MESSAGE.append(1026, (Object)"Insufficient memory space . ");
        DOWNLOAD_MESSAGE.append(1031, (Object)"Shutdown . ");
        DOWNLOAD_MESSAGE.append(1027, (Object)"Download time is overtime . ");
        DOWNLOAD_MESSAGE.append(1030, (Object)"The user canceled the download . ");
        DOWNLOAD_MESSAGE.append(1033, (Object)"IO Error . ");
        DOWNLOAD_MESSAGE.append(1283, (Object)"Service Unavailable . ");
        DOWNLOAD_MESSAGE.append(1032, (Object)"Too many redirects . ");
        DOWNLOAD_MESSAGE.append(512, (Object)"Download successful . ");
    }

    private final class LoadingRandomAccessFile
    extends RandomAccessFile {
        public LoadingRandomAccessFile(File file) throws FileNotFoundException {
            super(file, "rw");
        }

        @Override
        public void write(byte[] buffer, int offset, int count) throws IOException {
            super.write(buffer, offset, count);
            Downloader.this.mLoaded = Downloader.this.mLoaded + (long)count;
            Downloader.this.publishProgress(new Integer[]{0});
        }
    }
}

