/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.manager;

import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.manager.ItemManager;
import java.util.List;

public class ItemManageImpl<T>
extends ItemManager<T> {
    public ItemManageImpl(BaseRecyclerAdapter<T> adapter) {
        super(adapter);
    }

    @Override
    public void addItem(T item) {
        this.getDatas().add(item);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        int itemPosition = this.getItemPosition(item);
        this.getAdapter().notifyItemInserted(itemPosition);
    }

    @Override
    public void addItem(int position, T item) {
        this.getDatas().add(position, item);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        position = this.dataToItemPosition(position);
        this.getAdapter().notifyItemInserted(position);
    }

    @Override
    public void addItems(List<T> items) {
        this.getDatas().addAll(items);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        this.getAdapter().notifyItemRangeInserted(this.getDatas().size(), items.size());
    }

    @Override
    public void addItems(int position, List<T> items) {
        this.getDatas().addAll(position, items);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        int itemPosition = this.dataToItemPosition(position);
        this.getAdapter().notifyItemRangeInserted(itemPosition, items.size());
    }

    @Override
    public void removeItem(T item) {
        int position = this.getItemPosition(item);
        this.getDatas().remove(item);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        int itemPosition = this.dataToItemPosition(position);
        this.getAdapter().notifyItemRemoved(itemPosition);
    }

    @Override
    public void removeItem(int position) {
        this.getDatas().remove(position);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        int itemPosition = this.dataToItemPosition(position);
        this.getAdapter().notifyItemRemoved(itemPosition);
    }

    @Override
    public void removeItems(List<T> items) {
        this.getDatas().removeAll(items);
        this.notifyDataChanged();
    }

    @Override
    public void replaceItem(int position, T item) {
        this.getDatas().set(position, item);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        int itemPosition = this.dataToItemPosition(position);
        this.getAdapter().notifyItemChanged(itemPosition);
    }

    @Override
    public void replaceAllItem(List<T> items) {
        if (items == null) {
            return;
        }
        this.setDatas(items);
        if (!this.isOpenAnim()) {
            this.notifyDataChanged();
            return;
        }
        this.getAdapter().notifyItemRangeChanged(0, this.getDatas().size());
    }

    protected void setDatas(List<T> items) {
        this.getAdapter().setDatas(items);
    }

    protected List<T> getDatas() {
        return this.getAdapter().getDatas();
    }

    @Override
    public T getItem(int position) {
        return this.getDatas().get(position);
    }

    @Override
    public int getItemPosition(T item) {
        return this.getDatas().indexOf(item);
    }

    @Override
    public void clean() {
        this.getAdapter().clear();
        this.notifyDataChanged();
    }
}

