/*
 * Decompiled with CFR 0.152.
 */
package com.baozi.treerecyclerview.adpater;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.baozi.treerecyclerview.adpater.TreeRecyclerType;
import com.baozi.treerecyclerview.base.BaseRecyclerAdapter;
import com.baozi.treerecyclerview.base.ViewHolder;
import com.baozi.treerecyclerview.factory.ItemHelperFactory;
import com.baozi.treerecyclerview.item.TreeItem;
import com.baozi.treerecyclerview.item.TreeItemGroup;
import com.baozi.treerecyclerview.manager.ItemManageImpl;
import com.baozi.treerecyclerview.manager.ItemManager;
import java.util.ArrayList;
import java.util.List;

public class TreeRecyclerAdapter
extends BaseRecyclerAdapter<TreeItem> {
    private TreeRecyclerType type;
    private ItemManager<TreeItem> mItemManager;
    RecyclerView.ItemDecoration treeItemDecoration = new RecyclerView.ItemDecoration(){

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            super.getItemOffsets(outRect, view, parent, state);
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)view.getLayoutParams();
            int viewLayoutPosition = layoutParams.getViewLayoutPosition();
            int i = TreeRecyclerAdapter.this.getItemCount();
            if (TreeRecyclerAdapter.this.getItemCount() == 0) {
                return;
            }
            int checkPosition = TreeRecyclerAdapter.this.checkPosition(viewLayoutPosition);
            if (checkPosition < 0 || checkPosition >= i) {
                return;
            }
            TreeItem data = (TreeItem)TreeRecyclerAdapter.this.getData(checkPosition);
            if (data != null) {
                data.getItemOffsets(outRect, layoutParams, checkPosition);
            }
        }
    };

    public TreeRecyclerAdapter() {
        this(null);
    }

    public TreeRecyclerAdapter(TreeRecyclerType treeRecyclerType) {
        this.type = treeRecyclerType == null ? TreeRecyclerType.SHOW_DEFAULT : treeRecyclerType;
    }

    @Override
    public void onBindViewHolderClick(final @NonNull ViewHolder holder, View view) {
        if (!view.hasOnClickListeners()) {
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    int layoutPosition = holder.getLayoutPosition();
                    TreeItem item = (TreeItem)TreeRecyclerAdapter.this.getData(layoutPosition = TreeRecyclerAdapter.this.checkPosition(layoutPosition));
                    TreeItemGroup itemParentItem = item.getParentItem();
                    if (itemParentItem != null && itemParentItem.onInterceptClick(item)) {
                        return;
                    }
                    if (item instanceof TreeItemGroup && TreeRecyclerAdapter.this.type != TreeRecyclerType.SHOW_ALL) {
                        TreeItemGroup treeItemGroup;
                        treeItemGroup.setExpand(!(treeItemGroup = (TreeItemGroup)item).isExpand());
                    }
                    if (TreeRecyclerAdapter.this.mOnItemClickListener != null) {
                        TreeRecyclerAdapter.this.mOnItemClickListener.onItemClick(holder, layoutPosition);
                    } else {
                        item.onClick(holder);
                    }
                }
            });
        }
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                int layoutPosition = holder.getLayoutPosition();
                int itemPosition = TreeRecyclerAdapter.this.checkPosition(layoutPosition);
                if (TreeRecyclerAdapter.this.mOnItemLongClickListener != null) {
                    return TreeRecyclerAdapter.this.mOnItemLongClickListener.onItemLongClick(holder, itemPosition);
                }
                return false;
            }
        });
    }

    @Override
    public void setDatas(List<TreeItem> items) {
        if (null == items || items.isEmpty()) {
            return;
        }
        this.getDatas().clear();
        this.assembleItems(items);
    }

    public void setDatas(TreeItemGroup treeItemGroup) {
        if (null == treeItemGroup) {
            return;
        }
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        arrayList.add(treeItemGroup);
        this.setDatas((List<TreeItem>)arrayList);
    }

    private void assembleItems(List<TreeItem> items) {
        if (this.type != null) {
            List datas = this.getDatas();
            datas.addAll(ItemHelperFactory.getChildItemsWithType(items, this.type));
        } else {
            super.setDatas(items);
        }
    }

    @Override
    public ItemManager<TreeItem> getItemManager() {
        if (this.mItemManager == null) {
            this.mItemManager = new TreeItemManageImpl(this);
        }
        return this.mItemManager;
    }

    @Override
    public void setItemManager(ItemManager<TreeItem> itemManage) {
        this.mItemManager = itemManage;
    }

    @Override
    public int getLayoutId(int position) {
        TreeItem data = (TreeItem)this.getData(position);
        if (data != null) {
            return data.getLayoutId();
        }
        return 0;
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        TreeItem t = (TreeItem)this.getData(position);
        if (t == null) {
            return;
        }
        this.checkItemManage(t);
        t.onBindViewHolder(holder);
    }

    private void checkItemManage(TreeItem item) {
        if (item.getItemManager() == null) {
            item.setItemManager(this.getItemManager());
        }
    }

    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        recyclerView.removeItemDecoration(this.treeItemDecoration);
        recyclerView.addItemDecoration(this.treeItemDecoration);
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof GridLayoutManager) {
            GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
            int spanCount = gridLayoutManager.getSpanCount();
            TreeSpanSizeLookup treeSpanSizeLookup = new TreeSpanSizeLookup(this, spanCount);
            gridLayoutManager.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)treeSpanSizeLookup);
        }
    }

    @Override
    @Deprecated
    public int getItemSpanSize(int position) {
        TreeItem data = (TreeItem)this.getData(position);
        if (data == null) {
            return 0;
        }
        return data.getSpanSize();
    }

    @Override
    public int getItemSpanSize(int position, int maxSpan) {
        TreeItem data = (TreeItem)this.getData(position);
        if (data == null) {
            return maxSpan;
        }
        return data.getSpanSize(maxSpan);
    }

    @Deprecated
    public void setType(TreeRecyclerType type) {
        this.type = type;
    }

    public static final class TreeSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        private final BaseRecyclerAdapter adapter;
        private final int spanCount;

        public TreeSpanSizeLookup(BaseRecyclerAdapter adapter, int spanCount) {
            this.adapter = adapter;
            this.spanCount = spanCount;
        }

        public int getSpanSize(int position) {
            int i = this.adapter.getItemCount();
            if (i == 0) {
                return this.spanCount;
            }
            int itemToDataPosition = this.adapter.getItemManager().itemToDataPosition(position);
            if (itemToDataPosition < 0 || itemToDataPosition >= i) {
                return this.spanCount;
            }
            int itemSpanSize = this.adapter.getItemSpanSize(itemToDataPosition);
            if (itemSpanSize != 0) {
                return itemSpanSize;
            }
            itemSpanSize = this.adapter.getItemSpanSize(itemToDataPosition, this.spanCount);
            if (itemSpanSize == 0) {
                return this.spanCount;
            }
            return itemSpanSize;
        }
    }

    private class TreeItemManageImpl
    extends ItemManageImpl<TreeItem> {
        TreeItemManageImpl(BaseRecyclerAdapter<TreeItem> adapter) {
            super(adapter);
        }

        @Override
        public void addItem(TreeItem item) {
            if (item instanceof TreeItemGroup) {
                ArrayList<TreeItem> childItemsWithType = ItemHelperFactory.getChildItemsWithType((TreeItemGroup)item, TreeRecyclerAdapter.this.type);
                childItemsWithType.add(0, item);
                super.addItems(childItemsWithType);
            } else {
                super.addItem(item);
            }
        }

        @Override
        public void addItems(List<TreeItem> items) {
            ArrayList<TreeItem> childItemsWithType = ItemHelperFactory.getChildItemsWithType(items, TreeRecyclerAdapter.this.type);
            super.addItems(childItemsWithType);
        }

        @Override
        public void addItems(int position, List<TreeItem> items) {
            ArrayList<TreeItem> childItemsWithType = ItemHelperFactory.getChildItemsWithType(items, TreeRecyclerAdapter.this.type);
            super.addItems(position, childItemsWithType);
        }

        @Override
        public void removeItem(TreeItem item) {
            if (item instanceof TreeItemGroup) {
                ArrayList<TreeItem> childItemsWithType = ItemHelperFactory.getChildItemsWithType((TreeItemGroup)item, TreeRecyclerAdapter.this.type);
                childItemsWithType.add(0, item);
                super.removeItems(childItemsWithType);
            } else {
                super.removeItem(item);
            }
        }

        @Override
        public void removeItems(List<TreeItem> items) {
            ArrayList<TreeItem> childItemsWithType = ItemHelperFactory.getChildItemsWithType(items, TreeRecyclerAdapter.this.type);
            super.removeItems(childItemsWithType);
        }
    }
}

