/*
 * Decompiled with CFR 0.152.
 */
package me.jessyan.autosize.external;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.jessyan.autosize.external.ExternalAdaptInfo;
import me.jessyan.autosize.utils.Preconditions;

public class ExternalAdaptManager {
    private List<String> mCancelAdaptList;
    private Map<String, ExternalAdaptInfo> mExternalAdaptInfos;
    private boolean isRun;

    public synchronized ExternalAdaptManager addCancelAdaptOfActivity(Class<?> targetClass) {
        Preconditions.checkNotNull(targetClass, "targetClass == null");
        if (!this.isRun) {
            this.isRun = true;
        }
        if (this.mCancelAdaptList == null) {
            this.mCancelAdaptList = new ArrayList<String>();
        }
        this.mCancelAdaptList.add(targetClass.getCanonicalName());
        return this;
    }

    public synchronized ExternalAdaptManager addExternalAdaptInfoOfActivity(Class<?> targetClass, ExternalAdaptInfo info) {
        Preconditions.checkNotNull(targetClass, "targetClass == null");
        if (!this.isRun) {
            this.isRun = true;
        }
        if (this.mExternalAdaptInfos == null) {
            this.mExternalAdaptInfos = new HashMap<String, ExternalAdaptInfo>(16);
        }
        this.mExternalAdaptInfos.put(targetClass.getCanonicalName(), info);
        return this;
    }

    public synchronized boolean isCancelAdapt(Class<?> targetClass) {
        Preconditions.checkNotNull(targetClass, "targetClass == null");
        if (this.mCancelAdaptList == null) {
            return false;
        }
        return this.mCancelAdaptList.contains(targetClass.getCanonicalName());
    }

    public synchronized ExternalAdaptInfo getExternalAdaptInfoOfActivity(Class<?> targetClass) {
        Preconditions.checkNotNull(targetClass, "targetClass == null");
        if (this.mExternalAdaptInfos == null) {
            return null;
        }
        return this.mExternalAdaptInfos.get(targetClass.getCanonicalName());
    }

    public boolean isRun() {
        return this.isRun;
    }

    public void setRun(boolean run) {
        this.isRun = run;
    }
}

