/*
 * Decompiled with CFR 0.152.
 */
package com.jayfang.dropdownmenu;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.jayfang.dropdownmenu.MenuListAdapter;
import com.jayfang.dropdownmenu.OnMenuSelectedListener;
import com.jayfang.dropdownmenu.R;
import java.util.ArrayList;
import java.util.List;

public class DropDownMenu
extends LinearLayout {
    private List<MenuListAdapter> mMenuAdapters = new ArrayList<MenuListAdapter>();
    private List<String[]> mMenuItems = new ArrayList<String[]>();
    private List<TextView> mTvMenuTitles = new ArrayList<TextView>();
    private List<RelativeLayout> mRlMenuBacks = new ArrayList<RelativeLayout>();
    private List<ImageView> mIvMenuArrow = new ArrayList<ImageView>();
    private Context mContext;
    private PopupWindow mPopupWindow;
    private ListView mMenuList;
    private RelativeLayout mRlShadow;
    private OnMenuSelectedListener mMenuSelectedListener;
    private int mMenuCount;
    private int mShowCount;
    private int mRowSelected = 0;
    private int mColumnSelected = 0;
    private int mMenuTitleTextColor;
    private int mMenuTitleTextSize;
    private int mMenuPressedTitleTextColor;
    private int mMenuPressedBackColor;
    private int mMenuBackColor;
    private int mMenuListTextSize;
    private int mMenuListTextColor;
    private boolean mShowCheck;
    private boolean mShowDivider;
    private int mMenuListBackColor;
    private int mMenuListSelectorRes;
    private int mArrowMarginTitle;
    private int mCheckIcon;
    private int mUpArrow;
    private int mDownArrow;
    private boolean mDrawable = false;
    private String[] mDefaultMenuTitle;
    private boolean isDebug = true;

    public DropDownMenu(Context mContext) {
        super(mContext);
        this.init(mContext);
    }

    public DropDownMenu(Context mContext, AttributeSet attrs) {
        super(mContext, attrs);
        this.init(mContext);
    }

    private void init(Context mContext) {
        this.mContext = mContext;
        View popWindows = LayoutInflater.from((Context)mContext).inflate(R.layout.popupwindow_menu, null);
        this.mPopupWindow = new PopupWindow(popWindows, -1, -2, true);
        this.mMenuList = (ListView)popWindows.findViewById(R.id.lv_menu);
        this.mRlShadow = (RelativeLayout)popWindows.findViewById(R.id.rl_menu_shadow);
        this.mMenuCount = 2;
        this.mShowCount = 5;
        this.mMenuTitleTextColor = this.getResources().getColor(R.color.default_menu_text);
        this.mMenuPressedBackColor = this.getResources().getColor(R.color.default_menu_press_back);
        this.mMenuPressedTitleTextColor = this.getResources().getColor(R.color.default_menu_press_text);
        this.mMenuBackColor = this.getResources().getColor(R.color.default_menu_back);
        this.mMenuListBackColor = this.getResources().getColor(R.color.white);
        this.mMenuListSelectorRes = R.color.white;
        this.mMenuTitleTextSize = 18;
        this.mArrowMarginTitle = 10;
        this.mShowCheck = true;
        this.mShowDivider = true;
        this.mCheckIcon = R.drawable.ico_make;
        this.mUpArrow = R.drawable.arrow_up;
        this.mDownArrow = R.drawable.arrow_down;
    }

    public void setmMenuItems(List<String[]> menuItems) {
        this.mMenuItems = menuItems;
        this.mDrawable = true;
        this.invalidate();
    }

    public void setmMenuCount(int menuCount) {
        this.mMenuCount = menuCount;
    }

    public void setShowDivider(boolean mShowDivider) {
        this.mShowDivider = mShowDivider;
    }

    public void setmMenuListBackColor(int menuListBackColor) {
        this.mMenuListBackColor = menuListBackColor;
    }

    public void setmMenuListSelectorRes(int menuListSelectorRes) {
        this.mMenuListSelectorRes = menuListSelectorRes;
    }

    public void setmArrowMarginTitle(int arrowMarginTitle) {
        this.mArrowMarginTitle = arrowMarginTitle;
    }

    public void setmMenuPressedTitleTextColor(int menuPressedTitleTextColor) {
        this.mMenuPressedTitleTextColor = menuPressedTitleTextColor;
    }

    public void setDefaultMenuTitle(String[] mDefaultMenuTitle) {
        this.mDefaultMenuTitle = mDefaultMenuTitle;
    }

    public void setIsDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    public void setmShowCount(int showCount) {
        this.mShowCount = showCount;
    }

    public void setmMenuTitleTextColor(int menuTitleTextColor) {
        this.mMenuTitleTextColor = menuTitleTextColor;
    }

    public void setmMenuTitleTextSize(int menuTitleTextSize) {
        this.mMenuTitleTextSize = menuTitleTextSize;
    }

    public void setmMenuBackColor(int menuBackColor) {
        this.mMenuBackColor = menuBackColor;
    }

    public void setmMenuPressedBackColor(int menuPressedBackColor) {
        this.mMenuPressedBackColor = menuPressedBackColor;
    }

    public void setmMenuListTextColor(int menuListTextColor) {
        this.mMenuListTextColor = menuListTextColor;
        for (int i = 0; i < this.mMenuAdapters.size(); ++i) {
            this.mMenuAdapters.get(i).setTextColor(this.mMenuListTextColor);
        }
    }

    public void setmMenuListTextSize(int menuListTextSize) {
        this.mMenuListTextSize = menuListTextSize;
        for (int i = 0; i < this.mMenuAdapters.size(); ++i) {
            this.mMenuAdapters.get(i).setTextSize(menuListTextSize);
        }
    }

    public void setShowCheck(boolean mShowCheck) {
        this.mShowCheck = mShowCheck;
    }

    public void setmCheckIcon(int checkIcon) {
        this.mCheckIcon = checkIcon;
    }

    public void setmUpArrow(int upArrow) {
        this.mUpArrow = upArrow;
    }

    public void setmDownArrow(int downArrow) {
        this.mDownArrow = downArrow;
    }

    public void setMenuSelectedListener(OnMenuSelectedListener menuSelectedListener) {
        this.mMenuSelectedListener = menuSelectedListener;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawable) {
            this.mPopupWindow.setTouchable(true);
            this.mPopupWindow.setOutsideTouchable(true);
            this.mPopupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable());
            this.mRlShadow.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    DropDownMenu.this.mPopupWindow.dismiss();
                }
            });
            this.mMenuList.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    DropDownMenu.this.mPopupWindow.dismiss();
                    DropDownMenu.this.mRowSelected = position;
                    ((TextView)DropDownMenu.this.mTvMenuTitles.get(DropDownMenu.this.mColumnSelected)).setText((CharSequence)((String[])DropDownMenu.this.mMenuItems.get(DropDownMenu.this.mColumnSelected))[DropDownMenu.this.mRowSelected]);
                    ((ImageView)DropDownMenu.this.mIvMenuArrow.get(DropDownMenu.this.mColumnSelected)).setImageResource(DropDownMenu.this.mDownArrow);
                    ((MenuListAdapter)((Object)DropDownMenu.this.mMenuAdapters.get(DropDownMenu.this.mColumnSelected))).setSelectIndex(DropDownMenu.this.mRowSelected);
                    if (DropDownMenu.this.mMenuSelectedListener == null && DropDownMenu.this.isDebug) {
                        Toast.makeText((Context)DropDownMenu.this.mContext, (CharSequence)"MenuSelectedListener is  null", (int)1).show();
                    } else {
                        DropDownMenu.this.mMenuSelectedListener.onSelected(view, DropDownMenu.this.mRowSelected, DropDownMenu.this.mColumnSelected);
                    }
                }
            });
            this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    for (int i = 0; i < DropDownMenu.this.mMenuCount; ++i) {
                        ((ImageView)DropDownMenu.this.mIvMenuArrow.get(i)).setImageResource(DropDownMenu.this.mDownArrow);
                        ((RelativeLayout)DropDownMenu.this.mRlMenuBacks.get(i)).setBackgroundColor(DropDownMenu.this.mMenuBackColor);
                        ((TextView)DropDownMenu.this.mTvMenuTitles.get(i)).setTextColor(DropDownMenu.this.mMenuTitleTextColor);
                    }
                }
            });
            if (this.mMenuItems.size() != this.mMenuCount) {
                if (this.isDebug) {
                    Toast.makeText((Context)this.mContext, (CharSequence)"Menu item is not setted or incorrect", (int)1).show();
                }
                return;
            }
            if (this.mMenuAdapters.size() == 0) {
                for (int i = 0; i < this.mMenuCount; ++i) {
                    MenuListAdapter adapter = new MenuListAdapter(this.mContext, this.mMenuItems.get(i));
                    adapter.setShowCheck(this.mShowCheck);
                    adapter.setCheckIcon(this.mCheckIcon);
                    this.mMenuAdapters.add(adapter);
                }
            } else if (this.mMenuAdapters.size() != this.mMenuCount) {
                if (this.isDebug) {
                    Toast.makeText((Context)this.mContext, (CharSequence)"If you want set Adapter by yourself,please ensure the number of adpaters equal mMenuCount", (int)1).show();
                }
                return;
            }
            int width = this.getWidth();
            int i = 0;
            while (i < this.mMenuCount) {
                final RelativeLayout v = (RelativeLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.menu_item, null, false);
                RelativeLayout.LayoutParams parms = new RelativeLayout.LayoutParams(width / this.mMenuCount, -2);
                v.setLayoutParams((ViewGroup.LayoutParams)parms);
                TextView tv = (TextView)v.findViewById(R.id.tv_menu_title);
                tv.setTextColor(this.mMenuTitleTextColor);
                tv.setTextSize((float)this.mMenuTitleTextSize);
                if (this.mDefaultMenuTitle == null || this.mDefaultMenuTitle.length == 0) {
                    tv.setText((CharSequence)this.mMenuItems.get(i)[0]);
                } else {
                    tv.setText((CharSequence)this.mDefaultMenuTitle[i]);
                }
                this.addView((View)v, i);
                this.mTvMenuTitles.add(tv);
                RelativeLayout rl = (RelativeLayout)v.findViewById(R.id.rl_menu_head);
                rl.setBackgroundColor(this.mMenuBackColor);
                this.mRlMenuBacks.add(rl);
                ImageView iv = (ImageView)v.findViewById(R.id.iv_menu_arrow);
                this.mIvMenuArrow.add(iv);
                this.mIvMenuArrow.get(i).setImageResource(this.mDownArrow);
                RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)iv.getLayoutParams();
                params.leftMargin = this.mArrowMarginTitle;
                iv.setLayoutParams((ViewGroup.LayoutParams)params);
                final int index = i++;
                v.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        DropDownMenu.this.mMenuList.setAdapter((ListAdapter)DropDownMenu.this.mMenuAdapters.get(index));
                        if (((MenuListAdapter)((Object)DropDownMenu.this.mMenuAdapters.get(index))).getCount() > DropDownMenu.this.mShowCount) {
                            View childView = ((MenuListAdapter)((Object)DropDownMenu.this.mMenuAdapters.get(index))).getView(0, null, (ViewGroup)DropDownMenu.this.mMenuList);
                            childView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                            RelativeLayout.LayoutParams parms = new RelativeLayout.LayoutParams(-1, childView.getMeasuredHeight() * DropDownMenu.this.mShowCount);
                            DropDownMenu.this.mMenuList.setLayoutParams((ViewGroup.LayoutParams)parms);
                        } else {
                            View childView = ((MenuListAdapter)((Object)DropDownMenu.this.mMenuAdapters.get(index))).getView(0, null, (ViewGroup)DropDownMenu.this.mMenuList);
                            childView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                            RelativeLayout.LayoutParams parms = new RelativeLayout.LayoutParams(-1, -2);
                            DropDownMenu.this.mMenuList.setLayoutParams((ViewGroup.LayoutParams)parms);
                        }
                        if (!DropDownMenu.this.mShowDivider) {
                            DropDownMenu.this.mMenuList.setDivider(null);
                        }
                        DropDownMenu.this.mMenuList.setBackgroundColor(DropDownMenu.this.mMenuListBackColor);
                        DropDownMenu.this.mMenuList.setSelector(DropDownMenu.this.mMenuListSelectorRes);
                        DropDownMenu.this.mColumnSelected = index;
                        ((TextView)DropDownMenu.this.mTvMenuTitles.get(index)).setTextColor(DropDownMenu.this.mMenuPressedTitleTextColor);
                        ((RelativeLayout)DropDownMenu.this.mRlMenuBacks.get(index)).setBackgroundColor(DropDownMenu.this.mMenuPressedBackColor);
                        ((ImageView)DropDownMenu.this.mIvMenuArrow.get(index)).setImageResource(DropDownMenu.this.mUpArrow);
                        DropDownMenu.this.mPopupWindow.showAsDropDown((View)v);
                    }
                });
            }
            this.mDrawable = false;
        }
    }
}

