/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import androidx.annotation.AttrRes;
import androidx.annotation.StyleableRes;
import com.noober.background.R;
import com.noober.background.drawable.DrawableFactory;
import com.noober.background.drawable.ICreateDrawable;

public class SelectorPre21DrawableCreator
implements ICreateDrawable {
    private TypedArray typedArray;

    public SelectorPre21DrawableCreator(TypedArray typedArray) {
        this.typedArray = typedArray;
    }

    public StateListDrawable create() throws Exception {
        StateListDrawable stateListDrawable = new StateListDrawable();
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_checkable_solid_color, R.styleable.background_bl_checkable_stroke_color, 16842911);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_unCheckable_solid_color, R.styleable.background_bl_unCheckable_stroke_color, -16842911);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_checked_solid_color, R.styleable.background_bl_checked_stroke_color, 0x10100A0);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_unChecked_solid_color, R.styleable.background_bl_unChecked_stroke_color, -16842912);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_enabled_solid_color, R.styleable.background_bl_enabled_stroke_color, 16842910);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_unEnabled_solid_color, R.styleable.background_bl_unEnabled_stroke_color, -16842910);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_selected_solid_color, R.styleable.background_bl_selected_stroke_color, 0x10100A1);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_unSelected_solid_color, R.styleable.background_bl_unSelected_stroke_color, -16842913);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_pressed_solid_color, R.styleable.background_bl_pressed_stroke_color, 16842919);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_unPressed_solid_color, R.styleable.background_bl_unPressed_stroke_color, -16842919);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_focused_solid_color, R.styleable.background_bl_focused_stroke_color, 16842908);
        this.setSelectorDrawable(stateListDrawable, R.styleable.background_bl_unFocused_solid_color, R.styleable.background_bl_unFocused_stroke_color, -16842908);
        return stateListDrawable;
    }

    private void setSelectorDrawable(StateListDrawable stateListDrawable, @StyleableRes int solidAttr, @StyleableRes int strokeAttr, @AttrRes int functionId) throws Exception {
        if (this.typedArray.hasValue(solidAttr) || this.typedArray.hasValue(strokeAttr)) {
            GradientDrawable tmpDrawable = DrawableFactory.getDrawable(this.typedArray);
            if (this.typedArray.hasValue(solidAttr)) {
                tmpDrawable.setColor(this.typedArray.getColor(solidAttr, 0));
            }
            if (this.typedArray.hasValue(strokeAttr)) {
                int strokeWidth = this.typedArray.getDimensionPixelSize(R.styleable.background_bl_stroke_width, 0);
                int strokeColor = this.typedArray.getColor(strokeAttr, 0);
                float strokeDashWidth = this.typedArray.getDimension(R.styleable.background_bl_stroke_dashWidth, 0.0f);
                float strokeGap = this.typedArray.getDimension(R.styleable.background_bl_stroke_dashGap, 0.0f);
                tmpDrawable.setStroke(strokeWidth, strokeColor, strokeDashWidth, strokeGap);
            }
            stateListDrawable.addState(new int[]{functionId}, (Drawable)tmpDrawable);
        }
    }
}

