/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import androidx.annotation.AttrRes;
import com.noober.background.R;
import com.noober.background.drawable.DrawableFactory;
import com.noober.background.drawable.ICreateDrawable;

public class SelectorDrawableCreator
implements ICreateDrawable {
    private TypedArray typedArray;
    private TypedArray selectorTa;

    public SelectorDrawableCreator(TypedArray typedArray, TypedArray selectorTa) {
        this.typedArray = typedArray;
        this.selectorTa = selectorTa;
    }

    @Override
    public Drawable create() throws Exception {
        StateListDrawable stateListDrawable = new StateListDrawable();
        for (int i = 0; i < this.selectorTa.getIndexCount(); ++i) {
            int attr2 = this.selectorTa.getIndex(i);
            if (attr2 == R.styleable.background_selector_bl_checkable_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 16842911);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unCheckable_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16842911);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_checked_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 0x10100A0);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unChecked_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16842912);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_enabled_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 16842910);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unEnabled_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16842910);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_selected_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 0x10100A1);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unSelected_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16842913);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_pressed_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 16842919);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unPressed_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16842919);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_focused_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 16842908);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unFocused_drawable) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16842908);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_focused_hovered) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 16843623);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_unFocused_hovered) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16843623);
                continue;
            }
            if (attr2 == R.styleable.background_selector_bl_focused_activated) {
                this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, 16843518);
                continue;
            }
            if (attr2 != R.styleable.background_selector_bl_unFocused_activated) continue;
            this.setSelectorDrawable(this.typedArray, this.selectorTa, stateListDrawable, attr2, -16843518);
        }
        return stateListDrawable;
    }

    private void setSelectorDrawable(TypedArray typedArray, TypedArray selectorTa, StateListDrawable stateListDrawable, int attr2, @AttrRes int functionId) throws Exception {
        int color = 0;
        Drawable resDrawable = null;
        try {
            color = selectorTa.getColor(attr2, 0);
            if (color == 0) {
                resDrawable = selectorTa.getDrawable(attr2);
            }
        }
        catch (Exception e) {
            resDrawable = selectorTa.getDrawable(attr2);
        }
        if (resDrawable == null && color != 0) {
            GradientDrawable tmpDrawable = DrawableFactory.getDrawable(typedArray);
            tmpDrawable.setColor(color);
            stateListDrawable.addState(new int[]{functionId}, (Drawable)tmpDrawable);
        } else {
            stateListDrawable.addState(new int[]{functionId}, resDrawable);
        }
    }
}

