/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import com.noober.background.R;
import com.noober.background.common.MultiSelector;
import com.noober.background.common.ResourceUtils;
import com.noober.background.drawable.DrawableFactory;
import com.noober.background.drawable.ICreateDrawable;
import org.xmlpull.v1.XmlPullParserException;

public class MultiSelectorDrawableCreator
implements ICreateDrawable {
    private TypedArray selectorTa;
    private Context context;
    private GradientDrawable gradientDrawable;
    TypedArray typedArray;

    public MultiSelectorDrawableCreator(Context context, TypedArray selectorTa, TypedArray typedArray) {
        this.selectorTa = selectorTa;
        this.context = context;
        this.typedArray = typedArray;
    }

    @Override
    public Drawable create() {
        StateListDrawable stateListDrawable = new StateListDrawable();
        for (int i = 0; i < this.selectorTa.getIndexCount(); ++i) {
            int attr2 = this.selectorTa.getIndex(i);
            if (attr2 == R.styleable.background_multi_selector_bl_multi_selector1) {
                this.addState(stateListDrawable, attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_bl_multi_selector2) {
                this.addState(stateListDrawable, attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_bl_multi_selector3) {
                this.addState(stateListDrawable, attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_bl_multi_selector4) {
                this.addState(stateListDrawable, attr2);
                continue;
            }
            if (attr2 == R.styleable.background_multi_selector_bl_multi_selector5) {
                this.addState(stateListDrawable, attr2);
                continue;
            }
            if (attr2 != R.styleable.background_multi_selector_bl_multi_selector6) continue;
            this.addState(stateListDrawable, attr2);
        }
        return stateListDrawable;
    }

    private void addState(StateListDrawable stateListDrawable, int attr2) {
        String value = this.selectorTa.getString(attr2);
        if (value != null) {
            String[] vArray = value.split(",");
            if (vArray.length < 2) {
                throw new IllegalArgumentException("Attributes and drawable must be set at the same time");
            }
            Drawable drawable = null;
            int[] attrId = new int[vArray.length - 1];
            for (int p = 0; p < vArray.length; ++p) {
                String attrStr = vArray[p];
                if (p == vArray.length - 1) {
                    int color = ResourceUtils.getColor(this.context, attrStr);
                    if (this.typedArray.getIndexCount() > 0) {
                        try {
                            this.gradientDrawable = DrawableFactory.getDrawable(this.typedArray);
                        }
                        catch (XmlPullParserException e) {
                            e.printStackTrace();
                        }
                    }
                    if (this.gradientDrawable != null && color != -1) {
                        this.gradientDrawable.setColor(color);
                        drawable = this.gradientDrawable;
                    } else {
                        drawable = ResourceUtils.getDrawable(this.context, attrStr);
                    }
                    if (drawable != null) continue;
                    throw new IllegalArgumentException("cannot find drawable from the last attribute");
                }
                MultiSelector multiSelector = MultiSelector.getMultiAttr(attrStr.replace("-", ""));
                if (multiSelector == null) {
                    throw new IllegalArgumentException("the attribute of bl_multi_selector only support state_checkable, state_checked, state_enabled, state_selected, state_pressed, state_focused, state_hovered, state_activated");
                }
                attrId[p] = attrStr.contains("-") ? -multiSelector.id : multiSelector.id;
            }
            stateListDrawable.addState(attrId, drawable);
        }
    }
}

