/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.annotation.TargetApi;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;

public class DrawableCreator {
    public static void setDrawable(Drawable drawable, View view, DrawablePosition drawablePosition) {
        if (view instanceof TextView) {
            if (drawable != null) {
                if (drawablePosition == DrawablePosition.Left) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(drawable, null, null, null);
                } else if (drawablePosition == DrawablePosition.Top) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(null, drawable, null, null);
                } else if (drawablePosition == DrawablePosition.Right) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(null, null, drawable, null);
                } else if (drawablePosition == DrawablePosition.Bottom) {
                    drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
                    ((TextView)view).setCompoundDrawables(null, null, null, drawable);
                } else if (Build.VERSION.SDK_INT >= 16) {
                    view.setBackground(drawable);
                } else {
                    view.setBackgroundDrawable(drawable);
                }
            } else {
                Drawable[] drawables = ((TextView)view).getCompoundDrawables();
                if (drawablePosition == DrawablePosition.Left) {
                    drawables[0] = null;
                } else if (drawablePosition == DrawablePosition.Top) {
                    drawables[1] = null;
                } else if (drawablePosition == DrawablePosition.Right) {
                    drawables[2] = null;
                } else if (drawablePosition == DrawablePosition.Bottom) {
                    drawables[3] = null;
                }
                ((TextView)view).setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable);
        } else {
            view.setBackgroundDrawable(drawable);
        }
    }

    public static class Builder {
        private Shape shape = Shape.Rectangle;
        private Integer solidColor;
        private Float cornersRadius;
        private Float cornersBottomLeftRadius;
        private Float cornersBottomRightRadius;
        private Float cornersTopLeftRadius;
        private Float cornersTopRightRadius;
        private int gradientAngle = -1;
        private Float gradientCenterX;
        private Float gradientCenterY;
        private Integer gradientCenterColor;
        private Integer gradientEndColor;
        private Integer gradientStartColor;
        private Float gradientRadius;
        private Gradient gradient = Gradient.Linear;
        private boolean useLevel = false;
        private Rect padding = new Rect();
        private boolean hasSetPadding = false;
        private Float sizeWidth;
        private Float sizeHeight;
        private Float strokeWidth;
        private Integer strokeColor;
        private float strokeDashWidth = 0.0f;
        private float strokeDashGap = 0.0f;
        private boolean rippleEnable = false;
        private Integer rippleColor;
        private Integer checkableStrokeColor;
        private Integer checkedStrokeColor;
        private Integer enabledStrokeColor;
        private Integer selectedStrokeColor;
        private Integer pressedStrokeColor;
        private Integer focusedStrokeColor;
        private Integer unCheckableStrokeColor;
        private Integer unCheckedStrokeColor;
        private Integer unEnabledStrokeColor;
        private Integer unSelectedStrokeColor;
        private Integer unPressedStrokeColor;
        private Integer unFocusedStrokeColor;
        private Integer checkableSolidColor;
        private Integer checkedSolidColor;
        private Integer enabledSolidColor;
        private Integer selectedSolidColor;
        private Integer pressedSolidColor;
        private Integer focusedSolidColor;
        private Integer unCheckableSolidColor;
        private Integer unCheckedSolidColor;
        private Integer unEnabledSolidColor;
        private Integer unSelectedSolidColor;
        private Integer unPressedSolidColor;
        private Integer unFocusedSolidColor;
        private Drawable checkableDrawable;
        private Drawable checkedDrawable;
        private Drawable enabledDrawable;
        private Drawable selectedDrawable;
        private Drawable pressedDrawable;
        private Drawable focusedDrawable;
        private Drawable focusedHovered;
        private Drawable focusedActivated;
        private Drawable unCheckableDrawable;
        private Drawable unCheckedDrawable;
        private Drawable unEnabledDrawable;
        private Drawable unSelectedDrawable;
        private Drawable unPressedDrawable;
        private Drawable unFocusedDrawable;
        private Drawable unFocusedHovered;
        private Drawable unFocusedActivated;
        private Integer checkableTextColor;
        private Integer checkedTextColor;
        private Integer enabledTextColor;
        private Integer selectedTextColor;
        private Integer pressedTextColor;
        private Integer focusedTextColor;
        private Integer unCheckableTextColor;
        private Integer unCheckedTextColor;
        private Integer unEnabledTextColor;
        private Integer unSelectedTextColor;
        private Integer unPressedTextColor;
        private Integer unFocusedTextColor;
        private int textColorCount;
        private float alpha = -1.0f;
        private boolean hasSelectDrawable = false;
        private GradientDrawable baseGradientDrawable = null;
        private StateListDrawable baseStateListDrawable = null;

        public Builder setShape(Shape shape) {
            this.shape = shape;
            return this;
        }

        public Builder setShapeAlpha(float alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder setSolidColor(int solidColor) {
            this.solidColor = solidColor;
            return this;
        }

        public Builder setCornersRadius(float cornersRadius) {
            this.cornersRadius = Float.valueOf(cornersRadius);
            return this;
        }

        public Builder setCornersRadius(float cornersBottomLeftRadius, float cornersBottomRightRadius, float cornersTopLeftRadius, float cornersTopRightRadius) {
            this.cornersBottomLeftRadius = Float.valueOf(cornersBottomLeftRadius);
            this.cornersBottomRightRadius = Float.valueOf(cornersBottomRightRadius);
            this.cornersTopLeftRadius = Float.valueOf(cornersTopLeftRadius);
            this.cornersTopRightRadius = Float.valueOf(cornersTopRightRadius);
            return this;
        }

        @TargetApi(value=16)
        public Builder setGradientAngle(int gradientAngle) {
            this.gradientAngle = gradientAngle;
            return this;
        }

        public Builder setGradientCenterXY(float gradientCenterX, float gradientCenterY) {
            this.gradientCenterX = Float.valueOf(gradientCenterX);
            this.gradientCenterY = Float.valueOf(gradientCenterY);
            return this;
        }

        @TargetApi(value=16)
        public Builder setGradientColor(int startColor, int endColor) {
            this.gradientStartColor = startColor;
            this.gradientEndColor = endColor;
            return this;
        }

        @TargetApi(value=16)
        public Builder setGradientColor(int startColor, int centerColor, int endColor) {
            this.gradientStartColor = startColor;
            this.gradientCenterColor = centerColor;
            this.gradientEndColor = endColor;
            return this;
        }

        public Builder setGradientRadius(float gradientRadius) {
            this.gradientRadius = Float.valueOf(gradientRadius);
            return this;
        }

        public Builder setGradient(Gradient gradient) {
            this.gradient = gradient;
            return this;
        }

        public Builder setUseLevel(boolean useLevel) {
            this.useLevel = useLevel;
            return this;
        }

        public Builder setPadding(float paddingLeft, float paddingTop, float paddingRight, float paddingBottom) {
            this.hasSetPadding = true;
            this.padding.left = (int)paddingLeft;
            this.padding.top = (int)paddingTop;
            this.padding.right = (int)paddingRight;
            this.padding.bottom = (int)paddingBottom;
            return this;
        }

        public Builder setSizeWidth(float sizeWidth) {
            this.sizeWidth = Float.valueOf(sizeWidth);
            return this;
        }

        public Builder setSizeHeight(float sizeHeight) {
            this.sizeHeight = Float.valueOf(sizeHeight);
            return this;
        }

        public Builder setStrokeWidth(float strokeWidth) {
            this.strokeWidth = Float.valueOf(strokeWidth);
            return this;
        }

        public Builder setStrokeColor(int strokeColor) {
            this.strokeColor = strokeColor;
            return this;
        }

        public Builder setStrokeDashWidth(float strokeDashWidth) {
            this.strokeDashWidth = strokeDashWidth;
            return this;
        }

        public Builder setStrokeDashGap(float strokeDashGap) {
            this.strokeDashGap = strokeDashGap;
            return this;
        }

        public Builder setRipple(boolean rippleEnable, int rippleColor) {
            this.rippleEnable = rippleEnable;
            this.rippleColor = rippleColor;
            return this;
        }

        public Builder setCheckableStrokeColor(int checkableStrokeColor, int unCheckableStrokeColor) {
            this.checkableStrokeColor = checkableStrokeColor;
            this.unCheckableStrokeColor = unCheckableStrokeColor;
            return this;
        }

        public Builder setCheckedStrokeColor(int checkedStrokeColor, int unCheckedStrokeColor) {
            this.checkedStrokeColor = checkedStrokeColor;
            this.unCheckedStrokeColor = unCheckedStrokeColor;
            return this;
        }

        public Builder setEnabledStrokeColor(int enabledStrokeColor, int unEnabledStrokeColor) {
            this.enabledStrokeColor = enabledStrokeColor;
            this.unEnabledStrokeColor = unEnabledStrokeColor;
            return this;
        }

        public Builder setSelectedStrokeColor(int selectedStrokeColor, int unSelectedStrokeColor) {
            this.selectedStrokeColor = selectedStrokeColor;
            this.unSelectedStrokeColor = unSelectedStrokeColor;
            return this;
        }

        public Builder setPressedStrokeColor(int pressedStrokeColor, int unPressedStrokeColor) {
            this.pressedStrokeColor = pressedStrokeColor;
            this.unPressedStrokeColor = unPressedStrokeColor;
            return this;
        }

        public Builder setFocusedStrokeColor(int focusedStrokeColor, int unFocusedStrokeColor) {
            this.focusedStrokeColor = focusedStrokeColor;
            this.unFocusedStrokeColor = unFocusedStrokeColor;
            return this;
        }

        public Builder setCheckableSolidColor(int checkableSolidColor, int unCheckableSolidColor) {
            this.checkableSolidColor = checkableSolidColor;
            this.unCheckableSolidColor = unCheckableSolidColor;
            return this;
        }

        public Builder setCheckedSolidColor(int checkedSolidColor, int unCheckedSolidColor) {
            this.checkedSolidColor = checkedSolidColor;
            this.unCheckedSolidColor = unCheckedSolidColor;
            return this;
        }

        public Builder setEnabledSolidColor(int enabledSolidColor, int unEnabledSolidColor) {
            this.enabledSolidColor = enabledSolidColor;
            this.unEnabledSolidColor = unEnabledSolidColor;
            return this;
        }

        public Builder setSelectedSolidColor(int selectedSolidColor, int unSelectedSolidColor) {
            this.selectedSolidColor = selectedSolidColor;
            this.unSelectedSolidColor = unSelectedSolidColor;
            return this;
        }

        public Builder setPressedSolidColor(int pressedSolidColor, int unPressedSolidColor) {
            this.pressedSolidColor = pressedSolidColor;
            this.unPressedSolidColor = unPressedSolidColor;
            return this;
        }

        public Builder setFocusedSolidColor(int focusedSolidColor, int unFocusedSolidColor) {
            this.focusedSolidColor = focusedSolidColor;
            this.unFocusedSolidColor = unFocusedSolidColor;
            return this;
        }

        public Builder setCheckableDrawable(Drawable checkableDrawable) {
            this.hasSelectDrawable = true;
            this.checkableDrawable = checkableDrawable;
            return this;
        }

        public Builder setCheckedDrawable(Drawable checkedDrawable) {
            this.hasSelectDrawable = true;
            this.checkedDrawable = checkedDrawable;
            return this;
        }

        public Builder setEnabledDrawable(Drawable enabledDrawable) {
            this.hasSelectDrawable = true;
            this.enabledDrawable = enabledDrawable;
            return this;
        }

        public Builder setSelectedDrawable(Drawable selectedDrawable) {
            this.hasSelectDrawable = true;
            this.selectedDrawable = selectedDrawable;
            return this;
        }

        public Builder setPressedDrawable(Drawable pressedDrawable) {
            this.hasSelectDrawable = true;
            this.pressedDrawable = pressedDrawable;
            return this;
        }

        public Builder setFocusedDrawable(Drawable focusedDrawable) {
            this.hasSelectDrawable = true;
            this.focusedDrawable = focusedDrawable;
            return this;
        }

        public Builder setFocusedHovered(Drawable focusedHovered) {
            this.hasSelectDrawable = true;
            this.focusedHovered = focusedHovered;
            return this;
        }

        public Builder setFocusedActivated(Drawable focusedActivated) {
            this.hasSelectDrawable = true;
            this.focusedActivated = focusedActivated;
            return this;
        }

        public Builder setUnCheckableDrawable(Drawable unCheckableDrawable) {
            this.hasSelectDrawable = true;
            this.unCheckableDrawable = unCheckableDrawable;
            return this;
        }

        public Builder setUnCheckedDrawable(Drawable unCheckedDrawable) {
            this.hasSelectDrawable = true;
            this.unCheckedDrawable = unCheckedDrawable;
            return this;
        }

        public Builder setUnEnabledDrawable(Drawable unEnabledDrawable) {
            this.hasSelectDrawable = true;
            this.unEnabledDrawable = unEnabledDrawable;
            return this;
        }

        public Builder setUnSelectedDrawable(Drawable unSelectedDrawable) {
            this.hasSelectDrawable = true;
            this.unSelectedDrawable = unSelectedDrawable;
            return this;
        }

        public Builder setUnPressedDrawable(Drawable unPressedDrawable) {
            this.hasSelectDrawable = true;
            this.unPressedDrawable = unPressedDrawable;
            return this;
        }

        public Builder setUnFocusedDrawable(Drawable unFocusedDrawable) {
            this.hasSelectDrawable = true;
            this.hasSelectDrawable = true;
            this.unFocusedDrawable = unFocusedDrawable;
            return this;
        }

        public Builder setUnFocusedHovered(Drawable unFocusedHovered) {
            this.hasSelectDrawable = true;
            this.unFocusedHovered = unFocusedHovered;
            return this;
        }

        public Builder setUnFocusedActivated(Drawable unFocusedActivated) {
            this.hasSelectDrawable = true;
            this.unFocusedActivated = unFocusedActivated;
            return this;
        }

        public Builder setCheckableTextColor(int checkableTextColor) {
            this.checkableTextColor = checkableTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setCheckedTextColor(int checkedTextColor) {
            this.checkedTextColor = checkedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setEnabledTextColor(int enabledTextColor) {
            this.enabledTextColor = enabledTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setSelectedTextColor(int selectedTextColor) {
            this.selectedTextColor = selectedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setPressedTextColor(int pressedTextColor) {
            this.pressedTextColor = pressedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setFocusedTextColor(int focusedTextColor) {
            this.focusedTextColor = focusedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setUnCheckableTextColor(int unCheckableTextColor) {
            this.unCheckableTextColor = unCheckableTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setUnCheckedTextColor(int unCheckedTextColor) {
            this.unCheckedTextColor = unCheckedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setUnEnabledTextColor(int unEnabledTextColor) {
            this.unEnabledTextColor = unEnabledTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setUnSelectedTextColor(int unSelectedTextColor) {
            this.unSelectedTextColor = unSelectedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setUnPressedTextColor(int unPressedTextColor) {
            this.unPressedTextColor = unPressedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setUnFocusedTextColor(int unFocusedTextColor) {
            this.unFocusedTextColor = unFocusedTextColor;
            ++this.textColorCount;
            return this;
        }

        public Builder setBaseGradientDrawable(GradientDrawable baseGradientDrawable) {
            this.baseGradientDrawable = baseGradientDrawable;
            return this;
        }

        public Builder setBaseStateListDrawable(StateListDrawable baseStateListDrawable) {
            this.baseStateListDrawable = baseStateListDrawable;
            return this;
        }

        public Drawable build() {
            StateListDrawable result;
            GradientDrawable drawable = null;
            StateListDrawable stateListDrawable = null;
            if (this.hasSelectDrawable) {
                stateListDrawable = this.getStateListDrawable();
            } else {
                drawable = this.getGradientDrawable();
            }
            if (this.rippleEnable && this.rippleColor != null) {
                if (Build.VERSION.SDK_INT >= 21) {
                    GradientDrawable contentDrawable = stateListDrawable == null ? drawable : stateListDrawable;
                    return new RippleDrawable(ColorStateList.valueOf((int)this.rippleColor), (Drawable)contentDrawable, (Drawable)contentDrawable);
                }
                StateListDrawable resultDrawable = new StateListDrawable();
                GradientDrawable unPressDrawable = this.getGradientDrawable();
                unPressDrawable.setColor(this.rippleColor.intValue());
                resultDrawable.addState(new int[]{-16842919}, (Drawable)drawable);
                resultDrawable.addState(new int[]{16842919}, (Drawable)unPressDrawable);
                return resultDrawable;
            }
            Object object = result = drawable == null ? stateListDrawable : drawable;
            if (this.alpha != -1.0f) {
                this.alpha = this.alpha >= 1.0f ? 255.0f : (this.alpha <= 0.0f ? 0.0f : (this.alpha *= 255.0f));
                result.setAlpha((int)this.alpha);
            }
            return result;
        }

        public ColorStateList buildTextColor() {
            if (this.textColorCount > 0) {
                return this.getColorStateList();
            }
            return null;
        }

        private ColorStateList getColorStateList() {
            int[][] states = new int[this.textColorCount][];
            int[] colors = new int[this.textColorCount];
            int index = 0;
            if (this.checkableTextColor != null) {
                states[index] = new int[]{16842911};
                colors[index] = this.checkableTextColor;
                ++index;
            }
            if (this.unCheckableTextColor != null) {
                states[index] = new int[]{-16842911};
                colors[index] = this.unCheckableTextColor;
                ++index;
            }
            if (this.checkedTextColor != null) {
                states[index] = new int[]{0x10100A0};
                colors[index] = this.checkedTextColor;
                ++index;
            }
            if (this.unCheckedTextColor != null) {
                states[index] = new int[]{-16842912};
                colors[index] = this.unCheckedTextColor;
                ++index;
            }
            if (this.enabledTextColor != null) {
                states[index] = new int[]{16842910};
                colors[index] = this.enabledTextColor;
                ++index;
            }
            if (this.unEnabledTextColor != null) {
                states[index] = new int[]{-16842910};
                colors[index] = this.unEnabledTextColor;
                ++index;
            }
            if (this.selectedTextColor != null) {
                states[index] = new int[]{0x10100A1};
                colors[index] = this.selectedTextColor;
                ++index;
            }
            if (this.unSelectedTextColor != null) {
                states[index] = new int[]{-16842913};
                colors[index] = this.unSelectedTextColor;
                ++index;
            }
            if (this.pressedTextColor != null) {
                states[index] = new int[]{16842919};
                colors[index] = this.pressedTextColor;
                ++index;
            }
            if (this.unPressedTextColor != null) {
                states[index] = new int[]{-16842919};
                colors[index] = this.unPressedTextColor;
                ++index;
            }
            if (this.focusedTextColor != null) {
                states[index] = new int[]{16842908};
                colors[index] = this.focusedTextColor;
                ++index;
            }
            if (this.unFocusedTextColor != null) {
                states[index] = new int[]{-16842908};
                colors[index] = this.unFocusedTextColor;
            }
            return new ColorStateList((int[][])states, colors);
        }

        private StateListDrawable getStateListDrawable() {
            StateListDrawable stateListDrawable = this.baseStateListDrawable;
            if (this.checkableDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{16842911}, this.checkableDrawable);
            }
            if (this.unCheckableDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16842911}, this.unCheckableDrawable);
            }
            if (this.checkedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{0x10100A0}, this.checkedDrawable);
            }
            if (this.unCheckedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16842912}, this.unCheckedDrawable);
            }
            if (this.enabledDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{16842910}, this.enabledDrawable);
            }
            if (this.unEnabledDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16842910}, this.unEnabledDrawable);
            }
            if (this.selectedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{0x10100A1}, this.selectedDrawable);
            }
            if (this.unSelectedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16842913}, this.unSelectedDrawable);
            }
            if (this.pressedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{16842919}, this.pressedDrawable);
            }
            if (this.unPressedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16842919}, this.unPressedDrawable);
            }
            if (this.focusedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{16842908}, this.focusedDrawable);
            }
            if (this.unFocusedDrawable != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16842908}, this.unFocusedDrawable);
            }
            if (this.focusedHovered != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{16843623}, this.focusedHovered);
            }
            if (this.unFocusedHovered != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16843623}, this.unFocusedHovered);
            }
            if (this.focusedActivated != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{16843518}, this.focusedActivated);
            }
            if (this.unFocusedActivated != null) {
                stateListDrawable = this.getStateListDrawable(stateListDrawable);
                stateListDrawable.addState(new int[]{-16843518}, this.unFocusedActivated);
            }
            return stateListDrawable;
        }

        @NonNull
        private GradientDrawable getGradientDrawable() {
            ColorStateList colorStateList;
            int iState;
            int[] color;
            int[][] state;
            ArrayList<Integer> colorList;
            ArrayList<Integer> stateList;
            GradientDrawable drawable = this.baseGradientDrawable;
            if (drawable == null) {
                drawable = new GradientDrawable();
            }
            drawable.setShape(this.shape.value);
            if (this.cornersRadius != null) {
                drawable.setCornerRadius(this.cornersRadius.floatValue());
            }
            if (this.cornersBottomLeftRadius != null && this.cornersBottomRightRadius != null && this.cornersTopLeftRadius != null && this.cornersTopRightRadius != null) {
                float[] cornerRadius = new float[]{this.cornersTopLeftRadius.floatValue(), this.cornersTopLeftRadius.floatValue(), this.cornersTopRightRadius.floatValue(), this.cornersTopRightRadius.floatValue(), this.cornersBottomRightRadius.floatValue(), this.cornersBottomRightRadius.floatValue(), this.cornersBottomLeftRadius.floatValue(), this.cornersBottomLeftRadius.floatValue()};
                drawable.setCornerRadii(cornerRadius);
            }
            if (this.gradient == Gradient.Linear && this.gradientAngle != -1) {
                this.gradientAngle %= 360;
                if (this.gradientAngle % 45 == 0) {
                    GradientDrawable.Orientation mOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
                    switch (this.gradientAngle) {
                        case 0: {
                            mOrientation = GradientDrawable.Orientation.LEFT_RIGHT;
                            break;
                        }
                        case 45: {
                            mOrientation = GradientDrawable.Orientation.BL_TR;
                            break;
                        }
                        case 90: {
                            mOrientation = GradientDrawable.Orientation.BOTTOM_TOP;
                            break;
                        }
                        case 135: {
                            mOrientation = GradientDrawable.Orientation.BR_TL;
                            break;
                        }
                        case 180: {
                            mOrientation = GradientDrawable.Orientation.RIGHT_LEFT;
                            break;
                        }
                        case 225: {
                            mOrientation = GradientDrawable.Orientation.TR_BL;
                            break;
                        }
                        case 270: {
                            mOrientation = GradientDrawable.Orientation.TOP_BOTTOM;
                            break;
                        }
                        case 315: {
                            mOrientation = GradientDrawable.Orientation.TL_BR;
                        }
                    }
                    if (Build.VERSION.SDK_INT >= 16) {
                        drawable.setOrientation(mOrientation);
                    }
                }
            }
            if (this.gradientCenterX != null && this.gradientCenterY != null) {
                drawable.setGradientCenter(this.gradientCenterX.floatValue(), this.gradientCenterY.floatValue());
            }
            if (this.gradientStartColor != null && this.gradientEndColor != null) {
                int[] colors = this.gradientCenterColor != null ? new int[]{this.gradientStartColor, this.gradientCenterColor, this.gradientEndColor} : new int[]{this.gradientStartColor, this.gradientEndColor};
                if (Build.VERSION.SDK_INT >= 16) {
                    drawable.setColors(colors);
                }
            }
            if (this.gradientRadius != null) {
                drawable.setGradientRadius(this.gradientRadius.floatValue());
            }
            drawable.setGradientType(this.gradient.value);
            drawable.setUseLevel(this.useLevel);
            if (this.hasSetPadding) {
                if (Build.VERSION.SDK_INT >= 29) {
                    drawable.setPadding(this.padding.left, this.padding.top, this.padding.right, this.padding.bottom);
                } else {
                    try {
                        Field paddingField = drawable.getClass().getDeclaredField("mPadding");
                        paddingField.setAccessible(true);
                        paddingField.set(drawable, this.padding);
                    }
                    catch (NoSuchFieldException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.sizeWidth != null && this.sizeHeight != null) {
                drawable.setSize(this.sizeWidth.intValue(), this.sizeHeight.intValue());
            }
            if (this.strokeWidth != null && this.strokeWidth.floatValue() > 0.0f) {
                if (Build.VERSION.SDK_INT >= 21) {
                    int start = 0;
                    stateList = new ArrayList();
                    colorList = new ArrayList();
                    if (this.pressedStrokeColor != null && this.unPressedStrokeColor != null) {
                        stateList.add(16842919);
                        stateList.add(-16842919);
                        colorList.add(this.pressedStrokeColor);
                        colorList.add(this.unPressedStrokeColor);
                    }
                    if (this.checkableStrokeColor != null && this.unCheckableStrokeColor != null) {
                        stateList.add(16842911);
                        stateList.add(-16842911);
                        colorList.add(this.checkableStrokeColor);
                        colorList.add(this.unCheckableStrokeColor);
                    }
                    if (this.checkedStrokeColor != null && this.unCheckedStrokeColor != null) {
                        stateList.add(0x10100A0);
                        stateList.add(-16842912);
                        colorList.add(this.checkedStrokeColor);
                        colorList.add(this.unCheckedStrokeColor);
                    }
                    if (this.enabledStrokeColor != null && this.unEnabledStrokeColor != null) {
                        stateList.add(16842910);
                        stateList.add(-16842910);
                        colorList.add(this.enabledStrokeColor);
                        colorList.add(this.unEnabledStrokeColor);
                    }
                    if (this.selectedStrokeColor != null && this.unSelectedStrokeColor != null) {
                        stateList.add(0x10100A1);
                        stateList.add(-16842913);
                        colorList.add(this.selectedStrokeColor);
                        colorList.add(this.unSelectedStrokeColor);
                    }
                    if (this.focusedStrokeColor != null && this.unFocusedStrokeColor != null) {
                        stateList.add(16842908);
                        stateList.add(-16842908);
                        colorList.add(this.focusedStrokeColor);
                        colorList.add(this.unFocusedStrokeColor);
                    }
                    if (stateList.size() > 0) {
                        state = new int[stateList.size()][];
                        color = new int[stateList.size()];
                        Iterator iterator = stateList.iterator();
                        while (iterator.hasNext()) {
                            iState = (Integer)iterator.next();
                            state[start] = new int[]{iState};
                            color[start] = (Integer)colorList.get(start);
                            ++start;
                        }
                        colorStateList = new ColorStateList((int[][])state, color);
                        drawable.setStroke(this.strokeWidth.intValue(), colorStateList, this.strokeDashWidth, this.strokeDashGap);
                    } else if (this.strokeColor != null) {
                        drawable.setStroke(this.strokeWidth.intValue(), this.strokeColor.intValue(), this.strokeDashWidth, this.strokeDashGap);
                    }
                    stateList = null;
                    colorList = null;
                } else if (this.strokeColor != null) {
                    drawable.setStroke(this.strokeWidth.intValue(), this.strokeColor.intValue(), this.strokeDashWidth, this.strokeDashGap);
                }
            }
            if (Build.VERSION.SDK_INT >= 21) {
                int start = 0;
                stateList = new ArrayList<Integer>();
                colorList = new ArrayList<Integer>();
                if (this.pressedSolidColor != null && this.unPressedSolidColor != null) {
                    stateList.add(16842919);
                    stateList.add(-16842919);
                    colorList.add(this.pressedSolidColor);
                    colorList.add(this.unPressedSolidColor);
                }
                if (this.checkableSolidColor != null && this.unCheckableSolidColor != null) {
                    stateList.add(16842911);
                    stateList.add(-16842911);
                    colorList.add(this.checkableSolidColor);
                    colorList.add(this.unCheckableSolidColor);
                }
                if (this.checkedSolidColor != null && this.unCheckedSolidColor != null) {
                    stateList.add(0x10100A0);
                    stateList.add(-16842912);
                    colorList.add(this.checkedSolidColor);
                    colorList.add(this.unCheckedSolidColor);
                }
                if (this.enabledSolidColor != null && this.unEnabledSolidColor != null) {
                    stateList.add(16842910);
                    stateList.add(-16842910);
                    colorList.add(this.enabledSolidColor);
                    colorList.add(this.unEnabledSolidColor);
                }
                if (this.selectedSolidColor != null && this.unSelectedSolidColor != null) {
                    stateList.add(0x10100A1);
                    stateList.add(-16842913);
                    colorList.add(this.selectedSolidColor);
                    colorList.add(this.unSelectedSolidColor);
                }
                if (this.focusedSolidColor != null && this.unFocusedSolidColor != null) {
                    stateList.add(16842908);
                    stateList.add(-16842908);
                    colorList.add(this.focusedSolidColor);
                    colorList.add(this.unFocusedSolidColor);
                }
                if (stateList.size() > 0) {
                    state = new int[stateList.size()][];
                    color = new int[stateList.size()];
                    colorStateList = stateList.iterator();
                    while (colorStateList.hasNext()) {
                        iState = (Integer)colorStateList.next();
                        state[start] = new int[]{iState};
                        color[start] = (Integer)colorList.get(start);
                        ++start;
                    }
                    colorStateList = new ColorStateList((int[][])state, color);
                    drawable.setColor(colorStateList);
                } else if (this.solidColor != null) {
                    drawable.setColor(this.solidColor.intValue());
                }
                stateList = null;
                colorList = null;
            } else if (this.solidColor != null) {
                drawable.setColor(this.solidColor.intValue());
            }
            return drawable;
        }

        StateListDrawable getStateListDrawable(StateListDrawable stateListDrawable) {
            if (stateListDrawable == null) {
                stateListDrawable = new StateListDrawable();
            }
            return stateListDrawable;
        }
    }

    public static enum DrawablePosition {
        Left,
        Right,
        Top,
        Bottom;

    }

    public static enum Gradient {
        Linear(0),
        Radial(1),
        Sweep(2);

        int value;

        private Gradient(int value) {
            this.value = value;
        }
    }

    public static enum Shape {
        Rectangle(0),
        Oval(1),
        Line(2),
        Ring(3);

        int value;

        private Shape(int value) {
            this.value = value;
        }
    }
}

