/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background.drawable;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import androidx.annotation.AttrRes;
import com.noober.background.R;
import com.noober.background.drawable.DrawableFactory;
import com.noober.background.drawable.ICreateDrawable;

public class ButtonDrawableCreator
implements ICreateDrawable {
    private TypedArray typedArray;
    private TypedArray buttonTa;

    public ButtonDrawableCreator(TypedArray typedArray, TypedArray buttonTa) {
        this.typedArray = typedArray;
        this.buttonTa = buttonTa;
    }

    @Override
    public Drawable create() throws Exception {
        StateListDrawable stateListDrawable = new StateListDrawable();
        for (int i = 0; i < this.buttonTa.getIndexCount(); ++i) {
            int attr2 = this.buttonTa.getIndex(i);
            if (attr2 == R.styleable.background_button_drawable_bl_checked_button_drawable) {
                this.setSelectorDrawable(this.typedArray, this.buttonTa, stateListDrawable, attr2, 0x10100A0);
                continue;
            }
            if (attr2 != R.styleable.background_button_drawable_bl_unChecked_button_drawable) continue;
            this.setSelectorDrawable(this.typedArray, this.buttonTa, stateListDrawable, attr2, -16842912);
        }
        return stateListDrawable;
    }

    private void setSelectorDrawable(TypedArray typedArray, TypedArray buttonTa, StateListDrawable stateListDrawable, int attr2, @AttrRes int functionId) throws Exception {
        int color = 0;
        Drawable resDrawable = null;
        try {
            color = buttonTa.getColor(attr2, 0);
            if (color == 0) {
                resDrawable = buttonTa.getDrawable(attr2);
            }
        }
        catch (Exception e) {
            resDrawable = buttonTa.getDrawable(attr2);
        }
        if (resDrawable == null && color != 0) {
            GradientDrawable tmpDrawable = DrawableFactory.getDrawable(typedArray);
            tmpDrawable.setColor(color);
            stateListDrawable.addState(new int[]{functionId}, (Drawable)tmpDrawable);
        } else {
            stateListDrawable.addState(new int[]{functionId}, resDrawable);
        }
    }
}

