/*
 * Decompiled with CFR 0.152.
 */
package com.noober.background;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.view.LayoutInflaterCompat;
import com.noober.background.BackgroundFactory;
import java.lang.reflect.Field;

public class BackgroundLibrary {
    public static LayoutInflater inject(Context context) {
        LayoutInflater inflater = context instanceof Activity ? ((Activity)context).getLayoutInflater() : LayoutInflater.from((Context)context);
        if (inflater == null) {
            return null;
        }
        if (inflater.getFactory2() == null) {
            BackgroundFactory factory = BackgroundLibrary.setDelegateFactory(context);
            inflater.setFactory2((LayoutInflater.Factory2)factory);
        } else if (!(inflater.getFactory2() instanceof BackgroundFactory)) {
            BackgroundLibrary.forceSetFactory2(inflater);
        }
        return inflater;
    }

    @NonNull
    private static BackgroundFactory setDelegateFactory(Context context) {
        BackgroundFactory factory = new BackgroundFactory();
        if (context instanceof AppCompatActivity) {
            final AppCompatDelegate delegate = ((AppCompatActivity)context).getDelegate();
            factory.setInterceptFactory(new LayoutInflater.Factory(){

                public View onCreateView(String name, Context context, AttributeSet attrs) {
                    return delegate.createView(null, name, context, attrs);
                }
            });
        }
        return factory;
    }

    public static LayoutInflater inject2(Context context) {
        LayoutInflater inflater = context instanceof Activity ? ((Activity)context).getLayoutInflater() : LayoutInflater.from((Context)context);
        if (inflater == null) {
            return null;
        }
        BackgroundLibrary.forceSetFactory2(inflater);
        return inflater;
    }

    private static void forceSetFactory2(LayoutInflater inflater) {
        Class<LayoutInflaterCompat> compatClass = LayoutInflaterCompat.class;
        Class<LayoutInflater> inflaterClass = LayoutInflater.class;
        try {
            Field sCheckedField = compatClass.getDeclaredField("sCheckedField");
            sCheckedField.setAccessible(true);
            sCheckedField.setBoolean(compatClass, false);
            Field mFactory = inflaterClass.getDeclaredField("mFactory");
            mFactory.setAccessible(true);
            Field mFactory2 = inflaterClass.getDeclaredField("mFactory2");
            mFactory2.setAccessible(true);
            BackgroundFactory factory = new BackgroundFactory();
            if (inflater.getFactory2() != null) {
                factory.setInterceptFactory2(inflater.getFactory2());
            } else if (inflater.getFactory() != null) {
                factory.setInterceptFactory(inflater.getFactory());
            }
            mFactory2.set(inflater, factory);
            mFactory.set(inflater, factory);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

