/*
 * Decompiled with CFR 0.152.
 */
package com.eden.common.injection;

import com.caseyjbrooks.clog.Clog;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class EdenInjector {
    private List<AnnotationDefinition> annotationDefinitionList = new ArrayList<AnnotationDefinition>();

    public void addAnnotation(AnnotationDefinition annotationDefinition) {
        this.annotationDefinitionList.add(annotationDefinition);
    }

    public void processAnnotations(Object object) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            for (AnnotationDefinition definition : this.annotationDefinitionList) {
                if (!field.isAnnotationPresent(definition.annotationClass)) continue;
                if (definition.fieldTypeClass.isAssignableFrom(field.getType())) {
                    definition.annotationHandler.handle(field.getAnnotation(definition.annotationClass), object, field);
                    continue;
                }
                Clog.e((String)"@#{$1} annotation must be used on a field of type #{$2} or one of its subclasses.", (Object[])new Object[]{definition.annotationClass.getSimpleName(), definition.fieldTypeClass.getSimpleName()});
            }
        }
    }

    public static class AnnotationDefinition {
        Class<? extends Annotation> annotationClass;
        Class<?> fieldTypeClass;
        AnnotationHandler annotationHandler;

        public AnnotationDefinition(Class<? extends Annotation> annotationClass, Class<?> fieldTypeClass, AnnotationHandler annotationHandler) {
            this.annotationClass = annotationClass;
            this.fieldTypeClass = fieldTypeClass;
            this.annotationHandler = annotationHandler;
        }
    }

    public static interface AnnotationHandler {
        public void handle(Annotation var1, Object var2, Field var3);
    }
}

