/*
 * Decompiled with CFR 0.152.
 */
package com.intrusoft.scatter;

import com.intrusoft.scatter.ChartData;
import com.intrusoft.scatter.ChartUtils;
import java.util.ArrayList;
import java.util.List;

class ChartHelper {
    ChartHelper() {
    }

    static List<ChartUtils> generateSimpleRadius(List<ChartData> chartData, int maxDiameter) {
        int size = chartData.size();
        ArrayList<ChartUtils> chartUtils = new ArrayList<ChartUtils>();
        int lastR = maxDiameter / 2;
        int firstR = lastR / 3;
        int equalR = 0;
        float textSize = 0.0f;
        float offset = 0.0f;
        if (size - 1 > 1) {
            equalR = (lastR - firstR) / (size - 1);
            textSize = (float)equalR * 0.4f;
            offset = textSize + (float)(equalR * 20 / 100);
        }
        chartUtils.add(0, new ChartUtils(firstR, textSize, offset, chartData.get(0).getPartInPercent()));
        for (int i = 1; i < size; ++i) {
            chartUtils.add(i, new ChartUtils(((ChartUtils)chartUtils.get(i - 1)).getRadius() + (float)equalR, textSize, offset, chartData.get(i).getPartInPercent()));
        }
        return chartUtils;
    }

    static List<ChartUtils> generateSimpleRadiusWithPercent(List<ChartData> chartData, int maxDiameter) {
        ArrayList<ChartUtils> chartUtils = new ArrayList<ChartUtils>();
        float unit = maxDiameter / 200;
        float radius = chartData.get(0).getPartInPercent() * unit;
        float textSize = radius * 2.0f / 10.0f;
        float offset = textSize + radius * 10.0f / 100.0f;
        chartUtils.add(0, new ChartUtils(radius, textSize, offset, chartData.get(0).getPartInPercent()));
        for (int i = 1; i < chartData.size(); ++i) {
            radius = ((ChartUtils)chartUtils.get(i - 1)).getRadius() + chartData.get(i).getPartInPercent() * unit;
            textSize = (radius - ((ChartUtils)chartUtils.get(i - 1)).getRadius()) / 2.0f;
            offset = textSize + (radius - ((ChartUtils)chartUtils.get(i - 1)).getRadius()) / 5.0f;
            chartUtils.add(i, new ChartUtils(radius, textSize, offset, chartData.get(i).getPartInPercent()));
        }
        return chartUtils;
    }

    static List<ChartUtils> generateArcWithPercent(List<ChartData> chartData) {
        ArrayList<ChartUtils> chartUtils = new ArrayList<ChartUtils>();
        float unit = 3.6f;
        float radius = chartData.get(0).getPartInPercent() * unit;
        chartUtils.add(0, new ChartUtils(radius, 0.0f, 0.0f, chartData.get(0).getPartInPercent()));
        for (int i = 1; i < chartData.size(); ++i) {
            radius = ((ChartUtils)chartUtils.get(i - 1)).getRadius() + chartData.get(i).getPartInPercent() * unit;
            chartUtils.add(i, new ChartUtils(radius, 0.0f, 0.0f, chartData.get(i).getPartInPercent()));
        }
        return chartUtils;
    }

    public static List<ChartUtils> generateArc(List<ChartData> chartData) {
        ArrayList<ChartUtils> chartUtils = new ArrayList<ChartUtils>();
        float unit = 360 / chartData.size();
        chartUtils.add(0, new ChartUtils(unit, 0.0f, 0.0f, chartData.get(0).getPartInPercent()));
        for (int i = 1; i < chartData.size(); ++i) {
            float radius = ((ChartUtils)chartUtils.get(i - 1)).getRadius() + unit;
            chartUtils.add(i, new ChartUtils(radius, 0.0f, 0.0f, chartData.get(i).getPartInPercent()));
        }
        return chartUtils;
    }
}

