/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview.listener;

import android.graphics.Bitmap;
import android.view.MotionEvent;
import com.infomaniak.lib.pdfview.link.LinkHandler;
import com.infomaniak.lib.pdfview.listener.OnAttachCompleteListener;
import com.infomaniak.lib.pdfview.listener.OnDetachCompleteListener;
import com.infomaniak.lib.pdfview.listener.OnDrawListener;
import com.infomaniak.lib.pdfview.listener.OnErrorListener;
import com.infomaniak.lib.pdfview.listener.OnLoadCompleteListener;
import com.infomaniak.lib.pdfview.listener.OnLongPressListener;
import com.infomaniak.lib.pdfview.listener.OnPageChangeListener;
import com.infomaniak.lib.pdfview.listener.OnPageErrorListener;
import com.infomaniak.lib.pdfview.listener.OnPageScrollListener;
import com.infomaniak.lib.pdfview.listener.OnReadyForPrintingListener;
import com.infomaniak.lib.pdfview.listener.OnRenderListener;
import com.infomaniak.lib.pdfview.listener.OnTapListener;
import com.infomaniak.lib.pdfview.model.LinkTapEvent;
import java.util.List;

public class Callbacks {
    private OnReadyForPrintingListener onReadyForPrintingListener;
    private OnLoadCompleteListener onLoadCompleteListener;
    private OnAttachCompleteListener onAttachCompleteListener;
    private OnDetachCompleteListener onDetachCompleteListener;
    private OnErrorListener onErrorListener;
    private OnPageErrorListener onPageErrorListener;
    private OnRenderListener onRenderListener;
    private OnPageChangeListener onPageChangeListener;
    private OnPageScrollListener onPageScrollListener;
    private OnDrawListener onDrawListener;
    private OnDrawListener onDrawAllListener;
    private OnTapListener onTapListener;
    private OnLongPressListener onLongPressListener;
    private LinkHandler linkHandler;

    public void setOnReadyForPrinting(OnReadyForPrintingListener onReadyForPrintingListener) {
        this.onReadyForPrintingListener = onReadyForPrintingListener;
    }

    public void callsOnReadyForPrinting(List<Bitmap> pagesAsBitmaps) {
        if (this.onReadyForPrintingListener != null) {
            this.onReadyForPrintingListener.bitmapsReady(pagesAsBitmaps);
        }
    }

    public void setOnLoadComplete(OnLoadCompleteListener onLoadCompleteListener) {
        this.onLoadCompleteListener = onLoadCompleteListener;
    }

    public void callOnLoadComplete(int pagesCount) {
        if (this.onLoadCompleteListener != null) {
            this.onLoadCompleteListener.loadComplete(pagesCount);
        }
    }

    public void setOnAttachCompleteListener(OnAttachCompleteListener onAttachCompleteListener) {
        this.onAttachCompleteListener = onAttachCompleteListener;
    }

    public void setOnDetachCompleteListener(OnDetachCompleteListener onDetachCompleteListener) {
        this.onDetachCompleteListener = onDetachCompleteListener;
    }

    public void callOnAttachComplete() {
        if (this.onAttachCompleteListener != null) {
            this.onAttachCompleteListener.onAttachComplete();
        }
    }

    public void callOnDetachComplete() {
        if (this.onDetachCompleteListener != null) {
            this.onDetachCompleteListener.onDetachComplete();
        }
    }

    public OnErrorListener getOnError() {
        return this.onErrorListener;
    }

    public void setOnError(OnErrorListener onErrorListener) {
        this.onErrorListener = onErrorListener;
    }

    public void setOnPageError(OnPageErrorListener onPageErrorListener) {
        this.onPageErrorListener = onPageErrorListener;
    }

    public boolean callOnPageError(int page, Throwable error) {
        if (this.onPageErrorListener != null) {
            this.onPageErrorListener.onPageError(page, error);
            return true;
        }
        return false;
    }

    public void setOnRender(OnRenderListener onRenderListener) {
        this.onRenderListener = onRenderListener;
    }

    public void callOnRender(int pagesCount) {
        if (this.onRenderListener != null) {
            this.onRenderListener.onInitiallyRendered(pagesCount);
        }
    }

    public void setOnPageChange(OnPageChangeListener onPageChangeListener) {
        this.onPageChangeListener = onPageChangeListener;
    }

    public void callOnPageChange(int page, int pagesCount) {
        if (this.onPageChangeListener != null) {
            this.onPageChangeListener.onPageChanged(page, pagesCount);
        }
    }

    public void setOnPageScroll(OnPageScrollListener onPageScrollListener) {
        this.onPageScrollListener = onPageScrollListener;
    }

    public void callOnPageScroll(int currentPage, float offset) {
        if (this.onPageScrollListener != null) {
            this.onPageScrollListener.onPageScrolled(currentPage, offset);
        }
    }

    public OnDrawListener getOnDraw() {
        return this.onDrawListener;
    }

    public void setOnDraw(OnDrawListener onDrawListener) {
        this.onDrawListener = onDrawListener;
    }

    public OnDrawListener getOnDrawAll() {
        return this.onDrawAllListener;
    }

    public void setOnDrawAll(OnDrawListener onDrawAllListener) {
        this.onDrawAllListener = onDrawAllListener;
    }

    public void setOnTap(OnTapListener onTapListener) {
        this.onTapListener = onTapListener;
    }

    public boolean callOnTap(MotionEvent event) {
        return this.onTapListener != null && this.onTapListener.onTap(event);
    }

    public void setOnLongPress(OnLongPressListener onLongPressListener) {
        this.onLongPressListener = onLongPressListener;
    }

    public void callOnLongPress(MotionEvent event) {
        if (this.onLongPressListener != null) {
            this.onLongPressListener.onLongPress(event);
        }
    }

    public void setLinkHandler(LinkHandler linkHandler) {
        this.linkHandler = linkHandler;
    }

    public void callLinkHandler(LinkTapEvent event) {
        if (this.linkHandler != null) {
            this.linkHandler.handleLinkEvent(event);
        }
    }

    public void clear() {
        this.onLoadCompleteListener = null;
        this.onErrorListener = null;
        this.onPageErrorListener = null;
        this.onRenderListener = null;
        this.onPageChangeListener = null;
        this.onPageScrollListener = null;
        this.onDrawListener = null;
        this.onDrawAllListener = null;
        this.onTapListener = null;
        this.onLongPressListener = null;
        this.linkHandler = null;
    }
}

