/*
 * Decompiled with CFR 0.152.
 */
package com.infomaniak.lib.pdfview;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.infomaniak.lib.pdfview.PDFView;
import com.infomaniak.lib.pdfview.PdfFile;
import com.infomaniak.lib.pdfview.exception.PageRenderingException;
import com.infomaniak.lib.pdfview.model.PagePart;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 *2\u00020\u0001:\u0003()*B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J>\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fJ\u0006\u0010\u001b\u001a\u00020\u0011J\u0006\u0010\u001c\u001a\u00020\u0011J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/infomaniak/lib/pdfview/RenderingHandler;", "Landroid/os/Handler;", "looper", "Landroid/os/Looper;", "pdfView", "Lcom/infomaniak/lib/pdfview/PDFView;", "<init>", "(Landroid/os/Looper;Lcom/infomaniak/lib/pdfview/PDFView;)V", "renderBounds", "Landroid/graphics/RectF;", "roundedRenderBounds", "Landroid/graphics/Rect;", "renderMatrix", "Landroid/graphics/Matrix;", "running", "", "addRenderingTask", "", "page", "", "renderingSize", "Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingSize;", "thumbnail", "cacheOrder", "bestQuality", "annotationRendering", "isForPrinting", "stop", "start", "handleMessage", "message", "Landroid/os/Message;", "proceed", "Lcom/infomaniak/lib/pdfview/model/PagePart;", "renderingTask", "Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingTask;", "calculateBounds", "width", "height", "pageSliceBounds", "RenderingSize", "RenderingTask", "Companion", "android-pdf-viewer_release"})
public final class RenderingHandler
extends Handler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PDFView pdfView;
    @NotNull
    private final RectF renderBounds;
    @NotNull
    private final Rect roundedRenderBounds;
    @NotNull
    private final Matrix renderMatrix;
    private boolean running;
    public static final int MSG_RENDER_TASK = 1;
    @NotNull
    private static final String TAG;

    public RenderingHandler(@Nullable Looper looper, @NotNull PDFView pdfView) {
        Intrinsics.checkNotNullParameter((Object)((Object)pdfView), (String)"pdfView");
        Looper looper2 = looper;
        Intrinsics.checkNotNull((Object)looper2);
        super(looper2);
        this.pdfView = pdfView;
        this.renderBounds = new RectF();
        this.roundedRenderBounds = new Rect();
        this.renderMatrix = new Matrix();
    }

    public final void addRenderingTask(int page, @NotNull RenderingSize renderingSize, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering, boolean isForPrinting) {
        Intrinsics.checkNotNullParameter((Object)renderingSize, (String)"renderingSize");
        RenderingTask task = new RenderingTask(renderingSize, page, thumbnail, cacheOrder, bestQuality, annotationRendering, isForPrinting);
        Message message = this.obtainMessage(1, task);
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"obtainMessage(...)");
        Message msg = message;
        this.sendMessage(msg);
    }

    public final void stop() {
        this.running = false;
    }

    public final void start() {
        this.running = true;
    }

    public void handleMessage(@NotNull Message message) {
        block7: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            PDFView $this$handleMessage_u24lambda_u245 = this.pdfView;
            boolean bl = false;
            Object object2 = message.obj;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.infomaniak.lib.pdfview.RenderingHandler.RenderingTask");
            RenderingTask task = (RenderingTask)object2;
            Object object3 = $this$handleMessage_u24lambda_u245;
            try {
                Object object4;
                PDFView $this$handleMessage_u24lambda_u245_u24lambda_u242 = object3;
                boolean bl2 = false;
                PagePart pagePart = this.proceed(task);
                if (pagePart != null) {
                    PagePart pagePart2 = pagePart;
                    boolean bl3 = false;
                    if (this.running) {
                        object4 = $this$handleMessage_u24lambda_u245_u24lambda_u242.post(() -> RenderingHandler.handleMessage$lambda$5$lambda$2$lambda$1$lambda$0($this$handleMessage_u24lambda_u245_u24lambda_u242, pagePart2, task));
                    } else {
                        pagePart2.getRenderedBitmap().recycle();
                        object4 = Unit.INSTANCE;
                    }
                } else {
                    object4 = null;
                }
                object = Result.constructor-impl(object4);
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object3 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable == null) break block7;
            Object exception = object = throwable;
            boolean bl4 = false;
            if (exception instanceof PageRenderingException) {
                $this$handleMessage_u24lambda_u245.post(() -> RenderingHandler.handleMessage$lambda$5$lambda$4$lambda$3($this$handleMessage_u24lambda_u245, (Throwable)exception));
            }
        }
    }

    private final PagePart proceed(RenderingTask renderingTask) throws PageRenderingException {
        Object $this$proceed_u24lambda_u246;
        PdfFile pdfFile = this.pdfView.pdfFile;
        pdfFile.openPage(renderingTask.getPage());
        int w = Math.round(renderingTask.getRenderingSize().getWidth());
        int h = Math.round(renderingTask.getRenderingSize().getHeight());
        if (w == 0 || h == 0 || pdfFile.pageHasError(renderingTask.getPage())) {
            return null;
        }
        Bitmap render = null;
        RenderingHandler renderingHandler = this;
        try {
            $this$proceed_u24lambda_u246 = renderingHandler;
            boolean bl = false;
            $this$proceed_u24lambda_u246 = Result.constructor-impl((Object)Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)(renderingTask.getBestQuality() ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565)));
        }
        catch (Throwable bl) {
            $this$proceed_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        renderingHandler = $this$proceed_u24lambda_u246;
        if (Result.isSuccess-impl((Object)((Object)renderingHandler))) {
            Bitmap renderedBitmap = (Bitmap)renderingHandler;
            boolean bl = false;
            render = renderedBitmap;
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)((Object)renderingHandler));
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            Log.e((String)TAG, (String)"Cannot create bitmap", (Throwable)it);
            render = null;
        }
        this.calculateBounds(w, h, renderingTask.getRenderingSize().getBounds());
        pdfFile.renderPageBitmap(render, renderingTask.getPage(), this.roundedRenderBounds, renderingTask.getAnnotationRendering());
        return new PagePart(renderingTask.getPage(), render, renderingTask.getRenderingSize().getBounds(), renderingTask.getThumbnail(), renderingTask.getCacheOrder());
    }

    private final void calculateBounds(int width, int height, RectF pageSliceBounds) {
        this.renderMatrix.reset();
        this.renderMatrix.postTranslate(-pageSliceBounds.left * (float)width, -pageSliceBounds.top * (float)height);
        this.renderMatrix.postScale(1.0f / pageSliceBounds.width(), 1.0f / pageSliceBounds.height());
        this.renderBounds.set(0.0f, 0.0f, (float)width, (float)height);
        this.renderMatrix.mapRect(this.renderBounds);
        this.renderBounds.round(this.roundedRenderBounds);
    }

    private static final void handleMessage$lambda$5$lambda$2$lambda$1$lambda$0(PDFView $this_runCatching, PagePart $pagePart, RenderingTask $task) {
        $this_runCatching.onBitmapRendered($pagePart, $task.isForPrinting());
    }

    private static final void handleMessage$lambda$5$lambda$4$lambda$3(PDFView $this_with, Throwable $exception) {
        $this_with.onPageError((PageRenderingException)$exception);
    }

    static {
        String string = RenderingHandler.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        TAG = string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/infomaniak/lib/pdfview/RenderingHandler$Companion;", "", "<init>", "()V", "MSG_RENDER_TASK", "", "TAG", "", "android-pdf-viewer_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingSize;", "", "width", "", "height", "bounds", "Landroid/graphics/RectF;", "<init>", "(FFLandroid/graphics/RectF;)V", "getWidth", "()F", "setWidth", "(F)V", "getHeight", "setHeight", "getBounds", "()Landroid/graphics/RectF;", "setBounds", "(Landroid/graphics/RectF;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android-pdf-viewer_release"})
    public static final class RenderingSize {
        private float width;
        private float height;
        @NotNull
        private RectF bounds;

        public RenderingSize(float width, float height, @NotNull RectF bounds) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            this.width = width;
            this.height = height;
            this.bounds = bounds;
        }

        public final float getWidth() {
            return this.width;
        }

        public final void setWidth(float f) {
            this.width = f;
        }

        public final float getHeight() {
            return this.height;
        }

        public final void setHeight(float f) {
            this.height = f;
        }

        @NotNull
        public final RectF getBounds() {
            return this.bounds;
        }

        public final void setBounds(@NotNull RectF rectF) {
            Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
            this.bounds = rectF;
        }

        public final float component1() {
            return this.width;
        }

        public final float component2() {
            return this.height;
        }

        @NotNull
        public final RectF component3() {
            return this.bounds;
        }

        @NotNull
        public final RenderingSize copy(float width, float height, @NotNull RectF bounds) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            return new RenderingSize(width, height, bounds);
        }

        public static /* synthetic */ RenderingSize copy$default(RenderingSize renderingSize, float f, float f2, RectF rectF, int n, Object object) {
            if ((n & 1) != 0) {
                f = renderingSize.width;
            }
            if ((n & 2) != 0) {
                f2 = renderingSize.height;
            }
            if ((n & 4) != 0) {
                rectF = renderingSize.bounds;
            }
            return renderingSize.copy(f, f2, rectF);
        }

        @NotNull
        public String toString() {
            return "RenderingSize(width=" + this.width + ", height=" + this.height + ", bounds=" + this.bounds + ")";
        }

        public int hashCode() {
            int result = Float.hashCode(this.width);
            result = result * 31 + Float.hashCode(this.height);
            result = result * 31 + this.bounds.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenderingSize)) {
                return false;
            }
            RenderingSize renderingSize = (RenderingSize)other;
            if (Float.compare(this.width, renderingSize.width) != 0) {
                return false;
            }
            if (Float.compare(this.height, renderingSize.height) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bounds, (Object)renderingSize.bounds);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b%\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J\t\u0010&\u001a\u00020\u0007H\u00c6\u0003J\t\u0010'\u001a\u00020\u0007H\u00c6\u0003JO\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010)\u001a\u00020\u00072\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0017\"\u0004\b \u0010\u0019\u00a8\u0006."}, d2={"Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingTask;", "", "renderingSize", "Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingSize;", "page", "", "thumbnail", "", "cacheOrder", "bestQuality", "annotationRendering", "isForPrinting", "<init>", "(Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingSize;IZIZZZ)V", "getRenderingSize", "()Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingSize;", "setRenderingSize", "(Lcom/infomaniak/lib/pdfview/RenderingHandler$RenderingSize;)V", "getPage", "()I", "setPage", "(I)V", "getThumbnail", "()Z", "setThumbnail", "(Z)V", "getCacheOrder", "setCacheOrder", "getBestQuality", "setBestQuality", "getAnnotationRendering", "setAnnotationRendering", "setForPrinting", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "android-pdf-viewer_release"})
    private static final class RenderingTask {
        @NotNull
        private RenderingSize renderingSize;
        private int page;
        private boolean thumbnail;
        private int cacheOrder;
        private boolean bestQuality;
        private boolean annotationRendering;
        private boolean isForPrinting;

        public RenderingTask(@NotNull RenderingSize renderingSize, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering, boolean isForPrinting) {
            Intrinsics.checkNotNullParameter((Object)renderingSize, (String)"renderingSize");
            this.renderingSize = renderingSize;
            this.page = page;
            this.thumbnail = thumbnail;
            this.cacheOrder = cacheOrder;
            this.bestQuality = bestQuality;
            this.annotationRendering = annotationRendering;
            this.isForPrinting = isForPrinting;
        }

        @NotNull
        public final RenderingSize getRenderingSize() {
            return this.renderingSize;
        }

        public final void setRenderingSize(@NotNull RenderingSize renderingSize) {
            Intrinsics.checkNotNullParameter((Object)renderingSize, (String)"<set-?>");
            this.renderingSize = renderingSize;
        }

        public final int getPage() {
            return this.page;
        }

        public final void setPage(int n) {
            this.page = n;
        }

        public final boolean getThumbnail() {
            return this.thumbnail;
        }

        public final void setThumbnail(boolean bl) {
            this.thumbnail = bl;
        }

        public final int getCacheOrder() {
            return this.cacheOrder;
        }

        public final void setCacheOrder(int n) {
            this.cacheOrder = n;
        }

        public final boolean getBestQuality() {
            return this.bestQuality;
        }

        public final void setBestQuality(boolean bl) {
            this.bestQuality = bl;
        }

        public final boolean getAnnotationRendering() {
            return this.annotationRendering;
        }

        public final void setAnnotationRendering(boolean bl) {
            this.annotationRendering = bl;
        }

        public final boolean isForPrinting() {
            return this.isForPrinting;
        }

        public final void setForPrinting(boolean bl) {
            this.isForPrinting = bl;
        }

        @NotNull
        public final RenderingSize component1() {
            return this.renderingSize;
        }

        public final int component2() {
            return this.page;
        }

        public final boolean component3() {
            return this.thumbnail;
        }

        public final int component4() {
            return this.cacheOrder;
        }

        public final boolean component5() {
            return this.bestQuality;
        }

        public final boolean component6() {
            return this.annotationRendering;
        }

        public final boolean component7() {
            return this.isForPrinting;
        }

        @NotNull
        public final RenderingTask copy(@NotNull RenderingSize renderingSize, int page, boolean thumbnail, int cacheOrder, boolean bestQuality, boolean annotationRendering, boolean isForPrinting) {
            Intrinsics.checkNotNullParameter((Object)renderingSize, (String)"renderingSize");
            return new RenderingTask(renderingSize, page, thumbnail, cacheOrder, bestQuality, annotationRendering, isForPrinting);
        }

        public static /* synthetic */ RenderingTask copy$default(RenderingTask renderingTask, RenderingSize renderingSize, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4, int n3, Object object) {
            if ((n3 & 1) != 0) {
                renderingSize = renderingTask.renderingSize;
            }
            if ((n3 & 2) != 0) {
                n = renderingTask.page;
            }
            if ((n3 & 4) != 0) {
                bl = renderingTask.thumbnail;
            }
            if ((n3 & 8) != 0) {
                n2 = renderingTask.cacheOrder;
            }
            if ((n3 & 0x10) != 0) {
                bl2 = renderingTask.bestQuality;
            }
            if ((n3 & 0x20) != 0) {
                bl3 = renderingTask.annotationRendering;
            }
            if ((n3 & 0x40) != 0) {
                bl4 = renderingTask.isForPrinting;
            }
            return renderingTask.copy(renderingSize, n, bl, n2, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "RenderingTask(renderingSize=" + this.renderingSize + ", page=" + this.page + ", thumbnail=" + this.thumbnail + ", cacheOrder=" + this.cacheOrder + ", bestQuality=" + this.bestQuality + ", annotationRendering=" + this.annotationRendering + ", isForPrinting=" + this.isForPrinting + ")";
        }

        public int hashCode() {
            int result = this.renderingSize.hashCode();
            result = result * 31 + Integer.hashCode(this.page);
            result = result * 31 + Boolean.hashCode(this.thumbnail);
            result = result * 31 + Integer.hashCode(this.cacheOrder);
            result = result * 31 + Boolean.hashCode(this.bestQuality);
            result = result * 31 + Boolean.hashCode(this.annotationRendering);
            result = result * 31 + Boolean.hashCode(this.isForPrinting);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RenderingTask)) {
                return false;
            }
            RenderingTask renderingTask = (RenderingTask)other;
            if (!Intrinsics.areEqual((Object)this.renderingSize, (Object)renderingTask.renderingSize)) {
                return false;
            }
            if (this.page != renderingTask.page) {
                return false;
            }
            if (this.thumbnail != renderingTask.thumbnail) {
                return false;
            }
            if (this.cacheOrder != renderingTask.cacheOrder) {
                return false;
            }
            if (this.bestQuality != renderingTask.bestQuality) {
                return false;
            }
            if (this.annotationRendering != renderingTask.annotationRendering) {
                return false;
            }
            return this.isForPrinting == renderingTask.isForPrinting;
        }
    }
}

