/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview.toolkit;

import android.widget.ListView;
import de.codecrafters.tableview.TableView;
import de.codecrafters.tableview.listeners.OnScrollListener;

public class TableHeaderCollapseOnScrollListener
implements OnScrollListener {
    private final TableView tableView;
    private int previousFirstVisibleItem = 0;
    private boolean headerVisible;
    private int animationDuration = 0;
    private int rowOffset = 2;

    public TableHeaderCollapseOnScrollListener(TableView tableView) {
        this.tableView = tableView;
        this.headerVisible = tableView.isHeaderVisible();
    }

    public void setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }

    @Override
    public void onScroll(ListView tableDataView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem > this.previousFirstVisibleItem && firstVisibleItem - this.previousFirstVisibleItem >= this.rowOffset && this.headerVisible) {
            this.tableView.setHeaderVisible(false, this.animationDuration);
            this.headerVisible = false;
            this.previousFirstVisibleItem = firstVisibleItem;
        } else if (firstVisibleItem < this.previousFirstVisibleItem && this.previousFirstVisibleItem - firstVisibleItem >= this.rowOffset && !this.headerVisible) {
            this.tableView.setHeaderVisible(true, this.animationDuration);
            this.headerVisible = true;
            this.previousFirstVisibleItem = firstVisibleItem;
        }
        if (firstVisibleItem > this.previousFirstVisibleItem && !this.headerVisible) {
            this.previousFirstVisibleItem = firstVisibleItem;
        } else if (firstVisibleItem < this.previousFirstVisibleItem && this.headerVisible) {
            this.previousFirstVisibleItem = firstVisibleItem;
        }
    }

    @Override
    public void onScrollStateChanged(ListView tableDateView, OnScrollListener.ScrollState scrollState) {
    }
}

