/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.content.res.Resources;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.codecrafters.tableview.model.TableColumnModel;
import de.codecrafters.tableview.model.TableColumnWeightModel;

public abstract class TableHeaderAdapter
extends ArrayAdapter {
    private final Context context;
    private TableColumnModel columnModel;

    public TableHeaderAdapter(Context context) {
        this(context, 0);
    }

    protected TableHeaderAdapter(Context context, int columnCount) {
        this(context, new TableColumnWeightModel(columnCount));
    }

    protected TableHeaderAdapter(Context context, TableColumnModel columnModel) {
        super(context, 0);
        this.context = context;
        this.columnModel = columnModel;
    }

    public Context getContext() {
        return this.context;
    }

    public LayoutInflater getLayoutInflater() {
        return (LayoutInflater)this.getContext().getSystemService("layout_inflater");
    }

    public Resources getResources() {
        return this.getContext().getResources();
    }

    protected TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    protected void setColumnModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    protected int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    protected void setColumnCount(int columnCount) {
        this.columnModel.setColumnCount(columnCount);
    }

    public int getCount() {
        return 1;
    }

    public final View getView(int position, View convertView, ViewGroup parent) {
        LinearLayout rowView = new LinearLayout(this.getContext());
        AbsListView.LayoutParams rowLayoutParams = new AbsListView.LayoutParams(-1, -2);
        rowView.setLayoutParams((ViewGroup.LayoutParams)rowLayoutParams);
        rowView.setGravity(16);
        int tableWidth = parent.getWidth();
        for (int columnIndex = 0; columnIndex < this.getColumnModel().getColumnCount(); ++columnIndex) {
            View cellView = this.getHeaderView(columnIndex, (ViewGroup)rowView);
            if (cellView == null) {
                cellView = new TextView(this.getContext());
            }
            int cellWidth = this.getColumnModel().getColumnWidth(columnIndex, tableWidth);
            LinearLayout.LayoutParams cellLayoutParams = new LinearLayout.LayoutParams(cellWidth, -2);
            cellView.setLayoutParams((ViewGroup.LayoutParams)cellLayoutParams);
            rowView.addView(cellView);
        }
        return rowView;
    }

    public abstract View getHeaderView(int var1, ViewGroup var2);
}

