/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import de.codecrafters.tableview.SortState;
import de.codecrafters.tableview.SortableTableHeaderView;
import de.codecrafters.tableview.SortingOrder;
import de.codecrafters.tableview.SortingStatus;
import de.codecrafters.tableview.TableDataAdapter;
import de.codecrafters.tableview.TableView;
import de.codecrafters.tableview.listeners.SortingStatusChangeListener;
import de.codecrafters.tableview.listeners.TableHeaderClickListener;
import de.codecrafters.tableview.providers.SortStateViewProvider;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SortableTableView<T>
extends TableView<T> {
    private static final String LOG_TAG = SortableTableView.class.getName();
    private static final String SAVED_STATE_SUPER_STATE = "SAVED_STATE_SUPER";
    private static final String SAVED_STATE_SORTED_DIRECTION = "SAVED_STATE_SORTED_DIRECTION";
    private static final String SAVED_STATE_SORTED_COLUMN = "SAVED_STATE_SORTED_COLUMN";
    private final SortableTableHeaderView sortableTableHeaderView;
    private final SortingController sortingController;

    public SortableTableView(Context context) {
        this(context, null);
    }

    public SortableTableView(Context context, AttributeSet attributes) {
        this(context, attributes, 16842868);
    }

    public SortableTableView(Context context, AttributeSet attributes, int styleAttributes) {
        super(context, attributes, styleAttributes);
        this.sortableTableHeaderView = new SortableTableHeaderView(context);
        this.sortableTableHeaderView.setBackgroundColor(-3355444);
        this.setHeaderView(this.sortableTableHeaderView);
        this.sortingController = new SortingController();
        this.sortableTableHeaderView.addHeaderClickListener(this.sortingController);
    }

    @Override
    public void setDataAdapter(TableDataAdapter<T> dataAdapter) {
        dataAdapter.registerDataSetObserver(new RecapSortingDataSetObserver());
        super.setDataAdapter(dataAdapter);
    }

    public void setColumnComparator(int columnIndex, Comparator<T> columnComparator) {
        this.sortingController.setComparator(columnIndex, columnComparator);
    }

    public SortStateViewProvider getHeaderSortStateViewProvider() {
        return this.sortableTableHeaderView.getSortStateViewProvider();
    }

    public void setHeaderSortStateViewProvider(SortStateViewProvider provider) {
        this.sortableTableHeaderView.setSortStateViewProvider(provider);
    }

    public Comparator<T> getColumnComparator(int columnIndex) {
        return this.sortingController.getRawComparator(columnIndex);
    }

    public void sort(int columnIndex) {
        this.sortingController.onHeaderClicked(columnIndex);
    }

    @Deprecated
    public void sort(int columnIndex, boolean sortAscending) {
        SortingOrder sortingOrder = sortAscending ? SortingOrder.ASCENDING : SortingOrder.DESCENDING;
        this.sortingController.sort(columnIndex, sortingOrder);
    }

    public void sort(int columnIndex, SortingOrder sortingOrder) {
        this.sortingController.sort(columnIndex, sortingOrder);
    }

    public SortingStatus getSortingStatus() {
        return this.sortingController.sortingStatus;
    }

    public boolean addSortingStatusChangeListener(SortingStatusChangeListener listener) {
        return this.sortingController.sortingStatusListeners.add(listener);
    }

    public boolean removeSortingStatusChangeListener(SortingStatusChangeListener listener) {
        return this.sortingController.sortingStatusListeners.remove(listener);
    }

    public void sort(Comparator<T> comparator) {
        this.sortingController.sortDataSFCT(comparator);
    }

    protected Parcelable onSaveInstanceState() {
        Bundle state = new Bundle();
        state.putParcelable(SAVED_STATE_SUPER_STATE, super.onSaveInstanceState());
        state.putSerializable(SAVED_STATE_SORTED_DIRECTION, (Serializable)((Object)this.sortingController.sortingStatus.getSortedOrder()));
        state.putInt(SAVED_STATE_SORTED_COLUMN, this.sortingController.sortingStatus.getSortedColumnIndex());
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle savedState = (Bundle)state;
            Parcelable superState = savedState.getParcelable(SAVED_STATE_SUPER_STATE);
            SortingOrder sortingOrder = (SortingOrder)((Object)savedState.getSerializable(SAVED_STATE_SORTED_DIRECTION));
            int sortedColumnIndex = savedState.getInt(SAVED_STATE_SORTED_COLUMN, -1);
            super.onRestoreInstanceState(superState);
            if (sortedColumnIndex != -1) {
                this.sortingController.sort(sortedColumnIndex, sortingOrder);
            }
        }
    }

    private class RecapSortingDataSetObserver
    extends DataSetObserver {
        private boolean initializedByMyself = false;

        private RecapSortingDataSetObserver() {
        }

        public void onChanged() {
            if (this.initializedByMyself) {
                this.initializedByMyself = false;
            } else {
                this.initializedByMyself = true;
                SortableTableView.this.sortingController.recapSorting();
            }
        }
    }

    private class SortingController
    implements TableHeaderClickListener {
        private final Set<SortingStatusChangeListener> sortingStatusListeners = new HashSet<SortingStatusChangeListener>();
        private final SparseArray<Comparator<T>> comparators = new SparseArray();
        private final SortingStatus sortingStatus = new SortingStatus();
        private Comparator<T> sortedColumnComparator;

        private SortingController() {
        }

        @Override
        public void onHeaderClicked(int columnIndex) {
            if (this.comparators.get(columnIndex) == null) {
                Log.i((String)LOG_TAG, (String)("Unable to sort column with index " + columnIndex + ". Reason: no comparator set for this column."));
                return;
            }
            SortingOrder sortingOrder = this.getSortingOrder(columnIndex);
            this.sortedColumnComparator = this.getComparator(columnIndex, sortingOrder);
            this.sortingStatus.setSortedColumnIndex(columnIndex);
            this.sortingStatus.setSortedOrder(sortingOrder);
            this.sortDataSFCT(this.sortedColumnComparator);
            this.setSortView(columnIndex);
            this.notifySortingStatusListeners();
        }

        private void notifySortingStatusListeners() {
            for (SortingStatusChangeListener sortingStatusListener : this.sortingStatusListeners) {
                sortingStatusListener.onSortingStatusChanged(this.sortingStatus);
            }
        }

        private SortingOrder getSortingOrder(int columnIndex) {
            if (this.sortingStatus.getSortedColumnIndex() == columnIndex && this.sortingStatus.getSortedOrder() == SortingOrder.ASCENDING) {
                return SortingOrder.DESCENDING;
            }
            return SortingOrder.ASCENDING;
        }

        public void sort(int columnIndex, SortingOrder sortingOrder) {
            if (this.comparators.get(columnIndex) == null) {
                Log.i((String)LOG_TAG, (String)("Unable to sort column with index " + columnIndex + ". Reason: no comparator set for this column."));
                return;
            }
            Comparator columnComparator = (Comparator)this.comparators.get(columnIndex);
            if (sortingOrder == SortingOrder.DESCENDING) {
                columnComparator = Collections.reverseOrder(columnComparator);
            }
            this.sortedColumnComparator = columnComparator;
            this.sortingStatus.setSortedColumnIndex(columnIndex);
            this.sortingStatus.setSortedOrder(sortingOrder);
            this.sortDataSFCT(columnComparator);
            this.setSortView(columnIndex);
        }

        private void setSortView(int columnIndex) {
            SortableTableView.this.sortableTableHeaderView.resetSortViews();
            if (this.sortingStatus.getSortedOrder() == SortingOrder.ASCENDING) {
                SortableTableView.this.sortableTableHeaderView.setSortState(columnIndex, SortState.SORTED_ASC);
            } else {
                SortableTableView.this.sortableTableHeaderView.setSortState(columnIndex, SortState.SORTED_DESC);
            }
        }

        private void recapSorting() {
            this.sortDataSFCT(this.sortedColumnComparator);
        }

        private void sortDataSFCT(Comparator<T> comparator) {
            if (comparator != null) {
                List data = SortableTableView.this.getDataAdapter().getData();
                Collections.sort(data, comparator);
                SortableTableView.this.getDataAdapter().notifyDataSetChanged();
            }
        }

        private Comparator<T> getRawComparator(int columnIndex) {
            return (Comparator)this.comparators.get(columnIndex);
        }

        private Comparator<T> getComparator(int columnIndex, SortingOrder sortingOrder) {
            Comparator columnComparator = (Comparator)this.comparators.get(columnIndex);
            if (sortingOrder == SortingOrder.ASCENDING) {
                return columnComparator;
            }
            return Collections.reverseOrder(columnComparator);
        }

        public void setComparator(int columnIndex, Comparator<T> columnComparator) {
            if (columnComparator == null) {
                this.comparators.remove(columnIndex);
                SortableTableView.this.sortableTableHeaderView.setSortState(columnIndex, SortState.NOT_SORTABLE);
            } else {
                this.comparators.put(columnIndex, columnComparator);
                SortableTableView.this.sortableTableHeaderView.setSortState(columnIndex, SortState.SORTABLE);
            }
        }
    }
}

