/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.content.res.Resources;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.codecrafters.tableview.InternalHeaderClickListener;
import de.codecrafters.tableview.R;
import de.codecrafters.tableview.SortState;
import de.codecrafters.tableview.TableHeaderAdapter;
import de.codecrafters.tableview.TableHeaderView;
import de.codecrafters.tableview.model.TableColumnModel;
import de.codecrafters.tableview.providers.SortStateViewProvider;
import de.codecrafters.tableview.toolkit.SortStateViewProviders;

class SortableTableHeaderView
extends TableHeaderView {
    private final SparseArray<ImageView> sortViews = new SparseArray();
    private final SparseArray<SortState> sortStates = new SparseArray();
    private SortStateViewProvider sortStateViewProvider = SortStateViewProviders.darkArrows();

    public SortableTableHeaderView(Context context) {
        super(context);
    }

    public void resetSortViews() {
        int columnIndex;
        int i;
        for (i = 0; i < this.sortStates.size(); ++i) {
            columnIndex = this.sortStates.keyAt(i);
            SortState columnSortState = (SortState)((Object)this.sortStates.get(columnIndex));
            if (columnSortState != SortState.NOT_SORTABLE) {
                columnSortState = SortState.SORTABLE;
            }
            this.sortStates.put(columnIndex, (Object)columnSortState);
        }
        for (i = 0; i < this.sortStates.size(); ++i) {
            columnIndex = this.sortStates.keyAt(i);
            ImageView sortView = (ImageView)this.sortViews.get(columnIndex);
            SortState sortState = (SortState)((Object)this.sortStates.get(columnIndex));
            this.setSortStateToView(sortState, sortView);
        }
    }

    @Override
    public void setAdapter(TableHeaderAdapter adapter) {
        super.setAdapter(new SortStateArrayAdapter(adapter));
    }

    public void setSortState(int columnIndex, SortState sortState) {
        this.sortStates.put(columnIndex, (Object)sortState);
        this.invalidate();
    }

    private void setSortStateToView(SortState state, ImageView view) {
        if (view != null) {
            int imageRes = this.sortStateViewProvider.getSortStateViewResource(state);
            view.setImageResource(imageRes);
            if (imageRes == 0) {
                view.setVisibility(8);
            } else {
                view.setVisibility(0);
            }
        }
    }

    public SortStateViewProvider getSortStateViewProvider() {
        return this.sortStateViewProvider;
    }

    public void setSortStateViewProvider(SortStateViewProvider provider) {
        this.sortStateViewProvider = provider;
        this.invalidate();
    }

    @Override
    public void invalidate() {
        if (this.getAdapter() != null) {
            this.getAdapter().notifyDataSetChanged();
        }
        super.invalidate();
    }

    @Override
    public TableHeaderAdapter getAdapter() {
        if (super.getAdapter() instanceof SortStateArrayAdapter) {
            return ((SortStateArrayAdapter)super.getAdapter()).delegate;
        }
        return super.getAdapter();
    }

    private class SortStateArrayAdapter
    extends TableHeaderAdapter {
        private final TableHeaderAdapter delegate;

        public SortStateArrayAdapter(TableHeaderAdapter delegate) {
            super(delegate.getContext());
            this.delegate = delegate;
        }

        @Override
        public Context getContext() {
            return this.delegate.getContext();
        }

        @Override
        public LayoutInflater getLayoutInflater() {
            return this.delegate.getLayoutInflater();
        }

        @Override
        public Resources getResources() {
            return this.delegate.getResources();
        }

        @Override
        public TableColumnModel getColumnModel() {
            return this.delegate.getColumnModel();
        }

        @Override
        public void setColumnModel(TableColumnModel columnModel) {
            this.delegate.setColumnModel(columnModel);
        }

        @Override
        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        @Override
        public void setColumnCount(int columnCount) {
            this.delegate.setColumnCount(columnCount);
        }

        @Override
        public int getCount() {
            return this.delegate.getCount();
        }

        @Override
        public View getHeaderView(int columnIndex, ViewGroup parentView) {
            LinearLayout headerLayout = (LinearLayout)this.delegate.getLayoutInflater().inflate(R.layout.sortable_header, parentView, false);
            headerLayout.setOnClickListener((View.OnClickListener)new InternalHeaderClickListener(columnIndex, SortableTableHeaderView.this.getHeaderClickListeners()));
            View headerView = this.delegate.getHeaderView(columnIndex, (ViewGroup)headerLayout);
            if (headerView == null) {
                headerView = new TextView(this.getContext());
            }
            ((FrameLayout)headerLayout.findViewById(R.id.container)).addView(headerView);
            ImageView sortView = (ImageView)headerLayout.findViewById(R.id.sort_view);
            SortableTableHeaderView.this.sortViews.put(columnIndex, (Object)sortView);
            SortState sortState = (SortState)((Object)SortableTableHeaderView.this.sortStates.get(columnIndex));
            if (sortState == null) {
                sortState = SortState.NOT_SORTABLE;
                SortableTableHeaderView.this.sortStates.put(columnIndex, (Object)sortState);
            }
            SortableTableHeaderView.this.setSortStateToView(sortState, sortView);
            return headerLayout;
        }
    }
}

