/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.codecrafters.tableview.InternalHeaderClickListener;
import de.codecrafters.tableview.TableHeaderAdapter;
import de.codecrafters.tableview.listeners.TableHeaderClickListener;
import java.util.HashSet;
import java.util.Set;

class TableHeaderView
extends LinearLayout {
    private final Set<TableHeaderClickListener> listeners = new HashSet<TableHeaderClickListener>();
    protected TableHeaderAdapter adapter;

    public TableHeaderView(Context context) {
        super(context);
        this.setOrientation(0);
        this.setGravity(16);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (right - left != oldRight - oldLeft) {
                    System.out.println("was resized");
                    TableHeaderView.this.renderHeaderViews();
                }
            }
        });
    }

    public void setAdapter(TableHeaderAdapter adapter) {
        this.adapter = adapter;
        this.renderHeaderViews();
    }

    public void invalidate() {
        this.renderHeaderViews();
        super.invalidate();
    }

    protected void renderHeaderViews() {
        this.removeAllViews();
        int tableWidth = 0;
        if (this.getParent() instanceof View) {
            tableWidth = ((View)this.getParent()).getWidth();
        }
        for (int columnIndex = 0; columnIndex < this.adapter.getColumnCount(); ++columnIndex) {
            View headerView = this.adapter.getHeaderView(columnIndex, (ViewGroup)this);
            if (headerView == null) {
                headerView = new TextView(this.getContext());
            }
            headerView.setOnClickListener((View.OnClickListener)new InternalHeaderClickListener(columnIndex, this.getHeaderClickListeners()));
            int width = this.adapter.getColumnModel().getColumnWidth(columnIndex, tableWidth);
            int height = -2;
            LinearLayout.LayoutParams headerLayoutParams = new LinearLayout.LayoutParams(width, -2);
            this.addView(headerView, (ViewGroup.LayoutParams)headerLayoutParams);
        }
    }

    protected Set<TableHeaderClickListener> getHeaderClickListeners() {
        return this.listeners;
    }

    public void addHeaderClickListener(TableHeaderClickListener listener) {
        this.listeners.add(listener);
    }

    public void removeHeaderClickListener(TableHeaderClickListener listener) {
        this.listeners.remove(listener);
    }
}

