/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.codecrafters.tableview.TableColumnModel;
import de.codecrafters.tableview.providers.TableDataRowBackgroundProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class TableDataAdapter<T>
extends ArrayAdapter<T> {
    private static final String LOG_TAG = TableDataAdapter.class.getName();
    private final List<T> data;
    private TableColumnModel columnModel;
    private TableDataRowBackgroundProvider<? super T> rowBackgroundProvider;

    public TableDataAdapter(Context context, T[] data) {
        this(context, 0, new ArrayList<T>(Arrays.asList(data)));
    }

    public TableDataAdapter(Context context, List<T> data) {
        this(context, 0, data);
    }

    protected TableDataAdapter(Context context, int columnCount, List<T> data) {
        this(context, new TableColumnModel(columnCount), data);
    }

    protected TableDataAdapter(Context context, TableColumnModel columnModel, List<T> data) {
        super(context, -1, data);
        this.columnModel = columnModel;
        this.data = data;
    }

    public T getRowData(int rowIndex) {
        return (T)this.getItem(rowIndex);
    }

    public List<T> getData() {
        return this.data;
    }

    public Context getContext() {
        return super.getContext();
    }

    public LayoutInflater getLayoutInflater() {
        return (LayoutInflater)this.getContext().getSystemService("layout_inflater");
    }

    public Resources getResources() {
        return this.getContext().getResources();
    }

    public abstract View getCellView(int var1, int var2, ViewGroup var3);

    public final View getView(int rowIndex, View convertView, ViewGroup parent) {
        LinearLayout rowView = new LinearLayout(this.getContext());
        AbsListView.LayoutParams rowLayoutParams = new AbsListView.LayoutParams(-1, -2);
        rowView.setLayoutParams((ViewGroup.LayoutParams)rowLayoutParams);
        rowView.setGravity(16);
        Object rowData = null;
        try {
            rowData = this.getItem(rowIndex);
        }
        catch (IndexOutOfBoundsException e) {
            Log.w((String)LOG_TAG, (String)("No row date available for row with index " + rowIndex + ". " + "Caught Exception: " + e.getMessage()));
        }
        if (Build.VERSION.SDK_INT < 16) {
            rowView.setBackgroundDrawable(this.rowBackgroundProvider.getRowBackground(rowIndex, rowData));
        } else {
            rowView.setBackground(this.rowBackgroundProvider.getRowBackground(rowIndex, rowData));
        }
        int widthUnit = parent.getWidth() / this.columnModel.getColumnWeightSum();
        for (int columnIndex = 0; columnIndex < this.getColumnCount(); ++columnIndex) {
            View cellView = this.getCellView(rowIndex, columnIndex, (ViewGroup)rowView);
            if (cellView == null) {
                cellView = new TextView(this.getContext());
            }
            int width = widthUnit * this.columnModel.getColumnWeight(columnIndex);
            LinearLayout.LayoutParams cellLayoutParams = new LinearLayout.LayoutParams(width, -2);
            cellLayoutParams.weight = this.columnModel.getColumnWeight(columnIndex);
            cellView.setLayoutParams((ViewGroup.LayoutParams)cellLayoutParams);
            rowView.addView(cellView);
        }
        return rowView;
    }

    protected void setRowBackgroundProvider(TableDataRowBackgroundProvider<? super T> rowbackgroundProvider) {
        this.rowBackgroundProvider = rowbackgroundProvider;
    }

    protected TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    protected void setColumnModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    protected int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    protected void setColumnCount(int columnCount) {
        this.columnModel.setColumnCount(columnCount);
    }

    protected void setColumnWeight(int columnIndex, int columnWeight) {
        this.columnModel.setColumnWeight(columnIndex, columnWeight);
    }

    protected int getColumnWeight(int columnIndex) {
        return this.columnModel.getColumnWeight(columnIndex);
    }

    protected int getColumnWeightSum() {
        return this.columnModel.getColumnWeightSum();
    }
}

