/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview.toolkit;

import de.codecrafters.tableview.R;
import de.codecrafters.tableview.SortState;
import de.codecrafters.tableview.providers.SortStateViewProvider;

public final class SortStateViewProviders {
    public static SortStateViewProvider darkArrows() {
        return new DarkSortStateViewProvider();
    }

    public static SortStateViewProvider brightArrows() {
        return new BrightSortStateViewProvider();
    }

    private static class BrightSortStateViewProvider
    implements SortStateViewProvider {
        private BrightSortStateViewProvider() {
        }

        @Override
        public int getSortStateViewResource(SortState state) {
            switch (state) {
                case SORTABLE: {
                    return R.mipmap.ic_light_sortable;
                }
                case SORTED_ASC: {
                    return R.mipmap.ic_light_sorted_asc;
                }
                case SORTED_DESC: {
                    return R.mipmap.ic_light_sorted_desc;
                }
            }
            return 0;
        }
    }

    private static class DarkSortStateViewProvider
    implements SortStateViewProvider {
        private DarkSortStateViewProvider() {
        }

        @Override
        public int getSortStateViewResource(SortState state) {
            switch (state) {
                case SORTABLE: {
                    return R.mipmap.ic_dark_sortable;
                }
                case SORTED_ASC: {
                    return R.mipmap.ic_dark_sorted_asc;
                }
                case SORTED_DESC: {
                    return R.mipmap.ic_dark_sorted_desc;
                }
            }
            return 0;
        }
    }
}

