/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview.toolkit;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import de.codecrafters.tableview.TableDataAdapter;
import java.util.List;

public final class SimpleTableDataAdapter
extends TableDataAdapter<String[]> {
    private static final String LOG_TAG = SimpleTableDataAdapter.class.getName();
    private int paddingLeft = 20;
    private int paddingTop = 15;
    private int paddingRight = 20;
    private int paddingBottom = 15;
    private int textSize = 18;
    private int typeface = 0;
    private int textColor = -1728053248;

    public SimpleTableDataAdapter(Context context, String[][] data) {
        super(context, (T[])data);
    }

    public SimpleTableDataAdapter(Context context, List<String[]> data) {
        super(context, data);
    }

    @Override
    public View getCellView(int rowIndex, int columnIndex, ViewGroup parentView) {
        TextView textView = new TextView(this.getContext());
        textView.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        textView.setTypeface(textView.getTypeface(), this.typeface);
        textView.setTextSize((float)this.textSize);
        textView.setTextColor(this.textColor);
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        try {
            String textToShow = ((String[])this.getItem(rowIndex))[columnIndex];
            textView.setText((CharSequence)textToShow);
        }
        catch (IndexOutOfBoundsException e) {
            Log.w((String)LOG_TAG, (String)("No Sting given for row " + rowIndex + ", column " + columnIndex + ". " + "Caught exception: " + e.toString()));
        }
        return textView;
    }

    public void setPaddings(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public void setTypeface(int typeface) {
        this.typeface = typeface;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
    }
}

