/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import de.codecrafters.tableview.R;
import de.codecrafters.tableview.TableColumnModel;
import de.codecrafters.tableview.TableDataAdapter;
import de.codecrafters.tableview.TableHeaderAdapter;
import de.codecrafters.tableview.TableHeaderView;
import de.codecrafters.tableview.colorizers.TableDataRowColorizer;
import de.codecrafters.tableview.listeners.TableDataClickListener;
import de.codecrafters.tableview.listeners.TableHeaderClickListener;
import de.codecrafters.tableview.toolkit.TableDataRowColorizers;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class TableView<T>
extends LinearLayout {
    private static final String LOG_TAG = TableView.class.getName();
    private static final int DEFAULT_COLUMN_COUNT = 4;
    private static final int DEFAULT_HEADER_ELEVATION = 1;
    private static final int DEFAULT_HEADER_COLOR = -3355444;
    private final Set<TableDataClickListener<T>> dataClickListeners = new HashSet<TableDataClickListener<T>>();
    private TableColumnModel columnModel;
    private TableHeaderView tableHeaderView;
    private ListView tableDataView;
    private TableHeaderAdapter tableHeaderAdapter;
    protected TableDataAdapter<T> tableDataAdapter;
    private TableDataRowColorizer<? super T> dataRowColoriser = TableDataRowColorizers.similarRowColor(0);
    private int headerElevation;
    private int headerColor;

    public TableView(Context context) {
        this(context, null);
    }

    public TableView(Context context, AttributeSet attributes) {
        this(context, attributes, 0);
    }

    public TableView(Context context, AttributeSet attributes, int styleAttributes) {
        super(context, attributes, styleAttributes);
        this.setOrientation(1);
        this.setAttributes(attributes);
        this.setupTableHeaderView();
        this.setupTableDataView(attributes, styleAttributes);
    }

    protected void setHeaderView(TableHeaderView headerView) {
        this.tableHeaderView = headerView;
        this.tableHeaderView.setAdapter(this.tableHeaderAdapter);
        this.tableHeaderView.setBackgroundColor(this.headerColor);
        if (this.getChildCount() == 2) {
            this.removeViewAt(0);
        }
        this.addView((View)this.tableHeaderView, 0);
        this.setHeaderElevation(this.headerElevation);
        this.forceRefresh();
    }

    public void setHeaderBackground(int resId) {
        this.tableHeaderView.setBackgroundResource(resId);
    }

    public void setHeaderBackgroundColor(int color) {
        this.tableHeaderView.setBackgroundColor(color);
    }

    public void setHeaderElevation(int elevation) {
        ViewCompat.setElevation((View)this.tableHeaderView, (float)elevation);
    }

    public void setDataRowColoriser(TableDataRowColorizer<? super T> coloriser) {
        this.dataRowColoriser = coloriser;
        this.tableDataAdapter.setRowColoriser(coloriser);
    }

    public void addDataClickListener(TableDataClickListener<T> listener) {
        this.dataClickListeners.add(listener);
    }

    public void removeTableDataClickListener(TableDataClickListener<T> listener) {
        this.dataClickListeners.remove(listener);
    }

    public void addHeaderClickListener(TableHeaderClickListener listener) {
        this.tableHeaderView.addHeaderClickListener(listener);
    }

    public void removeHeaderListener(TableHeaderClickListener listener) {
        this.tableHeaderView.removeHeaderClickListener(listener);
    }

    public void setHeaderAdapter(TableHeaderAdapter headerAdapter) {
        this.tableHeaderAdapter = headerAdapter;
        this.tableHeaderAdapter.setColumnModel(this.columnModel);
        this.tableHeaderView.setAdapter(this.tableHeaderAdapter);
        this.forceRefresh();
    }

    public void setDataAdapter(TableDataAdapter<T> dataAdapter) {
        this.tableDataAdapter = dataAdapter;
        this.tableDataAdapter.setColumnModel(this.columnModel);
        this.tableDataAdapter.setRowColoriser(this.dataRowColoriser);
        this.tableDataView.setAdapter(this.tableDataAdapter);
        this.forceRefresh();
    }

    public void setColumnCount(int columnCount) {
        this.columnModel.setColumnCount(columnCount);
        this.forceRefresh();
    }

    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    public void setColumnWeight(int columnIndex, int columnWeight) {
        this.columnModel.setColumnWeight(columnIndex, columnWeight);
        this.forceRefresh();
    }

    public int getColumnWeight(int columnIndex) {
        return this.columnModel.getColumnWeight(columnIndex);
    }

    private void forceRefresh() {
        if (this.tableHeaderView != null) {
            this.tableHeaderView.invalidate();
        }
        if (this.tableDataView != null) {
            this.tableDataView.invalidate();
        }
    }

    private void setAttributes(AttributeSet attributes) {
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(attributes, R.styleable.TableView);
        this.headerColor = styledAttributes.getInt(R.styleable.TableView_headerColor, -3355444);
        this.headerElevation = styledAttributes.getInt(R.styleable.TableView_headerElevation, 1);
        int columnCount = styledAttributes.getInt(R.styleable.TableView_columnCount, 4);
        this.columnModel = new TableColumnModel(columnCount);
        styledAttributes.recycle();
    }

    private void setupTableHeaderView() {
        this.tableHeaderAdapter = this.isInEditMode() ? new EditModeTableHeaderAdapter(this.getContext()) : new DefaultTableHeaderAdapter(this.getContext());
        TableHeaderView tableHeaderView = new TableHeaderView(this.getContext());
        this.setHeaderView(tableHeaderView);
    }

    private void setupTableDataView(AttributeSet attributes, int styleAttributes) {
        LinearLayout.LayoutParams dataViewLayoutParams = new LinearLayout.LayoutParams(-1, -1);
        this.tableDataAdapter = this.isInEditMode() ? new EditModeTableDataAdapter(this.getContext()) : new DefaultTableDataAdapter(this.getContext());
        this.tableDataAdapter.setRowColoriser(this.dataRowColoriser);
        this.tableDataView = new ListView(this.getContext(), attributes, styleAttributes);
        this.tableDataView.setOnItemClickListener((AdapterView.OnItemClickListener)new InternalDataClickListener());
        this.tableDataView.setLayoutParams((ViewGroup.LayoutParams)dataViewLayoutParams);
        this.tableDataView.setAdapter(this.tableDataAdapter);
        this.addView((View)this.tableDataView);
    }

    private class EditModeTableDataAdapter
    extends TableDataAdapter<T> {
        private static final float TEXT_SIZE = 16.0f;

        public EditModeTableDataAdapter(Context context) {
            super(context, TableView.this.columnModel, new ArrayList());
        }

        @Override
        public View getCellView(int rowIndex, int columnIndex, ViewGroup parent) {
            TextView textView = new TextView(this.getContext());
            textView.setText((CharSequence)("Cell [" + columnIndex + ":" + rowIndex + "]"));
            textView.setPadding(20, 10, 20, 10);
            textView.setTextSize(16.0f);
            return textView;
        }

        public int getCount() {
            return 50;
        }
    }

    private class EditModeTableHeaderAdapter
    extends TableHeaderAdapter {
        private static final float TEXT_SIZE = 18.0f;

        public EditModeTableHeaderAdapter(Context context) {
            super(context, TableView.this.columnModel);
        }

        @Override
        public View getHeaderView(int columnIndex, ViewGroup parentView) {
            TextView textView = new TextView(this.getContext());
            textView.setText((CharSequence)("Header " + columnIndex));
            textView.setPadding(20, 40, 20, 40);
            textView.setTypeface(textView.getTypeface(), 1);
            textView.setTextSize(18.0f);
            return textView;
        }
    }

    private class DefaultTableDataAdapter
    extends TableDataAdapter<T> {
        public DefaultTableDataAdapter(Context context) {
            super(context, TableView.this.columnModel, new ArrayList());
        }

        @Override
        public View getCellView(int rowIndex, int columnIndex, ViewGroup parentView) {
            return new TextView(this.getContext());
        }
    }

    private class DefaultTableHeaderAdapter
    extends TableHeaderAdapter {
        public DefaultTableHeaderAdapter(Context context) {
            super(context, TableView.this.columnModel);
        }

        @Override
        public View getHeaderView(int columnIndex, ViewGroup parentView) {
            TextView view = new TextView(this.getContext());
            view.setText((CharSequence)" ");
            view.setPadding(20, 40, 20, 40);
            return view;
        }
    }

    private class InternalDataClickListener
    implements AdapterView.OnItemClickListener {
        private InternalDataClickListener() {
        }

        public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
            this.informAllListeners(i);
        }

        private void informAllListeners(int rowIndex) {
            Object clickedObject = TableView.this.tableDataAdapter.getItem(rowIndex);
            for (TableDataClickListener listener : TableView.this.dataClickListeners) {
                try {
                    listener.onDataClicked(rowIndex, clickedObject);
                }
                catch (Throwable t) {
                    Log.w((String)LOG_TAG, (String)("Caught Throwable on listener notification: " + t.toString()));
                }
            }
        }
    }
}

