/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafters.tableview;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import de.codecrafters.tableview.InternalHeaderClickListener;
import de.codecrafters.tableview.R;
import de.codecrafters.tableview.SortState;
import de.codecrafters.tableview.TableHeaderView;
import de.codecrafters.tableview.providers.SortStateViewProvider;
import de.codecrafters.tableview.toolkit.SortStateViewProviders;
import java.util.HashMap;
import java.util.Map;

class SortableTableHeaderView
extends TableHeaderView {
    private static final String LOG_TAG = SortableTableHeaderView.class.toString();
    private final Map<Integer, ImageView> sortViews = new HashMap<Integer, ImageView>();
    private final Map<Integer, SortState> sortStates = new HashMap<Integer, SortState>();
    private SortStateViewProvider sortStateViewProvider = SortStateViewProviders.darkArrows();

    public SortableTableHeaderView(Context context) {
        super(context);
    }

    public void resetSortViews() {
        for (int column : this.sortStates.keySet()) {
            SortState columnSortState = this.sortStates.get(column);
            if (columnSortState != SortState.NOT_SORTABLE) {
                columnSortState = SortState.SORTABLE;
            }
            this.sortStates.put(column, columnSortState);
        }
        for (int column : this.sortStates.keySet()) {
            ImageView sortView = this.sortViews.get(column);
            SortState sortState = this.sortStates.get(column);
            int imageRes = this.sortStateViewProvider.getSortStateViewResource(sortState);
            sortView.setImageResource(imageRes);
            if (imageRes == 0) {
                sortView.setVisibility(8);
                continue;
            }
            sortView.setVisibility(0);
        }
    }

    public void setSortState(int columnIndex, SortState state) {
        ImageView sortView = this.sortViews.get(columnIndex);
        if (sortView == null) {
            Log.e((String)LOG_TAG, (String)("SortView not found for columnIndex with index " + columnIndex));
            return;
        }
        this.sortStates.put(columnIndex, state);
        int imageRes = this.sortStateViewProvider.getSortStateViewResource(state);
        sortView.setImageResource(imageRes);
        if (imageRes == 0) {
            sortView.setVisibility(8);
        } else {
            sortView.setVisibility(0);
        }
    }

    public SortStateViewProvider getSortStateViewProvider() {
        return this.sortStateViewProvider;
    }

    public void setSortStateViewProvider(SortStateViewProvider provider) {
        this.sortStateViewProvider = provider;
        this.resetSortViews();
    }

    @Override
    protected void renderHeaderViews() {
        this.removeAllViews();
        for (int columnIndex = 0; columnIndex < this.adapter.getColumnCount(); ++columnIndex) {
            LinearLayout headerContainerLayout = (LinearLayout)this.adapter.getLayoutInflater().inflate(R.layout.sortable_header, (ViewGroup)this, false);
            headerContainerLayout.setOnClickListener((View.OnClickListener)new InternalHeaderClickListener(columnIndex, this.getHeaderClickListeners()));
            View headerView = this.adapter.getHeaderView(columnIndex, (ViewGroup)headerContainerLayout);
            if (headerView == null) {
                headerView = new TextView(this.getContext());
            }
            FrameLayout headerContainer = (FrameLayout)headerContainerLayout.findViewById(R.id.container);
            headerContainer.addView(headerView);
            int imageRes = this.sortStateViewProvider.getSortStateViewResource(SortState.NOT_SORTABLE);
            ImageView sortView = (ImageView)headerContainerLayout.findViewById(R.id.sort_view);
            sortView.setImageResource(imageRes);
            if (imageRes == 0) {
                sortView.setVisibility(8);
            } else {
                sortView.setVisibility(0);
            }
            this.sortViews.put(columnIndex, sortView);
            boolean width = false;
            int height = -2;
            int weight = this.adapter.getColumnWeight(columnIndex);
            LinearLayout.LayoutParams headerLayoutParams = new LinearLayout.LayoutParams(0, -2, (float)weight);
            this.addView((View)headerContainerLayout, (ViewGroup.LayoutParams)headerLayoutParams);
        }
        this.resetSortViews();
    }
}

